/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.factory;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Function;
import org.adempiere.base.IServiceReferenceHolder;
import org.adempiere.base.Service;
import org.adempiere.webui.factory.IInfoFactory;
import org.adempiere.webui.info.InfoWindow;
import org.adempiere.webui.panel.InfoPanel;
import org.compiere.model.GridField;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.util.CCache;
import org.osgi.framework.ServiceReference;

public class InfoManager {
    private static final CCache<Integer, ConcurrentHashMap<Long, IServiceReferenceHolder<IInfoFactory>>> s_infoFactoryCache = new CCache(null, "IInfoFactory", 10, 0, false, 0);
    private static final Set<Integer> s_rankings = new ConcurrentSkipListSet(Comparator.reverseOrder());

    public static InfoPanel create(int WindowNo, String tableName, String keyColumn, String value, boolean multiSelection, String whereClause, boolean lookup) {
        Function<IInfoFactory, InfoPanel> funcGetInfoFromService = service -> service.create(WindowNo, tableName, keyColumn, value, multiSelection, whereClause, 0, lookup);
        return InfoManager.create(funcGetInfoFromService);
    }

    public static InfoPanel create(Lookup lookup, GridField field, String tableName, String keyColumn, String queryValue, boolean multiSelection, String whereClause) {
        Function<IInfoFactory, InfoPanel> funcGetInfoFromService = null;
        if (lookup instanceof MLookup) {
            int AD_InfoWindow_ID = ((MLookup)lookup).getAD_InfoWindow_ID();
            funcGetInfoFromService = service -> service.create(lookup, field, tableName, keyColumn, queryValue, multiSelection, whereClause, AD_InfoWindow_ID);
        } else {
            funcGetInfoFromService = service -> service.create(lookup, field, tableName, keyColumn, queryValue, multiSelection, whereClause, 0);
        }
        return InfoManager.create(funcGetInfoFromService);
    }

    public static InfoWindow create(int AD_InfoWindow_ID) {
        return InfoManager.create(AD_InfoWindow_ID, null);
    }

    public static InfoWindow create(int AD_InfoWindow_ID, String predefinedContextVariables) {
        return InfoManager.create(-1, AD_InfoWindow_ID, predefinedContextVariables);
    }

    public static InfoWindow create(int windowNo, int AD_InfoWindow_ID, String predefinedContextVariables) {
        Function<IInfoFactory, InfoPanel> funcGetInfoFromService = service -> service.create(windowNo, AD_InfoWindow_ID, predefinedContextVariables);
        return (InfoWindow)InfoManager.create(funcGetInfoFromService);
    }

    public static InfoPanel create(Function<IInfoFactory, InfoPanel> funcGetInfoFromService) {
        InfoPanel info = null;
        ArrayList<Long> visitedIds = new ArrayList<Long>();
        if (!s_infoFactoryCache.isEmpty()) {
            for (Integer ranking : s_rankings) {
                Long[] keys;
                ConcurrentHashMap serviceIdMap = (ConcurrentHashMap)s_infoFactoryCache.get((Object)ranking);
                if (serviceIdMap == null) continue;
                Long[] longArray = keys = ((ConcurrentHashMap.CollectionView)((Object)serviceIdMap.keySet())).toArray(new Long[0]);
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    Long key = longArray[n2];
                    IServiceReferenceHolder serviceReference = (IServiceReferenceHolder)serviceIdMap.get(key);
                    if (serviceReference != null) {
                        IInfoFactory service = (IInfoFactory)serviceReference.getService();
                        if (service != null) {
                            visitedIds.add(key);
                            info = funcGetInfoFromService.apply(service);
                            if (info != null) {
                                return info;
                            }
                        } else {
                            serviceIdMap.remove(key);
                        }
                    }
                    ++n2;
                }
            }
        }
        List serviceReferences = Service.locator().list(IInfoFactory.class).getServiceReferences();
        for (IServiceReferenceHolder serviceReference : serviceReferences) {
            ConcurrentHashMap<Long, IServiceReferenceHolder> serviceIdMap;
            IInfoFactory service;
            ServiceReference reference = serviceReference.getServiceReference();
            Long serviceId = (Long)reference.getProperty("service.id");
            if (visitedIds.contains(serviceId) || (service = (IInfoFactory)serviceReference.getService()) == null) continue;
            Integer ranking = (Integer)reference.getProperty("service.ranking");
            if (ranking == null) {
                ranking = 0;
            }
            if (!s_rankings.contains(ranking)) {
                s_rankings.add(ranking);
            }
            if ((serviceIdMap = (ConcurrentHashMap<Long, IServiceReferenceHolder>)s_infoFactoryCache.get((Object)ranking)) == null) {
                serviceIdMap = new ConcurrentHashMap<Long, IServiceReferenceHolder>();
                s_infoFactoryCache.put((Object)ranking, serviceIdMap);
            }
            serviceIdMap.put(serviceId, serviceReference);
            info = funcGetInfoFromService.apply(service);
            if (info != null) break;
        }
        return info;
    }
}

