/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.report.jasper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Level;
import org.adempiere.report.jasper.Activator;
import org.compiere.util.CLogger;
import org.compiere.util.Language;
import org.compiere.utils.DigestOfFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class ClassResourceLoader {
    private static final CLogger log = CLogger.getCLogger(ClassResourceLoader.class);
    private String destinationFolder;
    private String resourcePath;
    private static final String RESOURCE_PATH_PREFIX = "resource:";

    public ClassResourceLoader(String destinationFolder) {
        this.destinationFolder = destinationFolder;
    }

    public Object getResource(String path) {
        boolean empty = true;
        URL url = null;
        File reportFile = null;
        String resourceName = path.startsWith(RESOURCE_PATH_PREFIX) ? path.substring(RESOURCE_PATH_PREFIX.length()).trim() : path.trim();
        Bundle bundle = null;
        if (resourceName.indexOf(":") > 0) {
            String symbolicName = resourceName.substring(0, resourceName.indexOf(":"));
            resourceName = resourceName.substring(resourceName.indexOf(":") + 1);
            Optional<Bundle> optional = Arrays.stream(Activator.getBundleContext().getBundles()).filter(b -> b.getSymbolicName().equals(symbolicName)).findFirst();
            if (optional.isPresent()) {
                bundle = optional.get();
            }
        }
        ClassLoader classLoader = null;
        classLoader = bundle != null ? ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader() : this.getClass().getClassLoader();
        if (resourceName.endsWith(".jrxml")) {
            String localResourceName = this.toLocalName(resourceName);
            String localAbsolutePathName = this.destinationFolder + localResourceName;
            reportFile = new File(localAbsolutePathName);
            String localPathName = localAbsolutePathName.substring(0, localAbsolutePathName.lastIndexOf(File.separator) + 1);
            Path localAbsolutePath = Path.of(localPathName, new String[0]);
            try {
                if (!Files.exists(localAbsolutePath, new LinkOption[0])) {
                    Files.createDirectory(localAbsolutePath, new FileAttribute[0]);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            String localFileName = localAbsolutePathName.substring(localAbsolutePathName.lastIndexOf(File.separator) + 1);
            String extension = localFileName.substring(localFileName.lastIndexOf("."));
            File tmpOutputFile = null;
            url = classLoader.getResource(resourceName);
            if (url != null) {
                block41: {
                    try {
                        Throwable throwable = null;
                        Object var16_19 = null;
                        try (InputStream inputStream = url.openStream();){
                            if (inputStream == null) break block41;
                            if (!reportFile.exists()) {
                                reportFile.createNewFile();
                                tmpOutputFile = reportFile;
                            } else {
                                tmpOutputFile = File.createTempFile(localFileName.substring(0, localFileName.lastIndexOf(".")), extension, localAbsolutePath.toFile());
                            }
                            Throwable throwable2 = null;
                            Object var19_25 = null;
                            try (FileOutputStream out = new FileOutputStream(tmpOutputFile);){
                                if (out != null) {
                                    int len;
                                    byte[] buf = new byte[1024];
                                    while ((len = inputStream.read(buf)) > 0) {
                                        empty = false;
                                        ((OutputStream)out).write(buf, 0, len);
                                    }
                                }
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                        empty = true;
                    }
                }
                if (!empty && tmpOutputFile != reportFile) {
                    if (!DigestOfFile.md5HashCompare(reportFile, tmpOutputFile)) {
                        Path to = reportFile.toPath();
                        Path from = tmpOutputFile.toPath();
                        try {
                            Files.copy(from, to, StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException e) {
                            log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                            return null;
                        }
                    }
                    try {
                        Files.delete(tmpOutputFile.toPath());
                    }
                    catch (IOException iOException) {}
                }
            }
        } else {
            url = classLoader.getResource(resourceName);
            boolean bl = empty = url == null;
        }
        if (empty) {
            return null;
        }
        if (url != null) {
            this.resourcePath = url.toString();
            if (this.resourcePath != null && this.resourcePath.lastIndexOf("/") > 0) {
                this.resourcePath = this.resourcePath.substring(0, this.resourcePath.lastIndexOf("/") + 1);
            }
        }
        return reportFile != null ? reportFile : url;
    }

    private String toLocalName(String name) {
        Object localName = name;
        if (((String)localName).startsWith("/")) {
            localName = ((String)localName).substring(1);
        }
        if (((String)localName).lastIndexOf("/") > 0) {
            String path = ((String)localName).substring(0, ((String)localName).lastIndexOf("/"));
            localName = ((String)localName).substring(((String)localName).lastIndexOf("/") + 1);
            path = path.replace('/', '_');
            localName = path + File.separator + (String)localName;
        }
        return localName;
    }

    public URL getResourceBundle(String bundleName, Language currLang) {
        String resourceName = bundleName + "_" + currLang.getLocale().getLanguage() + "_" + currLang.getLocale().getCountry() + ".properties";
        URL resourceURL = null;
        try {
            resourceURL = (URL)this.getResource(resourceName);
        }
        catch (Exception exception) {}
        if (resourceURL == null) {
            resourceName = bundleName + "_" + currLang.getLocale().getLanguage() + ".properties";
            try {
                resourceURL = (URL)this.getResource(resourceName);
            }
            catch (Exception exception) {}
            if (resourceURL == null) {
                resourceName = bundleName + ".properties";
                try {
                    resourceURL = (URL)this.getResource(resourceName);
                }
                catch (Exception exception) {}
            }
        }
        return resourceURL;
    }

    public File[] getSubreports(String path) {
        return new File[0];
    }

    public String getRelatedResourcesPath() {
        return this.resourcePath;
    }

    public static boolean isClassResourcePath(String path) {
        return path != null && path.startsWith(RESOURCE_PATH_PREFIX);
    }
}

