/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install.util;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;

public class AEnv {
    public static void showCenterScreen(Window window) {
        AEnv.positionCenterScreen(window);
        AEnv.showWindow(window);
    }

    public static void showCenterWindow(Window parent, Window window) {
        AEnv.positionCenterWindow(parent, window);
        AEnv.showWindow(window);
    }

    public static void positionCenterWindow(Window parent, Window window) {
        int y;
        if (parent == null) {
            AEnv.positionCenterScreen(window);
            return;
        }
        window.pack();
        Dimension sSize = Toolkit.getDefaultToolkit().getScreenSize();
        GraphicsConfiguration config = window.getGraphicsConfiguration();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(config);
        sSize.width -= insets.left + insets.right;
        sSize.height -= insets.top + insets.bottom;
        Dimension wSize = window.getSize();
        if (wSize.height > sSize.height) {
            wSize.height = sSize.height;
        }
        if (wSize.width > sSize.width) {
            wSize.width = sSize.width;
        }
        window.setSize(wSize);
        Rectangle pBounds = parent.getBounds();
        if (pBounds.x == pBounds.y && pBounds.x == 0) {
            AEnv.positionCenterScreen(window);
            return;
        }
        int x = pBounds.x + (pBounds.width - wSize.width) / 2;
        if (x < 0) {
            x = 0;
        }
        if ((y = pBounds.y + (pBounds.height - wSize.height) / 2) < 0) {
            y = 0;
        }
        if (x + wSize.width > sSize.width) {
            x = sSize.width - wSize.width;
        }
        if (y + wSize.height > sSize.height) {
            y = sSize.height - wSize.height;
        }
        window.setLocation(x + insets.left, y + insets.top);
    }

    public static void positionCenterScreen(Window window) {
        AEnv.positionScreen(window, 0);
    }

    public static void positionScreen(Window window, int position) {
        window.pack();
        GraphicsConfiguration config = window.getGraphicsConfiguration();
        Rectangle bounds = config.getBounds();
        Dimension sSize = bounds.getSize();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(config);
        sSize.width -= insets.left + insets.right;
        sSize.height -= insets.top + insets.bottom;
        Dimension wSize = window.getSize();
        if (wSize.height > sSize.height) {
            wSize.height = sSize.height;
        }
        if (wSize.width > sSize.width) {
            wSize.width = sSize.width;
        }
        window.setSize(wSize);
        int x = (sSize.width - wSize.width) / 2;
        int y = (sSize.height - wSize.height) / 2;
        if (position != 0) {
            if (position == 8) {
                x = 0;
                y = 0;
            } else if (position == 1) {
                y = 0;
            } else if (position == 2) {
                x = sSize.width - wSize.width;
                y = 0;
            } else if (position == 7) {
                x = 0;
            } else if (position == 3) {
                x = sSize.width - wSize.width;
            } else if (position == 5) {
                y = sSize.height - wSize.height;
            } else if (position == 6) {
                x = 0;
                y = sSize.height - wSize.height;
            } else if (position == 4) {
                x = sSize.width - wSize.width;
                y = sSize.height - wSize.height;
            }
        }
        window.setLocation(bounds.x + x + insets.left, bounds.y + y + insets.top);
    }

    public static void showWindow(Window window) {
        Frame f;
        int state;
        window.setVisible(true);
        if (window instanceof Frame && ((state = (f = (Frame)window).getExtendedState()) & 1) > 0) {
            f.setExtendedState(state & 0xFFFFFFFE);
        }
        window.toFront();
    }
}

