/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import org.adempiere.base.Core;
import org.compiere.model.SystemProperties;
import org.compiere.util.CacheInterface;
import org.compiere.util.CacheMgt;
import org.compiere.util.Util;
import org.idempiere.distributed.ICacheService;

public class CCache<K, V>
implements CacheInterface,
Map<K, V>,
Serializable {
    private static final long serialVersionUID = 4960404895430292476L;
    protected Map<K, V> cache = null;
    protected Set<K> nullList = null;
    private String m_tableName;
    private boolean m_distributed;
    private int m_maxSize = 0;
    public static final int DEFAULT_EXPIRE_MINUTE = CCache.getDefaultExpireMinute();
    private String m_name = null;
    private int m_expire = 0;
    private volatile long m_timeExp = 0L;
    private boolean m_justReset = true;
    private VetoableChangeSupport m_changeSupport = null;
    private static String PROPERTYNAME = "cache";
    private final LongAdder m_hit = new LongAdder();
    private final LongAdder m_miss = new LongAdder();

    private static int getDefaultExpireMinute() {
        block5: {
            try {
                String property = SystemProperties.getCacheExpireMinute();
                if (property == null || property.trim().length() <= 0) break block5;
                int expireMinute = 0;
                try {
                    expireMinute = Integer.parseInt(property.trim());
                }
                catch (Throwable throwable) {}
                if (expireMinute > 0) {
                    return expireMinute;
                }
            }
            catch (Throwable throwable) {}
        }
        return 60;
    }

    private static int getCacheMaxSize(String name) {
        block5: {
            try {
                String property = SystemProperties.getCacheMaxSizeTable(name);
                if (property == null || property.trim().length() <= 0) break block5;
                int cacheMaxSize = 0;
                try {
                    cacheMaxSize = Integer.parseInt(property.trim());
                }
                catch (Throwable throwable) {}
                if (cacheMaxSize > 0) {
                    return cacheMaxSize;
                }
            }
            catch (Throwable throwable) {}
        }
        return -1;
    }

    public CCache(String name, int initialCapacity) {
        this(name, name, initialCapacity);
    }

    public CCache(String name, int initialCapacity, int expireMinutes) {
        this(name, initialCapacity, expireMinutes, false);
    }

    public CCache(String name, int initialCapacity, int expireMinutes, boolean distributed) {
        this(name, name, initialCapacity, expireMinutes, distributed);
    }

    public CCache(String name, int initialCapacity, int expireMinutes, boolean distributed, int maxSize) {
        this(name, name, initialCapacity, expireMinutes, distributed, maxSize);
    }

    public CCache(String tableName, String name, int initialCapacity) {
        this(tableName, name, initialCapacity, false);
    }

    public CCache(String tableName, String name, int initialCapacity, boolean distributed) {
        this(tableName, name, initialCapacity, DEFAULT_EXPIRE_MINUTE, distributed);
    }

    public CCache(String tableName, String name, int initialCapacity, int expireMinutes, boolean distributed) {
        this(tableName, name, initialCapacity, expireMinutes, distributed, CacheMgt.MAX_SIZE);
    }

    public CCache(String tableName, String name, int initialCapacity, int expireMinutes, boolean distributed, int maxSize) {
        ICacheService provider;
        this.m_name = name;
        this.m_tableName = tableName;
        this.setExpireMinutes(expireMinutes);
        int propMaxSize = CCache.getCacheMaxSize(name);
        this.m_maxSize = propMaxSize >= 0 ? propMaxSize : maxSize;
        this.cache = CacheMgt.get().register(this, distributed);
        this.m_distributed = distributed;
        if (distributed && (provider = Core.getCacheService()) != null) {
            this.nullList = provider.getSet(name);
        }
        if (this.nullList == null) {
            this.nullList = ConcurrentHashMap.newKeySet();
        }
    }

    public String getName() {
        return this.m_name;
    }

    public String getTableName() {
        return this.m_tableName;
    }

    public void setExpireMinutes(int expireMinutes) {
        if (expireMinutes > 0) {
            this.m_expire = expireMinutes;
            long addMS = 60000L * (long)this.m_expire;
            this.m_timeExp = System.currentTimeMillis() + addMS;
        } else {
            this.m_expire = 0;
            this.m_timeExp = 0L;
        }
    }

    public int getExpireMinutes() {
        return this.m_expire;
    }

    public boolean isReset() {
        return this.m_justReset;
    }

    public void setUsed() {
        this.m_justReset = false;
    }

    @Override
    public int reset() {
        int no = this.cache.size() + this.nullList.size();
        this.clear();
        return no;
    }

    public String toString() {
        return "CCache[" + this.m_name + ",Exp=" + this.getExpireMinutes() + ", #" + this.cache.size() + ", Hit=" + this.getHit() + ", Miss=" + this.getMiss() + "]";
    }

    @Override
    public void clear() {
        if (this.m_changeSupport != null) {
            try {
                this.m_changeSupport.fireVetoableChange(PROPERTYNAME, this.cache.size(), 0);
            }
            catch (Exception e) {
                System.out.println("CCache.clear - " + String.valueOf(e));
                return;
            }
        }
        this.cache.clear();
        this.nullList.clear();
        if (this.m_expire != 0) {
            long addMS = 60000L * (long)this.m_expire;
            this.m_timeExp = System.currentTimeMillis() + addMS;
        }
        this.m_justReset = true;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        return this.cache.containsKey(key) || this.nullList.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        return this.cache.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.cache.entrySet();
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return null;
        }
        V v = this.cache.get(key);
        if (v == null) {
            if (this.nullList.contains(key)) {
                this.m_hit.add(1L);
            } else {
                this.m_miss.add(1L);
            }
        } else {
            this.m_hit.add(1L);
        }
        return v;
    }

    @Override
    public V put(K key, V value) {
        this.m_justReset = false;
        if (value == null) {
            this.cache.remove(key);
            this.nullList.add(key);
            return null;
        }
        if (!this.nullList.isEmpty()) {
            this.nullList.remove(key);
        }
        return this.cache.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.m_justReset = false;
        this.cache.putAll(m);
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty() && this.nullList.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.cache.keySet();
    }

    @Override
    public int size() {
        return this.cache.size() + this.nullList.size();
    }

    public int sizeNoExpire() {
        return this.cache.size() + this.nullList.size();
    }

    @Override
    public Collection<V> values() {
        return this.cache.values();
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (this.m_changeSupport == null) {
            this.m_changeSupport = new VetoableChangeSupport(this);
        }
        if (listener != null) {
            this.m_changeSupport.addVetoableChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (this.m_changeSupport != null && listener != null) {
            this.m_changeSupport.removeVetoableChangeListener(listener);
        }
    }

    @Override
    public V remove(Object key) {
        if (!this.nullList.isEmpty() && this.nullList.remove(key)) {
            return null;
        }
        return this.cache.remove(key);
    }

    @Override
    public int reset(int recordId) {
        if (recordId <= 0) {
            return this.reset();
        }
        if (this.cache.isEmpty() && this.nullList.isEmpty()) {
            return 0;
        }
        Object firstKey = null;
        try {
            if (!this.cache.isEmpty()) {
                firstKey = this.cache.keySet().iterator().next();
            } else if (!this.nullList.isEmpty()) {
                firstKey = this.nullList.iterator().next();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {}
        if (firstKey != null && firstKey instanceof Integer) {
            if (!this.nullList.isEmpty() && this.nullList.remove(recordId)) {
                return 1;
            }
            V removed = this.cache.remove(recordId);
            return removed != null ? 1 : 0;
        }
        return this.reset();
    }

    @Override
    public int resetByStringKey(String key) {
        if (Util.isEmpty(key, true)) {
            return this.reset();
        }
        if (this.cache.isEmpty() && this.nullList.isEmpty()) {
            return 0;
        }
        Object firstKey = null;
        try {
            if (!this.cache.isEmpty()) {
                firstKey = this.cache.keySet().iterator().next();
            } else if (!this.nullList.isEmpty()) {
                firstKey = this.nullList.iterator().next();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {}
        if (firstKey != null && firstKey instanceof String) {
            if (!this.nullList.isEmpty() && this.nullList.remove(key)) {
                return 1;
            }
            V removed = this.cache.remove(key);
            return removed != null ? 1 : 0;
        }
        return this.reset();
    }

    @Override
    public void newRecord(int record_ID) {
    }

    public int getMaxSize() {
        return this.m_maxSize;
    }

    public boolean isDistributed() {
        return this.m_distributed;
    }

    public long getHit() {
        return this.m_hit.longValue();
    }

    public long getMiss() {
        return this.m_miss.longValue();
    }

    public boolean isExpire() {
        return this.m_expire > 0 && this.m_timeExp > 0L && this.m_timeExp < System.currentTimeMillis();
    }
}

