/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.Timestamp;
import org.compiere.model.MColumn;
import org.compiere.model.MQuery;
import org.compiere.model.MTable;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

class Restriction
implements Serializable {
    private static final long serialVersionUID = -4521978087587321243L;
    protected String DirectWhereClause = null;
    protected String ExistsClause = null;
    protected String ColumnName;
    protected String InfoName;
    protected String Operator;
    protected Object Code;
    protected String InfoDisplay;
    protected Object Code_to;
    protected String InfoDisplay_to;
    protected String andOrCondition = "AND";
    protected int joinDepth = 0;
    protected boolean notCondition = false;
    protected boolean existsCondition = false;

    Restriction(String columnName, String operator, Object code, String infoName, String infoDisplay, boolean andCondition, int depth) {
        this(columnName, operator, code, infoName, infoDisplay, andCondition ? "AND" : "OR", depth);
    }

    Restriction(String columnName, String operator, Object code, String infoName, String infoDisplay, String andOrCondition, int depth) {
        this.ColumnName = columnName.trim();
        this.InfoName = infoName != null ? infoName : this.ColumnName;
        this.andOrCondition = andOrCondition;
        this.joinDepth = depth < 0 ? 0 : depth;
        this.Operator = operator;
        this.Code = code instanceof Boolean ? ((Boolean)code != false ? "Y" : "N") : (code instanceof KeyNamePair ? Integer.valueOf(((KeyNamePair)code).getKey()) : (code instanceof ValueNamePair ? ((ValueNamePair)code).getValue() : code));
        if (this.Code instanceof String && this.Code.toString().startsWith("'") && this.Code.toString().endsWith("'")) {
            this.Code = this.Code.toString().substring(1);
            this.Code = this.Code.toString().substring(0, this.Code.toString().length() - 2);
        }
        if (infoDisplay != null) {
            this.InfoDisplay = infoDisplay.trim();
        } else if (code != null) {
            this.InfoDisplay = code.toString();
        }
    }

    Restriction(String columnName, String operator, Object code, String infoName, String infoDisplay, boolean andCondition, boolean notCondition, int depth) {
        this(columnName, operator, code, infoName, infoDisplay, andCondition, depth);
        this.notCondition = notCondition;
    }

    Restriction(String columnName, Object code, Object code_to, String infoName, String infoDisplay, String infoDisplay_to, boolean andCondition, int depth) {
        this(columnName, code, code_to, infoName, infoDisplay, infoDisplay_to, andCondition ? "AND" : "OR", depth);
    }

    Restriction(String columnName, Object code, Object code_to, String infoName, String infoDisplay, String infoDisplay_to, String andOrCondition, int depth) {
        this(columnName, " BETWEEN ", code, infoName, infoDisplay, andOrCondition, depth);
        this.Code_to = code_to;
        if (this.Code_to instanceof String) {
            if (this.Code_to.toString().startsWith("'")) {
                this.Code_to = this.Code_to.toString().substring(1);
            }
            if (this.Code_to.toString().endsWith("'")) {
                this.Code_to = this.Code_to.toString().substring(0, this.Code_to.toString().length() - 2);
            }
        }
        if (infoDisplay_to != null) {
            this.InfoDisplay_to = infoDisplay_to.trim();
        } else if (this.Code_to != null) {
            this.InfoDisplay_to = this.Code_to.toString();
        }
    }

    Restriction(String columnName, Object code, Object code_to, String infoName, String infoDisplay, String infoDisplay_to, boolean andCondition, boolean notCondition, int depth) {
        this(columnName, " BETWEEN ", code, infoName, infoDisplay, andCondition, notCondition, depth);
        this.Code_to = code_to;
        if (this.Code_to instanceof String) {
            if (this.Code_to.toString().startsWith("'")) {
                this.Code_to = this.Code_to.toString().substring(1);
            }
            if (this.Code_to.toString().endsWith("'")) {
                this.Code_to = this.Code_to.toString().substring(0, this.Code_to.toString().length() - 2);
            }
        }
        if (infoDisplay_to != null) {
            this.InfoDisplay_to = infoDisplay_to.trim();
        } else if (this.Code_to != null) {
            this.InfoDisplay_to = this.Code_to.toString();
        }
    }

    Restriction(String whereClause, boolean andCondition, int depth) {
        this(whereClause, andCondition ? "AND" : "OR", depth);
    }

    Restriction(String whereClause, String andOrCondition, int depth) {
        this.DirectWhereClause = whereClause;
        this.andOrCondition = andOrCondition;
        this.notCondition = false;
        this.existsCondition = false;
        this.joinDepth = depth;
    }

    Restriction(String whereClause, boolean andCondition, boolean notCondition, boolean existsCondition, int depth) {
        this.DirectWhereClause = whereClause;
        this.andOrCondition = andCondition ? "AND" : "OR";
        this.notCondition = notCondition;
        this.existsCondition = existsCondition;
        this.joinDepth = depth;
    }

    Restriction(String ExistsClause, Object Code) {
        this.ExistsClause = ExistsClause;
        this.Code = Code;
    }

    public String getSQL(String tableName) {
        MTable table2;
        if (this.DirectWhereClause != null) {
            return this.DirectWhereClause;
        }
        if (this.ExistsClause != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.ExistsClause);
            sb = this.Code instanceof String ? new StringBuilder(sb.toString().replace("?", DB.TO_STRING(this.Code.toString()))) : (this.Code instanceof Timestamp ? new StringBuilder(sb.toString().replace("?", DB.TO_DATE((Timestamp)this.Code, false))) : new StringBuilder(sb.toString().replace("?", this.Code.toString())));
            return sb.toString();
        }
        boolean virtualColumn = false;
        if (tableName != null && tableName.length() > 0 && (table2 = MTable.get(Env.getCtx(), tableName)) != null) {
            MColumn[] mColumnArray = table2.getColumns(false);
            int n = mColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                MColumn col = mColumnArray[n2];
                String colSQL = col.getColumnSQL(true, false);
                if (colSQL != null && colSQL.contains("@")) {
                    colSQL = Env.parseContext(Env.getCtx(), -1, colSQL, false, true);
                }
                if (colSQL != null && this.ColumnName.equals(colSQL.trim())) {
                    virtualColumn = true;
                    break;
                }
                ++n2;
            }
        }
        StringBuilder sb = new StringBuilder();
        if (!virtualColumn && tableName != null && tableName.length() > 0) {
            int pos = this.ColumnName.lastIndexOf(40) + 1;
            int end = this.ColumnName.indexOf(41);
            if (!(pos == -1 || end == -1 || pos - 1 == this.ColumnName.indexOf(40) && this.ColumnName.trim().startsWith("("))) {
                sb.append(this.ColumnName.substring(0, pos)).append(tableName).append(".").append(DB.getDatabase().quoteColumnName(this.ColumnName.substring(pos, end))).append(this.ColumnName.substring(end));
            } else {
                int selectIndex = this.ColumnName.toLowerCase().indexOf("select ");
                int fromIndex = this.ColumnName.toLowerCase().indexOf(" from ");
                if (selectIndex >= 0 && fromIndex > 0) {
                    sb.append(this.ColumnName);
                } else {
                    sb.append(tableName).append(".").append(DB.getDatabase().quoteColumnName(this.ColumnName));
                }
            }
        } else {
            sb.append(virtualColumn ? this.ColumnName : DB.getDatabase().quoteColumnName(this.ColumnName));
        }
        sb.append(this.Operator);
        if (!this.Operator.equals(" IS NULL ") && !this.Operator.equals(" IS NOT NULL ")) {
            if (this.Code instanceof String) {
                if (this.ColumnName.toUpperCase().startsWith("UPPER(")) {
                    sb.append("UPPER(" + DB.TO_STRING(this.Code.toString()) + ")");
                } else {
                    sb.append(DB.TO_STRING(this.Code.toString()));
                }
            } else if (this.Code instanceof Timestamp) {
                sb.append(DB.TO_DATE((Timestamp)this.Code, false));
            } else {
                sb.append(this.Code);
            }
            if (" BETWEEN ".equals(this.Operator)) {
                sb.append(" AND ");
                if (this.Code_to instanceof String) {
                    sb.append(DB.TO_STRING(this.Code_to.toString()));
                } else if (this.Code_to instanceof Timestamp) {
                    sb.append(DB.TO_DATE((Timestamp)this.Code_to, false));
                } else {
                    sb.append(this.Code_to);
                }
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.getSQL(null);
    }

    public String getInfoName() {
        return this.InfoName;
    }

    public String getInfoOperator() {
        int i = 0;
        while (i < MQuery.OPERATORS.length) {
            if (MQuery.OPERATORS[i].getValue().equals(this.Operator)) {
                return Msg.getMsg(Env.getCtx(), MQuery.OPERATORS[i].getName());
            }
            ++i;
        }
        return this.Operator;
    }

    public String getInfoDisplayAll() {
        if (this.InfoDisplay_to == null) {
            return this.InfoDisplay;
        }
        StringBuilder sb = new StringBuilder(this.InfoDisplay);
        sb.append(" - ").append(this.InfoDisplay_to);
        return sb.toString();
    }
}

