/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.BackDateTrxNotAllowedException;
import org.adempiere.exceptions.NegativeInventoryDisallowedException;
import org.adempiere.exceptions.PeriodClosedException;
import org.compiere.model.I_M_AttributeSet;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MCost;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostHistory;
import org.compiere.model.MDocType;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MInventoryLineMA;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MTransaction;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_M_Inventory;
import org.compiere.model.X_M_StorageOnHand;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;

public class MInventory
extends X_M_Inventory
implements DocAction {
    private static final long serialVersionUID = -1031896407532927376L;
    public static String REVERSE_INDICATOR = "^";
    protected MInventoryLine[] m_lines = null;
    protected String m_processMsg = null;
    protected boolean m_justPrepared = false;
    protected boolean m_reversal = false;

    public static MInventory get(int M_Inventory_ID) {
        return MInventory.get(Env.getCtx(), M_Inventory_ID);
    }

    public static MInventory get(Properties ctx, int M_Inventory_ID) {
        MInventory inventory = new MInventory(ctx, M_Inventory_ID, null);
        if (inventory.get_ID() == M_Inventory_ID) {
            return inventory;
        }
        return null;
    }

    public MInventory(Properties ctx, String M_Inventory_UU, String trxName) {
        super(ctx, M_Inventory_UU, trxName);
        if (Util.isEmpty(M_Inventory_UU)) {
            this.setInitialDefaults();
        }
    }

    public MInventory(Properties ctx, int M_Inventory_ID, String trxName) {
        super(ctx, M_Inventory_ID, trxName);
        if (M_Inventory_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setMovementDate(new Timestamp(System.currentTimeMillis()));
        this.setDocAction("CO");
        this.setDocStatus("DR");
        this.setIsApproved(false);
        this.setMovementDate(new Timestamp(System.currentTimeMillis()));
        this.setPosted(false);
        this.setProcessed(false);
    }

    public MInventory(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Deprecated
    public MInventory(MWarehouse wh) {
        this(wh, wh.get_TrxName());
    }

    public MInventory(MWarehouse wh, String trxName) {
        this(wh.getCtx(), 0, trxName);
        this.setClientOrg(wh);
        this.setM_Warehouse_ID(wh.getM_Warehouse_ID());
    }

    public MInventory(MInventory copy) {
        this(Env.getCtx(), copy);
    }

    public MInventory(Properties ctx, MInventory copy) {
        this(ctx, copy, null);
    }

    public MInventory(Properties ctx, MInventory copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_lines = copy.m_lines != null ? (MInventoryLine[])Arrays.stream(copy.m_lines).map(e -> {
            MInventoryLine v = new MInventoryLine(ctx, (MInventoryLine)e, trxName);
            v.setParent(this);
            return v;
        }).toArray(MInventoryLine[]::new) : null;
    }

    public MInventoryLine[] getLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            MInventory.set_TrxName(this.m_lines, this.get_TrxName());
            return this.m_lines;
        }
        List<MInventoryLine> list = new Query(this.getCtx(), "M_InventoryLine", "M_Inventory_ID=?", this.get_TrxName()).setParameters(this.get_ID()).setOrderBy("Line,M_InventoryLine_ID").list();
        this.m_lines = list.toArray(new MInventoryLine[list.size()]);
        return this.m_lines;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            StringBuilder msgreturn = new StringBuilder(desc).append(" | ").append(description);
            this.setDescription(msgreturn.toString());
        }
    }

    @Override
    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MInventory[");
        sb.append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",M_Warehouse_ID=").append(this.getM_Warehouse_ID()).append("]");
        return sb.toString();
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getC_DocType_ID());
        StringBuilder msgreturn = new StringBuilder().append(dt.getNameTrl()).append(" ").append(this.getDocumentNo());
        return msgreturn.toString();
    }

    @Override
    public File createPDF() {
        try {
            StringBuilder msgfile = new StringBuilder().append(this.get_TableName()).append(this.get_ID()).append("_");
            File temp = File.createTempFile(msgfile.toString(), ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        int cnt;
        if (this.getC_DocType_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "C_DocType_ID"));
            return false;
        }
        if (!newRecord && this.is_ValueChanged("M_Warehouse_ID") && (cnt = DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM M_InventoryLine WHERE M_Inventory_ID=?", this.getM_Inventory_ID())) > 0) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), "CannotChangeWarehouse"));
            return false;
        }
        String docSubTypeInv = MDocType.get(this.getC_DocType_ID()).getDocSubTypeInv();
        if ("CA".equals(docSubTypeInv) && this.getC_Currency_ID() == 0) {
            this.setC_Currency_ID(MClient.get(this.getCtx()).getAcctSchema().getC_Currency_ID());
        }
        return true;
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        int noLine = DB.executeUpdateEx("UPDATE M_InventoryLine SET Processed=? WHERE M_Inventory_ID=?", new Object[]{processed, this.getM_Inventory_ID()}, this.get_TrxName());
        this.m_lines = null;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Processed=" + processed + " - Lines=" + noLine);
        }
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getMovementDate(), "MMI", this.getAD_Org_ID());
        MAcctSchema.testBackDateTrxAllowed(this.getCtx(), this.getMovementDate(), this.get_TrxName());
        MInventoryLine[] lines = this.getLines(false);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        MInventoryLine[] mInventoryLineArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            MProduct product;
            MInventoryLine line = mInventoryLineArray[n2];
            if (line.getM_AttributeSetInstance_ID() == 0 && (product = MProduct.get(this.getCtx(), line.getM_Product_ID(), this.get_TrxName())) != null && product.isASIMandatoryFor(null, line.isSOTrx()) && product.getAttributeSet() != null && !product.getAttributeSet().excludeTableEntry(322, line.isSOTrx())) {
                MDocType dt = MDocType.get(this.getC_DocType_ID());
                String docSubTypeInv = dt.getDocSubTypeInv();
                BigDecimal qtyDiff = line.getQtyInternalUse();
                if ("PI".equals(docSubTypeInv)) {
                    qtyDiff = line.getQtyBook().subtract(line.getQtyCount());
                }
                MInventoryLineMA[] mas = MInventoryLineMA.get(this.getCtx(), line.getM_InventoryLine_ID(), this.get_TrxName());
                BigDecimal qtyma = Env.ZERO;
                MInventoryLineMA[] mInventoryLineMAArray = mas;
                int n3 = mas.length;
                int n4 = 0;
                while (n4 < n3) {
                    MInventoryLineMA ma = mInventoryLineMAArray[n4];
                    if (!ma.isAutoGenerated()) {
                        qtyma = qtyma.add(ma.getMovementQty());
                    }
                    ++n4;
                }
                if (qtyma.subtract(qtyDiff).signum() != 0) {
                    this.m_processMsg = "@Line@ " + line.getLine() + ": @FillMandatory@ @M_AttributeSetInstance_ID@";
                    return "IN";
                }
            }
            ++n2;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setIsApproved(false);
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public String completeIt() {
        MInventoryLine[] lines;
        MDocType dt = MDocType.get(this.getC_DocType_ID());
        String docSubTypeInv = dt.getDocSubTypeInv();
        if (Util.isEmpty(docSubTypeInv)) {
            this.m_processMsg = "Document inventory subtype not configured, cannot complete";
            return "IN";
        }
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.setDefiniteDocumentNo();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        if (!this.isReversal()) {
            try {
                this.periodClosedCheckForBackDateTrx(null);
            }
            catch (PeriodClosedException e) {
                this.m_processMsg = e.getLocalizedMessage();
                return "IN";
            }
        }
        StringBuilder errors = new StringBuilder();
        MInventoryLine[] mInventoryLineArray = lines = this.getLines(false);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            MInventoryLine line = mInventoryLineArray[n2];
            if (line.isActive()) {
                MProduct product = line.getProduct();
                try {
                    Object cost;
                    BigDecimal qtyDiff = Env.ZERO;
                    if ("IU".equals(docSubTypeInv)) {
                        qtyDiff = line.getQtyInternalUse().negate();
                    } else if ("PI".equals(docSubTypeInv)) {
                        qtyDiff = line.getQtyCount().subtract(line.getQtyBook());
                    } else if ("CA".equals(docSubTypeInv) && !this.isReversal()) {
                        BigDecimal currentCost = line.getCurrentCostPrice();
                        MClient client = MClient.get(this.getCtx(), this.getAD_Client_ID());
                        MAcctSchema as = client.getAcctSchema();
                        MAcctSchema[] ass = MAcctSchema.getClientAcctSchema(this.getCtx(), client.get_ID());
                        if (as.getC_Currency_ID() != this.getC_Currency_ID()) {
                            int i = 0;
                            while (i < ass.length) {
                                MAcctSchema a2 = ass[i];
                                if (a2.getC_Currency_ID() == this.getC_Currency_ID()) {
                                    as = a2;
                                }
                                ++i;
                            }
                        }
                        if ((cost = product.getCostInfo(as, this.getAD_Org_ID(), line.getM_AttributeSetInstance_ID(), this.getCostingMethod(), this.getMovementDate())) != null && cost.getCurrentCostPrice().compareTo(currentCost) != 0) {
                            this.m_processMsg = "Current Cost for Line " + line.getLine() + " have changed.";
                            return "IN";
                        }
                    }
                    if ("PI".equals(docSubTypeInv) && !this.isReversal()) {
                        if (line.getM_AttributeSetInstance_ID() == 0) {
                            storages = MStorageOnHand.getWarehouse(this.getCtx(), this.getM_Warehouse_ID(), line.getM_Product_ID(), 0, null, "F".equals(product.getMMPolicy()), true, line.getM_Locator_ID(), this.get_TrxName(), false);
                            if (storages != null) {
                                cost = storages;
                                int ass = storages.length;
                                int as = 0;
                                while (as < ass) {
                                    storage = cost[as];
                                    ((X_M_StorageOnHand)storage).setDateLastInventory(this.getMovementDate());
                                    if (!((PO)storage).save(this.get_TrxName())) {
                                        this.m_processMsg = "Storage on hand not updated for DateLastInventory";
                                        return "IN";
                                    }
                                    ++as;
                                }
                            }
                        } else {
                            storages = MStorageOnHand.getAll(this.getCtx(), line.getM_Product_ID(), line.getM_Locator_ID(), line.getM_AttributeSetInstance_ID(), null, false, this.get_TrxName());
                            if (storages != null) {
                                cost = storages;
                                int ass = storages.length;
                                int as = 0;
                                while (as < ass) {
                                    storage = cost[as];
                                    ((X_M_StorageOnHand)storage).setDateLastInventory(this.getMovementDate());
                                    if (!((PO)storage).save(this.get_TrxName())) {
                                        this.m_processMsg = "Storage on hand not updated for DateLastInventory";
                                        return "IN";
                                    }
                                    ++as;
                                }
                            }
                        }
                    }
                    if (qtyDiff.signum() != 0) {
                        if (!this.isReversal()) {
                            BigDecimal qtyOnLineMA = MInventoryLineMA.getManualQty(line.getM_InventoryLine_ID(), this.get_TrxName());
                            if (qtyDiff.signum() < 0) {
                                if (qtyOnLineMA.compareTo(qtyDiff) < 0) {
                                    this.m_processMsg = "@Over_Qty_On_Attribute_Tab@ " + line.getLine();
                                    return "IN";
                                }
                            } else if (qtyOnLineMA.compareTo(qtyDiff) > 0) {
                                this.m_processMsg = "@Over_Qty_On_Attribute_Tab@ " + line.getLine();
                                return "IN";
                            }
                            this.checkMaterialPolicy(line, qtyDiff.subtract(qtyOnLineMA));
                        }
                        if (product != null && product.isStocked()) {
                            this.log.fine("Material Transaction");
                            MTransaction mtrx = null;
                            if (line.getM_AttributeSetInstance_ID() == 0 || qtyDiff.compareTo(Env.ZERO) == 0) {
                                MInventoryLineMA[] mas = MInventoryLineMA.get(this.getCtx(), line.getM_InventoryLine_ID(), this.get_TrxName());
                                int j = 0;
                                while (j < mas.length) {
                                    MInventoryLineMA ma = mas[j];
                                    BigDecimal QtyMA = ma.getMovementQty();
                                    BigDecimal QtyNew = QtyMA.add(qtyDiff);
                                    if (this.log.isLoggable(Level.FINE)) {
                                        this.log.fine("Diff=" + String.valueOf(qtyDiff) + " - Instance OnHand=" + String.valueOf(QtyMA) + "->" + String.valueOf(QtyNew));
                                    }
                                    if (!MStorageOnHand.add(this.getCtx(), line.getM_Locator_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), QtyMA.negate(), ma.getDateMaterialPolicy(), this.getMovementDate(), this.get_TrxName())) {
                                        String lastError = CLogger.retrieveErrorString("");
                                        this.m_processMsg = "Cannot correct Inventory (MA) - " + lastError;
                                        return "IN";
                                    }
                                    String m_MovementType = null;
                                    m_MovementType = QtyMA.negate().compareTo(Env.ZERO) > 0 ? "I+" : "I-";
                                    mtrx = new MTransaction(this.getCtx(), line.getAD_Org_ID(), m_MovementType, line.getM_Locator_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), QtyMA.negate(), this.getMovementDate(), this.get_TrxName());
                                    mtrx.setM_InventoryLine_ID(line.getM_InventoryLine_ID());
                                    if (!mtrx.save()) {
                                        this.m_processMsg = "Transaction not inserted(2)";
                                        return "IN";
                                    }
                                    qtyDiff = QtyNew;
                                    ++j;
                                }
                            }
                            if (mtrx == null) {
                                Timestamp t;
                                Timestamp dateMPolicy;
                                Timestamp timestamp = dateMPolicy = qtyDiff.signum() > 0 ? this.getMovementDate() : null;
                                if (line.getM_AttributeSetInstance_ID() > 0 && (t = MStorageOnHand.getDateMaterialPolicy(line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.getM_Locator_ID(), line.get_TrxName())) != null) {
                                    dateMPolicy = t;
                                }
                                if (!MStorageOnHand.add(this.getCtx(), line.getM_Locator_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), qtyDiff, dateMPolicy, this.getMovementDate(), this.get_TrxName())) {
                                    String lastError = CLogger.retrieveErrorString("");
                                    this.m_processMsg = "Cannot correct Inventory OnHand (MA) - " + lastError;
                                    return "IN";
                                }
                                String m_MovementType = null;
                                m_MovementType = qtyDiff.compareTo(Env.ZERO) > 0 ? "I+" : "I-";
                                mtrx = new MTransaction(this.getCtx(), line.getAD_Org_ID(), m_MovementType, line.getM_Locator_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), qtyDiff, this.getMovementDate(), this.get_TrxName());
                                mtrx.setM_InventoryLine_ID(line.getM_InventoryLine_ID());
                                if (!mtrx.save()) {
                                    this.m_processMsg = "Transaction not inserted(2)";
                                    return "IN";
                                }
                            }
                        }
                    }
                }
                catch (NegativeInventoryDisallowedException e) {
                    this.log.severe(e.getMessage());
                    errors.append(Msg.getElement(this.getCtx(), "Line")).append(" ").append(line.getLine()).append(": ");
                    errors.append(e.getMessage()).append("\n");
                }
            }
            ++n2;
        }
        if (errors.toString().length() > 0) {
            this.m_processMsg = errors.toString();
            return "IN";
        }
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    protected void setDefiniteDocumentNo() {
        String value;
        MDocType dt = MDocType.get(this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setMovementDate(TimeUtil.getDay(0L));
            MPeriod.testPeriodOpen(this.getCtx(), this.getMovementDate(), "MMI", this.getAD_Org_ID());
            MAcctSchema.testBackDateTrxAllowed(this.getCtx(), this.getMovementDate(), this.get_TrxName());
        }
        if (dt.isOverwriteSeqOnComplete() && (value = DB.getDocumentNo(this.getC_DocType_ID(), this.get_TrxName(), true, (PO)this)) != null) {
            this.setDocumentNo(value);
        }
    }

    protected void checkMaterialPolicy(MInventoryLine line, BigDecimal qtyDiff) {
        int no = MInventoryLineMA.deleteInventoryLineMA(line.getM_InventoryLine_ID(), this.get_TrxName());
        if (no > 0 && this.log.isLoggable(Level.CONFIG)) {
            this.log.config("Delete old #" + no);
        }
        if (((BigDecimal)qtyDiff).compareTo(Env.ZERO) == 0) {
            return;
        }
        if (line.getM_AttributeSetInstance_ID() == 0) {
            MProduct product = MProduct.get(this.getCtx(), line.getM_Product_ID(), this.get_TrxName());
            boolean serial = product.isSerial();
            if (((BigDecimal)qtyDiff).signum() > 0) {
                MInventoryLineMA lineMA;
                Object maQty;
                MStorageOnHand[] storages;
                MStorageOnHand[] mStorageOnHandArray = storages = MStorageOnHand.getWarehouseNegative(this.getCtx(), this.getM_Warehouse_ID(), line.getM_Product_ID(), 0, null, "F".equals(product.getMMPolicy()), line.getM_Locator_ID(), this.get_TrxName(), false);
                int n = storages.length;
                int n2 = 0;
                while (n2 < n) {
                    MAttributeSetInstance asi;
                    MStorageOnHand storage = mStorageOnHandArray[n2];
                    if ((storage.getM_AttributeSetInstance_ID() <= 0 || !serial || Util.isEmpty((asi = new MAttributeSetInstance(Env.getCtx(), storage.getM_AttributeSetInstance_ID(), this.get_TrxName())).getSerNo(), true)) && storage.getQtyOnHand().signum() < 0) {
                        maQty = qtyDiff;
                        if (maQty.compareTo(storage.getQtyOnHand().negate()) > 0) {
                            maQty = storage.getQtyOnHand().negate();
                        }
                        lineMA = new MInventoryLineMA(line, storage.getM_AttributeSetInstance_ID(), maQty.negate(), storage.getDateMaterialPolicy(), true);
                        lineMA.saveEx();
                        qtyDiff = ((BigDecimal)qtyDiff).subtract((BigDecimal)maQty);
                        if (((BigDecimal)qtyDiff).compareTo(Env.ZERO) == 0) break;
                    }
                    ++n2;
                }
                if (((BigDecimal)qtyDiff).compareTo(Env.ZERO) > 0) {
                    I_M_AttributeSet as = line.getM_Product().getM_AttributeSet();
                    if (as != null && as.isInstanceAttribute()) {
                        maQty = storages = MStorageOnHand.getWarehouse(this.getCtx(), this.getM_Warehouse_ID(), line.getM_Product_ID(), 0, null, false, true, 0, this.get_TrxName());
                        int n3 = storages.length;
                        n = 0;
                        while (n < n3) {
                            MAttributeSetInstance asi;
                            MStorageOnHand storage = maQty[n];
                            if (storage.getM_AttributeSetInstance_ID() != 0 && (!serial || Util.isEmpty((asi = new MAttributeSetInstance(Env.getCtx(), storage.getM_AttributeSetInstance_ID(), this.get_TrxName())).getSerNo(), true))) {
                                Object maQty2 = qtyDiff;
                                MInventoryLineMA lineMA2 = new MInventoryLineMA(line, storage.getM_AttributeSetInstance_ID(), ((BigDecimal)maQty2).negate(), storage.getDateMaterialPolicy(), true);
                                lineMA2.saveEx();
                                qtyDiff = ((BigDecimal)qtyDiff).subtract((BigDecimal)maQty2);
                                if (((BigDecimal)qtyDiff).compareTo(Env.ZERO) == 0) break;
                            }
                            ++n;
                        }
                    }
                    if (((BigDecimal)qtyDiff).compareTo(Env.ZERO) > 0) {
                        MClientInfo m_clientInfo = MClientInfo.get(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName());
                        MAcctSchema acctSchema = new MAcctSchema(this.getCtx(), m_clientInfo.getC_AcctSchema1_ID(), this.get_TrxName());
                        if ("B".equals(product.getCostingLevel(acctSchema))) {
                            String sqlWhere = "M_Product_ID=? AND M_Locator_ID=? AND QtyOnHand = 0 AND M_AttributeSetInstance_ID > 0 ";
                            MStorageOnHand storage = (MStorageOnHand)new Query(this.getCtx(), "M_StorageOnHand", sqlWhere, this.get_TrxName()).setParameters(line.getM_Product_ID(), line.getM_Locator_ID()).setOrderBy("DateMaterialPolicy,M_AttributeSetInstance_ID").first();
                            if (storage != null) {
                                lineMA = MInventoryLineMA.addOrCreate(line, storage.getM_AttributeSetInstance_ID(), ((BigDecimal)qtyDiff).negate(), this.getMovementDate(), true);
                                lineMA.saveEx();
                            } else {
                                String costingMethod = product.getCostingMethod(acctSchema);
                                StringBuilder localWhereClause = new StringBuilder("M_Product_ID =?").append(" AND C_AcctSchema_ID=?").append(" AND ce.CostingMethod = ? ").append(" AND CurrentCostPrice <> 0 ");
                                MCost cost = (MCost)new Query(this.getCtx(), "M_Cost", localWhereClause.toString(), this.get_TrxName()).setParameters(line.getM_Product_ID(), acctSchema.get_ID(), costingMethod).addJoinClause(" INNER JOIN M_CostElement ce ON (M_Cost.M_CostElement_ID =ce.M_CostElement_ID ) ").setOrderBy("Updated DESC").first();
                                if (cost != null) {
                                    MInventoryLineMA lineMA3 = MInventoryLineMA.addOrCreate(line, cost.getM_AttributeSetInstance_ID(), ((BigDecimal)qtyDiff).negate(), this.getMovementDate(), true);
                                    lineMA3.saveEx();
                                } else {
                                    this.m_processMsg = "Cannot retrieve cost of Inventory ";
                                }
                            }
                        } else {
                            MInventoryLineMA lineMA4 = MInventoryLineMA.addOrCreate(line, 0, ((BigDecimal)qtyDiff).negate(), this.getMovementDate(), true);
                            lineMA4.saveEx();
                        }
                    }
                }
            } else {
                String MMPolicy = product.getMMPolicy();
                MStorageOnHand[] storages = MStorageOnHand.getWarehouse(this.getCtx(), this.getM_Warehouse_ID(), line.getM_Product_ID(), 0, null, "F".equals(MMPolicy), true, line.getM_Locator_ID(), this.get_TrxName(), false);
                BigDecimal qtyToDeliver = ((BigDecimal)qtyDiff).negate();
                MStorageOnHand[] mStorageOnHandArray = storages;
                int n = storages.length;
                int n4 = 0;
                while (n4 < n) {
                    MAttributeSetInstance asi;
                    MStorageOnHand storage = mStorageOnHandArray[n4];
                    if (!serial || storage.getM_AttributeSetInstance_ID() <= 0 || Util.isEmpty((asi = new MAttributeSetInstance(Env.getCtx(), storage.getM_AttributeSetInstance_ID(), this.get_TrxName())).getSerNo(), true)) {
                        if (storage.getQtyOnHand().compareTo(qtyToDeliver) >= 0) {
                            ma = new MInventoryLineMA(line, storage.getM_AttributeSetInstance_ID(), qtyToDeliver, storage.getDateMaterialPolicy(), true);
                            ma.saveEx();
                            qtyToDeliver = Env.ZERO;
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine(String.valueOf(ma) + ", QtyToDeliver=" + String.valueOf(qtyToDeliver));
                            }
                        } else {
                            ma = new MInventoryLineMA(line, storage.getM_AttributeSetInstance_ID(), storage.getQtyOnHand(), storage.getDateMaterialPolicy(), true);
                            ma.saveEx();
                            qtyToDeliver = qtyToDeliver.subtract(storage.getQtyOnHand());
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine(String.valueOf(ma) + ", QtyToDeliver=" + String.valueOf(qtyToDeliver));
                            }
                        }
                        if (qtyToDeliver.signum() == 0) break;
                    }
                    ++n4;
                }
                if (qtyToDeliver.signum() != 0) {
                    MInventoryLineMA lineMA = MInventoryLineMA.addOrCreate(line, 0, qtyToDeliver, this.getMovementDate(), true);
                    lineMA.saveEx();
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("##: " + String.valueOf(lineMA));
                    }
                }
            }
        }
    }

    @Override
    public boolean voidIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            return false;
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
            if (this.m_processMsg != null) {
                return false;
            }
            MInventoryLine[] lines = this.getLines(false);
            int i = 0;
            while (i < lines.length) {
                MInventoryLine line = lines[i];
                BigDecimal oldCount = line.getQtyCount();
                BigDecimal oldInternal = line.getQtyInternalUse();
                if (oldCount.compareTo(line.getQtyBook()) != 0 || oldInternal.signum() != 0) {
                    line.setQtyInternalUse(Env.ZERO);
                    line.setQtyCount(line.getQtyBook());
                    StringBuilder msgd = new StringBuilder("Void (").append(oldCount).append("/").append(oldInternal).append(")");
                    line.addDescription(msgd.toString());
                    line.saveEx(this.get_TrxName());
                }
                ++i;
            }
        } else {
            boolean accrual = false;
            try {
                MPeriod.testPeriodOpen(this.getCtx(), this.getMovementDate(), this.getC_DocType_ID(), this.getAD_Org_ID());
            }
            catch (PeriodClosedException periodClosedException) {
                accrual = true;
            }
            try {
                MAcctSchema.testBackDateTrxAllowed(this.getCtx(), this.getMovementDate(), this.get_TrxName());
            }
            catch (BackDateTrxNotAllowedException backDateTrxNotAllowedException) {
                accrual = true;
            }
            if (accrual) {
                return this.reverseAccrualIt();
            }
            return this.reverseCorrectIt();
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        MInventory reversal = this.reverse(false);
        if (reversal == null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = reversal.getDocumentNo();
        return true;
    }

    protected MInventory reverse(boolean accrual) {
        Timestamp reversalDate;
        Timestamp timestamp = reversalDate = accrual ? Env.getContextAsDate(this.getCtx(), "#Date") : this.getMovementDate();
        if (reversalDate == null) {
            reversalDate = new Timestamp(System.currentTimeMillis());
        }
        MDocType dt = MDocType.get(this.getC_DocType_ID());
        MPeriod.testPeriodOpen(this.getCtx(), reversalDate, dt.getDocBaseType(), this.getAD_Org_ID());
        MAcctSchema.testBackDateTrxAllowed(this.getCtx(), reversalDate, this.get_TrxName());
        try {
            this.periodClosedCheckForBackDateTrx(reversalDate);
        }
        catch (PeriodClosedException e) {
            this.m_processMsg = e.getLocalizedMessage();
            return null;
        }
        MInventory reversal = new MInventory(this.getCtx(), 0, this.get_TrxName());
        MInventory.copyValues(this, reversal, this.getAD_Client_ID(), this.getAD_Org_ID());
        reversal.setDocumentNo(this.getDocumentNo() + REVERSE_INDICATOR);
        reversal.setMovementDate(reversalDate);
        reversal.setDocStatus("DR");
        reversal.setDocAction("CO");
        reversal.setIsApproved(false);
        reversal.setPosted(false);
        reversal.setProcessed(false);
        StringBuilder msgd = new StringBuilder("{->").append(this.getDocumentNo()).append(")");
        reversal.addDescription(msgd.toString());
        reversal.setReversal_ID(this.getM_Inventory_ID());
        reversal.saveEx();
        reversal.setReversal(true);
        MInventoryLine[] oLines = this.getLines(true);
        int i = 0;
        while (i < oLines.length) {
            MInventoryLine oLine = oLines[i];
            MInventoryLine rLine = new MInventoryLine(this.getCtx(), 0, this.get_TrxName());
            MInventory.copyValues(oLine, rLine, oLine.getAD_Client_ID(), oLine.getAD_Org_ID());
            rLine.setM_Inventory_ID(reversal.getM_Inventory_ID());
            rLine.setParent(reversal);
            rLine.setReversalLine_ID(oLine.getM_InventoryLine_ID());
            rLine.setQtyBook(oLine.getQtyCount());
            rLine.setQtyCount(oLine.getQtyBook());
            rLine.setQtyInternalUse(oLine.getQtyInternalUse().negate());
            rLine.setNewCostPrice(oLine.getCurrentCostPrice());
            rLine.setCurrentCostPrice(oLine.getNewCostPrice());
            rLine.saveEx();
            if (rLine.getM_AttributeSetInstance_ID() == 0) {
                MInventoryLineMA[] mas = MInventoryLineMA.get(this.getCtx(), oLines[i].getM_InventoryLine_ID(), this.get_TrxName());
                int j = 0;
                while (j < mas.length) {
                    MInventoryLineMA ma = new MInventoryLineMA(rLine, mas[j].getM_AttributeSetInstance_ID(), mas[j].getMovementQty().negate(), mas[j].getDateMaterialPolicy(), true);
                    ma.saveEx();
                    ++j;
                }
            }
            ++i;
        }
        if (!reversal.processIt("CO")) {
            this.m_processMsg = "Reversal ERROR: " + reversal.getProcessMsg();
            return null;
        }
        reversal.closeIt();
        reversal.setDocStatus("RE");
        reversal.setDocAction("--");
        reversal.saveEx();
        msgd = new StringBuilder("(").append(reversal.getDocumentNo()).append("<-)");
        this.addDescription(msgd.toString());
        this.setProcessed(true);
        this.setReversal_ID(reversal.getM_Inventory_ID());
        this.setDocStatus("RE");
        this.setDocAction("--");
        return reversal;
    }

    @Override
    public boolean reverseAccrualIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        MInventory reversal = this.reverse(true);
        if (reversal == null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = reversal.getDocumentNo();
        return true;
    }

    @Override
    public boolean reActivateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate(this.getCtx(), "ApprovalAmt")).append("=").append(this.getApprovalAmt()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getUpdatedBy();
    }

    protected void setReversal(boolean reversal) {
        this.m_reversal = reversal;
    }

    protected boolean isReversal() {
        return this.m_reversal;
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }

    private boolean periodClosedCheckForBackDateTrx(Timestamp reversalDate) {
        MInventoryLine[] iLines;
        MClientInfo info = MClientInfo.get(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName());
        MAcctSchema as = info.getMAcctSchema1();
        if (!"A".equals(as.getCostingMethod()) && !"I".equals(as.getCostingMethod())) {
            return true;
        }
        if (as.getBackDateDay() == 0) {
            return true;
        }
        Timestamp dateAcct = reversalDate != null ? reversalDate : this.getMovementDate();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT COUNT(*) FROM M_CostDetail ");
        sql.append("WHERE M_Product_ID IN (SELECT M_Product_ID FROM M_InventoryLine WHERE M_Inventory_ID=?) ");
        sql.append("AND Processed='Y' ");
        sql.append(reversalDate != null ? "AND DateAcct>=? " : "AND DateAcct>? ");
        int no = DB.getSQLValueEx(this.get_TrxName(), sql.toString(), this.get_ID(), dateAcct);
        if (no <= 0) {
            return true;
        }
        MInventoryLine[] mInventoryLineArray = iLines = this.getLines(false);
        int n = iLines.length;
        int n2 = 0;
        while (n2 < n) {
            MCostDetail cd;
            MInventoryLine iLine = mInventoryLineArray[n2];
            int AD_Org_ID = iLine.getAD_Org_ID();
            int M_AttributeSetInstance_ID = iLine.getM_AttributeSetInstance_ID();
            if ("C".equals(as.getCostingLevel())) {
                AD_Org_ID = 0;
                M_AttributeSetInstance_ID = 0;
            } else if ("O".equals(as.getCostingLevel())) {
                M_AttributeSetInstance_ID = 0;
            } else if ("B".equals(as.getCostingLevel())) {
                AD_Org_ID = 0;
            }
            MCostElement ce = MCostElement.getMaterialCostElement(this.getCtx(), as.getCostingMethod(), AD_Org_ID);
            int M_CostDetail_ID = 0;
            int M_InventoryLine_ID = iLine.getM_InventoryLine_ID();
            if (iLine.getReversalLine_ID() > 0 && iLine.get_ID() > iLine.getReversalLine_ID()) {
                M_InventoryLine_ID = iLine.getReversalLine_ID();
            }
            if ((cd = MCostDetail.getInventory(as, iLine.getM_Product_ID(), M_AttributeSetInstance_ID, M_InventoryLine_ID, 0, this.get_TrxName())) != null) {
                M_CostDetail_ID = cd.getM_CostDetail_ID();
            } else {
                MCostHistory history = MCostHistory.get(this.getCtx(), this.getAD_Client_ID(), AD_Org_ID, iLine.getM_Product_ID(), as.getM_CostType_ID(), as.getC_AcctSchema_ID(), ce.getCostingMethod(), ce.getM_CostElement_ID(), M_AttributeSetInstance_ID, dateAcct, this.get_TrxName());
                if (history != null) {
                    M_CostDetail_ID = history.getM_CostDetail_ID();
                }
            }
            if (M_CostDetail_ID > 0) {
                MCostDetail.periodClosedCheckForDocsAfterBackDateTrx(this.getAD_Client_ID(), as.getC_AcctSchema_ID(), iLine.getM_Product_ID(), M_CostDetail_ID, dateAcct, this.get_TrxName());
            }
            ++n2;
        }
        return true;
    }
}

