/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MColumn;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTable;
import org.compiere.model.M_Element;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

@Process
public class UUIDGenerator
extends SvrProcess {
    private String tableName;
    private boolean isFillUUID = false;
    private boolean isClearUUID = false;
    private static final CLogger s_log = CLogger.getCLogger(UUIDGenerator.class);

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter param = processInfoParameterArray[n2];
            if (param.getParameter() != null) {
                if (param.getParameterName().equals("TableName")) {
                    this.tableName = param.getParameter().toString();
                } else if (param.getParameterName().equals("IsFillUUID")) {
                    this.isFillUUID = param.getParameterAsBoolean();
                } else if (param.getParameterName().equals("IsClearUUID")) {
                    this.isClearUUID = param.getParameterAsBoolean();
                } else {
                    MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), param);
                }
            }
            ++n2;
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.tableName = this.tableName == null || this.tableName.trim().length() == 0 ? "%" : this.tableName.trim();
        String sql = "SELECT AD_Table_ID, TableName FROM AD_Table WHERE TableName LIKE ? AND IsView = 'N' AND IsActive='Y' ORDER BY TableName";
        CPreparedStatement stmt = null;
        ResultSet rs = null;
        int count = 0;
        try {
            stmt = DB.prepareStatement(sql, null);
            stmt.setString(1, this.tableName);
            rs = stmt.executeQuery();
            while (rs.next()) {
                StringBuilder sqlclear;
                int cnt;
                int AD_Table_ID = rs.getInt(1);
                String cTableName = rs.getString(2);
                this.statusUpdate(Msg.getMsg(this.getCtx(), "Processing") + " " + cTableName);
                String columnName = PO.getUUIDColumnName(cTableName);
                int AD_Column_ID = DB.getSQLValue(null, "SELECT AD_Column_ID FROM AD_Column Where AD_Table_ID = ? AND ColumnName = ?", AD_Table_ID, columnName);
                if (AD_Column_ID <= 0) {
                    String msg;
                    if (this.log.isLoggable(Level.INFO)) {
                        this.log.info("Adding UUID to " + cTableName);
                    }
                    ++count;
                    MColumn mColumn = new MColumn(this.getCtx(), 0, null);
                    mColumn.setAD_Table_ID(AD_Table_ID);
                    int AD_Element_ID = DB.getSQLValue(null, "SELECT AD_Element_ID FROM AD_Element WHERE ColumnName=?", columnName);
                    if (AD_Element_ID <= 0) {
                        M_Element adElement = new M_Element(this.getCtx(), 0, null);
                        adElement.setColumnName(columnName);
                        adElement.setName(columnName);
                        adElement.setPrintName(columnName);
                        adElement.setEntityType("U");
                        adElement.saveEx();
                        AD_Element_ID = adElement.getAD_Element_ID();
                    }
                    mColumn.setAD_Element_ID(AD_Element_ID);
                    mColumn.setColumnName(columnName);
                    mColumn.setAD_Reference_ID(200231);
                    mColumn.setEntityType("U");
                    mColumn.setFieldLength(36);
                    mColumn.setName(columnName);
                    mColumn.setVersion(Env.ONE);
                    mColumn.saveEx();
                    AD_Column_ID = mColumn.getAD_Column_ID();
                    this.syncColumn(mColumn);
                    if (!this.isFillUUID || Util.isEmpty(msg = UUIDGenerator.updateUUID(mColumn, null))) continue;
                    this.addBufferLog(0, null, null, msg, 0, 0);
                    continue;
                }
                MColumn column = MColumn.get(AD_Column_ID);
                if (column.isActive()) {
                    MColumn mColumn;
                    String msg;
                    if (!this.isFillUUID || Util.isEmpty(msg = UUIDGenerator.updateUUID(mColumn = MColumn.get(this.getCtx(), AD_Column_ID), null))) continue;
                    this.addBufferLog(0, null, null, msg, 0, 0);
                    continue;
                }
                if (!this.isClearUUID || (cnt = DB.executeUpdateEx((sqlclear = new StringBuilder("UPDATE ").append(cTableName).append(" SET ").append(columnName).append("=NULL WHERE ").append(columnName).append(" IS NOT NULL")).toString(), this.get_TrxName())) <= 0) continue;
                String msg = cnt + " UUID cleared from table " + cTableName;
                this.addBufferLog(0, null, null, msg, 0, 0);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, stmt);
            throw throwable;
        }
        DB.close(rs, stmt);
        StringBuilder msgreturn = new StringBuilder().append(count).append(" table altered");
        return msgreturn.toString();
    }

    public static String updateUUID(MColumn column, String trxName) {
        Trx trx;
        int n;
        MTable table2 = (MTable)column.getAD_Table();
        if (table2.getTableName().startsWith("T_")) {
            return "";
        }
        int AD_Column_ID = 0;
        StringBuilder sql = new StringBuilder("SELECT ");
        String keyColumn = null;
        String[] compositeKeys = table2.getKeyColumns();
        if (compositeKeys == null || compositeKeys.length == 1) {
            keyColumn = compositeKeys[0];
            AD_Column_ID = table2.getColumn(keyColumn).getAD_Column_ID();
            compositeKeys = null;
        }
        if ((compositeKeys == null || compositeKeys.length == 0) && keyColumn == null) {
            s_log.warning("Cannot update orphan table " + table2.getTableName() + " (not ID neither parents)");
            return "";
        }
        if (compositeKeys == null) {
            sql.append(keyColumn);
        } else {
            String[] stringArray = compositeKeys;
            n = compositeKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                sql.append(s).append(",");
                ++n2;
            }
            sql.deleteCharAt(sql.length() - 1);
        }
        sql.append(" FROM ").append(table2.getTableName());
        sql.append(" WHERE ").append(column.getColumnName()).append(" IS NULL ");
        StringBuilder updateSQL = new StringBuilder("UPDATE ");
        updateSQL.append(table2.getTableName());
        updateSQL.append(" SET ");
        updateSQL.append(column.getColumnName());
        updateSQL.append("=? WHERE ");
        if (AD_Column_ID > 0) {
            updateSQL.append(keyColumn).append("=?");
        } else {
            String[] stringArray = compositeKeys;
            int n3 = compositeKeys.length;
            n = 0;
            while (n < n3) {
                String s = stringArray[n];
                updateSQL.append(s).append("=? AND ");
                ++n;
            }
            int length = updateSQL.length();
            updateSQL.delete(length - 5, length);
        }
        boolean localTrx = false;
        CPreparedStatement stmt = null;
        ResultSet rs = null;
        Trx trx2 = trx = trxName != null ? Trx.get(trxName, false) : null;
        if (trx == null) {
            trx = Trx.get(Trx.createTrxName(), true);
            trx.setDisplayName(UUIDGenerator.class.getName() + "_updateUUID");
            localTrx = true;
        }
        Object msg = "";
        try {
            try {
                if (localTrx) {
                    trx.start();
                }
                stmt = DB.prepareStatement(sql.toString(), trx.getTrxName());
                stmt.setFetchSize(100);
                rs = stmt.executeQuery();
                int no = 0;
                while (rs.next()) {
                    if (AD_Column_ID > 0) {
                        int recordId = rs.getInt(1);
                        if (recordId <= 999999) continue;
                        UUID uuid = UUID.randomUUID();
                        no += DB.executeUpdateEx(updateSQL.toString(), new Object[]{uuid.toString(), recordId}, trx.getTrxName());
                        continue;
                    }
                    UUID uuid = UUID.randomUUID();
                    ArrayList<Object> params = new ArrayList<Object>();
                    params.add(uuid.toString());
                    String[] stringArray = compositeKeys;
                    int n4 = compositeKeys.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        String s = stringArray[n5];
                        params.add(rs.getObject(s));
                        ++n5;
                    }
                    no += DB.executeUpdateEx(updateSQL.toString(), params.toArray(), trx.getTrxName());
                }
                if (no > 0) {
                    msg = no + " UUID assigned for table " + table2.getTableName();
                }
                if (localTrx) {
                    trx.commit(true);
                }
            }
            catch (SQLException e) {
                if (localTrx) {
                    trx.rollback();
                }
                throw new DBException(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, stmt);
            if (localTrx) {
                trx.close();
            }
            throw throwable;
        }
        DB.close(rs, stmt);
        if (localTrx) {
            trx.close();
        }
        return msg;
    }

    private void syncColumn(MColumn column) {
        Connection conn = null;
        try {
            try {
                conn = DB.getConnection();
                DatabaseMetaData md = conn.getMetaData();
                String catalog = DB.getDatabase().getCatalog();
                String schema = DB.getDatabase().getSchema();
                MTable table2 = (MTable)column.getAD_Table();
                String tableName = table2.getTableName();
                if (md.storesUpperCaseIdentifiers()) {
                    tableName = tableName.toUpperCase();
                } else if (md.storesLowerCaseIdentifiers()) {
                    tableName = tableName.toLowerCase();
                }
                int noColumns = 0;
                StringBuilder sql = null;
                ResultSet rs = null;
                try {
                    rs = md.getColumns(catalog, schema, tableName, null);
                    while (rs.next()) {
                        ++noColumns;
                        StringBuilder columnName = new StringBuilder().append(rs.getString("COLUMN_NAME"));
                        if (!columnName.toString().equalsIgnoreCase(column.getColumnName())) continue;
                        boolean notNull = rs.getInt("NULLABLE") == 0;
                        sql = new StringBuilder().append(column.getSQLModify(table2, column.isMandatory() ^ notNull));
                        break;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs);
                    throw throwable;
                }
                DB.close(rs);
                if (noColumns == 0) {
                    sql = new StringBuilder(table2.getSQLCreate());
                } else if (sql == null) {
                    sql = new StringBuilder(column.getSQLAdd(table2));
                }
                int no = 0;
                if (sql.indexOf("; ") == -1) {
                    no = DB.executeUpdate(sql.toString(), false, null);
                    this.addLog(0, null, new BigDecimal(no), sql.toString());
                } else {
                    String[] statements = sql.toString().split("; ");
                    int i2 = 0;
                    while (i2 < statements.length) {
                        int count = DB.executeUpdate(statements[i2], false, null);
                        this.addLog(0, null, new BigDecimal(count), statements[i2]);
                        no += count;
                        ++i2;
                    }
                }
                if (no == -1) {
                    StringBuilder msg = new StringBuilder("@Error@ ");
                    ValueNamePair pp = CLogger.retrieveError();
                    if (pp != null) {
                        msg = new StringBuilder(pp.getName()).append(" - ");
                    }
                    msg.append((CharSequence)sql);
                    throw new AdempiereUserError(msg.toString());
                }
            }
            catch (SQLException e) {
                throw new DBException(e);
            }
        }
        catch (Throwable throwable) {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception exception) {}
        }
    }
}

