/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.exceptions;

import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.Env;

public class CrossTenantException
extends AdempiereException {
    private static final long serialVersionUID = 2869354491846765492L;
    private String fkColumn = null;
    private Object fkValue = null;

    public CrossTenantException(boolean isWriting, String tableName, int recordID) {
        super("Cross tenant PO " + (isWriting ? "writing" : "reading") + " request detected from session " + Env.getContext(Env.getCtx(), "#AD_Session_ID") + " for table " + tableName + " Record_ID=" + recordID);
    }

    public CrossTenantException(String tableName, int recordID) {
        super("Cross tenant ID " + recordID + " not allowed in " + tableName);
    }

    public CrossTenantException(String tableName, String recordUU) {
        super("Cross tenant UUID " + recordUU + " not allowed in " + tableName);
    }

    public CrossTenantException(Object fkValue, String fkColumn) {
        super("Cross tenant ID " + String.valueOf(fkValue) + " not allowed in " + fkColumn);
        this.fkColumn = fkColumn;
        this.fkValue = fkValue;
    }

    public String getFKColumn() {
        return this.fkColumn;
    }

    public Object getFKValue() {
        return this.fkValue;
    }
}

