/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base;

import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationInfoList;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.adempiere.base.AnnotationBasedFactory;
import org.adempiere.base.IColumnCallout;
import org.adempiere.base.IColumnCalloutFactory;
import org.adempiere.base.annotation.Callout;
import org.adempiere.base.annotation.Callouts;
import org.compiere.util.CLogger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;

public abstract class AnnotationBasedColumnCalloutFactory
extends AnnotationBasedFactory
implements IColumnCalloutFactory {
    private static final CLogger s_log = CLogger.getCLogger(AnnotationBasedColumnCalloutFactory.class);
    private BundleContext bundleContext;
    private final Map<String, Map<String, List<String>>> tableNameMap = new HashMap<String, Map<String, List<String>>>();
    private final Map<String, Constructor<?>[]> constructorCache = new ConcurrentHashMap<String, Constructor<?>[]>();

    @Override
    public IColumnCallout[] getColumnCallouts(String tableName, String columnName) {
        List<String> calloutClassNames;
        this.blockWhileScanning();
        ArrayList<IColumnCallout> callouts = new ArrayList<IColumnCallout>();
        ClassLoader classLoader = ((BundleWiring)this.bundleContext.getBundle().adapt(BundleWiring.class)).getClassLoader();
        Map<String, List<String>> columnNameMap = this.tableNameMap.get(tableName);
        if (columnNameMap != null) {
            calloutClassNames = columnNameMap.get(columnName);
            if (calloutClassNames != null) {
                this.newCalloutInstance(callouts, classLoader, calloutClassNames);
            }
            if ((calloutClassNames = columnNameMap.get("*")) != null) {
                this.newCalloutInstance(callouts, classLoader, calloutClassNames);
            }
        }
        if ((columnNameMap = this.tableNameMap.get("*")) != null) {
            calloutClassNames = columnNameMap.get(columnName);
            if (calloutClassNames != null) {
                this.newCalloutInstance(callouts, classLoader, calloutClassNames);
            }
            if ((calloutClassNames = columnNameMap.get("*")) != null) {
                this.newCalloutInstance(callouts, classLoader, calloutClassNames);
            }
        }
        return callouts.toArray(new IColumnCallout[0]);
    }

    private void newCalloutInstance(List<IColumnCallout> callouts, ClassLoader classLoader, List<String> calloutClassNames) {
        for (String calloutClass : calloutClassNames) {
            Constructor<?>[] constructors = this.constructorCache.get(calloutClass);
            if (constructors == null) {
                try {
                    Class<?> clazz = classLoader.loadClass(calloutClass);
                    Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                    IColumnCallout columnCallout = (IColumnCallout)constructor.newInstance(new Object[0]);
                    callouts.add(columnCallout);
                    constructors = new Constructor[]{constructor};
                    this.constructorCache.put(calloutClass, constructors);
                }
                catch (Exception e) {
                    s_log.log(Level.WARNING, e.getMessage(), e);
                    constructors = new Constructor[]{};
                    this.constructorCache.put(calloutClass, constructors);
                }
                continue;
            }
            if (constructors.length != 1) continue;
            try {
                IColumnCallout columnCallout = (IColumnCallout)constructors[0].newInstance(new Object[0]);
                callouts.add(columnCallout);
            }
            catch (Exception e) {
                s_log.log(Level.WARNING, e.getMessage(), e);
                constructors = new Constructor[]{};
                this.constructorCache.put(calloutClass, constructors);
            }
        }
    }

    protected abstract String[] getPackages();

    @Activate
    public void activate(ComponentContext context) throws ClassNotFoundException {
        long start = System.currentTimeMillis();
        this.bundleContext = context.getBundleContext();
        ClassLoader classLoader = ((BundleWiring)this.bundleContext.getBundle().adapt(BundleWiring.class)).getClassLoader();
        ClassGraph graph = new ClassGraph().enableAnnotationInfo().overrideClassLoaders(new ClassLoader[]{classLoader}).disableNestedJarScanning().disableModuleScanning().acceptPackagesNonRecursive(this.getPackages());
        ClassGraph.ScanResultProcessor scanResultProcessor = scanResult -> {
            String className;
            ArrayList<String> processed = new ArrayList<String>();
            for (ClassInfo classInfo : scanResult.getClassesWithAnnotation(Callouts.class)) {
                if (classInfo.isAbstract()) continue;
                className = classInfo.getName();
                AnnotationInfoList annotInfos = classInfo.getAnnotationInfo();
                for (AnnotationInfo annotInfo : annotInfos) {
                    Object[] calloutAnnotInfos;
                    if (Callout.class.getName().equals(annotInfo.getName())) {
                        this.processAnnotation(className, annotInfo);
                        continue;
                    }
                    if (!Callouts.class.getName().equals(annotInfo.getName())) continue;
                    String calloutsRepeatablePropertiesName = "value";
                    Object[] objectArray = calloutAnnotInfos = (Object[])annotInfo.getParameterValues().getValue(calloutsRepeatablePropertiesName);
                    int n = calloutAnnotInfos.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object calloutAnnotInfo = objectArray[n2];
                        this.processAnnotation(className, (AnnotationInfo)calloutAnnotInfo);
                        ++n2;
                    }
                }
                processed.add(className);
            }
            for (ClassInfo classInfo : scanResult.getClassesWithAnnotation(Callout.class)) {
                if (classInfo.isAbstract() || processed.contains(className = classInfo.getName())) continue;
                AnnotationInfo annotationInfo = classInfo.getAnnotationInfo(Callout.class);
                this.processAnnotation(className, annotationInfo);
            }
            this.signalScanCompletion(true);
            long end = System.currentTimeMillis();
            s_log.info(() -> this.getClass().getSimpleName() + " loaded " + this.tableNameMap.size() + " classes in " + (float)(end - start) / 1000.0f + "s");
        };
        graph.scanAsync(this.getExecutorService(), this.getMaxThreads(), scanResultProcessor, this.getScanFailureHandler());
    }

    private void processAnnotation(String className, AnnotationInfo annotationInfo) {
        Object[] tableNames = (Object[])annotationInfo.getParameterValues().getValue("tableName");
        Object[] columnNames = (Object[])annotationInfo.getParameterValues().getValue("columnName");
        boolean matchAllTables = false;
        Object[] objectArray = tableNames;
        int n = tableNames.length;
        int n2 = 0;
        while (n2 < n) {
            Object tableName = objectArray[n2];
            if ("*".equals(tableName)) {
                matchAllTables = true;
                break;
            }
            ++n2;
        }
        boolean matchAllColumns = false;
        Object[] objectArray2 = columnNames;
        int n3 = columnNames.length;
        n = 0;
        while (n < n3) {
            Object columnName = objectArray2[n];
            if ("*".equals(columnName)) {
                matchAllColumns = true;
                break;
            }
            ++n;
        }
        if (matchAllColumns && matchAllTables) {
            return;
        }
        Map<String, List<String>> columnNameMap = null;
        if (matchAllTables) {
            columnNameMap = this.tableNameMap.get("*");
            if (columnNameMap == null) {
                columnNameMap = new HashMap<String, List<String>>();
                this.tableNameMap.put("*", columnNameMap);
            }
            if (matchAllColumns) {
                this.addCallout(className, columnNameMap);
            } else {
                this.addCallout(className, columnNames, columnNameMap);
            }
        } else {
            Object[] objectArray3 = tableNames;
            int n4 = tableNames.length;
            n3 = 0;
            while (n3 < n4) {
                Object tableName = objectArray3[n3];
                columnNameMap = this.tableNameMap.get(tableName);
                if (columnNameMap == null) {
                    columnNameMap = new HashMap<String, List<String>>();
                    this.tableNameMap.put((String)tableName, columnNameMap);
                }
                if (matchAllColumns) {
                    this.addCallout(className, columnNameMap);
                } else {
                    this.addCallout(className, columnNames, columnNameMap);
                }
                ++n3;
            }
        }
    }

    private void addCallout(String className, Object[] columnNames, Map<String, List<String>> columnNameMap) {
        Object[] objectArray = columnNames;
        int n = columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            Object columnName = objectArray[n2];
            List<String> callouts = columnNameMap.get(columnName);
            if (callouts == null) {
                callouts = new ArrayList<String>();
                columnNameMap.put((String)columnName, callouts);
            }
            callouts.add(className);
            ++n2;
        }
    }

    private void addCallout(String className, Map<String, List<String>> columnNameMap) {
        List<String> callouts = columnNameMap.get("*");
        if (callouts == null) {
            callouts = new ArrayList<String>();
            columnNameMap.put("*", callouts);
        }
        callouts.add(className);
    }
}

