/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print.layout;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.awt.image.ImageObserver;
import java.io.Serializable;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MQuery;
import org.compiere.print.PrintData;
import org.compiere.print.layout.Page;
import org.compiere.util.CLogger;

public abstract class PrintElement
implements ImageObserver,
Serializable {
    private static final long serialVersionUID = 5894090289966933777L;
    public static final Color LINK_COLOR = Color.blue;
    protected float p_width = 0.0f;
    protected float p_height = 0.0f;
    protected boolean p_sizeCalculated = false;
    protected float p_maxWidth = 0.0f;
    protected float p_maxHeight = 0.0f;
    protected String p_FieldAlignmentType;
    protected Point2D.Double p_pageLocation = null;
    private boolean m_imageNotLoaded = true;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private Page m_currentPage;
    private PrintData m_printData;
    private int m_rowIndex = -1;
    private String m_pageLogic;

    protected PrintElement() {
    }

    public float getWidth() {
        if (!this.p_sizeCalculated) {
            this.p_sizeCalculated = this.calculateSize();
        }
        return this.p_width;
    }

    public float getHeight() {
        if (!this.p_sizeCalculated) {
            this.p_sizeCalculated = this.calculateSize();
        }
        return this.p_height;
    }

    public float getHeight(int pageNo) {
        return this.getHeight();
    }

    public int getPageCount() {
        return 1;
    }

    protected abstract boolean calculateSize();

    public void layout(float maxWidth, float maxHeight, boolean isHeightOneLine, String FieldAlignmentType) {
        if (isHeightOneLine) {
            this.p_maxHeight = -1.0f;
        } else if (maxHeight > 0.0f) {
            this.p_maxHeight = maxHeight;
        }
        this.p_maxWidth = maxWidth;
        this.p_FieldAlignmentType = FieldAlignmentType;
        if (this.p_FieldAlignmentType == null || this.p_FieldAlignmentType.equals("D")) {
            this.p_FieldAlignmentType = "L";
        }
        this.p_sizeCalculated = this.calculateSize();
    }

    public void setMaxHeight(float maxHeight) {
        this.p_maxHeight = maxHeight;
    }

    public void setMaxWidth(float maxWidth) {
        this.p_maxWidth = maxWidth;
    }

    public void setLocation(Point2D pageLocation) {
        this.p_pageLocation = new Point2D.Double(pageLocation.getX(), pageLocation.getY());
    }

    public Point2D getLocation() {
        return this.p_pageLocation;
    }

    protected Point2D.Double getAbsoluteLocation(Point2D pageStart) {
        Point2D.Double retValue = new Point2D.Double(this.p_pageLocation.x + pageStart.getX(), this.p_pageLocation.y + pageStart.getY());
        return retValue;
    }

    public Rectangle getBounds() {
        if (this.p_pageLocation == null) {
            return new Rectangle(0, 0, (int)this.p_width, (int)this.p_height);
        }
        return new Rectangle((int)this.p_pageLocation.x, (int)this.p_pageLocation.y, (int)this.p_width, (int)this.p_height);
    }

    public MQuery getDrillDown(Point relativePoint, int pageNo) {
        return null;
    }

    public MQuery getDrillAcross(Point relativePoint, int pageNo) {
        return null;
    }

    public void translate(Properties ctx) {
    }

    public boolean isTranslated() {
        return false;
    }

    public abstract void paint(Graphics2D var1, int var2, Point2D var3, Properties var4, boolean var5);

    @Override
    public boolean imageUpdate(Image img2, int infoflags, int x, int y, int width, int height) {
        boolean bl = this.m_imageNotLoaded = (infoflags & 0xA0) == 0;
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Flags=" + infoflags + ", x=" + x + ", y=" + y + ", width=" + width + ", height=" + height + " - NotLoaded=" + this.m_imageNotLoaded);
        }
        return this.m_imageNotLoaded;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitForLoad(Image image) {
        long start = System.currentTimeMillis();
        Thread.yield();
        int count = 0;
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            while (!toolkit.prepareImage(image, -1, -1, this)) {
                block10: {
                    if (count > 1000) {
                        this.log.severe(String.valueOf(this) + " - Timeout - " + (System.currentTimeMillis() - start) + "ms - #" + count);
                        return false;
                    }
                    try {
                        if (count < 10) {
                            Thread.sleep(10L);
                            break block10;
                        }
                        if (count < 100) {
                            Thread.sleep(15L);
                        } else {
                            Thread.sleep(20L);
                        }
                    }
                    catch (InterruptedException ex) {
                        this.log.log(Level.SEVERE, "", ex);
                        break;
                    }
                }
                ++count;
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
            return false;
        }
        if (count > 0 && this.log.isLoggable(Level.FINE)) {
            this.log.fine(System.currentTimeMillis() - start + "ms - #" + count);
        }
        return true;
    }

    protected String getDetailInfo() {
        return "";
    }

    public String toString() {
        String cn = this.getClass().getName();
        StringBuilder sb = new StringBuilder();
        sb.append(cn.substring(cn.lastIndexOf(46) + 1)).append("[");
        sb.append("Bounds=").append(this.getBounds()).append(",Height=").append(this.p_height).append("(").append(this.p_maxHeight).append("),Width=").append(this.p_width).append("(").append(this.p_maxHeight).append("),PageLocation=").append(this.p_pageLocation);
        sb.append("]");
        return sb.toString();
    }

    public void setCurrentPage(Page page) {
        this.m_currentPage = page;
    }

    protected Page getCurrentPage() {
        return this.m_currentPage;
    }

    public void setPrintData(PrintData printData) {
        this.m_printData = printData;
    }

    public PrintData getPrintData() {
        return this.m_printData;
    }

    public void setRowIndex(int row) {
        this.m_rowIndex = row;
    }

    public int getRowIndex() {
        return this.m_rowIndex;
    }

    public void setPageLogic(String displayLogic) {
        this.m_pageLogic = displayLogic;
    }

    public String getPageLogic() {
        return this.m_pageLogic;
    }
}

