/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MLocator;
import org.compiere.model.MMovement;
import org.compiere.model.MProduct;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.model.X_M_MovementLine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.eevolution.model.MDDOrderLine;

public class MMovementLine
extends X_M_MovementLine {
    private static final long serialVersionUID = -2529644775541337889L;
    protected MMovement m_parent = null;

    public MMovementLine(Properties ctx, String M_MovementLine_UU, String trxName) {
        super(ctx, M_MovementLine_UU, trxName);
        if (Util.isEmpty(M_MovementLine_UU)) {
            this.setInitialDefaults();
        }
    }

    public MMovementLine(Properties ctx, int M_MovementLine_ID, String trxName) {
        super(ctx, M_MovementLine_ID, trxName);
        if (M_MovementLine_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setM_AttributeSetInstance_ID(0);
        this.setMovementQty(Env.ZERO);
        this.setTargetQty(Env.ZERO);
        this.setScrappedQty(Env.ZERO);
        this.setConfirmedQty(Env.ZERO);
        this.setProcessed(false);
    }

    public MMovementLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MMovementLine(MMovement parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setM_Movement_ID(parent.getM_Movement_ID());
    }

    @Override
    public int getM_AttributeSetInstanceTo_ID() {
        int M_AttributeSetInstanceTo_ID = super.getM_AttributeSetInstanceTo_ID();
        if (M_AttributeSetInstanceTo_ID == 0 && this.getM_Locator_ID() == this.getM_LocatorTo_ID()) {
            M_AttributeSetInstanceTo_ID = super.getM_AttributeSetInstance_ID();
        }
        return M_AttributeSetInstanceTo_ID;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public MProduct getProduct() {
        if (this.getM_Product_ID() != 0) {
            return MProduct.getCopy(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
        }
        return null;
    }

    @Override
    public void setMovementQty(BigDecimal MovementQty) {
        MProduct product;
        if (MovementQty != null && (product = this.getProduct()) != null) {
            int precision = product.getUOMPrecision();
            MovementQty = MovementQty.setScale(precision, RoundingMode.HALF_UP);
        }
        super.setMovementQty(MovementQty);
    }

    public MMovement getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MMovement(this.getCtx(), this.getM_Movement_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord && this.getParent().isProcessed()) {
            this.log.saveError("ParentComplete", Msg.translate(this.getCtx(), "M_Movement_ID"));
            return false;
        }
        if (this.getParent().pendingConfirmations() && (newRecord || this.is_ValueChanged("MovementQty") && !this.is_ValueChanged("TargetQty"))) {
            this.log.saveError("SaveError", Msg.parseTranslation(this.getCtx(), "@Open@: @M_MovementConfirm_ID@"));
            return false;
        }
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 AS DefaultValue FROM M_MovementLine WHERE M_Movement_ID=?";
            int ii = DB.getSQLValue(this.get_TrxName(), sql, this.getM_Movement_ID());
            this.setLine(ii);
        }
        if (this.getM_Locator_ID() == this.getM_LocatorTo_ID() && this.getM_AttributeSetInstance_ID() == this.getM_AttributeSetInstanceTo_ID()) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@M_Locator_ID@ == @M_LocatorTo_ID@ and @M_AttributeSetInstance_ID@ == @M_AttributeSetInstanceTo_ID@"));
            return false;
        }
        if (this.getC_UOM_ID() == 0) {
            this.setDefaultC_UOM_ID();
        }
        if (this.getMovementQty().signum() == 0) {
            String docAction = this.getParent().getDocAction();
            String docStatus = this.getParent().getDocStatus();
            if (!("VO".equals(docAction) && ("DR".equals(docStatus) || "IN".equals(docStatus) || "IP".equals(docStatus) || "AP".equals(docStatus) || "NA".equals(docStatus)) || "CO".equals(docAction) && "IP".equals(docStatus))) {
                this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "MovementQty"));
                return false;
            }
        }
        int C_UOM_ID = MProduct.get(this.getCtx(), this.getM_Product_ID()).getC_UOM_ID();
        if (this.getC_UOM_ID() != C_UOM_ID && this.getMovementQty().compareTo(BigDecimal.ZERO) != 0 && (this.getQtyEntered() == null || this.getQtyEntered().compareTo(BigDecimal.ZERO) == 0)) {
            this.log.saveError("SaveError", "Please provide a valid Entered Quantity or use the default UOM");
            return false;
        }
        if (newRecord && this.getMovementQty().compareTo(BigDecimal.ZERO) != 0 && (this.getQtyEntered() == null || this.getQtyEntered().compareTo(BigDecimal.ZERO) == 0)) {
            this.setQtyEntered(this.getMovementQty());
        }
        if (newRecord || this.is_ValueChanged("MovementQty")) {
            this.setMovementQty(this.getMovementQty());
        }
        if (newRecord || this.is_ValueChanged("QtyEntered") || this.is_ValueChanged("C_UOM_ID")) {
            this.setQtyEntered(this.getQtyEntered());
        }
        if (this.getM_AttributeSetInstanceTo_ID() == 0 && this.getM_Locator_ID() != this.getM_LocatorTo_ID() && this.getM_AttributeSetInstance_ID() != 0) {
            this.setM_AttributeSetInstanceTo_ID(this.getM_AttributeSetInstance_ID());
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        if (this.getParent().pendingConfirmations()) {
            this.log.saveError("DeleteError", Msg.parseTranslation(this.getCtx(), "@Open@: @M_MovementConfirm_ID@"));
            return false;
        }
        return super.beforeDelete();
    }

    @Deprecated
    public void setOrderLine(MDDOrderLine oLine, BigDecimal Qty, boolean isReceipt) {
        this.setDD_OrderLine_ID(oLine.getDD_OrderLine_ID());
        this.setLine(oLine.getLine());
        MProduct product = oLine.getProduct();
        if (product == null) {
            this.set_ValueNoCheck("M_Product_ID", null);
            this.set_ValueNoCheck("M_AttributeSetInstance_ID", null);
            this.set_ValueNoCheck("M_AttributeSetInstanceTo_ID", null);
            this.set_ValueNoCheck("M_Locator_ID", null);
            this.set_ValueNoCheck("M_LocatorTo_ID", null);
        } else {
            this.setM_Product_ID(oLine.getM_Product_ID());
            this.setM_AttributeSetInstance_ID(oLine.getM_AttributeSetInstance_ID());
            this.setM_AttributeSetInstanceTo_ID(oLine.getM_AttributeSetInstanceTo_ID());
            if (product.isItem()) {
                MWarehouse w = MWarehouse.get(this.getCtx(), oLine.getParent().getM_Warehouse_ID());
                MLocator locator_inTransit = MLocator.getDefault(w);
                if (locator_inTransit == null) {
                    throw new AdempiereException("Do not exist Locator for the  Warehouse in transit");
                }
                if (isReceipt) {
                    this.setM_Locator_ID(locator_inTransit.getM_Locator_ID());
                    this.setM_LocatorTo_ID(oLine.getM_LocatorTo_ID());
                } else {
                    this.setM_Locator_ID(oLine.getM_Locator_ID());
                    this.setM_LocatorTo_ID(locator_inTransit.getM_Locator_ID());
                }
            } else {
                this.set_ValueNoCheck("M_Locator_ID", null);
                this.set_ValueNoCheck("M_LocatorTo_ID", null);
            }
        }
        this.setDescription(oLine.getDescription());
        this.setMovementQty(Qty);
    }

    @Override
    public void setM_Locator_ID(int M_Locator_ID) {
        if (M_Locator_ID < 0) {
            throw new IllegalArgumentException("M_Locator_ID is mandatory.");
        }
        this.set_Value("M_Locator_ID", (Object)M_Locator_ID);
    }

    @Override
    public void setM_LocatorTo_ID(int M_LocatorTo_ID) {
        if (M_LocatorTo_ID < 0) {
            throw new IllegalArgumentException("M_LocatorTo_ID is mandatory.");
        }
        this.set_Value("M_LocatorTo_ID", (Object)M_LocatorTo_ID);
    }

    @Override
    public void setQtyEntered(BigDecimal qtyEntered) {
        if (qtyEntered != null && this.getC_UOM_ID() != 0) {
            int precision = MUOM.getPrecision(this.getCtx(), this.getC_UOM_ID());
            qtyEntered = qtyEntered.setScale(precision, RoundingMode.HALF_UP);
        }
        super.setQtyEntered(qtyEntered);
        this.setMovementQtyFromQtyEntered(qtyEntered);
    }

    public void setMovementQtyFromQtyEntered(BigDecimal qtyEntered) {
        BigDecimal movementQty = MUOMConversion.convertProductFrom(this.getCtx(), this.getM_Product_ID(), this.getC_UOM_ID(), qtyEntered);
        if (movementQty == null) {
            movementQty = qtyEntered;
        }
        super.setMovementQty(movementQty);
    }

    private void setDefaultC_UOM_ID() {
        int C_UOM_ID = MProduct.get(this.getCtx(), this.getM_Product_ID()).getC_UOM_ID();
        this.setC_UOM_ID(C_UOM_ID);
    }

    @Deprecated
    public static MMovementLine[] getOfOrderLine(Properties ctx, int DD_OrderLine_ID, String where, String trxName) {
        Object whereClause = "DD_OrderLine_ID=?";
        if (where != null && where.length() > 0) {
            whereClause = (String)whereClause + " AND (" + where + ")";
        }
        List<MMovementLine> list = new Query(ctx, "M_MovementLine", (String)whereClause, trxName).setParameters(DD_OrderLine_ID).list();
        return list.toArray(new MMovementLine[list.size()]);
    }

    @Override
    public String toString() {
        return "M_MovementLine[" + this.get_ID() + ", M_Product_ID=" + this.getM_Product_ID() + ", M_ASI_ID=" + this.getM_AttributeSetInstance_ID() + ", M_ASITo_ID=" + this.getM_AttributeSetInstanceTo_ID() + ", M_Locator_ID=" + this.getM_Locator_ID() + ", M_LocatorTo_ID=" + this.getM_LocatorTo_ID() + "]";
    }
}

