/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.adempiere.base.CreditStatus;
import org.adempiere.base.ICreditManager;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.BackDateTrxNotAllowedException;
import org.adempiere.exceptions.DBException;
import org.adempiere.exceptions.NegativeInventoryDisallowedException;
import org.adempiere.exceptions.PeriodClosedException;
import org.adempiere.util.IReservationTracer;
import org.adempiere.util.IReservationTracerFactory;
import org.adempiere.util.ShippingUtil;
import org.compiere.model.ICostInfo;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAsset;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MClientInfo;
import org.compiere.model.MCost;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostHistory;
import org.compiere.model.MDocType;
import org.compiere.model.MDocTypeCounter;
import org.compiere.model.MInOutConfirm;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInOutLineMA;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.MRefList;
import org.compiere.model.MRole;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MStorageReservation;
import org.compiere.model.MTransaction;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_Invoice;
import org.compiere.model.X_C_Order;
import org.compiere.model.X_C_OrderLine;
import org.compiere.model.X_M_InOut;
import org.compiere.model.X_M_RMA;
import org.compiere.model.X_M_RMALine;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.process.IDocsPostProcess;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.TrxEventListener;
import org.compiere.util.Util;
import org.compiere.wf.MWFActivity;
import org.compiere.wf.MWorkflow;

public class MInOut
extends X_M_InOut
implements DocAction,
IDocsPostProcess {
    private static final long serialVersionUID = 327740106819501242L;
    private static final String BASE_MATCHING_SQL = "\tSELECT hdr.M_InOut_ID, hdr.DocumentNo, hdr.MovementDate, bp.Name, hdr.C_BPartner_ID,\n\tlin.Line, lin.M_InOutLine_ID, p.Name, lin.M_Product_ID,\n\tCASE WHEN (dt.DocBaseType='MMS' AND hdr.issotrx='N') THEN lin.MovementQty * -1 ELSE lin.MovementQty END,\n\t%s, org.Name, hdr.AD_Org_ID\n\t FROM M_InOut hdr\n\t INNER JOIN AD_Org org ON (hdr.AD_Org_ID=org.AD_Org_ID)\n\t INNER JOIN C_BPartner bp ON (hdr.C_BPartner_ID=bp.C_BPartner_ID)\n\t INNER JOIN M_InOutLine lin ON (hdr.M_InOut_ID=lin.M_InOut_ID)\n\t INNER JOIN M_Product p ON (lin.M_Product_ID=p.M_Product_ID)\n\t INNER JOIN C_DocType dt ON (hdr.C_DocType_ID = dt.C_DocType_ID AND (dt.DocBaseType='MMR' OR (dt.DocBaseType='MMS' AND hdr.isSOTrx ='N')))\n\t FULL JOIN %s m ON (lin.M_InOutLine_ID=m.M_InOutLine_ID)\n\t WHERE hdr.DocStatus IN ('CO','CL')\n";
    private static final String BASE_MATCHING_GROUP_BY_SQL = "\tGROUP BY hdr.M_InOut_ID,hdr.DocumentNo,hdr.MovementDate,bp.Name,hdr.C_BPartner_ID,\n\t  lin.Line,lin.M_InOutLine_ID,p.Name,lin.M_Product_ID,lin.MovementQty, org.Name, hdr.AD_Org_ID, dt.DocBaseType, hdr.IsSOTrx\n\tHAVING %s <> %s\n";
    public static final String NOT_FULLY_MATCHED_TO_ORDER = "\tSELECT hdr.M_InOut_ID, hdr.DocumentNo, hdr.MovementDate, bp.Name, hdr.C_BPartner_ID,\n\tlin.Line, lin.M_InOutLine_ID, p.Name, lin.M_Product_ID,\n\tCASE WHEN (dt.DocBaseType='MMS' AND hdr.issotrx='N') THEN lin.MovementQty * -1 ELSE lin.MovementQty END,\n\t%s, org.Name, hdr.AD_Org_ID\n\t FROM M_InOut hdr\n\t INNER JOIN AD_Org org ON (hdr.AD_Org_ID=org.AD_Org_ID)\n\t INNER JOIN C_BPartner bp ON (hdr.C_BPartner_ID=bp.C_BPartner_ID)\n\t INNER JOIN M_InOutLine lin ON (hdr.M_InOut_ID=lin.M_InOut_ID)\n\t INNER JOIN M_Product p ON (lin.M_Product_ID=p.M_Product_ID)\n\t INNER JOIN C_DocType dt ON (hdr.C_DocType_ID = dt.C_DocType_ID AND (dt.DocBaseType='MMR' OR (dt.DocBaseType='MMS' AND hdr.isSOTrx ='N')))\n\t FULL JOIN %s m ON (lin.M_InOutLine_ID=m.M_InOutLine_ID)\n\t WHERE hdr.DocStatus IN ('CO','CL')\n".formatted("SUM(CASE WHEN m.M_InOutLine_ID IS NOT NULL THEN COALESCE(m.Qty,0) ELSE 0 END)", "M_MatchPO");
    public static final String NOT_FULLY_MATCHED_TO_ORDER_GROUP_BY = "\tGROUP BY hdr.M_InOut_ID,hdr.DocumentNo,hdr.MovementDate,bp.Name,hdr.C_BPartner_ID,\n\t  lin.Line,lin.M_InOutLine_ID,p.Name,lin.M_Product_ID,lin.MovementQty, org.Name, hdr.AD_Org_ID, dt.DocBaseType, hdr.IsSOTrx\n\tHAVING %s <> %s\n".formatted("CASE WHEN (dt.DocBaseType='MMS' AND hdr.issotrx='N') THEN lin.MovementQty * -1 ELSE lin.MovementQty END", "SUM(CASE WHEN m.M_InOutLine_ID IS NOT NULL THEN COALESCE(m.Qty,0) ELSE 0 END)");
    public static final String FULL_OR_PARTIALLY_MATCHED_TO_ORDER = "\tSELECT hdr.M_InOut_ID, hdr.DocumentNo, hdr.MovementDate, bp.Name, hdr.C_BPartner_ID,\n\tlin.Line, lin.M_InOutLine_ID, p.Name, lin.M_Product_ID,\n\tCASE WHEN (dt.DocBaseType='MMS' AND hdr.issotrx='N') THEN lin.MovementQty * -1 ELSE lin.MovementQty END,\n\t%s, org.Name, hdr.AD_Org_ID\n\t FROM M_InOut hdr\n\t INNER JOIN AD_Org org ON (hdr.AD_Org_ID=org.AD_Org_ID)\n\t INNER JOIN C_BPartner bp ON (hdr.C_BPartner_ID=bp.C_BPartner_ID)\n\t INNER JOIN M_InOutLine lin ON (hdr.M_InOut_ID=lin.M_InOut_ID)\n\t INNER JOIN M_Product p ON (lin.M_Product_ID=p.M_Product_ID)\n\t INNER JOIN C_DocType dt ON (hdr.C_DocType_ID = dt.C_DocType_ID AND (dt.DocBaseType='MMR' OR (dt.DocBaseType='MMS' AND hdr.isSOTrx ='N')))\n\t FULL JOIN %s m ON (lin.M_InOutLine_ID=m.M_InOutLine_ID)\n\t WHERE hdr.DocStatus IN ('CO','CL')\n".formatted("SUM(CASE WHEN m.M_InOutLine_ID IS NOT NULL THEN COALESCE(m.Qty,0) ELSE 0 END)", "M_MatchPO");
    public static final String FULL_OR_PARTIALLY_MATCHED_TO_ORDER_GROUP_BY = "\tGROUP BY hdr.M_InOut_ID,hdr.DocumentNo,hdr.MovementDate,bp.Name,hdr.C_BPartner_ID,\n\t  lin.Line,lin.M_InOutLine_ID,p.Name,lin.M_Product_ID,lin.MovementQty, org.Name, hdr.AD_Org_ID, dt.DocBaseType, hdr.IsSOTrx\n\tHAVING %s <> %s\n".formatted("0", "SUM(CASE WHEN m.M_InOutLine_ID IS NOT NULL THEN COALESCE(m.Qty,0) ELSE 0 END)");
    public static final String NOT_FULLY_MATCHED_TO_INVOICE = "\tSELECT hdr.M_InOut_ID, hdr.DocumentNo, hdr.MovementDate, bp.Name, hdr.C_BPartner_ID,\n\tlin.Line, lin.M_InOutLine_ID, p.Name, lin.M_Product_ID,\n\tCASE WHEN (dt.DocBaseType='MMS' AND hdr.issotrx='N') THEN lin.MovementQty * -1 ELSE lin.MovementQty END,\n\t%s, org.Name, hdr.AD_Org_ID\n\t FROM M_InOut hdr\n\t INNER JOIN AD_Org org ON (hdr.AD_Org_ID=org.AD_Org_ID)\n\t INNER JOIN C_BPartner bp ON (hdr.C_BPartner_ID=bp.C_BPartner_ID)\n\t INNER JOIN M_InOutLine lin ON (hdr.M_InOut_ID=lin.M_InOut_ID)\n\t INNER JOIN M_Product p ON (lin.M_Product_ID=p.M_Product_ID)\n\t INNER JOIN C_DocType dt ON (hdr.C_DocType_ID = dt.C_DocType_ID AND (dt.DocBaseType='MMR' OR (dt.DocBaseType='MMS' AND hdr.isSOTrx ='N')))\n\t FULL JOIN %s m ON (lin.M_InOutLine_ID=m.M_InOutLine_ID)\n\t WHERE hdr.DocStatus IN ('CO','CL')\n".formatted("SUM(COALESCE(m.Qty,0))", "M_MatchInv");
    public static final String NOT_FULLY_MATCHED_TO_INVOICE_GROUP_BY = "\tGROUP BY hdr.M_InOut_ID,hdr.DocumentNo,hdr.MovementDate,bp.Name,hdr.C_BPartner_ID,\n\t  lin.Line,lin.M_InOutLine_ID,p.Name,lin.M_Product_ID,lin.MovementQty, org.Name, hdr.AD_Org_ID, dt.DocBaseType, hdr.IsSOTrx\n\tHAVING %s <> %s\n".formatted("CASE WHEN (dt.DocBaseType='MMS' AND hdr.issotrx='N') THEN lin.MovementQty * -1 ELSE lin.MovementQty END", "SUM(COALESCE(m.Qty,0))");
    public static final String FULL_OR_PARTIALLY_MATCHED_TO_INVOICE = "\tGROUP BY hdr.M_InOut_ID,hdr.DocumentNo,hdr.MovementDate,bp.Name,hdr.C_BPartner_ID,\n\t  lin.Line,lin.M_InOutLine_ID,p.Name,lin.M_Product_ID,lin.MovementQty, org.Name, hdr.AD_Org_ID, dt.DocBaseType, hdr.IsSOTrx\n\tHAVING %s <> %s\n".formatted("SUM(COALESCE(m.Qty,0))", "M_MatchInv");
    public static final String FULL_OR_PARTIALLY_MATCHED_TO_INVOICE_GROUP_BY = "\tGROUP BY hdr.M_InOut_ID,hdr.DocumentNo,hdr.MovementDate,bp.Name,hdr.C_BPartner_ID,\n\t  lin.Line,lin.M_InOutLine_ID,p.Name,lin.M_Product_ID,lin.MovementQty, org.Name, hdr.AD_Org_ID, dt.DocBaseType, hdr.IsSOTrx\n\tHAVING %s <> %s\n".formatted("0", "SUM(COALESCE(m.Qty,0))");
    protected MInOutLine[] m_lines = null;
    protected MInOutConfirm[] m_confirms = null;
    protected MBPartner m_partner = null;
    protected boolean m_reversal = false;
    protected String m_processMsg = null;
    protected boolean m_justPrepared = false;
    protected ArrayList<PO> docsPostProcess = new ArrayList();

    public static List<MatchingRecord> getNotFullyMatchedToOrder(int C_BPartner_ID, int M_Product_ID, int C_OrderLine_ID, Timestamp from, Timestamp to, String trxName) {
        StringBuilder builder = new StringBuilder(NOT_FULLY_MATCHED_TO_ORDER);
        if (C_OrderLine_ID > 0) {
            builder.append(" AND m.C_OrderLine_ID=").append(C_OrderLine_ID);
        }
        if (M_Product_ID > 0) {
            builder.append(" AND lin.M_Product_ID=").append(M_Product_ID);
        }
        if (C_BPartner_ID > 0) {
            builder.append(" AND hdr.C_BPartner_ID=").append(C_BPartner_ID);
        }
        if (from != null) {
            builder.append(" AND ").append("hdr.MovementDate").append(" >= ").append(DB.TO_DATE(from));
        }
        if (to != null) {
            builder.append(" AND ").append("hdr.MovementDate").append(" <= ").append(DB.TO_DATE(to));
        }
        String sql = MRole.getDefault().addAccessSQL(builder.toString(), "hdr", true, false) + NOT_FULLY_MATCHED_TO_ORDER_GROUP_BY;
        ArrayList<MatchingRecord> records = new ArrayList<MatchingRecord>();
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (CPreparedStatement stmt = DB.prepareStatement(sql, trxName);){
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    MatchingRecord matchingRecord = new MatchingRecord(rs.getInt(1), rs.getString(2), rs.getTimestamp(3), rs.getString(4), rs.getInt(5), rs.getInt(6), rs.getInt(7), rs.getString(8), rs.getInt(9), rs.getBigDecimal(10), rs.getBigDecimal(11), rs.getString(12), rs.getInt(13));
                    records.add(matchingRecord);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException(e.getMessage(), e);
        }
        return records;
    }

    public static List<MatchingRecord> getFullOrPartiallyMatchedToOrder(int C_BPartner_ID, int M_Product_ID, int C_OrderLine_ID, Timestamp from, Timestamp to, String trxName) {
        StringBuilder builder = new StringBuilder(FULL_OR_PARTIALLY_MATCHED_TO_ORDER);
        if (C_OrderLine_ID > 0) {
            builder.append(" AND m.C_OrderLine_ID=").append(C_OrderLine_ID);
        }
        if (M_Product_ID > 0) {
            builder.append(" AND lin.M_Product_ID=").append(M_Product_ID);
        }
        if (C_BPartner_ID > 0) {
            builder.append(" AND hdr.C_BPartner_ID=").append(C_BPartner_ID);
        }
        if (from != null) {
            builder.append(" AND ").append("hdr.MovementDate").append(" >= ").append(DB.TO_DATE(from));
        }
        if (to != null) {
            builder.append(" AND ").append("hdr.MovementDate").append(" <= ").append(DB.TO_DATE(to));
        }
        String sql = MRole.getDefault().addAccessSQL(builder.toString(), "hdr", true, false) + FULL_OR_PARTIALLY_MATCHED_TO_ORDER_GROUP_BY;
        ArrayList<MatchingRecord> records = new ArrayList<MatchingRecord>();
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (CPreparedStatement stmt = DB.prepareStatement(sql, trxName);){
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    MatchingRecord matchingRecord = new MatchingRecord(rs.getInt(1), rs.getString(2), rs.getTimestamp(3), rs.getString(4), rs.getInt(5), rs.getInt(6), rs.getInt(7), rs.getString(8), rs.getInt(9), rs.getBigDecimal(10), rs.getBigDecimal(11), rs.getString(12), rs.getInt(13));
                    records.add(matchingRecord);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException(e.getMessage(), e);
        }
        return records;
    }

    public static List<MatchingRecord> getNotFullyMatchedToInvoice(int C_BPartner_ID, int M_Product_ID, int C_InvoiceLine_ID, Timestamp from, Timestamp to, String trxName) {
        StringBuilder builder = new StringBuilder(NOT_FULLY_MATCHED_TO_INVOICE);
        if (C_InvoiceLine_ID > 0) {
            builder.append(" AND m.C_InvoiceLine_ID=").append(C_InvoiceLine_ID);
        }
        if (M_Product_ID > 0) {
            builder.append(" AND lin.M_Product_ID=").append(M_Product_ID);
        }
        if (C_BPartner_ID > 0) {
            builder.append(" AND hdr.C_BPartner_ID=").append(C_BPartner_ID);
        }
        if (from != null) {
            builder.append(" AND ").append("hdr.MovementDate").append(" >= ").append(DB.TO_DATE(from));
        }
        if (to != null) {
            builder.append(" AND ").append("hdr.MovementDate").append(" <= ").append(DB.TO_DATE(to));
        }
        String sql = MRole.getDefault().addAccessSQL(builder.toString(), "hdr", true, false) + NOT_FULLY_MATCHED_TO_INVOICE_GROUP_BY;
        ArrayList<MatchingRecord> records = new ArrayList<MatchingRecord>();
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (CPreparedStatement stmt = DB.prepareStatement(sql, trxName);){
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    MatchingRecord matchingRecord = new MatchingRecord(rs.getInt(1), rs.getString(2), rs.getTimestamp(3), rs.getString(4), rs.getInt(5), rs.getInt(6), rs.getInt(7), rs.getString(8), rs.getInt(9), rs.getBigDecimal(10), rs.getBigDecimal(11), rs.getString(12), rs.getInt(13));
                    records.add(matchingRecord);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException(e.getMessage(), e);
        }
        return records;
    }

    public static List<MatchingRecord> getFullOrPartiallyMatchedToInvoice(int C_BPartner_ID, int M_Product_ID, int C_InvoiceLine_ID, Timestamp from, Timestamp to, String trxName) {
        StringBuilder builder = new StringBuilder(FULL_OR_PARTIALLY_MATCHED_TO_INVOICE);
        if (C_InvoiceLine_ID > 0) {
            builder.append(" AND m.C_InvoiceLine_ID=").append(C_InvoiceLine_ID);
        }
        if (M_Product_ID > 0) {
            builder.append(" AND lin.M_Product_ID=").append(M_Product_ID);
        }
        if (C_BPartner_ID > 0) {
            builder.append(" AND hdr.C_BPartner_ID=").append(C_BPartner_ID);
        }
        if (from != null) {
            builder.append(" AND ").append("hdr.MovementDate").append(" >= ").append(DB.TO_DATE(from));
        }
        if (to != null) {
            builder.append(" AND ").append("hdr.MovementDate").append(" <= ").append(DB.TO_DATE(to));
        }
        String sql = MRole.getDefault().addAccessSQL(builder.toString(), "hdr", true, false) + FULL_OR_PARTIALLY_MATCHED_TO_INVOICE_GROUP_BY;
        ArrayList<MatchingRecord> records = new ArrayList<MatchingRecord>();
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (CPreparedStatement stmt = DB.prepareStatement(sql, trxName);){
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    MatchingRecord matchingRecord = new MatchingRecord(rs.getInt(1), rs.getString(2), rs.getTimestamp(3), rs.getString(4), rs.getInt(5), rs.getInt(6), rs.getInt(7), rs.getString(8), rs.getInt(9), rs.getBigDecimal(10), rs.getBigDecimal(11), rs.getString(12), rs.getInt(13));
                    records.add(matchingRecord);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException(e.getMessage(), e);
        }
        return records;
    }

    public static MInOut createFrom(MOrder order, Timestamp movementDate, boolean forceDelivery, boolean allAttributeInstances, Timestamp minGuaranteeDate, boolean complete, String trxName) {
        if (order == null) {
            throw new IllegalArgumentException("No Order");
        }
        if (!forceDelivery && "L".equals(order.getDeliveryRule())) {
            return null;
        }
        MInOut retValue = new MInOut(order, 0, movementDate);
        retValue.setDocAction(complete ? "CO" : "PR");
        MOrderLine[] oLines = order.getLines(true, "M_Product_ID");
        int i = 0;
        while (i < oLines.length) {
            block14: {
                MStorageOnHand[] storages;
                BigDecimal qty;
                block15: {
                    BigDecimal maxQty;
                    block16: {
                        qty = oLines[i].getQtyOrdered().subtract(oLines[i].getQtyDelivered());
                        if (qty.signum() == 0) break block14;
                        storages = null;
                        MProduct product = oLines[i].getProduct();
                        if (product == null || product.get_ID() == 0 || !product.isStocked()) break block14;
                        String MMPolicy = product.getMMPolicy();
                        storages = MStorageOnHand.getWarehouse(order.getCtx(), order.getM_Warehouse_ID(), oLines[i].getM_Product_ID(), oLines[i].getM_AttributeSetInstance_ID(), minGuaranteeDate, "F".equals(MMPolicy), true, 0, trxName);
                        if (forceDelivery) break block15;
                        maxQty = Env.ZERO;
                        int ll = 0;
                        while (ll < storages.length) {
                            maxQty = maxQty.add(storages[ll].getQtyOnHand());
                            ++ll;
                        }
                        if (!"A".equals(order.getDeliveryRule())) break block16;
                        if (maxQty.compareTo(qty) < 0) {
                            qty = maxQty;
                        }
                        break block15;
                    }
                    if ("L".equals(order.getDeliveryRule()) && maxQty.compareTo(qty) < 0) break block14;
                }
                if (retValue.get_ID() == 0) {
                    retValue.saveEx(trxName);
                }
                int ll = 0;
                while (ll < storages.length) {
                    BigDecimal lineQty = storages[ll].getQtyOnHand();
                    if (lineQty.compareTo(qty) > 0) {
                        lineQty = qty;
                    }
                    MInOutLine line = new MInOutLine(retValue);
                    line.setOrderLine(oLines[i], storages[ll].getM_Locator_ID(), order.isSOTrx() ? lineQty : Env.ZERO);
                    line.setQty(lineQty);
                    if (oLines[i].getQtyEntered().compareTo(oLines[i].getQtyOrdered()) != 0) {
                        line.setQtyEntered(lineQty.multiply(oLines[i].getQtyEntered()).divide(oLines[i].getQtyOrdered(), 12, RoundingMode.HALF_UP));
                    }
                    line.setC_Project_ID(oLines[i].getC_Project_ID());
                    line.saveEx(trxName);
                    qty = qty.subtract(lineQty);
                    if (qty.signum() == 0) break;
                    ++ll;
                }
            }
            ++i;
        }
        if (retValue.get_ID() == 0) {
            return null;
        }
        return retValue;
    }

    public static MInOut copyFrom(MInOut from, Timestamp dateDoc, Timestamp dateAcct, int C_DocType_ID, boolean isSOTrx, boolean counter, String trxName, boolean setOrder) {
        MInOut to = new MInOut(from.getCtx(), 0, null);
        to.set_TrxName(trxName);
        MInOut.copyValues(from, to, from.getAD_Client_ID(), from.getAD_Org_ID());
        to.set_ValueNoCheck("M_InOut_ID", I_ZERO);
        to.set_ValueNoCheck("DocumentNo", null);
        to.setDocStatus("DR");
        to.setDocAction("CO");
        to.setC_DocType_ID(C_DocType_ID);
        to.setIsSOTrx(isSOTrx);
        if (counter) {
            to.setMovementType();
        }
        to.setDateOrdered(dateDoc);
        to.setDateAcct(dateAcct);
        to.setMovementDate(dateDoc);
        to.setDatePrinted(null);
        to.setIsPrinted(false);
        to.setDateReceived(null);
        to.setNoPackages(0);
        to.setShipDate(null);
        to.setPickDate(null);
        to.setIsInTransit(false);
        to.setIsApproved(false);
        to.setC_Invoice_ID(0);
        to.setTrackingNo(null);
        to.setIsInDispute(false);
        to.setPosted(false);
        to.setProcessed(false);
        to.setProcessing(false);
        to.setC_Order_ID(0);
        to.setM_RMA_ID(0);
        if (counter) {
            PO peer;
            to.setC_Order_ID(0);
            to.setRef_InOut_ID(from.getM_InOut_ID());
            if (from.getC_Order_ID() != 0 && ((X_C_Order)(peer = new MOrder(from.getCtx(), from.getC_Order_ID(), from.get_TrxName()))).getRef_Order_ID() != 0) {
                to.setC_Order_ID(((X_C_Order)peer).getRef_Order_ID());
            }
            if (from.getC_Invoice_ID() != 0 && ((X_C_Invoice)(peer = new MInvoice(from.getCtx(), from.getC_Invoice_ID(), from.get_TrxName()))).getRef_Invoice_ID() != 0) {
                to.setC_Invoice_ID(((X_C_Invoice)peer).getRef_Invoice_ID());
            }
            if (from.getM_RMA_ID() != 0 && ((X_M_RMA)(peer = new MRMA(from.getCtx(), from.getM_RMA_ID(), from.get_TrxName()))).getRef_RMA_ID() > 0) {
                to.setM_RMA_ID(((X_M_RMA)peer).getRef_RMA_ID());
            }
        } else {
            to.setRef_InOut_ID(0);
            if (setOrder) {
                to.setC_Order_ID(from.getC_Order_ID());
                to.setM_RMA_ID(from.getM_RMA_ID());
            }
        }
        if (!to.save(trxName)) {
            throw new IllegalStateException("Could not create Shipment");
        }
        if (counter) {
            from.setRef_InOut_ID(to.getM_InOut_ID());
        }
        if (to.copyLinesFrom(from, counter, setOrder) <= 0) {
            throw new IllegalStateException("Could not create Shipment Lines");
        }
        return to;
    }

    @Deprecated
    public static MInOut copyFrom(MInOut from, Timestamp dateDoc, int C_DocType_ID, boolean isSOTrx, boolean counter, String trxName, boolean setOrder) {
        MInOut to = MInOut.copyFrom(from, dateDoc, dateDoc, C_DocType_ID, isSOTrx, counter, trxName, setOrder);
        return to;
    }

    public MInOut(Properties ctx, String M_InOut_UU, String trxName) {
        super(ctx, M_InOut_UU, trxName);
        if (Util.isEmpty(M_InOut_UU)) {
            this.setInitialDefaults();
        }
    }

    public MInOut(Properties ctx, int M_InOut_ID, String trxName) {
        this(ctx, M_InOut_ID, trxName, null);
    }

    public MInOut(Properties ctx, int M_InOut_ID, String trxName, String ... virtualColumns) {
        super(ctx, M_InOut_ID, trxName, virtualColumns);
        if (M_InOut_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setIsSOTrx(false);
        this.setMovementDate(new Timestamp(System.currentTimeMillis()));
        this.setDateAcct(this.getMovementDate());
        this.setDeliveryRule("A");
        this.setDeliveryViaRule("P");
        this.setFreightCostRule("I");
        this.setDocStatus("DR");
        this.setDocAction("CO");
        this.setPriorityRule("5");
        this.setNoPackages(0);
        this.setIsInTransit(false);
        this.setIsPrinted(false);
        this.setSendEMail(false);
        this.setIsInDispute(false);
        this.setIsApproved(false);
        super.setProcessed(false);
        this.setProcessing(false);
        this.setPosted(false);
    }

    public MInOut(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInOut(MOrder order, int C_DocTypeShipment_ID, Timestamp movementDate) {
        this(order.getCtx(), 0, order.get_TrxName());
        MDocType dto;
        this.setClientOrg(order);
        this.setC_BPartner_ID(order.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(order.getC_BPartner_Location_ID());
        this.setAD_User_ID(order.getAD_User_ID());
        this.setM_Warehouse_ID(order.getM_Warehouse_ID());
        this.setIsSOTrx(order.isSOTrx());
        if (C_DocTypeShipment_ID == 0 && (C_DocTypeShipment_ID = (dto = MDocType.get(this.getCtx(), order.getC_DocType_ID())).getC_DocTypeShipment_ID()) <= 0) {
            throw new AdempiereException("@NotFound@ @C_DocTypeShipment_ID@ - @C_DocType_ID@:" + dto.get_Translation("Name"));
        }
        this.setC_DocType_ID(C_DocTypeShipment_ID);
        this.setMovementType();
        if (movementDate != null) {
            this.setMovementDate(movementDate);
        }
        this.setDateAcct(this.getMovementDate());
        this.setC_Order_ID(order.getC_Order_ID());
        this.setDeliveryRule(order.getDeliveryRule());
        this.setDeliveryViaRule(order.getDeliveryViaRule());
        this.setM_Shipper_ID(order.getM_Shipper_ID());
        this.setFreightCostRule(order.getFreightCostRule());
        this.setFreightAmt(order.getFreightAmt());
        this.setSalesRep_ID(order.getSalesRep_ID());
        this.setC_Activity_ID(order.getC_Activity_ID());
        this.setC_Campaign_ID(order.getC_Campaign_ID());
        this.setC_Charge_ID(order.getC_Charge_ID());
        this.setChargeAmt(order.getChargeAmt());
        this.setC_Project_ID(order.getC_Project_ID());
        this.setDateOrdered(order.getDateOrdered());
        this.setDescription(order.getDescription());
        this.setPOReference(order.getPOReference());
        this.setSalesRep_ID(order.getSalesRep_ID());
        this.setAD_OrgTrx_ID(order.getAD_OrgTrx_ID());
        this.setUser1_ID(order.getUser1_ID());
        this.setUser2_ID(order.getUser2_ID());
        this.setPriorityRule(order.getPriorityRule());
        this.setIsDropShip(order.isDropShip());
        this.setDropShip_BPartner_ID(order.getDropShip_BPartner_ID());
        this.setDropShip_Location_ID(order.getDropShip_Location_ID());
        this.setDropShip_User_ID(order.getDropShip_User_ID());
    }

    public MInOut(MInvoice invoice, int C_DocTypeShipment_ID, Timestamp movementDate, int M_Warehouse_ID) {
        this(invoice.getCtx(), 0, invoice.get_TrxName());
        this.setClientOrg(invoice);
        this.setC_BPartner_ID(invoice.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(invoice.getC_BPartner_Location_ID());
        this.setAD_User_ID(invoice.getAD_User_ID());
        this.setM_Warehouse_ID(M_Warehouse_ID);
        this.setIsSOTrx(invoice.isSOTrx());
        this.setMovementType(invoice.isSOTrx() ? "C-" : "V+");
        X_C_Order order = null;
        if (invoice.getC_Order_ID() != 0) {
            order = new MOrder(invoice.getCtx(), invoice.getC_Order_ID(), invoice.get_TrxName());
        }
        if (C_DocTypeShipment_ID == 0 && order != null) {
            C_DocTypeShipment_ID = DB.getSQLValue(null, "SELECT C_DocTypeShipment_ID FROM C_DocType WHERE C_DocType_ID=?", order.getC_DocType_ID());
        }
        if (C_DocTypeShipment_ID != 0) {
            this.setC_DocType_ID(C_DocTypeShipment_ID);
        } else {
            this.setC_DocType_ID();
        }
        if (movementDate != null) {
            this.setMovementDate(movementDate);
        }
        this.setDateAcct(this.getMovementDate());
        this.setC_Order_ID(invoice.getC_Order_ID());
        this.setSalesRep_ID(invoice.getSalesRep_ID());
        this.setC_Activity_ID(invoice.getC_Activity_ID());
        this.setC_Campaign_ID(invoice.getC_Campaign_ID());
        this.setC_Charge_ID(invoice.getC_Charge_ID());
        this.setChargeAmt(invoice.getChargeAmt());
        this.setC_Project_ID(invoice.getC_Project_ID());
        this.setDateOrdered(invoice.getDateOrdered());
        this.setDescription(invoice.getDescription());
        this.setPOReference(invoice.getPOReference());
        this.setAD_OrgTrx_ID(invoice.getAD_OrgTrx_ID());
        this.setUser1_ID(invoice.getUser1_ID());
        this.setUser2_ID(invoice.getUser2_ID());
        if (order != null) {
            this.setDeliveryRule(order.getDeliveryRule());
            this.setDeliveryViaRule(order.getDeliveryViaRule());
            this.setM_Shipper_ID(order.getM_Shipper_ID());
            this.setFreightCostRule(order.getFreightCostRule());
            this.setFreightAmt(order.getFreightAmt());
            this.setIsDropShip(order.isDropShip());
            this.setDropShip_BPartner_ID(order.getDropShip_BPartner_ID());
            this.setDropShip_Location_ID(order.getDropShip_Location_ID());
            this.setDropShip_User_ID(order.getDropShip_User_ID());
        }
    }

    public MInOut(MInOut original, int C_DocTypeShipment_ID, Timestamp movementDate) {
        this(original.getCtx(), 0, original.get_TrxName());
        this.setClientOrg(original);
        this.setC_BPartner_ID(original.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(original.getC_BPartner_Location_ID());
        this.setAD_User_ID(original.getAD_User_ID());
        this.setM_Warehouse_ID(original.getM_Warehouse_ID());
        this.setIsSOTrx(original.isSOTrx());
        this.setMovementType(original.getMovementType());
        if (C_DocTypeShipment_ID == 0) {
            this.setC_DocType_ID(original.getC_DocType_ID());
        } else {
            this.setC_DocType_ID(C_DocTypeShipment_ID);
        }
        if (movementDate != null) {
            this.setMovementDate(movementDate);
        }
        this.setDateAcct(this.getMovementDate());
        this.setC_Order_ID(original.getC_Order_ID());
        this.setDeliveryRule(original.getDeliveryRule());
        this.setDeliveryViaRule(original.getDeliveryViaRule());
        this.setM_Shipper_ID(original.getM_Shipper_ID());
        this.setFreightCostRule(original.getFreightCostRule());
        this.setFreightAmt(original.getFreightAmt());
        this.setSalesRep_ID(original.getSalesRep_ID());
        this.setC_Activity_ID(original.getC_Activity_ID());
        this.setC_Campaign_ID(original.getC_Campaign_ID());
        this.setC_Charge_ID(original.getC_Charge_ID());
        this.setChargeAmt(original.getChargeAmt());
        this.setC_Project_ID(original.getC_Project_ID());
        this.setDateOrdered(original.getDateOrdered());
        this.setDescription(original.getDescription());
        this.setPOReference(original.getPOReference());
        this.setSalesRep_ID(original.getSalesRep_ID());
        this.setAD_OrgTrx_ID(original.getAD_OrgTrx_ID());
        this.setUser1_ID(original.getUser1_ID());
        this.setUser2_ID(original.getUser2_ID());
        this.setIsDropShip(original.isDropShip());
        this.setDropShip_BPartner_ID(original.getDropShip_BPartner_ID());
        this.setDropShip_Location_ID(original.getDropShip_Location_ID());
        this.setDropShip_User_ID(original.getDropShip_User_ID());
    }

    public String getDocStatusName() {
        return MRefList.getListName(this.getCtx(), 131, this.getDocStatus());
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            StringBuilder msgd = new StringBuilder(desc).append(" | ").append(description);
            this.setDescription(msgd.toString());
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MInOut[").append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",DocStatus=").append(this.getDocStatus()).append("]");
        return sb.toString();
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        StringBuilder msgreturn = new StringBuilder().append(dt.getNameTrl()).append(" ").append(this.getDocumentNo());
        return msgreturn.toString();
    }

    @Override
    public File createPDF() {
        try {
            StringBuilder msgfile = new StringBuilder().append(this.get_TableName()).append(this.get_ID()).append("_");
            File temp = File.createTempFile(msgfile.toString(), ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        ReportEngine re = ReportEngine.get(this.getCtx(), 1, this.getM_InOut_ID(), this.get_TrxName());
        if (re == null) {
            return null;
        }
        MPrintFormat format = re.getPrintFormat();
        if (format.getJasperProcess_ID() > 0) {
            ProcessInfo pi = new ProcessInfo("", format.getJasperProcess_ID());
            pi.setRecord_ID(this.getM_InOut_ID());
            pi.setIsBatch(true);
            pi.setTransientObject(format);
            ServerProcessCtl.process(pi, null);
            return pi.getPDFReport();
        }
        return re.getPDF(file);
    }

    public MInOutLine[] getLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            MInOut.set_TrxName(this.m_lines, this.get_TrxName());
            return this.m_lines;
        }
        List<MInOutLine> list = new Query(this.getCtx(), "M_InOutLine", "M_InOut_ID=?", this.get_TrxName()).setParameters(this.getM_InOut_ID()).setOrderBy("Line,M_InOutLine_ID").list();
        this.m_lines = new MInOutLine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    public MInOutLine[] getLines() {
        return this.getLines(false);
    }

    public MInOutConfirm[] getConfirmations(boolean requery) {
        if (this.m_confirms != null && !requery) {
            MInOut.set_TrxName(this.m_confirms, this.get_TrxName());
            return this.m_confirms;
        }
        List<MInOutConfirm> list = new Query(this.getCtx(), "M_InOutConfirm", "M_InOut_ID=?", this.get_TrxName()).setParameters(this.getM_InOut_ID()).list();
        this.m_confirms = new MInOutConfirm[list.size()];
        list.toArray(this.m_confirms);
        return this.m_confirms;
    }

    public int copyLinesFrom(MInOut otherShipment, boolean counter, boolean setOrder) {
        if (this.isProcessed() || this.isPosted() || otherShipment == null) {
            return 0;
        }
        MInOutLine[] fromLines = otherShipment.getLines(false);
        int count = 0;
        int i = 0;
        while (i < fromLines.length) {
            MInOutLine line = new MInOutLine(this);
            MInOutLine fromLine = fromLines[i];
            line.set_TrxName(this.get_TrxName());
            if (counter) {
                PO.copyValues(fromLine, line, this.getAD_Client_ID(), this.getAD_Org_ID());
            } else {
                PO.copyValues(fromLine, line, fromLine.getAD_Client_ID(), fromLine.getAD_Org_ID());
            }
            line.setM_InOut_ID(this.getM_InOut_ID());
            line.set_ValueNoCheck("M_InOutLine_ID", I_ZERO);
            if (!setOrder) {
                line.setC_OrderLine_ID(0);
                line.setM_RMALine_ID(0);
            }
            if (!counter) {
                line.setM_AttributeSetInstance_ID(0);
            }
            line.setRef_InOutLine_ID(0);
            line.setIsInvoiced(false);
            line.setConfirmedQty(Env.ZERO);
            line.setPickedQty(Env.ZERO);
            line.setScrappedQty(Env.ZERO);
            line.setTargetQty(Env.ZERO);
            if (this.getM_Warehouse_ID() != otherShipment.getM_Warehouse_ID()) {
                line.setM_Locator_ID(0);
                line.setM_Locator_ID(Env.ZERO);
            }
            if (counter) {
                PO peer;
                line.setRef_InOutLine_ID(fromLine.getM_InOutLine_ID());
                if (fromLine.getC_OrderLine_ID() != 0 && ((X_C_OrderLine)(peer = new MOrderLine(this.getCtx(), fromLine.getC_OrderLine_ID(), this.get_TrxName()))).getRef_OrderLine_ID() != 0) {
                    line.setC_OrderLine_ID(((X_C_OrderLine)peer).getRef_OrderLine_ID());
                }
                if (fromLine.getM_RMALine_ID() != 0 && ((X_M_RMALine)(peer = new MRMALine(this.getCtx(), fromLine.getM_RMALine_ID(), this.get_TrxName()))).getRef_RMALine_ID() > 0) {
                    line.setM_RMALine_ID(((X_M_RMALine)peer).getRef_RMALine_ID());
                }
            }
            line.setProcessed(false);
            if (line.save(this.get_TrxName())) {
                ++count;
            }
            if (counter) {
                fromLine.setRef_InOutLine_ID(line.getM_InOutLine_ID());
                fromLine.saveEx(this.get_TrxName());
            }
            ++i;
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "Line difference - From=" + fromLines.length + " <> Saved=" + count);
            count = -1;
        }
        return count;
    }

    protected void setReversal(boolean reversal) {
        this.m_reversal = reversal;
    }

    public boolean isReversal() {
        return this.m_reversal;
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        StringBuilder sql = new StringBuilder("UPDATE M_InOutLine SET Processed='").append(processed ? "Y" : "N").append("' WHERE M_InOut_ID=").append(this.getM_InOut_ID());
        int noLine = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.m_lines = null;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(processed + " - Lines=" + noLine);
        }
    }

    public MBPartner getBPartner() {
        if (this.m_partner == null) {
            this.m_partner = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        }
        return this.m_partner;
    }

    public void setC_DocType_ID(String DocBaseType) {
        String sql = "SELECT C_DocType_ID FROM C_DocType WHERE AD_Client_ID=? AND DocBaseType=? AND IsActive='Y' AND IsSOTrx='" + (this.isSOTrx() ? "Y" : "N") + "' ORDER BY IsDefault DESC";
        int C_DocType_ID = DB.getSQLValue(null, sql, this.getAD_Client_ID(), DocBaseType);
        if (C_DocType_ID <= 0) {
            this.log.log(Level.SEVERE, "Not found for AC_Client_ID=" + this.getAD_Client_ID() + " - " + DocBaseType);
        } else {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("DocBaseType=" + DocBaseType + " - C_DocType_ID=" + C_DocType_ID);
            }
            this.setC_DocType_ID(C_DocType_ID);
            boolean isSOTrx = "MMS".equals(DocBaseType);
            this.setIsSOTrx(isSOTrx);
        }
    }

    public void setC_DocType_ID() {
        if (this.isSOTrx()) {
            this.setC_DocType_ID("MMS");
        } else {
            this.setC_DocType_ID("MMR");
        }
    }

    public void setBPartner(MBPartner bp) {
        MUser[] contacts;
        if (bp == null) {
            return;
        }
        this.setC_BPartner_ID(bp.getC_BPartner_ID());
        MBPartnerLocation[] locs = bp.getLocations(false);
        if (locs != null) {
            int i = 0;
            while (i < locs.length) {
                if (locs[i].isShipTo()) {
                    this.setC_BPartner_Location_ID(locs[i].getC_BPartner_Location_ID());
                }
                ++i;
            }
            if (this.getC_BPartner_Location_ID() == 0 && locs.length > 0) {
                this.setC_BPartner_Location_ID(locs[0].getC_BPartner_Location_ID());
            }
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            this.log.log(Level.SEVERE, "Has no To Address: " + String.valueOf(bp));
        }
        if ((contacts = bp.getContacts(false)) != null && contacts.length > 0) {
            this.setAD_User_ID(contacts[0].getAD_User_ID());
        }
    }

    public void createConfirmation() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        boolean pick = dt.isPickQAConfirm();
        boolean ship = dt.isShipConfirm();
        if (!pick && !ship) {
            this.log.fine("No need");
            return;
        }
        if (pick && ship) {
            boolean havePick = false;
            boolean haveShip = false;
            MInOutConfirm[] confirmations = this.getConfirmations(false);
            int i = 0;
            while (i < confirmations.length) {
                MInOutConfirm confirm = confirmations[i];
                if ("PC".equals(confirm.getConfirmType())) {
                    if (!confirm.isProcessed()) {
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("Unprocessed: " + String.valueOf(confirm));
                        }
                        return;
                    }
                    havePick = true;
                } else if ("SC".equals(confirm.getConfirmType())) {
                    haveShip = true;
                }
                ++i;
            }
            if (!havePick) {
                MInOutConfirm.create(this, "PC", false);
                return;
            }
            if (!haveShip) {
                MInOutConfirm.create(this, "SC", false);
                return;
            }
            return;
        }
        if (pick) {
            MInOutConfirm.create(this, "PC", true);
        } else if (ship) {
            MInOutConfirm.create(this, "SC", true);
        }
    }

    protected void voidConfirmations() {
        MInOutConfirm[] mInOutConfirmArray = this.getConfirmations(true);
        int n = mInOutConfirmArray.length;
        int n2 = 0;
        while (n2 < n) {
            MInOutConfirm confirm = mInOutConfirmArray[n2];
            if (!confirm.isProcessed()) {
                if (!confirm.processIt("VO")) {
                    throw new AdempiereException(confirm.getProcessMsg());
                }
                confirm.saveEx();
            }
            ++n2;
        }
    }

    @Override
    public void setM_Warehouse_ID(int M_Warehouse_ID) {
        if (M_Warehouse_ID == 0) {
            this.log.severe("Ignored - Cannot set AD_Warehouse_ID to 0");
            return;
        }
        super.setM_Warehouse_ID(M_Warehouse_ID);
        MWarehouse wh = MWarehouse.get(this.getCtx(), this.getM_Warehouse_ID());
        if (wh.getAD_Org_ID() != this.getAD_Org_ID()) {
            this.log.warning("M_Warehouse_ID=" + M_Warehouse_ID + ", Overwritten AD_Org_ID=" + this.getAD_Org_ID() + "->" + wh.getAD_Org_ID());
            this.setAD_Org_ID(wh.getAD_Org_ID());
        }
    }

    public static String getMovementType(Properties ctx, int C_DocType_ID, boolean issotrx, String trxName) {
        String movementType = null;
        MDocType docType = MDocType.get(C_DocType_ID);
        if (docType == null) {
            return null;
        }
        if (docType.getDocBaseType().equals("MMS")) {
            movementType = docType.isSOTrx() ? "C-" : "V-";
        } else if (docType.getDocBaseType().equals("MMR")) {
            movementType = docType.isSOTrx() ? "C+" : "V+";
        }
        return movementType;
    }

    public void setMovementType() {
        if (this.getC_DocType_ID() <= 0) {
            this.log.saveError("FillMandatory", Msg.translate(this.getCtx(), "C_DocType_ID"));
            return;
        }
        String movementType = MInOut.getMovementType(this.getCtx(), this.getC_DocType_ID(), this.isSOTrx(), this.get_TrxName());
        this.setMovementType(movementType);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MRMA rma;
        if (newRecord || this.is_ValueChanged("C_DocType_ID")) {
            this.setMovementType();
        }
        MWarehouse wh = MWarehouse.get(this.getCtx(), this.getM_Warehouse_ID());
        if (newRecord && wh.getAD_Org_ID() != this.getAD_Org_ID()) {
            this.log.saveError("WarehouseOrgConflict", "");
            return false;
        }
        boolean disallowNegInv = wh.isDisallowNegativeInv();
        String DeliveryRule = this.getDeliveryRule();
        if (disallowNegInv && "F".equals(DeliveryRule) || DeliveryRule == null || DeliveryRule.length() == 0) {
            this.setDeliveryRule("A");
        }
        if (this.getC_Order_ID() != 0 && this.getM_RMA_ID() != 0) {
            this.log.saveError("OrderOrRMA", "");
            return false;
        }
        if (this.isSOTrx() && this.getM_RMA_ID() != 0) {
            rma = new MRMA(this.getCtx(), this.getM_RMA_ID(), this.get_TrxName());
            MDocType docType = MDocType.get(this.getCtx(), rma.getC_DocType_ID());
            this.setC_DocType_ID(docType.getC_DocTypeShipment_ID());
        }
        if (newRecord && this.isSOTrx() && "U".equals(this.getFreightCostRule())) {
            if (Util.isEmpty(this.getShipperAccount())) {
                String shipperAccount = ShippingUtil.getBPShipperAccount(this.getM_Shipper_ID(), this.getC_BPartner_ID(), this.getC_BPartner_Location_ID(), this.getAD_Org_ID(), this.get_TrxName());
                this.setShipperAccount(shipperAccount);
            }
            if (Util.isEmpty(this.getFreightCharges())) {
                this.setFreightCharges("A_Col");
            }
        }
        if (this.getSalesRep_ID() == 0) {
            if (this.getC_Order_ID() > 0) {
                MOrder order = new MOrder(this.getCtx(), this.getC_Order_ID(), this.get_TrxName());
                this.setSalesRep_ID(order.getSalesRep_ID());
            } else if (this.getM_RMA_ID() > 0) {
                rma = new MRMA(this.getCtx(), this.getM_RMA_ID(), this.get_TrxName());
                MInOut originalReceipt = rma.getShipment();
                this.setSalesRep_ID(originalReceipt.getSalesRep_ID());
            }
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success || newRecord) {
            return success;
        }
        if (this.is_ValueChanged("AD_Org_ID")) {
            int no = DB.executeUpdateEx("UPDATE M_InOutLine ol SET AD_Org_ID =(SELECT AD_Org_ID FROM M_InOut o WHERE ol.M_InOut_ID=o.M_InOut_ID) WHERE M_InOut_ID=?", new Object[]{this.getM_InOut_ID()}, this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Lines -> #" + no);
            }
        }
        return true;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        CreditStatus status;
        ICreditManager creditManager;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (this.getC_Order_ID() != 0 && this.getM_RMA_ID() != 0) {
            this.m_processMsg = "@OrderOrRMA@";
            return "IN";
        }
        if (!MPeriod.isOpen(this.getCtx(), this.getDateAcct(), dt.getDocBaseType(), this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        if (!MAcctSchema.isBackDateTrxAllowed(this.getCtx(), this.getDateAcct(), this.get_TrxName())) {
            this.m_processMsg = "@BackDateTrxNotAllowed@";
            return "IN";
        }
        if (!this.isReversal()) {
            StringBuilder sql = new StringBuilder("SELECT DISTINCT o.DocumentNo FROM M_InOut io ").append("JOIN M_InOutLine iol ON (io.M_InOut_ID=iol.M_InOut_ID) ").append("JOIN C_OrderLine ol ON (iol.C_OrderLine_ID=ol.C_OrderLine_ID) ").append("JOIN C_Order o ON (ol.C_Order_ID=o.C_Order_ID) ").append("WHERE o.DocStatus='CL' AND (ol.M_Product_ID > 0 OR ol.C_Charge_ID > 0) AND iol.MovementQty != 0 ").append("AND ol.IsActive='Y' AND iol.IsActive='Y' ").append("AND io.M_InOut_ID=? ");
            List<List<Object>> closeOrders = DB.getSQLArrayObjectsEx(this.get_TrxName(), sql.toString(), this.getM_InOut_ID());
            if (closeOrders != null && closeOrders.size() > 0) {
                this.m_processMsg = Msg.getMsg(this.p_ctx, "OrderClosed") + " (";
                int i = 0;
                while (i < closeOrders.size()) {
                    if (i > 0) {
                        this.m_processMsg = String.valueOf(this.m_processMsg) + ", ";
                    }
                    this.m_processMsg = String.valueOf(this.m_processMsg) + closeOrders.get(i).get(0).toString();
                    ++i;
                }
                this.m_processMsg = String.valueOf(this.m_processMsg) + ")";
                return "IN";
            }
        }
        if ((creditManager = Core.getCreditManager(this)) != null && (status = creditManager.checkCreditStatus("PR")).isError()) {
            this.m_processMsg = status.getErrorMsg();
            return "IN";
        }
        MInOutLine[] lines = this.getLines(true);
        if (lines == null || lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        BigDecimal Volume = Env.ZERO;
        BigDecimal Weight = Env.ZERO;
        int i = 0;
        while (i < lines.length) {
            MInOutLine line = lines[i];
            MProduct product = line.getProduct();
            if (product != null) {
                Volume = Volume.add(product.getVolume().multiply(line.getMovementQty()));
                Weight = Weight.add(product.getWeight().multiply(line.getMovementQty()));
            }
            if (line.getM_AttributeSetInstance_ID() == 0 && product != null && product.isASIMandatoryFor("S", this.isSOTrx()) && product.getAttributeSet() != null && !product.getAttributeSet().excludeTableEntry(320, this.isSOTrx())) {
                BigDecimal qtyDiff = line.getMovementQty();
                MInOutLineMA[] mas = MInOutLineMA.get(this.getCtx(), line.getM_InOutLine_ID(), this.get_TrxName());
                BigDecimal qtyma = Env.ZERO;
                MInOutLineMA[] mInOutLineMAArray = mas;
                int n = mas.length;
                int n2 = 0;
                while (n2 < n) {
                    MInOutLineMA ma = mInOutLineMAArray[n2];
                    if (!ma.isAutoGenerated()) {
                        qtyma = qtyma.add(ma.getMovementQty());
                    }
                    ++n2;
                }
                if (qtyma.subtract(qtyDiff).signum() != 0) {
                    this.m_processMsg = "@M_AttributeSet_ID@ @IsMandatory@ (@Line@ #" + lines[i].getLine() + ", @M_Product_ID@=" + product.getValue() + ")";
                    return "IN";
                }
            }
            ++i;
        }
        this.setVolume(Volume);
        this.setWeight(Weight);
        if (!this.isReversal()) {
            this.createConfirmation();
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (this.getC_Order_ID() > 0) {
            int[] orderIds = DB.getIDsEx(this.get_TrxName(), " SELECT DISTINCT ol.C_Order_ID  FROM M_InOutLine iol  JOIN C_OrderLine ol ON (iol.C_OrderLine_ID=ol.C_OrderLine_ID)  WHERE iol.M_InOut_ID=?", this.getM_InOut_ID());
            if (orderIds.length == 1 && orderIds[0] != this.getC_Order_ID()) {
                this.setC_Order_ID(orderIds[0]);
            } else if (orderIds.length > 1) {
                this.setC_Order_ID(0);
            }
        }
        if (this.getM_RMA_ID() > 0) {
            int[] rmaIds = DB.getIDsEx(this.get_TrxName(), " SELECT DISTINCT rmal.M_RMA_ID  FROM M_InOutLine iol  JOIN M_RMALine rmal ON (iol.M_RMALine_ID=rmal.M_RMALine_ID)  WHERE iol.M_InOut_ID=?", this.getM_InOut_ID());
            if (rmaIds.length == 1 && rmaIds[0] != this.getM_RMA_ID()) {
                this.setM_RMA_ID(rmaIds[0]);
            } else if (rmaIds.length > 1) {
                this.setM_RMA_ID(0);
            }
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public boolean isCustomerReturn() {
        MDocType doctype = MDocType.get(this.getC_DocType_ID());
        return this.isSOTrx() && doctype.getDocBaseType().equals("MMR") && doctype.isSOTrx();
    }

    @Override
    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setIsApproved(false);
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public String completeIt() {
        String valid;
        MInOut dropShipment;
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.setDefiniteDocumentNo();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (this.pendingCustomerConfirmations()) {
            this.m_processMsg = "@Open@: @M_InOutConfirm_ID@";
            return "IP";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        if (!this.isReversal()) {
            try {
                this.periodClosedCheckForBackDateTrx(null);
            }
            catch (PeriodClosedException e) {
                this.m_processMsg = e.getLocalizedMessage();
                return "IN";
            }
        }
        if (!this.isReversal() && !this.stockCoverageCheckForBackDateTrx(null)) {
            this.m_processMsg = "@InsufficientStockCoverage@";
            return "IN";
        }
        StringBuilder info = new StringBuilder();
        StringBuilder errors = new StringBuilder();
        MInOutLine[] lines = this.getLines(false);
        int lineIndex = 0;
        while (lineIndex < lines.length) {
            MInOutLine sLine = lines[lineIndex];
            MProduct product = sLine.getProduct();
            try {
                String MovementType = this.getMovementType();
                BigDecimal Qty = sLine.getMovementQty();
                if (MovementType.charAt(1) == '-') {
                    Qty = Qty.negate();
                }
                MOrderLine oLine = null;
                if (sLine.getC_OrderLine_ID() != 0) {
                    oLine = new MOrderLine(this.getCtx(), sLine.getC_OrderLine_ID(), this.get_TrxName());
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("OrderLine - Reserved=" + String.valueOf(oLine.getQtyReserved()) + ", Delivered=" + String.valueOf(oLine.getQtyDelivered()));
                    }
                }
                boolean orderClosed = oLine != null && "CL".equals(oLine.getParent().getDocStatus());
                MRMALine rmaLine = null;
                if (sLine.getM_RMALine_ID() != 0) {
                    rmaLine = new MRMALine(this.getCtx(), sLine.getM_RMALine_ID(), this.get_TrxName());
                }
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Line=" + sLine.getLine() + " - Qty=" + String.valueOf(sLine.getMovementQty()));
                }
                if (product != null && product.isStocked()) {
                    BigDecimal toDelivered;
                    if (!this.isReversal()) {
                        BigDecimal movementQty = sLine.getMovementQty();
                        BigDecimal qtyOnLineMA = MInOutLineMA.getManualQty(sLine.getM_InOutLine_ID(), this.get_TrxName());
                        if (movementQty.signum() != 0 && qtyOnLineMA.signum() != 0 && movementQty.signum() != qtyOnLineMA.signum() || qtyOnLineMA.abs().compareTo(movementQty.abs()) > 0) {
                            this.m_processMsg = "@Over_Qty_On_Attribute_Tab@ " + sLine.getLine();
                            return "IN";
                        }
                        this.checkMaterialPolicy(sLine, movementQty.subtract(qtyOnLineMA));
                    }
                    this.log.fine("Material Transaction");
                    MTransaction mtrx = null;
                    if (!this.isReversal() && oLine != null && (toDelivered = oLine.getQtyOrdered().subtract(oLine.getQtyDelivered())).signum() < 0) {
                        toDelivered = Env.ZERO;
                    }
                    BigDecimal storageReservationToUpdate = sLine.getMovementQty();
                    if (oLine != null) {
                        if (!this.isReversal()) {
                            if (storageReservationToUpdate.compareTo(oLine.getQtyReserved()) > 0) {
                                storageReservationToUpdate = oLine.getQtyReserved();
                            }
                        } else {
                            BigDecimal tmp = storageReservationToUpdate.negate().add(oLine.getQtyReserved());
                            if (tmp.compareTo(oLine.getQtyOrdered()) > 0) {
                                storageReservationToUpdate = oLine.getQtyOrdered().subtract(oLine.getQtyReserved());
                            }
                        }
                    }
                    if (sLine.getM_AttributeSetInstance_ID() == 0) {
                        MInOutLineMA[] mas = MInOutLineMA.get(this.getCtx(), sLine.getM_InOutLine_ID(), this.get_TrxName());
                        int j = 0;
                        while (j < mas.length) {
                            String status;
                            MInOutLineMA ma = mas[j];
                            BigDecimal QtyMA = ma.getMovementQty();
                            if (MovementType.charAt(1) == '-') {
                                QtyMA = QtyMA.negate();
                            }
                            if (product != null && QtyMA.signum() < 0 && MovementType.equals("C-") && ma.getM_AttributeSetInstance_ID() > 0 && oLine != null && oLine.getM_AttributeSetInstance_ID() == 0 && !ma.isAutoGenerated() && !this.isReversal() && (status = this.moveOnHandToShipmentASI(product, sLine.getM_Locator_ID(), ma.getM_AttributeSetInstance_ID(), QtyMA.negate(), ma.getDateMaterialPolicy(), sLine.get_ID(), false, this.get_TrxName())) != null) {
                                return status;
                            }
                            if (!MStorageOnHand.add(this.getCtx(), sLine.getM_Locator_ID(), sLine.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), QtyMA, ma.getDateMaterialPolicy(), this.get_TrxName())) {
                                String lastError = CLogger.retrieveErrorString("");
                                this.m_processMsg = "Cannot correct Inventory OnHand (MA) [" + product.getValue() + "] - " + lastError;
                                return "IN";
                            }
                            mtrx = new MTransaction(this.getCtx(), sLine.getAD_Org_ID(), MovementType, sLine.getM_Locator_ID(), sLine.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), QtyMA, this.getMovementDate(), this.get_TrxName());
                            mtrx.setM_InOutLine_ID(sLine.getM_InOutLine_ID());
                            if (!mtrx.save()) {
                                this.m_processMsg = "Could not create Material Transaction (MA) [" + product.getValue() + "]";
                                return "IN";
                            }
                            if (product != null && QtyMA.signum() > 0 && MovementType.equals("C-") && ma.getM_AttributeSetInstance_ID() > 0 && oLine != null && oLine.getM_AttributeSetInstance_ID() == 0 && !ma.isAutoGenerated() && this.isReversal() && (status = this.moveOnHandToShipmentASI(product, sLine.getM_Locator_ID(), ma.getM_AttributeSetInstance_ID(), QtyMA.negate(), ma.getDateMaterialPolicy(), sLine.get_ID(), true, this.get_TrxName())) != null) {
                                return status;
                            }
                            ++j;
                        }
                        if (oLine != null && mtrx != null && !orderClosed && (!this.isReversal() && oLine.getQtyReserved().signum() > 0 || this.isReversal() && oLine.getQtyOrdered().signum() > 0) && sLine.getC_OrderLine_ID() != 0 && oLine.getM_Product_ID() > 0) {
                            IReservationTracer tracer = null;
                            IReservationTracerFactory factory = Core.getReservationTracerFactory();
                            if (factory != null) {
                                tracer = factory.newTracer(this.getC_DocType_ID(), this.getDocumentNo(), sLine.getLine(), sLine.get_Table_ID(), sLine.get_ID(), oLine.getM_Warehouse_ID(), oLine.getM_Product_ID(), oLine.getM_AttributeSetInstance_ID(), this.isSOTrx(), this.get_TrxName());
                            }
                            if (!MStorageReservation.add(this.getCtx(), oLine.getM_Warehouse_ID(), oLine.getM_Product_ID(), oLine.getM_AttributeSetInstance_ID(), storageReservationToUpdate.negate(), this.isSOTrx(), this.get_TrxName(), tracer)) {
                                String lastError = CLogger.retrieveErrorString("");
                                this.m_processMsg = "Cannot correct Inventory " + (this.isSOTrx() ? "Reserved" : "Ordered") + " (MA) - [" + product.getValue() + "] - " + lastError;
                                return "IN";
                            }
                        }
                    }
                    if (mtrx == null) {
                        String status;
                        MAttributeSetInstance asi;
                        MAttributeSet as;
                        String status2;
                        if (product != null && MovementType.equals("C-") && sLine.getM_AttributeSetInstance_ID() > 0 && Qty.signum() < 0 && oLine != null && oLine.getM_AttributeSetInstance_ID() == 0 && !this.isReversal() && (status2 = this.moveOnHandToShipmentASI(product, sLine.getM_Locator_ID(), sLine.getM_AttributeSetInstance_ID(), Qty.negate(), null, sLine.get_ID(), false, this.get_TrxName())) != null) {
                            return status2;
                        }
                        Timestamp dateMPolicy = null;
                        BigDecimal pendingQty = Qty;
                        if (pendingQty.signum() < 0) {
                            MStorageOnHand[] storages;
                            MStorageOnHand[] mStorageOnHandArray = storages = MStorageOnHand.getWarehouse(this.getCtx(), 0, sLine.getM_Product_ID(), sLine.getM_AttributeSetInstance_ID(), null, "F".equals(product.getMMPolicy()), false, sLine.getM_Locator_ID(), this.get_TrxName());
                            int n = storages.length;
                            int n2 = 0;
                            while (n2 < n) {
                                MStorageOnHand storage = mStorageOnHandArray[n2];
                                if (pendingQty.signum() == 0) break;
                                if (storage.getQtyOnHand().compareTo(pendingQty.negate()) >= 0) {
                                    dateMPolicy = storage.getDateMaterialPolicy();
                                    break;
                                }
                                if (storage.getQtyOnHand().signum() > 0) {
                                    BigDecimal onHand = storage.getQtyOnHand();
                                    if (!MStorageOnHand.add(this.getCtx(), sLine.getM_Locator_ID(), sLine.getM_Product_ID(), sLine.getM_AttributeSetInstance_ID(), onHand.negate(), storage.getDateMaterialPolicy(), this.get_TrxName())) {
                                        String lastError = CLogger.retrieveErrorString("");
                                        this.m_processMsg = "Cannot correct Inventory OnHand [" + product.getValue() + "] - " + lastError;
                                        return "IN";
                                    }
                                    pendingQty = pendingQty.add(onHand);
                                }
                                ++n2;
                            }
                            if (dateMPolicy == null && storages.length > 0) {
                                dateMPolicy = storages[0].getDateMaterialPolicy();
                            }
                        }
                        if (dateMPolicy == null && product.getM_AttributeSet_ID() > 0 && (as = MAttributeSet.get(this.getCtx(), product.getM_AttributeSet_ID())).isUseGuaranteeDateForMPolicy() && (asi = new MAttributeSetInstance(this.getCtx(), sLine.getM_AttributeSetInstance_ID(), this.get_TrxName())) != null && asi.getGuaranteeDate() != null) {
                            dateMPolicy = asi.getGuaranteeDate();
                        }
                        if (dateMPolicy == null) {
                            dateMPolicy = this.getMovementDate();
                        }
                        if (pendingQty.signum() != 0 && !MStorageOnHand.add(this.getCtx(), sLine.getM_Locator_ID(), sLine.getM_Product_ID(), sLine.getM_AttributeSetInstance_ID(), pendingQty, dateMPolicy, this.get_TrxName())) {
                            String lastError = CLogger.retrieveErrorString("");
                            this.m_processMsg = "Cannot correct Inventory OnHand [" + product.getValue() + "] - " + lastError;
                            return "IN";
                        }
                        if (oLine != null && oLine.getM_Product_ID() > 0 && !orderClosed && (!this.isReversal() && oLine.getQtyReserved().signum() > 0 || this.isReversal() && oLine.getQtyOrdered().signum() > 0)) {
                            IReservationTracer tracer = null;
                            IReservationTracerFactory factory = Core.getReservationTracerFactory();
                            if (factory != null) {
                                tracer = factory.newTracer(this.getC_DocType_ID(), this.getDocumentNo(), sLine.getLine(), sLine.get_Table_ID(), sLine.get_ID(), oLine.getM_Warehouse_ID(), oLine.getM_Product_ID(), oLine.getM_AttributeSetInstance_ID(), this.isSOTrx(), this.get_TrxName());
                            }
                            if (!MStorageReservation.add(this.getCtx(), oLine.getM_Warehouse_ID(), oLine.getM_Product_ID(), oLine.getM_AttributeSetInstance_ID(), storageReservationToUpdate.negate(), this.isSOTrx(), this.get_TrxName(), tracer)) {
                                this.m_processMsg = "Cannot correct Inventory Reserved " + (this.isSOTrx() ? "Reserved [" : "Ordered [") + product.getValue() + "]";
                                return "IN";
                            }
                        }
                        mtrx = new MTransaction(this.getCtx(), sLine.getAD_Org_ID(), MovementType, sLine.getM_Locator_ID(), sLine.getM_Product_ID(), sLine.getM_AttributeSetInstance_ID(), Qty, this.getMovementDate(), this.get_TrxName());
                        mtrx.setM_InOutLine_ID(sLine.getM_InOutLine_ID());
                        if (!mtrx.save()) {
                            this.m_processMsg = CLogger.retrieveErrorString("Could not create Material Transaction [" + product.getValue() + "]");
                            return "IN";
                        }
                        if (product != null && MovementType.equals("C-") && sLine.getM_AttributeSetInstance_ID() > 0 && Qty.signum() > 0 && oLine != null && oLine.getM_AttributeSetInstance_ID() == 0 && this.isReversal() && (status = this.moveOnHandToShipmentASI(product, sLine.getM_Locator_ID(), sLine.getM_AttributeSetInstance_ID(), Qty.negate(), this.getMovementDate(), sLine.get_ID(), true, this.get_TrxName())) != null) {
                            return status;
                        }
                    }
                }
                if (product != null && oLine != null && !orderClosed && oLine.getQtyOrdered().signum() >= 0) {
                    oLine.setQtyReserved(oLine.getQtyReserved().subtract(sLine.getMovementQty()));
                    if (oLine.getQtyReserved().signum() == -1) {
                        oLine.setQtyReserved(Env.ZERO);
                    } else if (oLine.getQtyDelivered().compareTo(oLine.getQtyOrdered()) > 0) {
                        oLine.setQtyReserved(Env.ZERO);
                    }
                }
                if (oLine != null) {
                    if (this.isSOTrx() || sLine.getM_Product_ID() == 0) {
                        if (this.isSOTrx()) {
                            oLine.setQtyDelivered(oLine.getQtyDelivered().subtract(Qty));
                        } else {
                            oLine.setQtyDelivered(oLine.getQtyDelivered().add(Qty));
                        }
                        oLine.setDateDelivered(this.getMovementDate());
                    }
                    if (!oLine.save()) {
                        this.m_processMsg = "Could not update Order Line";
                        return "IN";
                    }
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("OrderLine -> Reserved=" + String.valueOf(oLine.getQtyReserved()) + ", Delivered=" + String.valueOf(oLine.getQtyReserved()));
                    }
                } else if (rmaLine != null) {
                    if (this.isSOTrx()) {
                        rmaLine.setQtyDelivered(rmaLine.getQtyDelivered().add(Qty));
                    } else {
                        rmaLine.setQtyDelivered(rmaLine.getQtyDelivered().subtract(Qty));
                    }
                    if (!rmaLine.save()) {
                        this.m_processMsg = "Could not update RMA Line";
                        return "IN";
                    }
                }
                if (product != null && this.isSOTrx() && product.isCreateAsset() && !product.getM_Product_Category().getA_Asset_Group().isFixedAsset() && sLine.getMovementQty().signum() > 0 && !this.isReversal()) {
                    this.log.fine("Asset");
                    info.append("@A_Asset_ID@: ");
                    int noAssets = sLine.getMovementQty().intValue();
                    if (!product.isOneAssetPerUOM()) {
                        noAssets = 1;
                    }
                    int i = 0;
                    while (i < noAssets) {
                        MAsset asset;
                        if (i > 0) {
                            info.append(" - ");
                        }
                        int deliveryCount = i + 1;
                        if (!product.isOneAssetPerUOM()) {
                            deliveryCount = 0;
                        }
                        if (!(asset = new MAsset(this, sLine, deliveryCount)).save(this.get_TrxName())) {
                            this.m_processMsg = "Could not create Asset";
                            return "IN";
                        }
                        info.append(asset.getValue());
                        ++i;
                    }
                }
                if (!this.isSOTrx() && sLine.getM_Product_ID() != 0 && !this.isReversal()) {
                    BigDecimal matchQty = sLine.getMovementQty();
                    MInvoiceLine iLine = MInvoiceLine.getOfInOutLine(sLine);
                    if (iLine != null && iLine.getM_Product_ID() != 0) {
                        MMatchInv[] matches;
                        if (matchQty.compareTo(iLine.getQtyInvoiced()) > 0) {
                            matchQty = iLine.getQtyInvoiced();
                        }
                        if ((matches = MMatchInv.get(this.getCtx(), sLine.getM_InOutLine_ID(), iLine.getC_InvoiceLine_ID(), this.get_TrxName())) == null || matches.length == 0) {
                            MMatchInv inv = new MMatchInv(iLine, this.getMovementDate(), matchQty);
                            if (sLine.getM_AttributeSetInstance_ID() != iLine.getM_AttributeSetInstance_ID()) {
                                iLine.setM_AttributeSetInstance_ID(sLine.getM_AttributeSetInstance_ID());
                                iLine.saveEx();
                                inv.setM_AttributeSetInstance_ID(sLine.getM_AttributeSetInstance_ID());
                            }
                            if (!inv.save(this.get_TrxName())) {
                                this.m_processMsg = CLogger.retrieveErrorString("Could not create Inv Matching");
                                return "IN";
                            }
                            this.addDocsPostProcess(inv);
                        }
                    }
                    if (sLine.getC_OrderLine_ID() != 0) {
                        this.log.fine("PO Matching");
                        MMatchPO po = MMatchPO.create(null, sLine, this.getMovementDate(), matchQty);
                        if (po != null) {
                            MMatchInv[] matchInvList;
                            if (!po.save(this.get_TrxName())) {
                                this.m_processMsg = "Could not create PO Matching";
                                return "IN";
                            }
                            if (!po.isPosted()) {
                                this.addDocsPostProcess(po);
                            }
                            MMatchInv[] mMatchInvArray = matchInvList = MMatchInv.getInOut(this.getCtx(), this.getM_InOut_ID(), this.get_TrxName());
                            int n = matchInvList.length;
                            int n3 = 0;
                            while (n3 < n) {
                                MMatchInv matchInvCreated = mMatchInvArray[n3];
                                this.addDocsPostProcess(matchInvCreated);
                                ++n3;
                            }
                        }
                        if (oLine != null && oLine.getM_AttributeSetInstance_ID() == 0 && sLine.getMovementQty().compareTo(oLine.getQtyOrdered()) == 0) {
                            oLine.setM_AttributeSetInstance_ID(sLine.getM_AttributeSetInstance_ID());
                            oLine.saveEx(this.get_TrxName());
                        }
                    } else if (iLine != null && iLine.getC_OrderLine_ID() != 0) {
                        this.log.fine("PO(Inv) Matching");
                        MMatchPO po = MMatchPO.create(iLine, sLine, this.getMovementDate(), matchQty);
                        if (po != null) {
                            if (!po.save(this.get_TrxName())) {
                                this.m_processMsg = "Could not create PO(Inv) Matching";
                                return "IN";
                            }
                            if (!po.isPosted()) {
                                this.addDocsPostProcess(po);
                            }
                        }
                        if ((oLine = new MOrderLine(this.getCtx(), iLine.getC_OrderLine_ID(), this.get_TrxName())) != null && oLine.getM_AttributeSetInstance_ID() == 0 && sLine.getMovementQty().compareTo(oLine.getQtyOrdered()) == 0) {
                            oLine.setM_AttributeSetInstance_ID(sLine.getM_AttributeSetInstance_ID());
                            oLine.saveEx(this.get_TrxName());
                        }
                    }
                }
            }
            catch (NegativeInventoryDisallowedException e) {
                this.log.severe(e.getMessage());
                errors.append(Msg.getElement(this.getCtx(), "Line")).append(" ").append(sLine.getLine()).append(": ");
                errors.append(e.getMessage()).append("\n");
            }
            ++lineIndex;
        }
        if (errors.toString().length() > 0) {
            this.m_processMsg = errors.toString();
            return "IN";
        }
        MInOut counter = this.createCounterDoc();
        if (counter != null) {
            info.append(" - @CounterDoc@: @M_InOut_ID@=").append(counter.getDocumentNo());
        }
        if ((dropShipment = this.createDropShipment()) != null) {
            info.append(" - @DropShipment@: @M_InOut_ID@=").append(dropShipment.getDocumentNo());
            final ProcessInfo pi = MWFActivity.getCurrentWorkflowProcessInfo();
            if (pi != null) {
                Trx.get(this.get_TrxName(), false).addTrxEventListener(new TrxEventListener(){

                    @Override
                    public void afterRollback(Trx trx, boolean success) {
                        trx.removeTrxEventListener(this);
                    }

                    @Override
                    public void afterCommit(Trx trx, boolean success) {
                        if (success) {
                            pi.addLog(pi.getAD_PInstance_ID(), null, null, dropShipment.getDocumentInfo(), 319, dropShipment.get_ID());
                        }
                        trx.removeTrxEventListener(this);
                    }

                    @Override
                    public void afterClose(Trx trx) {
                    }
                });
            }
        }
        if (dropShipment != null) {
            this.addDocsPostProcess(dropShipment);
        }
        if ((valid = ModelValidationEngine.get().fireDocValidate(this, 9)) != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.m_processMsg = info.toString();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    public boolean pendingCustomerConfirmations() {
        MInOutConfirm[] confirmations = this.getConfirmations(true);
        int i = 0;
        while (i < confirmations.length) {
            MInOutConfirm confirm = confirmations[i];
            if (!confirm.isProcessed() && !"XC".equals(confirm.getConfirmType())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean pendingConfirmations() {
        MInOutConfirm[] confirmations = this.getConfirmations(true);
        int i = 0;
        while (i < confirmations.length) {
            MInOutConfirm confirm = confirmations[i];
            if (!confirm.isProcessed()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void addDocsPostProcess(PO doc) {
        this.docsPostProcess.add(doc);
    }

    @Override
    public List<PO> getDocsPostProcess() {
        return this.docsPostProcess;
    }

    protected MInOut createDropShipment() {
        if (this.isSOTrx() || !this.isDropShip() || this.getC_Order_ID() == 0) {
            return null;
        }
        int linkedOrderID = new MOrder(this.getCtx(), this.getC_Order_ID(), this.get_TrxName()).getLink_Order_ID();
        if (linkedOrderID <= 0) {
            return null;
        }
        int C_DocTypeTarget_ID = 0;
        MDocType[] shipmentTypes = MDocType.getOfDocBaseType(this.getCtx(), "MMS");
        int i = 0;
        while (i < shipmentTypes.length) {
            if (shipmentTypes[i].isSOTrx() && (C_DocTypeTarget_ID == 0 || shipmentTypes[i].isDefault())) {
                C_DocTypeTarget_ID = shipmentTypes[i].getC_DocType_ID();
            }
            ++i;
        }
        MInOut dropShipment = MInOut.copyFrom(this, this.getMovementDate(), this.getDateAcct(), C_DocTypeTarget_ID, !this.isSOTrx(), false, this.get_TrxName(), true);
        dropShipment.setC_Order_ID(linkedOrderID);
        int invID = new MOrder(this.getCtx(), linkedOrderID, this.get_TrxName()).getC_Invoice_ID();
        if (invID != 0) {
            dropShipment.setC_Invoice_ID(invID);
        }
        dropShipment.setC_BPartner_ID(this.getDropShip_BPartner_ID());
        dropShipment.setC_BPartner_Location_ID(this.getDropShip_Location_ID());
        dropShipment.setAD_User_ID(this.getDropShip_User_ID());
        dropShipment.setIsDropShip(false);
        dropShipment.setDropShip_BPartner_ID(0);
        dropShipment.setDropShip_Location_ID(0);
        dropShipment.setDropShip_User_ID(0);
        dropShipment.setMovementType("C-");
        if (!Util.isEmpty(this.getTrackingNo()) && this.getM_Shipper_ID() > 0 && "S".equals(this.getDeliveryViaRule())) {
            dropShipment.setTrackingNo(this.getTrackingNo());
            dropShipment.setDeliveryViaRule("S");
            dropShipment.setM_Shipper_ID(this.getM_Shipper_ID());
        }
        dropShipment.setSalesRep_ID(this.getSalesRep_ID());
        dropShipment.saveEx(this.get_TrxName());
        MInOutLine[] lines = dropShipment.getLines(true);
        int i2 = 0;
        while (i2 < lines.length) {
            MInOutLine dropLine = lines[i2];
            MOrderLine ol = new MOrderLine(this.getCtx(), dropLine.getC_OrderLine_ID(), null);
            if (ol.getC_OrderLine_ID() != 0) {
                dropLine.setC_OrderLine_ID(ol.getLink_OrderLine_ID());
                dropLine.saveEx();
            }
            ++i2;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(dropShipment.toString());
        }
        dropShipment.set_Attribute("Document.PostImmediateAfterComplete", Boolean.FALSE);
        ProcessInfo processInfo = MWorkflow.runDocumentActionWorkflow(dropShipment, "CO");
        if (processInfo.isError()) {
            throw new RuntimeException(Msg.getMsg(this.getCtx(), "FailedProcessingDocument") + ": " + dropShipment.toString() + " - " + dropShipment.getProcessMsg());
        }
        dropShipment.saveEx();
        return dropShipment;
    }

    protected void setDefiniteDocumentNo() {
        String value;
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setMovementDate(TimeUtil.getDay(0L));
            if (this.getDateAcct().before(this.getMovementDate())) {
                this.setDateAcct(this.getMovementDate());
                MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), this.getC_DocType_ID(), this.getAD_Org_ID());
                MAcctSchema.testBackDateTrxAllowed(this.getCtx(), this.getDateAcct(), this.get_TrxName());
            }
        }
        if (dt.isOverwriteSeqOnComplete() && (value = DB.getDocumentNo(this.getC_DocType_ID(), this.get_TrxName(), true, (PO)this)) != null) {
            this.setDocumentNo(value);
        }
    }

    protected void checkMaterialPolicy(MInOutLine line, BigDecimal qty) {
        int no = MInOutLineMA.deleteInOutLineMA(line.getM_InOutLine_ID(), this.get_TrxName());
        if (no > 0 && this.log.isLoggable(Level.CONFIG)) {
            this.log.config("Delete old #" + no);
        }
        if (Env.ZERO.compareTo(qty) == 0) {
            return;
        }
        String MovementType = this.getMovementType();
        boolean inTrx = MovementType.charAt(1) == '+';
        boolean needSave = false;
        MProduct product = line.getProduct();
        if (product != null && line.getM_Locator_ID() == 0) {
            line.setM_Warehouse_ID(this.getM_Warehouse_ID());
            line.setM_Locator_ID(inTrx ? Env.ZERO : line.getMovementQty());
            needSave = true;
        }
        if (product != null && line.getM_AttributeSetInstance_ID() == 0) {
            if (this.getMovementType().compareTo("V+") == 0) {
                BigDecimal qtyToReceive = this.autoBalanceNegative(line, product, qty);
                if (qtyToReceive.compareTo(Env.ZERO) > 0) {
                    MInOutLineMA ma = MInOutLineMA.addOrCreate(line, 0, qtyToReceive, this.getMovementDate(), true);
                    ma.saveEx();
                }
            } else if (this.getMovementType().compareTo("C+") == 0) {
                MRMALine rmaLine;
                BigDecimal qtyToReturn = this.autoBalanceNegative(line, product, qty);
                if (line.getM_RMALine_ID() != 0 && qtyToReturn.compareTo(Env.ZERO) > 0 && (rmaLine = new MRMALine(this.getCtx(), line.getM_RMALine_ID(), this.get_TrxName())).getM_InOutLine_ID() > 0) {
                    MInOutLineMA[] shipmentMAS;
                    MInOutLineMA[] mInOutLineMAArray = shipmentMAS = MInOutLineMA.getNonReturned(this.getCtx(), rmaLine.getM_InOutLine_ID(), this.get_TrxName());
                    int n = shipmentMAS.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MInOutLineMA sMA = mInOutLineMAArray[n2];
                        BigDecimal lineMAQty = sMA.getMovementQty();
                        if (lineMAQty.compareTo(qtyToReturn) > 0) {
                            lineMAQty = qtyToReturn;
                        }
                        MInOutLineMA ma = MInOutLineMA.addOrCreate(line, sMA.getM_AttributeSetInstance_ID(), lineMAQty, sMA.getDateMaterialPolicy(), true);
                        ma.saveEx();
                        qtyToReturn = qtyToReturn.subtract(lineMAQty);
                        if (qtyToReturn.compareTo(Env.ZERO) == 0) break;
                        ++n2;
                    }
                }
                if (qtyToReturn.compareTo(Env.ZERO) > 0) {
                    MInOutLineMA ma = MInOutLineMA.addOrCreate(line, 0, qtyToReturn, this.getMovementDate(), true);
                    ma.saveEx();
                }
            } else if (this.getMovementType().compareTo("V-") == 0 || this.getMovementType().compareTo("C-") == 0) {
                String MMPolicy = product.getMMPolicy();
                Timestamp minGuaranteeDate = this.getMovementDate();
                MStorageOnHand[] storages = MStorageOnHand.getWarehouse(this.getCtx(), this.getM_Warehouse_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), minGuaranteeDate, "F".equals(MMPolicy), true, line.getM_Locator_ID(), this.get_TrxName(), false);
                BigDecimal qtyToDeliver = qty;
                MStorageOnHand[] mStorageOnHandArray = storages;
                int n = storages.length;
                int n3 = 0;
                while (n3 < n) {
                    MStorageOnHand storage = mStorageOnHandArray[n3];
                    if (storage.getQtyOnHand().compareTo(qtyToDeliver) >= 0) {
                        ma = new MInOutLineMA(line, storage.getM_AttributeSetInstance_ID(), qtyToDeliver, storage.getDateMaterialPolicy(), true);
                        ma.saveEx();
                        qtyToDeliver = Env.ZERO;
                    } else {
                        ma = new MInOutLineMA(line, storage.getM_AttributeSetInstance_ID(), storage.getQtyOnHand(), storage.getDateMaterialPolicy(), true);
                        ma.saveEx();
                        qtyToDeliver = qtyToDeliver.subtract(storage.getQtyOnHand());
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine(String.valueOf(ma) + ", QtyToDeliver=" + String.valueOf(qtyToDeliver));
                        }
                    }
                    if (qtyToDeliver.signum() == 0) break;
                    ++n3;
                }
                if (qtyToDeliver.signum() != 0) {
                    MInOutLineMA ma = MInOutLineMA.addOrCreate(line, line.getM_AttributeSetInstance_ID(), qtyToDeliver, this.getMovementDate(), true);
                    ma.saveEx();
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("##: " + String.valueOf(ma));
                    }
                }
            }
        }
        if (needSave) {
            line.saveEx();
        }
    }

    protected BigDecimal autoBalanceNegative(MInOutLine line, MProduct product, BigDecimal qtyToReceive) {
        MStorageOnHand[] storages = MStorageOnHand.getWarehouseNegative(this.getCtx(), this.getM_Warehouse_ID(), line.getM_Product_ID(), 0, null, "F".equals(product.getMMPolicy()), line.getM_Locator_ID(), this.get_TrxName(), false);
        Timestamp dateMPolicy = null;
        MStorageOnHand[] mStorageOnHandArray = storages;
        int n = storages.length;
        int n2 = 0;
        while (n2 < n) {
            MStorageOnHand storage = mStorageOnHandArray[n2];
            if (storage.getQtyOnHand().signum() < 0 && qtyToReceive.compareTo(Env.ZERO) > 0) {
                dateMPolicy = storage.getDateMaterialPolicy();
                BigDecimal lineMAQty = qtyToReceive;
                if (lineMAQty.compareTo(storage.getQtyOnHand().negate()) > 0) {
                    lineMAQty = storage.getQtyOnHand().negate();
                }
                MInOutLineMA ma = new MInOutLineMA(line, storage.getM_AttributeSetInstance_ID(), lineMAQty, dateMPolicy, true);
                ma.saveEx();
                qtyToReceive = qtyToReceive.subtract(lineMAQty);
            }
            ++n2;
        }
        return qtyToReceive;
    }

    protected MInOut createCounterDoc() {
        if (this.getRef_InOut_ID() != 0) {
            return null;
        }
        MOrg org = MOrg.get(this.getCtx(), this.getAD_Org_ID());
        int counterC_BPartner_ID = org.getLinkedC_BPartner_ID(this.get_TrxName());
        if (counterC_BPartner_ID == 0) {
            return null;
        }
        MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        int counterAD_Org_ID = bp.getAD_OrgBP_ID();
        if (counterAD_Org_ID == 0) {
            return null;
        }
        MBPartner counterBP = new MBPartner(this.getCtx(), counterC_BPartner_ID, null);
        MOrgInfo counterOrgInfo = MOrgInfo.get(this.getCtx(), counterAD_Org_ID, this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Counter BP=" + counterBP.getName());
        }
        int C_DocTypeTarget_ID = 0;
        MDocTypeCounter counterDT = MDocTypeCounter.getCounterDocType(this.getCtx(), this.getC_DocType_ID());
        if (counterDT != null) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(counterDT.toString());
            }
            if (!counterDT.isCreateCounter() || !counterDT.isValid()) {
                return null;
            }
            C_DocTypeTarget_ID = counterDT.getCounter_C_DocType_ID();
        } else {
            C_DocTypeTarget_ID = MDocTypeCounter.getCounterDocType_ID(this.getCtx(), this.getC_DocType_ID());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Indirect C_DocTypeTarget_ID=" + C_DocTypeTarget_ID);
            }
            if (C_DocTypeTarget_ID <= 0) {
                return null;
            }
        }
        MInOut counter = MInOut.copyFrom(this, this.getMovementDate(), this.getDateAcct(), C_DocTypeTarget_ID, !this.isSOTrx(), true, this.get_TrxName(), true);
        counter.setAD_Org_ID(counterAD_Org_ID);
        counter.setM_Warehouse_ID(counterOrgInfo.getM_Warehouse_ID());
        counter.setBPartner(counterBP);
        if (this.isDropShip()) {
            counter.setIsDropShip(true);
            counter.setDropShip_BPartner_ID(this.getDropShip_BPartner_ID());
            counter.setDropShip_Location_ID(this.getDropShip_Location_ID());
            counter.setDropShip_User_ID(this.getDropShip_User_ID());
        }
        counter.setSalesRep_ID(this.getSalesRep_ID());
        counter.saveEx(this.get_TrxName());
        String MovementType = counter.getMovementType();
        boolean inTrx = MovementType.charAt(1) == '+';
        MInOutLine[] counterLines = counter.getLines(true);
        int i = 0;
        while (i < counterLines.length) {
            MInOutLine counterLine = counterLines[i];
            counterLine.setClientOrg(counter);
            counterLine.setM_Warehouse_ID(counter.getM_Warehouse_ID());
            counterLine.setM_Locator_ID(0);
            counterLine.setM_Locator_ID(inTrx ? Env.ZERO : counterLine.getMovementQty());
            counterLine.saveEx(this.get_TrxName());
            ++i;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(counter.toString());
        }
        if (counterDT != null && counterDT.getDocAction() != null) {
            counter.setDocAction(counterDT.getDocAction());
            if (!counter.processIt(counterDT.getDocAction())) {
                throw new AdempiereException(Msg.getMsg(this.getCtx(), "FailedProcessingDocument") + " - " + counter.getProcessMsg());
            }
            counter.saveEx(this.get_TrxName());
        }
        return counter;
    }

    @Override
    public boolean voidIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            return false;
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
            if (this.m_processMsg != null) {
                return false;
            }
            MInOutLine[] lines = this.getLines(false);
            int i = 0;
            while (i < lines.length) {
                MInOutLine line = lines[i];
                BigDecimal old = line.getMovementQty();
                if (old.signum() != 0) {
                    line.setQty(Env.ZERO);
                    StringBuilder msgadd = new StringBuilder("Void (").append(old).append(")");
                    line.addDescription(msgadd.toString());
                    line.saveEx(this.get_TrxName());
                }
                ++i;
            }
        } else {
            boolean accrual = false;
            try {
                MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), this.getC_DocType_ID(), this.getAD_Org_ID());
            }
            catch (PeriodClosedException periodClosedException) {
                accrual = true;
            }
            try {
                MAcctSchema.testBackDateTrxAllowed(this.getCtx(), this.getDateAcct(), this.get_TrxName());
            }
            catch (BackDateTrxNotAllowedException backDateTrxNotAllowedException) {
                accrual = true;
            }
            if (accrual) {
                return this.reverseAccrualIt();
            }
            return this.reverseCorrectIt();
        }
        this.setDocStatus("VO");
        this.saveEx();
        this.voidConfirmations();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        MInOut reversal = this.reverse(false);
        if (reversal == null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = reversal.getDocumentNo();
        this.setProcessed(true);
        this.setDocStatus("RE");
        this.setDocAction("--");
        return true;
    }

    protected MInOut reverse(boolean accrual) {
        Timestamp reversalMovementDate;
        Timestamp reversalDate;
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        Timestamp timestamp = reversalDate = accrual ? Env.getContextAsDate(this.getCtx(), "#Date") : this.getDateAcct();
        if (reversalDate == null) {
            reversalDate = new Timestamp(System.currentTimeMillis());
        }
        Timestamp timestamp2 = reversalMovementDate = accrual ? reversalDate : this.getMovementDate();
        if (!MPeriod.isOpen(this.getCtx(), reversalDate, dt.getDocBaseType(), this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return null;
        }
        if (!MAcctSchema.isBackDateTrxAllowed(this.getCtx(), reversalDate, this.get_TrxName())) {
            this.m_processMsg = "@BackDateTrxNotAllowed@";
            return null;
        }
        try {
            this.periodClosedCheckForBackDateTrx(reversalDate);
        }
        catch (PeriodClosedException e) {
            this.m_processMsg = e.getLocalizedMessage();
            return null;
        }
        if (!this.stockCoverageCheckForBackDateTrx(reversalDate)) {
            this.m_processMsg = "@InsufficientStockCoverageForReversal@";
            return null;
        }
        if (!this.isSOTrx() && !this.reverseMatching(reversalDate)) {
            return null;
        }
        MInOut reversal = MInOut.copyFrom(this, reversalMovementDate, reversalDate, this.getC_DocType_ID(), this.isSOTrx(), false, this.get_TrxName(), true);
        if (reversal == null) {
            this.m_processMsg = "Could not create Ship Reversal";
            return null;
        }
        reversal.setReversal(true);
        MInOutLine[] sLines = this.getLines(false);
        MInOutLine[] rLines = reversal.getLines(false);
        int i = 0;
        while (i < rLines.length) {
            MAsset asset;
            MInOutLine rLine = rLines[i];
            rLine.setQtyEntered(rLine.getQtyEntered().negate());
            rLine.setMovementQty(rLine.getMovementQty().negate());
            rLine.setM_AttributeSetInstance_ID(sLines[i].getM_AttributeSetInstance_ID());
            rLine.setReversalLine_ID(sLines[i].getM_InOutLine_ID());
            if (!rLine.save(this.get_TrxName())) {
                this.m_processMsg = "Could not correct Ship Reversal Line";
                return null;
            }
            if (rLine.getM_AttributeSetInstance_ID() == 0) {
                MInOutLineMA[] mas = MInOutLineMA.get(this.getCtx(), sLines[i].getM_InOutLine_ID(), this.get_TrxName());
                int j = 0;
                while (j < mas.length) {
                    MInOutLineMA ma = new MInOutLineMA(rLine, mas[j].getM_AttributeSetInstance_ID(), mas[j].getMovementQty().negate(), mas[j].getDateMaterialPolicy(), mas[j].isAutoGenerated());
                    ma.saveEx();
                    ++j;
                }
            }
            if ((asset = MAsset.getFromShipment(this.getCtx(), sLines[i].getM_InOutLine_ID(), this.get_TrxName())) != null) {
                asset.setIsActive(false);
                asset.setDescription(asset.getDescription() + " (" + reversal.getDocumentNo() + " #" + rLine.getLine() + "<-)");
                asset.saveEx();
            }
            String sql = "SELECT C_InvoiceLine_ID FROM C_InvoiceLine WHERE M_InOutLine_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, sLines[i].getM_InOutLine_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int invoiceLineId = rs.getInt(1);
                        if (invoiceLineId <= 0) continue;
                        MInvoiceLine iLine = new MInvoiceLine(this.getCtx(), invoiceLineId, this.get_TrxName());
                        iLine.setM_InOutLine_ID(0);
                        iLine.saveEx();
                    }
                }
                catch (SQLException e) {
                    throw new DBException(e, sql);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            ++i;
        }
        reversal.setC_Order_ID(this.getC_Order_ID());
        reversal.setM_RMA_ID(this.getM_RMA_ID());
        StringBuilder msgadd = new StringBuilder("{->").append(this.getDocumentNo()).append(")");
        reversal.addDescription(msgadd.toString());
        reversal.setReversal_ID(this.getM_InOut_ID());
        reversal.saveEx(this.get_TrxName());
        reversal.docsPostProcess = this.docsPostProcess;
        this.docsPostProcess = new ArrayList();
        if (!reversal.processIt("CO") || !reversal.getDocStatus().equals("CO")) {
            this.m_processMsg = "Reversal ERROR: " + reversal.getProcessMsg();
            return null;
        }
        reversal.closeIt();
        reversal.setProcessing(false);
        reversal.setDocStatus("RE");
        reversal.setDocAction("--");
        reversal.saveEx(this.get_TrxName());
        msgadd = new StringBuilder("(").append(reversal.getDocumentNo()).append("<-)");
        this.addDescription(msgadd.toString());
        this.setDocStatus("RE");
        this.saveEx();
        this.setReversal_ID(reversal.getM_InOut_ID());
        this.voidConfirmations();
        return reversal;
    }

    protected boolean reverseMatching(Timestamp reversalDate) {
        MMatchPO[] mMatchPOList;
        MMatchInv[] mInv;
        MMatchInv[] mMatchInvArray = mInv = MMatchInv.getInOut(this.getCtx(), this.getM_InOut_ID(), this.get_TrxName());
        int n = mInv.length;
        int n2 = 0;
        while (n2 < n) {
            String description;
            MMatchInv mMatchInv = mMatchInvArray[n2];
            if (!(mMatchInv.getReversal_ID() > 0 || (description = mMatchInv.getDescription()) != null && description.endsWith("<-)"))) {
                if (!mMatchInv.reverse(reversalDate)) {
                    this.log.log(Level.SEVERE, "Failed to create reversal for match invoice " + mMatchInv.getDocumentNo());
                    return false;
                }
                this.addDocsPostProcess(new MMatchInv(Env.getCtx(), mMatchInv.getReversal_ID(), this.get_TrxName()));
            }
            ++n2;
        }
        MMatchPO[] mMatchPOArray = mMatchPOList = MMatchPO.getInOut(this.getCtx(), this.getM_InOut_ID(), this.get_TrxName());
        int n3 = mMatchPOList.length;
        n = 0;
        while (n < n3) {
            String description;
            MMatchPO mMatchPO = mMatchPOArray[n];
            if (!(mMatchPO.getReversal_ID() > 0 || (description = mMatchPO.getDescription()) != null && description.endsWith("<-)"))) {
                if (!mMatchPO.reverse(reversalDate)) {
                    this.log.log(Level.SEVERE, "Failed to create reversal for match purchase order " + mMatchPO.getDocumentNo());
                    return false;
                }
                this.addDocsPostProcess(new MMatchPO(Env.getCtx(), mMatchPO.getReversal_ID(), this.get_TrxName()));
            }
            ++n;
        }
        return true;
    }

    @Override
    public boolean reverseAccrualIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        MInOut reversal = this.reverse(true);
        if (reversal == null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = reversal.getDocumentNo();
        this.setProcessed(true);
        this.setDocStatus("RE");
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean reActivateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDocumentNo());
        sb.append(":").append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return Env.ZERO;
    }

    @Override
    public int getC_Currency_ID() {
        return Env.getContextAsInt(this.getCtx(), "$C_Currency_ID");
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String moveOnHandToShipmentASI(MProduct product, int M_Locator_ID, int M_AttributeSetInstance_ID, BigDecimal qty, Timestamp dateMaterialPolicy, int M_InOutLine_ID, boolean reversal, String trxName) {
        MStorageOnHand[] storages;
        if (qty.signum() == 0 || qty.signum() < 0 && !reversal || qty.signum() > 0 && reversal) {
            return null;
        }
        if (M_AttributeSetInstance_ID == 0) {
            return null;
        }
        if (dateMaterialPolicy != null) {
            MStorageOnHand asi = MStorageOnHand.get(this.getCtx(), M_Locator_ID, product.getM_Product_ID(), M_AttributeSetInstance_ID, dateMaterialPolicy, trxName);
            if (asi != null && asi.getQtyOnHand().signum() != 0 && !reversal) {
                return null;
            }
            if (!reversal) return this.doMove(product, M_Locator_ID, M_AttributeSetInstance_ID, dateMaterialPolicy, qty, M_InOutLine_ID, reversal, trxName);
            if (!MStorageOnHand.add(this.getCtx(), M_Locator_ID, product.getM_Product_ID(), 0, qty.negate(), dateMaterialPolicy, trxName)) {
                String lastError = CLogger.retrieveErrorString("");
                this.m_processMsg = "Cannot move Inventory OnHand to Non ASI [" + product.getValue() + "] - " + lastError;
                return "IN";
            }
            MTransaction trxFrom = new MTransaction(Env.getCtx(), this.getAD_Org_ID(), this.getMovementType(), M_Locator_ID, product.getM_Product_ID(), 0, qty.negate(), this.getMovementDate(), trxName);
            trxFrom.setM_InOutLine_ID(M_InOutLine_ID);
            if (!trxFrom.save()) {
                this.m_processMsg = "Transaction From not inserted (MA) [" + product.getValue() + "] - ";
                return "IN";
            }
            if (!MStorageOnHand.add(this.getCtx(), M_Locator_ID, product.getM_Product_ID(), M_AttributeSetInstance_ID, qty, dateMaterialPolicy, trxName)) {
                String lastError = CLogger.retrieveErrorString("");
                this.m_processMsg = "Cannot move Inventory OnHand to Shipment ASI [" + product.getValue() + "] - " + lastError;
                return "IN";
            }
            MTransaction trxTo = new MTransaction(Env.getCtx(), this.getAD_Org_ID(), this.getMovementType(), M_Locator_ID, product.getM_Product_ID(), M_AttributeSetInstance_ID, qty, this.getMovementDate(), trxName);
            trxTo.setM_InOutLine_ID(M_InOutLine_ID);
            if (trxTo.save()) return null;
            this.m_processMsg = "Transaction To not inserted (MA) [" + product.getValue() + "] - ";
            return "IN";
        }
        BigDecimal totalASI = BigDecimal.ZERO;
        MStorageOnHand[] mStorageOnHandArray = storages = MStorageOnHand.getWarehouse(this.getCtx(), 0, product.getM_Product_ID(), M_AttributeSetInstance_ID, null, "F".equals(product.getMMPolicy()), false, M_Locator_ID, this.get_TrxName());
        int n = storages.length;
        int n2 = 0;
        while (n2 < n) {
            MStorageOnHand onhand = mStorageOnHandArray[n2];
            totalASI = totalASI.add(onhand.getQtyOnHand());
            ++n2;
        }
        if (!reversal && totalASI.signum() != 0) {
            return null;
        }
        if (!reversal || totalASI.compareTo(qty) >= 0) return this.doMove(product, M_Locator_ID, M_AttributeSetInstance_ID, dateMaterialPolicy, qty, M_InOutLine_ID, reversal, trxName);
        return null;
    }

    private String doMove(MProduct product, int M_Locator_ID, int M_AttributeSetInstance_ID, Timestamp dateMaterialPolicy, BigDecimal qty, int M_InOutLine_ID, boolean reversal, String trxName) {
        BigDecimal totalOnHand = BigDecimal.ZERO;
        Timestamp onHandDateMaterialPolicy = null;
        MStorageOnHand[] storages = MStorageOnHand.getWarehouse(this.getCtx(), 0, product.getM_Product_ID(), 0, null, "F".equals(product.getMMPolicy()), true, M_Locator_ID, this.get_TrxName());
        ArrayList<MStorageOnHand> nonASIList = new ArrayList<MStorageOnHand>();
        MStorageOnHand[] mStorageOnHandArray = storages;
        int n = storages.length;
        int n2 = 0;
        while (n2 < n) {
            MStorageOnHand storage = mStorageOnHandArray[n2];
            if (storage.getM_AttributeSetInstance_ID() == 0) {
                totalOnHand = totalOnHand.add(storage.getQtyOnHand());
                nonASIList.add(storage);
            }
            ++n2;
        }
        if (totalOnHand.compareTo(qty) >= 0 || reversal) {
            BigDecimal totalToMove = qty;
            for (MStorageOnHand onhand : nonASIList) {
                BigDecimal toMove = totalToMove;
                if (!reversal && toMove.compareTo(onhand.getQtyOnHand()) >= 0) {
                    toMove = onhand.getQtyOnHand();
                }
                if (!MStorageOnHand.add(this.getCtx(), M_Locator_ID, product.getM_Product_ID(), 0, toMove.negate(), onhand.getDateMaterialPolicy(), trxName)) {
                    String lastError = CLogger.retrieveErrorString("");
                    this.m_processMsg = "Cannot move Inventory OnHand to Non ASI [" + product.getValue() + "] - " + lastError;
                    return "IN";
                }
                MTransaction trxFrom = new MTransaction(Env.getCtx(), this.getAD_Org_ID(), this.getMovementType(), M_Locator_ID, product.getM_Product_ID(), 0, toMove.negate(), this.getMovementDate(), trxName);
                trxFrom.setM_InOutLine_ID(M_InOutLine_ID);
                if (!trxFrom.save()) {
                    this.m_processMsg = "Transaction From not inserted (MA) [" + product.getValue() + "] - ";
                    return "IN";
                }
                onHandDateMaterialPolicy = onhand.getDateMaterialPolicy();
                totalToMove = totalToMove.subtract(toMove);
                if (!reversal && totalToMove.signum() <= 0 || reversal && totalToMove.signum() >= 0) break;
            }
            if (!MStorageOnHand.add(this.getCtx(), M_Locator_ID, product.getM_Product_ID(), M_AttributeSetInstance_ID, qty, dateMaterialPolicy != null ? dateMaterialPolicy : onHandDateMaterialPolicy, trxName)) {
                String lastError = CLogger.retrieveErrorString("");
                this.m_processMsg = "Cannot move Inventory OnHand to Shipment ASI [" + product.getValue() + "] - " + lastError;
                return "IN";
            }
            MTransaction trxTo = new MTransaction(Env.getCtx(), this.getAD_Org_ID(), this.getMovementType(), M_Locator_ID, product.getM_Product_ID(), M_AttributeSetInstance_ID, qty, this.getMovementDate(), trxName);
            trxTo.setM_InOutLine_ID(M_InOutLine_ID);
            if (!trxTo.save()) {
                this.m_processMsg = "Transaction To not inserted (MA) [" + product.getValue() + "] - ";
                return "IN";
            }
        }
        return null;
    }

    public void createLineFrom(int C_OrderLine_ID, int C_InvoiceLine_ID, int M_RMALine_ID, int M_Product_ID, int C_UOM_ID, BigDecimal Qty, int M_Locator_ID) {
        MInvoiceLine il = null;
        if (C_InvoiceLine_ID != 0) {
            il = new MInvoiceLine(Env.getCtx(), C_InvoiceLine_ID, this.get_TrxName());
        }
        MInOutLine iol = new MInOutLine(this);
        iol.setM_Product_ID(M_Product_ID, C_UOM_ID);
        iol.setQty(Qty);
        X_C_OrderLine ol = null;
        MRMALine rmal = null;
        if (C_OrderLine_ID != 0) {
            iol.setC_OrderLine_ID(C_OrderLine_ID);
            ol = new MOrderLine(Env.getCtx(), C_OrderLine_ID, this.get_TrxName());
            if (ol.getQtyEntered().compareTo(ol.getQtyOrdered()) != 0) {
                iol.setMovementQty(Qty.multiply(ol.getQtyOrdered()).divide(ol.getQtyEntered(), 12, RoundingMode.HALF_UP));
                iol.setC_UOM_ID(ol.getC_UOM_ID());
            }
            iol.setM_AttributeSetInstance_ID(ol.getM_AttributeSetInstance_ID());
            iol.setDescription(ol.getDescription());
            iol.setC_Project_ID(((MOrderLine)ol).getC_Project_ID());
            iol.setC_ProjectPhase_ID(ol.getC_ProjectPhase_ID());
            iol.setC_ProjectTask_ID(ol.getC_ProjectTask_ID());
            iol.setC_Activity_ID(((MOrderLine)ol).getC_Activity_ID());
            iol.setC_Campaign_ID(((MOrderLine)ol).getC_Campaign_ID());
            iol.setAD_OrgTrx_ID(((MOrderLine)ol).getAD_OrgTrx_ID());
            iol.setUser1_ID(((MOrderLine)ol).getUser1_ID());
            iol.setUser2_ID(((MOrderLine)ol).getUser2_ID());
        } else if (il != null) {
            if (il.getC_OrderLine_ID() > 0) {
                iol.setC_OrderLine_ID(il.getC_OrderLine_ID());
            }
            if (il.getQtyEntered().compareTo(il.getQtyInvoiced()) != 0) {
                iol.setMovementQty(Qty.multiply(il.getQtyInvoiced()).divide(il.getQtyEntered(), 12, RoundingMode.HALF_UP));
                iol.setC_UOM_ID(il.getC_UOM_ID());
            }
            iol.setDescription(il.getDescription());
            iol.setC_Project_ID(il.getC_Project_ID());
            iol.setC_ProjectPhase_ID(il.getC_ProjectPhase_ID());
            iol.setC_ProjectTask_ID(il.getC_ProjectTask_ID());
            iol.setC_Activity_ID(il.getC_Activity_ID());
            iol.setC_Campaign_ID(il.getC_Campaign_ID());
            iol.setAD_OrgTrx_ID(il.getAD_OrgTrx_ID());
            iol.setUser1_ID(il.getUser1_ID());
            iol.setUser2_ID(il.getUser2_ID());
        } else if (M_RMALine_ID != 0) {
            rmal = new MRMALine(Env.getCtx(), M_RMALine_ID, this.get_TrxName());
            iol.setM_RMALine_ID(M_RMALine_ID);
            iol.setQtyEntered(Qty);
            iol.setDescription(rmal.getDescription());
            iol.setM_AttributeSetInstance_ID(rmal.getM_AttributeSetInstance_ID());
            iol.setC_Project_ID(rmal.getC_Project_ID());
            iol.setC_ProjectPhase_ID(rmal.getC_ProjectPhase_ID());
            iol.setC_ProjectTask_ID(rmal.getC_ProjectTask_ID());
            iol.setC_Activity_ID(rmal.getC_Activity_ID());
            iol.setAD_OrgTrx_ID(rmal.getAD_OrgTrx_ID());
            iol.setUser1_ID(rmal.getUser1_ID());
            iol.setUser2_ID(rmal.getUser2_ID());
        }
        if (M_Product_ID == 0) {
            if (ol != null && ol.getC_Charge_ID() != 0) {
                iol.setC_Charge_ID(ol.getC_Charge_ID());
            } else if (il != null && il.getC_Charge_ID() != 0) {
                iol.setC_Charge_ID(il.getC_Charge_ID());
            } else if (rmal != null && rmal.getC_Charge_ID() != 0) {
                iol.setC_Charge_ID(rmal.getC_Charge_ID());
            }
        }
        iol.setM_Locator_ID(M_Locator_ID);
        iol.saveEx();
        if (il != null) {
            il.setM_InOutLine_ID(iol.getM_InOutLine_ID());
            il.saveEx();
        }
    }

    public void updateFrom(MOrder order, MInvoice invoice, MRMA rma) {
        if (order != null && order.getC_Order_ID() != 0) {
            this.setC_Order_ID(order.getC_Order_ID());
            this.setAD_OrgTrx_ID(order.getAD_OrgTrx_ID());
            this.setC_Project_ID(order.getC_Project_ID());
            this.setC_Campaign_ID(order.getC_Campaign_ID());
            this.setC_Activity_ID(order.getC_Activity_ID());
            this.setSalesRep_ID(order.getSalesRep_ID());
            this.setUser1_ID(order.getUser1_ID());
            this.setUser2_ID(order.getUser2_ID());
            if (order.isDropShip()) {
                this.setM_Warehouse_ID(order.getM_Warehouse_ID());
                this.setIsDropShip(order.isDropShip());
                this.setDropShip_BPartner_ID(order.getDropShip_BPartner_ID());
                this.setDropShip_Location_ID(order.getDropShip_Location_ID());
                this.setDropShip_User_ID(order.getDropShip_User_ID());
                if ("S".equals(order.getDeliveryViaRule()) && order.getM_Shipper_ID() > 0) {
                    this.setDeliveryViaRule(order.getDeliveryViaRule());
                    this.setM_Shipper_ID(order.getM_Shipper_ID());
                }
            }
        }
        if (invoice != null && invoice.getC_Invoice_ID() != 0) {
            if (this.getC_Order_ID() == 0) {
                this.setC_Order_ID(invoice.getC_Order_ID());
            }
            this.setC_Invoice_ID(invoice.getC_Invoice_ID());
            this.setAD_OrgTrx_ID(invoice.getAD_OrgTrx_ID());
            this.setC_Project_ID(invoice.getC_Project_ID());
            this.setC_Campaign_ID(invoice.getC_Campaign_ID());
            this.setC_Activity_ID(invoice.getC_Activity_ID());
            this.setUser1_ID(invoice.getUser1_ID());
            this.setUser2_ID(invoice.getUser2_ID());
        }
        if (rma != null && rma.getM_RMA_ID() != 0) {
            MInOut originalIO = rma.getShipment();
            this.setIsSOTrx(rma.isSOTrx());
            this.setC_Order_ID(0);
            this.setC_Invoice_ID(0);
            this.setM_RMA_ID(rma.getM_RMA_ID());
            this.setAD_OrgTrx_ID(originalIO.getAD_OrgTrx_ID());
            this.setC_Project_ID(originalIO.getC_Project_ID());
            this.setC_Campaign_ID(originalIO.getC_Campaign_ID());
            this.setC_Activity_ID(originalIO.getC_Activity_ID());
            this.setUser1_ID(originalIO.getUser1_ID());
            this.setUser2_ID(originalIO.getUser2_ID());
        }
        this.saveEx();
    }

    private boolean stockCoverageCheckForBackDateTrx(Timestamp reversalDate) {
        block14: {
            MInOutLine[] sLines;
            String MovementType;
            MAcctSchema as;
            block13: {
                MMatchPO[] mMatchPOList;
                MClientInfo info = MClientInfo.get(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName());
                as = info.getMAcctSchema1();
                if (!"A".equals(as.getCostingMethod()) && !"I".equals(as.getCostingMethod())) {
                    return true;
                }
                as.load(this.get_TrxName(), new String[0]);
                if (as.getBackDateDay() == 0) {
                    return true;
                }
                MovementType = this.getMovementType();
                if (reversalDate == null || !MovementType.equals("V+")) break block13;
                StringBuilder whereClause = new StringBuilder();
                whereClause.append("AD_Client_ID=? ");
                whereClause.append("AND C_AcctSchema_ID=? ");
                whereClause.append("AND M_Product_ID=? ");
                whereClause.append("AND (DateAcct, COALESCE(Ref_CostDetail_ID,M_CostDetail_ID), M_CostDetail_ID) > (");
                whereClause.append(" SELECT cd.DateAcct, ");
                whereClause.append(" CASE WHEN COALESCE(refcd.DateAcct,cd.DateAcct) = cd.DateAcct THEN COALESCE(cd.Ref_CostDetail_ID,cd.M_CostDetail_ID) ELSE cd.M_CostDetail_ID END, ");
                whereClause.append(" cd.M_CostDetail_ID ");
                whereClause.append(" FROM M_CostDetail cd ");
                whereClause.append(" LEFT JOIN M_CostDetail refcd ON (refcd.M_CostDetail_ID=cd.Ref_CostDetail_ID) ");
                whereClause.append(" WHERE cd.M_CostDetail_ID=? ");
                whereClause.append(") ");
                whereClause.append("AND DateAcct >= ? ");
                whereClause.append("AND Processed='Y' ");
                whereClause.append("AND (M_InOutLine_ID <> 0 OR C_ProjectIssue_ID <> 0) ");
                MMatchPO[] mMatchPOArray = mMatchPOList = MMatchPO.getInOut(this.getCtx(), this.getM_InOut_ID(), this.get_TrxName());
                int n = mMatchPOList.length;
                int n2 = 0;
                while (n2 < n) {
                    MCostDetail cd;
                    MMatchPO mMatchPO = mMatchPOArray[n2];
                    if (mMatchPO.getReversal_ID() <= 0 && (cd = MCostDetail.getOrder(as, mMatchPO.getM_Product_ID(), mMatchPO.getM_AttributeSetInstance_ID(), mMatchPO.getC_OrderLine_ID(), 0, reversalDate, this.get_TrxName())) != null) {
                        BigDecimal qty = cd.getQty().negate();
                        List costDetailList = new Query(this.getCtx(), "M_CostDetail", whereClause.toString(), this.get_TrxName()).setParameters(this.getAD_Client_ID(), as.getC_AcctSchema_ID(), cd.getM_Product_ID(), cd.getM_CostDetail_ID(), cd.getDateAcct()).list();
                        for (MCostDetail costDetail : costDetailList) {
                            if (costDetail.getM_InOutLine_ID() <= 0 ? costDetail.getC_ProjectIssue_ID() <= 0 || costDetail.getC_ProjectIssue().getReversal_ID() > 0 : costDetail.getM_InOutLine().getM_InOut().getReversal_ID() > 0) continue;
                            if (costDetail.getCurrentQty().add(qty).signum() >= 0) continue;
                            this.log.log(Level.SEVERE, "Insufficient stock coverage" + String.valueOf(costDetail));
                            return false;
                        }
                    }
                    ++n2;
                }
                break block14;
            }
            if (reversalDate != null || !MovementType.equals("C-")) break block14;
            MInOutLine[] mInOutLineArray = sLines = this.getLines(false);
            int n = sLines.length;
            int n3 = 0;
            while (n3 < n) {
                ICostInfo costInfo;
                MInOutLine sLine = mInOutLineArray[n3];
                int AD_Org_ID = sLine.getAD_Org_ID();
                int M_AttributeSetInstance_ID = sLine.getM_AttributeSetInstance_ID();
                if ("C".equals(as.getCostingLevel())) {
                    AD_Org_ID = 0;
                    M_AttributeSetInstance_ID = 0;
                } else if ("O".equals(as.getCostingLevel())) {
                    M_AttributeSetInstance_ID = 0;
                } else if ("B".equals(as.getCostingLevel())) {
                    AD_Org_ID = 0;
                }
                MCostElement ce = MCostElement.getMaterialCostElement(this.getCtx(), as.getCostingMethod(), AD_Org_ID);
                BigDecimal qty = sLine.getMovementQty();
                if (MovementType.charAt(1) == '-') {
                    qty = qty.negate();
                }
                if ((costInfo = MCost.getCostInfo(this.getCtx(), this.getAD_Client_ID(), AD_Org_ID, sLine.getM_Product_ID(), as.getM_CostType_ID(), as.getC_AcctSchema_ID(), ce.getM_CostElement_ID(), M_AttributeSetInstance_ID, this.getDateAcct(), null, this.get_TrxName())) != null && costInfo.getCurrentQty().add(qty).signum() < 0) {
                    this.log.log(Level.SEVERE, "Insufficient stock coverage" + String.valueOf(MProduct.get(this.getCtx(), sLine.getM_Product_ID(), this.get_TrxName())));
                    return false;
                }
                ++n3;
            }
        }
        return true;
    }

    private boolean periodClosedCheckForBackDateTrx(Timestamp reversalDate) {
        MInOutLine[] sLines;
        MClientInfo info = MClientInfo.get(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName());
        MAcctSchema as = info.getMAcctSchema1();
        if (!"A".equals(as.getCostingMethod()) && !"I".equals(as.getCostingMethod())) {
            return true;
        }
        if (as.getBackDateDay() == 0) {
            return true;
        }
        Timestamp dateAcct = reversalDate != null ? reversalDate : this.getDateAcct();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT COUNT(*) FROM M_CostDetail ");
        sql.append("WHERE M_Product_ID IN (SELECT M_Product_ID FROM M_InOutLine WHERE M_InOut_ID=?) ");
        sql.append("AND Processed='Y' ");
        sql.append(reversalDate != null ? "AND DateAcct>=? " : "AND DateAcct>? ");
        int no = DB.getSQLValueEx(this.get_TrxName(), sql.toString(), this.get_ID(), dateAcct);
        if (no <= 0) {
            return true;
        }
        MInOutLine[] mInOutLineArray = sLines = this.getLines(false);
        int n = sLines.length;
        int n2 = 0;
        while (n2 < n) {
            MInOutLine sLine = mInOutLineArray[n2];
            int AD_Org_ID = sLine.getAD_Org_ID();
            int M_AttributeSetInstance_ID = sLine.getM_AttributeSetInstance_ID();
            if ("C".equals(as.getCostingLevel())) {
                AD_Org_ID = 0;
                M_AttributeSetInstance_ID = 0;
            } else if ("O".equals(as.getCostingLevel())) {
                M_AttributeSetInstance_ID = 0;
            } else if ("B".equals(as.getCostingLevel())) {
                AD_Org_ID = 0;
            }
            MCostElement ce = MCostElement.getMaterialCostElement(this.getCtx(), as.getCostingMethod(), AD_Org_ID);
            int M_CostDetail_ID = 0;
            if (!this.isSOTrx()) {
                MCostHistory history;
                MMatchPO[] mMatchPOList;
                MMatchPO[] mMatchPOArray = mMatchPOList = MMatchPO.get(this.getCtx(), sLine.getM_InOutLine_ID(), this.get_TrxName());
                int n3 = mMatchPOList.length;
                int n4 = 0;
                while (n4 < n3) {
                    MCostDetail cd;
                    MMatchPO mMatchPO = mMatchPOArray[n4];
                    int C_OrderLine_ID = mMatchPO.getC_OrderLine_ID();
                    Timestamp dateAcct0 = mMatchPO.getDateAcct();
                    if (mMatchPO.getReversal_ID() > 0 && mMatchPO.get_ID() > mMatchPO.getReversal_ID()) {
                        C_OrderLine_ID = mMatchPO.getReversal().getC_OrderLine_ID();
                        dateAcct0 = mMatchPO.getReversal().getDateAcct();
                    }
                    if ((cd = MCostDetail.getOrder(as, mMatchPO.getM_Product_ID(), mMatchPO.getM_AttributeSetInstance_ID(), C_OrderLine_ID, 0, dateAcct0, this.get_TrxName())) != null) {
                        M_CostDetail_ID = cd.getM_CostDetail_ID();
                    }
                    ++n4;
                }
                if (M_CostDetail_ID == 0 && (history = MCostHistory.get(this.getCtx(), this.getAD_Client_ID(), AD_Org_ID, sLine.getM_Product_ID(), as.getM_CostType_ID(), as.getC_AcctSchema_ID(), ce.getCostingMethod(), ce.getM_CostElement_ID(), M_AttributeSetInstance_ID, dateAcct, this.get_TrxName())) != null) {
                    M_CostDetail_ID = history.getM_CostDetail_ID();
                }
                if (M_CostDetail_ID > 0) {
                    MCostDetail.periodClosedCheckForDocsAfterBackDateTrx(this.getAD_Client_ID(), as.getC_AcctSchema_ID(), sLine.getM_Product_ID(), M_CostDetail_ID, dateAcct, this.get_TrxName());
                }
            } else {
                MCostDetail cd;
                int M_InOutLine_ID = sLine.getM_InOutLine_ID();
                if (sLine.getReversalLine_ID() > 0 && sLine.get_ID() > sLine.getReversalLine_ID()) {
                    M_InOutLine_ID = sLine.getReversalLine_ID();
                }
                if ((cd = MCostDetail.getShipment(as, sLine.getM_Product_ID(), M_AttributeSetInstance_ID, M_InOutLine_ID, 0, this.get_TrxName())) != null) {
                    M_CostDetail_ID = cd.getM_CostDetail_ID();
                } else {
                    MCostHistory history = MCostHistory.get(this.getCtx(), this.getAD_Client_ID(), AD_Org_ID, sLine.getM_Product_ID(), as.getM_CostType_ID(), as.getC_AcctSchema_ID(), ce.getCostingMethod(), ce.getM_CostElement_ID(), M_AttributeSetInstance_ID, dateAcct, this.get_TrxName());
                    if (history != null) {
                        M_CostDetail_ID = history.getM_CostDetail_ID();
                    }
                }
                if (M_CostDetail_ID > 0) {
                    MCostDetail.periodClosedCheckForDocsAfterBackDateTrx(this.getAD_Client_ID(), as.getC_AcctSchema_ID(), sLine.getM_Product_ID(), M_CostDetail_ID, dateAcct, this.get_TrxName());
                }
            }
            ++n2;
        }
        return true;
    }

    public record MatchingRecord(int M_InOut_ID, String documentNo, Timestamp documentDate, String businessPartnerName, int C_BPartner_ID, int line, int M_InOutLine_ID, String productName, int M_Product_ID, BigDecimal movementQty, BigDecimal matchedQty, String organizationName, int AD_Org_ID) {
    }
}

