/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MProcessPara;
import org.compiere.model.MProduct;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.Env;

@Process
public class ProductUOMConvert
extends SvrProcess {
    private int p_M_Product_ID = 0;
    private int p_M_Product_To_ID = 0;
    private int p_M_Locator_ID = 0;
    private BigDecimal p_Qty = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Product_ID")) {
                    this.p_M_Product_ID = para[i].getParameterAsInt();
                } else if (name.equals("M_Product_To_ID")) {
                    this.p_M_Product_To_ID = para[i].getParameterAsInt();
                } else if (name.equals("M_Locator_ID")) {
                    this.p_M_Locator_ID = para[i].getParameterAsInt();
                } else if (name.equals("Qty")) {
                    this.p_Qty = (BigDecimal)para[i].getParameter();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        BigDecimal qtyTo6;
        if (this.p_M_Product_ID == 0 || this.p_M_Product_To_ID == 0 || this.p_M_Locator_ID == 0 || this.p_Qty == null || Env.ZERO.compareTo(this.p_Qty) == 0) {
            throw new AdempiereUserError("Invalid Parameter");
        }
        MProduct product = MProduct.get((Properties)this.getCtx(), (int)this.p_M_Product_ID);
        MProduct productTo = MProduct.get((Properties)this.getCtx(), (int)this.p_M_Product_To_ID);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Product=" + String.valueOf(product) + ", ProductTo=" + String.valueOf(productTo) + ", M_Locator_ID=" + this.p_M_Locator_ID + ", Qty=" + String.valueOf(this.p_Qty));
        }
        MUOMConversion[] conversions = MUOMConversion.getProductConversions((Properties)this.getCtx(), (int)product.getM_Product_ID());
        MUOMConversion conversion = null;
        int i = 0;
        while (i < conversions.length) {
            if (conversions[i].getC_UOM_To_ID() == productTo.getC_UOM_ID()) {
                conversion = conversions[i];
            }
            ++i;
        }
        if (conversion == null) {
            throw new AdempiereUserError("@NotFound@: @C_UOM_Conversion_ID@");
        }
        MUOM uomTo = MUOM.get((Properties)this.getCtx(), (int)productTo.getC_UOM_ID());
        BigDecimal qtyTo = this.p_Qty.divide(conversion.getDivideRate(), uomTo.getStdPrecision(), RoundingMode.HALF_UP);
        if (qtyTo.compareTo(qtyTo6 = this.p_Qty.divide(conversion.getDivideRate(), 6, RoundingMode.HALF_UP)) != 0) {
            throw new AdempiereUserError("@StdPrecision@: " + String.valueOf(qtyTo) + " <> " + String.valueOf(qtyTo6) + " (" + String.valueOf(this.p_Qty) + "/" + String.valueOf(conversion.getDivideRate()) + ")");
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(String.valueOf(conversion) + " -> " + String.valueOf(qtyTo));
        }
        return "Not completed yet";
    }
}

