/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.util.List;
import java.util.StringTokenizer;
import org.adempiere.base.ColumnCalloutManager;
import org.adempiere.base.Core;
import org.adempiere.base.IColumnCallout;
import org.adempiere.model.CalloutInfoWindow;
import org.compiere.Adempiere;
import org.compiere.model.Callout;
import org.compiere.model.MColumn;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.idempiere.test.AbstractTestCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CalloutTest
extends AbstractTestCase {
    @Test
    public void testAnnotatedCallout() {
        List callouts = ColumnCalloutManager.findCallout((String)"AD_InfoWindow", (String)"AD_Table_ID");
        Assertions.assertNotNull((Object)callouts, (String)"Null column callouts for AD_InfoWindow.AD_Table_ID");
        Assertions.assertTrue((callouts.size() > 0 ? 1 : 0) != 0, (String)"Empty column callouts for AD_InfoWindow.AD_Table_ID");
        int found = 0;
        for (IColumnCallout callout : callouts) {
            if (!(callout instanceof CalloutInfoWindow)) continue;
            ++found;
        }
        Assertions.assertTrue((found == 1 ? 1 : 0) != 0, (String)(CalloutInfoWindow.class.getName() + " not found for AD_InfoWindow.AD_Table_ID"));
        callouts = ColumnCalloutManager.findCallout((String)"AD_InfoColumn", (String)"AD_Element_ID");
        Assertions.assertNotNull((Object)callouts, (String)"Null column callouts for AD_InfoColumn.AD_Element_ID");
        Assertions.assertTrue((callouts.size() > 0 ? 1 : 0) != 0, (String)"Empty column callouts for AD_InfoColumn.AD_Element_ID");
        found = 0;
        for (IColumnCallout callout : callouts) {
            if (!(callout instanceof CalloutInfoWindow)) continue;
            ++found;
        }
        Assertions.assertTrue((found == 1 ? 1 : 0) != 0, (String)(CalloutInfoWindow.class.getName() + " not found for AD_InfoColumn.AD_Element_ID"));
        callouts = ColumnCalloutManager.findCallout((String)"AD_InfoColumn", (String)"AD_Reference_ID");
        Assertions.assertNotNull((Object)callouts, (String)"Null column callouts for AD_InfoColumn.AD_Reference_ID");
        Assertions.assertTrue((callouts.size() > 0 ? 1 : 0) != 0, (String)"Empty column callouts for AD_InfoColumn.AD_Reference_ID");
        found = 0;
        for (IColumnCallout callout : callouts) {
            if (!(callout instanceof CalloutInfoWindow)) continue;
            ++found;
        }
        Assertions.assertTrue((found == 1 ? 1 : 0) != 0, (String)(CalloutInfoWindow.class.getName() + " not found for AD_InfoColumn.AD_Reference_ID"));
        String calloutClass = "org.adempiere.base.callout.CostAdjustmentLineASI";
        callouts = ColumnCalloutManager.findCallout((String)"M_InventoryLine", (String)"M_AttributeSetInstance_ID");
        Assertions.assertNotNull((Object)callouts, (String)"Null column callouts for M_InventoryLine.M_AttributeSetInstance_ID");
        Assertions.assertTrue((callouts.size() > 0 ? 1 : 0) != 0, (String)"Empty column callouts for M_InventoryLine.M_AttributeSetInstance_ID");
        found = 0;
        for (IColumnCallout callout : callouts) {
            if (!callout.getClass().getName().equals(calloutClass)) continue;
            ++found;
        }
        Assertions.assertTrue((found == 1 ? 1 : 0) != 0, (String)(calloutClass + " not found for M_InventoryLine.M_AttributeSetInstance_ID"));
        calloutClass = "org.adempiere.base.callout.CostAdjustmentLineProduct";
        callouts = ColumnCalloutManager.findCallout((String)"M_InventoryLine", (String)"M_Product_ID");
        Assertions.assertNotNull((Object)callouts, (String)"Null column callouts for M_InventoryLine.M_Product_ID");
        Assertions.assertTrue((callouts.size() > 0 ? 1 : 0) != 0, (String)"Empty column callouts for M_InventoryLine.M_Product_ID");
        found = 0;
        for (IColumnCallout callout : callouts) {
            if (!callout.getClass().getName().equals(calloutClass)) continue;
            ++found;
        }
        Assertions.assertTrue((found == 1 ? 1 : 0) != 0, (String)(calloutClass + " not found for M_InventoryLine.M_Product_ID"));
        calloutClass = "org.adempiere.base.callout.CostAdjustmentLineProduct";
        callouts = ColumnCalloutManager.findCallout((String)"M_InventoryLine", (String)"M_AttributeSetInstance_ID");
        Assertions.assertNotNull((Object)callouts, (String)"Null column callouts for M_InventoryLine.M_AttributeSetInstance_ID");
        Assertions.assertTrue((callouts.size() > 0 ? 1 : 0) != 0, (String)"Empty column callouts for M_InventoryLine.M_AttributeSetInstance_ID");
        found = 0;
        for (IColumnCallout callout : callouts) {
            if (!callout.getClass().getName().equals(calloutClass)) continue;
            ++found;
        }
        Assertions.assertTrue((found == 0 ? 1 : 0) != 0, (String)(calloutClass + " found for M_InventoryLine.M_AttributeSetInstance_ID"));
        calloutClass = "org.adempiere.model.CalloutBPartnerQuickEntry";
        callouts = ColumnCalloutManager.findCallout((String)"C_BPartner", (String)"C_BPartner_ID");
        Assertions.assertNotNull((Object)callouts, (String)"Null column callouts for C_BPartner.C_BPartner_ID");
        Assertions.assertTrue((callouts.size() > 0 ? 1 : 0) != 0, (String)"Empty column callouts for C_BPartner.C_BPartner_ID");
        found = 0;
        for (IColumnCallout callout : callouts) {
            if (!callout.getClass().getName().equals(calloutClass)) continue;
            ++found;
        }
        Assertions.assertTrue((found == 1 ? 1 : 0) != 0, (String)(calloutClass + " not found for C_BPartner.Name"));
    }

    @Test
    public void testCoreCalloutMapping() {
        Query query = new Query(Env.getCtx(), "AD_Column", "AD_Column.IsActive='Y' AND AD_Column.AD_Column_ID < 1000000 AND AD_Table.IsActive='Y' AND AD_Table.AD_Table_ID < 1000000 AND AD_Column.Callout IS NOT NULL ", this.getTrxName());
        query.addJoinClause("JOIN AD_Table ON (AD_Column.AD_Table_ID=AD_Table.AD_Table_ID)");
        query.addJoinClause("JOIN AD_Tab ON (AD_Table.AD_Table_ID=AD_Tab.AD_Table_ID AND AD_Tab.IsActive='Y' AND AD_Tab.AD_Tab_ID<1000000)");
        query.addJoinClause("JOIN AD_Window ON (AD_Tab.AD_Window_ID=AD_Window.AD_Window_ID AND AD_Window.IsActive='Y' AND AD_Window.AD_Window_ID<1000000)");
        query.addJoinClause("JOIN AD_Menu ON (AD_Window.AD_Window_ID=AD_Menu.AD_Window_ID AND AD_Menu.IsActive='Y' AND AD_Menu.AD_Menu_ID<1000000)");
        List columns = query.list();
        ClassLoader baseClassLoader = Adempiere.class.getClassLoader();
        int calloutCount = 0;
        for (MColumn column : columns) {
            StringTokenizer st = new StringTokenizer(column.getCallout(), ";,", false);
            while (st.hasMoreTokens()) {
                String cmd = st.nextToken().trim();
                if (cmd.toLowerCase().startsWith("@script:")) continue;
                int methodStart = cmd.lastIndexOf(46);
                try {
                    String method;
                    if (methodStart == -1) continue;
                    String className = cmd.substring(0, methodStart);
                    Callout callout = Core.getCallout((String)className, (String)(method = cmd.substring(methodStart + 1)));
                    if (callout == null) {
                        Class<?> cClass = baseClassLoader.loadClass(className);
                        callout = (Callout)cClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    Assertions.assertNotNull((Object)callout, (String)("Can't get callout " + cmd + " for " + String.valueOf(column.getAD_Table()) + " " + String.valueOf(column)));
                    ++calloutCount;
                }
                catch (Exception e) {
                    Assertions.fail((String)("Can't get callout " + cmd + " for " + String.valueOf(column.getAD_Table()) + " " + String.valueOf(column)), (Throwable)e);
                }
            }
        }
        Assertions.assertTrue((calloutCount > 0 ? 1 : 0) != 0, (String)"Zero callout loaded");
    }
}

