/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionLine;
import org.compiere.model.MRole;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.ValueNamePair;

public class PaySelect {
    protected int m_WindowNo = 0;
    protected DecimalFormat m_format = DisplayType.getNumberFormat((int)12);
    private BigDecimal m_bankBalance = Env.ZERO;
    private String m_sql;
    protected int m_noSelected = 0;
    private int m_AD_Client_ID = 0;
    protected boolean m_isLocked = false;
    protected MPaySelection m_ps = null;
    protected boolean m_isOnePaymentPerInvoice = false;
    protected static final CLogger log = CLogger.getCLogger(PaySelect.class);

    public ArrayList<BankInfo> getBankAccountData() {
        ArrayList<BankInfo> data;
        block6: {
            data = new ArrayList<BankInfo>();
            this.m_AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
            String sql = MRole.getDefault().addAccessSQL("SELECT ba.C_BankAccount_ID,b.Name || ' ' || ba.AccountNo AS Name,ba.C_Currency_ID, c.ISO_Code,ba.CurrentBalance FROM C_Bank b, C_BankAccount ba, C_Currency c WHERE b.C_Bank_ID=ba.C_Bank_ID AND ba.C_Currency_ID=c.C_Currency_ID AND ba.IsActive='Y'  AND EXISTS (SELECT * FROM C_BankAccountDoc d WHERE d.C_BankAccount_ID=ba.C_BankAccount_ID AND d.IsActive='Y' ) ORDER BY 2", "b", true, true);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        boolean transfers = false;
                        BankInfo bi = new BankInfo(rs.getInt(1), rs.getInt(3), rs.getString(2), rs.getString(4), rs.getBigDecimal(5), transfers);
                        data.add(bi);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    public ArrayList<KeyNamePair> getBPartnerData() {
        ArrayList<KeyNamePair> data;
        block6: {
            data = new ArrayList<KeyNamePair>();
            KeyNamePair pp = new KeyNamePair(0, "");
            data.add(pp);
            String sql = MRole.getDefault().addAccessSQL("SELECT bp.C_BPartner_ID, bp.Name FROM C_BPartner bp", "bp", true, false) + " AND EXISTS (SELECT * FROM C_Invoice i WHERE bp.C_BPartner_ID=i.C_BPartner_ID AND (i.IsSOTrx='N' OR (i.IsSOTrx='Y' AND i.PaymentRule='D')) AND i.IsPaid<>'Y') ORDER BY 2";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                        data.add(pp);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    public ArrayList<KeyNamePair> getDocTypeData() {
        ArrayList<KeyNamePair> data;
        block6: {
            data = new ArrayList<KeyNamePair>();
            String sql = null;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    sql = MRole.getDefault().addAccessSQL("SELECT doc.c_doctype_id,doc.name FROM c_doctype doc WHERE doc.ad_client_id = ? AND doc.docbasetype in ('API','APC','ARI','ARC') ORDER BY 2", "doc", true, false);
                    KeyNamePair dt = new KeyNamePair(0, "");
                    data.add(dt);
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, this.m_AD_Client_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        dt = new KeyNamePair(rs.getInt(1), rs.getString(2));
                        data.add(dt);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    public void prepareTable(IMiniTable miniTable) {
        Properties ctx = Env.getCtx();
        this.m_sql = miniTable.prepareTable(new ColumnInfo[]{new ColumnInfo(" ", "i.C_Invoice_ID", IDColumn.class, false, false, null), new ColumnInfo(Msg.translate((Properties)ctx, (String)"DueDate"), "i.DueDate AS DateDue", Timestamp.class, true, true, null), new ColumnInfo(Msg.translate((Properties)ctx, (String)"C_BPartner_ID"), "bp.Name", KeyNamePair.class, true, false, "i.C_BPartner_ID"), new ColumnInfo(Msg.translate((Properties)ctx, (String)"DocumentNo"), "i.DocumentNo", String.class), new ColumnInfo(Msg.translate((Properties)ctx, (String)"C_Currency_ID"), "c.ISO_Code", KeyNamePair.class, true, false, "i.C_Currency_ID"), new ColumnInfo(Msg.translate((Properties)ctx, (String)"GrandTotal"), "i.GrandTotal", BigDecimal.class), new ColumnInfo(Msg.translate((Properties)ctx, (String)"DiscountAmt"), "currencyConvert(invoiceDiscount(i.C_Invoice_ID,?,i.C_InvoicePaySchedule_ID),i.C_Currency_ID, ?,?,i.C_ConversionType_ID, i.AD_Client_ID,i.AD_Org_ID)", BigDecimal.class), new ColumnInfo(Msg.translate((Properties)ctx, (String)"WriteOffAmt"), "currencyConvert(invoiceWriteOff(i.C_Invoice_ID),i.C_Currency_ID, ?,?,i.C_ConversionType_ID, i.AD_Client_ID,i.AD_Org_ID)", BigDecimal.class), new ColumnInfo(Msg.getMsg((Properties)ctx, (String)"DiscountDate"), "COALESCE((SELECT discountdate from C_InvoicePaySchedule ips WHERE ips.C_InvoicePaySchedule_ID=i.C_InvoicePaySchedule_ID),i.DateInvoiced+p.DiscountDays+p.GraceDays) AS DiscountDate", Timestamp.class), new ColumnInfo(Msg.getMsg((Properties)ctx, (String)"AmountDue"), "currencyConvertInvoice(i.C_Invoice_ID,?,invoiceOpen(i.C_Invoice_ID,i.C_InvoicePaySchedule_ID),?) AS AmountDue", BigDecimal.class), new ColumnInfo(Msg.getMsg((Properties)ctx, (String)"AmountPay"), "currencyConvertInvoice(i.C_Invoice_ID,?,invoiceOpen(i.C_Invoice_ID,i.C_InvoicePaySchedule_ID)-invoiceDiscount(i.C_Invoice_ID,?,i.C_InvoicePaySchedule_ID),?) AS AmountPay", BigDecimal.class)}, "C_Invoice_v i INNER JOIN C_BPartner bp ON (i.C_BPartner_ID=bp.C_BPartner_ID) INNER JOIN C_Currency c ON (i.C_Currency_ID=c.C_Currency_ID) INNER JOIN C_PaymentTerm p ON (i.C_PaymentTerm_ID=p.C_PaymentTerm_ID)", "i.IsSOTrx=? AND IsPaid='N' AND invoiceOpenToDate(i.C_Invoice_ID, i.C_InvoicePaySchedule_ID, SysDate) != 0 AND (i.C_InvoicePaySchedule_ID > 0 OR NOT EXISTS (SELECT * FROM C_PaySelectionLine psl INNER JOIN C_PaySelectionCheck psc ON (psl.C_PaySelectionCheck_ID=psc.C_PaySelectionCheck_ID) LEFT OUTER JOIN C_Payment pmt ON (pmt.C_Payment_ID=psc.C_Payment_ID) WHERE i.C_Invoice_ID=psl.C_Invoice_ID AND psl.IsActive='Y' AND (pmt.DocStatus IS NULL OR pmt.DocStatus NOT IN ('VO','RE')) )) AND i.DocStatus IN ('CO','CL') AND i.AD_Client_ID=?", true, "i");
    }

    public ArrayList<ValueNamePair> getPaymentRuleData(BankInfo bi) {
        ArrayList<ValueNamePair> data;
        block7: {
            if (bi == null) {
                return null;
            }
            this.m_bankBalance = bi.Balance;
            data = new ArrayList<ValueNamePair>();
            int AD_Reference_ID = 195;
            Language language = Env.getLanguage((Properties)Env.getCtx());
            MLookupInfo info = MLookupFactory.getLookup_List((Language)language, (int)AD_Reference_ID);
            String sql = info.Query.substring(0, info.Query.indexOf(" ORDER BY")) + " AND " + info.KeyColumn + " IN (SELECT PaymentRule FROM C_BankAccountDoc WHERE C_BankAccount_ID=? AND IsActive='Y') " + info.Query.substring(info.Query.indexOf(" ORDER BY"));
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, bi.C_BankAccount_ID);
                    rs = pstmt.executeQuery();
                    ValueNamePair vp = null;
                    while (rs.next()) {
                        vp = new ValueNamePair(rs.getString(2), rs.getString(3));
                        data.add(vp);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    public void loadTableInfo(BankInfo bi, Timestamp payDate, ValueNamePair paymentRule, boolean onlyDue, boolean onlyPositiveBalance, KeyNamePair bpartner, KeyNamePair docType, IMiniTable miniTable) {
        KeyNamePair dt;
        int c_doctype_id;
        KeyNamePair pp;
        int C_BPartner_ID;
        if (this.m_sql == null || paymentRule == null) {
            return;
        }
        Object sql = this.m_sql;
        String isSOTrx = "N";
        if (paymentRule != null && "D".equals(paymentRule.getValue())) {
            isSOTrx = "Y";
            sql = (String)sql + " AND i.PaymentRule='D'";
        }
        if (onlyDue) {
            sql = (String)sql + " AND i.DueDate <= ?";
        }
        if ((C_BPartner_ID = (pp = bpartner).getKey()) != 0) {
            sql = (String)sql + " AND i.C_BPartner_ID=?";
        }
        if ((c_doctype_id = (dt = docType).getKey()) != 0) {
            sql = (String)sql + " AND i.c_doctype_id =?";
        }
        if (onlyPositiveBalance) {
            int innerindex = ((String)sql).indexOf("INNER");
            String subWhereClause = ((String)sql).substring(innerindex, ((String)sql).length());
            subWhereClause = subWhereClause.replaceAll("\\bi\\b", "i1");
            subWhereClause = subWhereClause.replaceAll("\\bbp\\b", "bp1");
            subWhereClause = subWhereClause.replaceAll("\\bc\\b", "c1");
            subWhereClause = subWhereClause.replaceAll("\\bp\\b", "p1");
            subWhereClause = subWhereClause.replaceAll("\\bpsl\\b", "psl1");
            subWhereClause = subWhereClause.replaceAll("\\bpsc\\b", "psc1");
            subWhereClause = subWhereClause.replaceAll("\\bpmt\\b", "pmt1");
            sql = (String)sql + " AND i.c_bpartner_id NOT IN ( SELECT i1.C_BPartner_ID FROM C_Invoice_v i1 " + subWhereClause + " GROUP BY i1.C_BPartner_ID HAVING sum(invoiceOpen(i1.C_Invoice_ID, i1.C_InvoicePaySchedule_ID)) <= 0) ";
        }
        sql = (String)sql + " ORDER BY 2,3";
        if (log.isLoggable(Level.FINEST)) {
            log.finest((String)sql + " - C_Currency_ID=" + bi.C_Currency_ID + ", C_BPartner_ID=" + C_BPartner_ID + ", C_doctype_id=" + c_doctype_id);
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                int index = 1;
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setTimestamp(index++, payDate);
                pstmt.setInt(index++, bi.C_Currency_ID);
                pstmt.setTimestamp(index++, payDate);
                pstmt.setInt(index++, bi.C_Currency_ID);
                pstmt.setTimestamp(index++, payDate);
                pstmt.setInt(index++, bi.C_Currency_ID);
                pstmt.setTimestamp(index++, payDate);
                pstmt.setInt(index++, bi.C_Currency_ID);
                pstmt.setTimestamp(index++, payDate);
                pstmt.setTimestamp(index++, payDate);
                pstmt.setString(index++, isSOTrx);
                pstmt.setInt(index++, this.m_AD_Client_ID);
                if (onlyDue) {
                    pstmt.setTimestamp(index++, payDate);
                }
                if (C_BPartner_ID != 0) {
                    pstmt.setInt(index++, C_BPartner_ID);
                }
                if (c_doctype_id != 0) {
                    pstmt.setInt(index++, c_doctype_id);
                }
                if (onlyPositiveBalance) {
                    pstmt.setString(index++, isSOTrx);
                    pstmt.setInt(index++, this.m_AD_Client_ID);
                    if (onlyDue) {
                        pstmt.setTimestamp(index++, payDate);
                    }
                    if (C_BPartner_ID != 0) {
                        pstmt.setInt(index++, C_BPartner_ID);
                    }
                    if (c_doctype_id != 0) {
                        pstmt.setInt(index++, c_doctype_id);
                    }
                }
                rs = pstmt.executeQuery();
                miniTable.loadTable(rs);
            }
            catch (SQLException e) {
                throw new DBException((Exception)e);
            }
            catch (Exception e) {
                throw new AdempiereException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
    }

    public String calculateSelection(IMiniTable miniTable) {
        this.m_noSelected = 0;
        BigDecimal invoiceAmt = Env.ZERO;
        int rows = miniTable.getRowCount();
        int i = 0;
        while (i < rows) {
            IDColumn id = (IDColumn)miniTable.getValueAt(i, 0);
            if (id.isSelected()) {
                BigDecimal amt = (BigDecimal)miniTable.getValueAt(i, 9);
                if (amt != null) {
                    invoiceAmt = invoiceAmt.add(amt);
                }
                ++this.m_noSelected;
            }
            ++i;
        }
        BigDecimal remaining = this.m_bankBalance.subtract(invoiceAmt);
        StringBuilder info = new StringBuilder();
        info.append(this.m_noSelected).append(" ").append(Msg.getMsg((Properties)Env.getCtx(), (String)"Selected")).append(" - ");
        info.append(this.m_format.format(invoiceAmt)).append(", ");
        info.append(Msg.getMsg((Properties)Env.getCtx(), (String)"Remaining")).append(" ").append(this.m_format.format(remaining));
        return info.toString();
    }

    public String generatePaySelect(IMiniTable miniTable, ValueNamePair paymentRule, Timestamp payDate, BankInfo bi) {
        String trxName = null;
        Trx trx = null;
        try {
            try {
                trxName = Trx.createTrxName((String)"PaySelect");
                trx = Trx.get((String)trxName, (boolean)true);
                trx.setDisplayName(this.getClass().getName() + "_generatePaySelect");
                String PaymentRule = paymentRule.getValue();
                this.m_ps = new MPaySelection(Env.getCtx(), 0, trxName);
                this.m_ps.setName(Msg.getMsg((Properties)Env.getCtx(), (String)"VPaySelect") + " - " + paymentRule.getName() + " - " + String.valueOf(payDate));
                this.m_ps.setPayDate(payDate);
                this.m_ps.setC_BankAccount_ID(bi.C_BankAccount_ID);
                this.m_ps.setIsApproved(true);
                this.m_ps.setIsOnePaymentPerInvoice(this.m_isOnePaymentPerInvoice);
                this.m_ps.saveEx();
                if (log.isLoggable(Level.CONFIG)) {
                    log.config(this.m_ps.toString());
                }
                int rows = miniTable.getRowCount();
                int line = 0;
                int i = 0;
                while (i < rows) {
                    IDColumn id = (IDColumn)miniTable.getValueAt(i, 0);
                    if (id.isSelected()) {
                        MPaySelectionLine psl = new MPaySelectionLine(this.m_ps, line += 10, PaymentRule);
                        int C_Invoice_ID = id.getRecord_ID();
                        BigDecimal OpenAmt = (BigDecimal)miniTable.getValueAt(i, 9);
                        BigDecimal DiscountAmt = (BigDecimal)miniTable.getValueAt(i, 6);
                        BigDecimal WriteOffAmt = (BigDecimal)miniTable.getValueAt(i, 7);
                        BigDecimal PayAmt = (BigDecimal)miniTable.getValueAt(i, 10);
                        boolean isSOTrx = false;
                        if (paymentRule != null && "D".equals(paymentRule.getValue())) {
                            isSOTrx = true;
                        }
                        if (OpenAmt == null || PayAmt == null) {
                            throw new AdempiereSystemError(Msg.getMsg((Properties)Env.getCtx(), (String)"PaymentSelectAmtNull"));
                        }
                        psl.setInvoice(C_Invoice_ID, isSOTrx, OpenAmt, PayAmt, DiscountAmt, WriteOffAmt);
                        psl.saveEx(trxName);
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("C_Invoice_ID=" + C_Invoice_ID + ", PayAmt=" + String.valueOf(PayAmt));
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                if (trx != null) {
                    trx.rollback();
                    trx.close();
                    trx = null;
                }
                this.m_ps = null;
                throw new AdempiereException((Throwable)e);
            }
        }
        finally {
            if (trx != null) {
                trx.commit();
                trx.close();
            }
            if (this.m_ps != null) {
                this.m_ps.set_TrxName(null);
            }
        }
        return null;
    }

    protected BigDecimal getBankBalance() {
        return this.m_bankBalance;
    }

    public static class BankInfo {
        public int C_BankAccount_ID;
        public int C_Currency_ID;
        public String Name;
        public String Currency;
        public BigDecimal Balance;
        public boolean Transfers;

        public BankInfo(int newC_BankAccount_ID, int newC_Currency_ID, String newName, String newCurrency, BigDecimal newBalance, boolean newTransfers) {
            this.C_BankAccount_ID = newC_BankAccount_ID;
            this.C_Currency_ID = newC_Currency_ID;
            this.Name = newName;
            this.Currency = newCurrency;
            this.Balance = newBalance;
        }

        public String toString() {
            return this.Name;
        }
    }
}

