/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.process;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.taskdefs.Zip;
import org.compiere.install.Translation;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.tools.FileUtil;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

@Process
public class TranslationImpExp
extends SvrProcess {
    private String p_ImportOrExport;
    private int p_AD_Client_ID;
    private String p_AD_Language;
    private int p_AD_Table_ID;
    private boolean p_IsOnlyCentralizedData;
    private String p_Folder;
    private String p_FileName;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            String name = para.getParameterName();
            if ("ImportOrExport".equals(name)) {
                this.p_ImportOrExport = para.getParameterAsString();
            } else if ("AD_AllClients_V_ID".equals(name)) {
                this.p_AD_Client_ID = para.getParameterAsInt();
            } else if ("AD_Language".equals(name)) {
                this.p_AD_Language = para.getParameterAsString();
            } else if ("AD_Table_ID".equals(name)) {
                this.p_AD_Table_ID = para.getParameterAsInt();
            } else if ("IsOnlyCentralizedData".equals(name)) {
                this.p_IsOnlyCentralizedData = para.getParameterAsBoolean();
            } else if ("Folder".equals(name)) {
                this.p_Folder = para.getParameterAsString();
            } else if ("FileName".equals(name)) {
                this.p_FileName = para.getParameterAsString();
            } else {
                MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para);
            }
            ++n2;
        }
    }

    @Override
    protected String doIt() throws Exception {
        File tempFolder;
        block29: {
            if (Util.isEmpty(this.p_AD_Language, true)) {
                throw new AdempiereSystemError("@Mandatory@ @AD_Language@");
            }
            if ("import".equals(this.p_ImportOrExport) && Util.isEmpty(this.p_Folder, true) && Util.isEmpty(this.p_FileName, true)) {
                throw new AdempiereSystemError("@Mandatory@ @Folder@ / @FileName@");
            }
            tempFolder = null;
            try {
                if (!Util.isEmpty(this.p_FileName, true) && "import".equals(this.p_ImportOrExport)) {
                    block28: {
                        if (this.p_FileName.startsWith("http://") || this.p_FileName.startsWith("https://")) {
                            String tmpZip = null;
                            try (FileOutputStream fos = null;){
                                try {
                                    URL website = new URL(this.p_FileName);
                                    ReadableByteChannel rbc = Channels.newChannel(website.openStream());
                                    tmpZip = FileUtil.getTempMailName(this.p_AD_Language, ".zip");
                                    fos = new FileOutputStream(tmpZip);
                                    fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                                    this.p_FileName = tmpZip;
                                    break block28;
                                }
                                catch (Exception e) {
                                    throw new AdempiereSystemError("Could not download " + this.p_FileName + " -> " + e.getLocalizedMessage());
                                }
                            }
                        }
                        if (!this.p_FileName.toLowerCase().endsWith(".zip")) {
                            throw new AdempiereSystemError("@FileMustBeZIP@");
                        }
                    }
                    tempFolder = this.createTempFolder(this.p_AD_Language);
                    this.unZipLangFile(this.p_FileName, this.p_AD_Language, tempFolder);
                    this.p_Folder = tempFolder.getAbsolutePath();
                } else if (Util.isEmpty(this.p_Folder)) {
                    tempFolder = this.createTempFolder(this.p_AD_Language);
                    this.p_Folder = tempFolder.getAbsolutePath();
                }
                Translation translation = new Translation(Env.getCtx());
                String msg = translation.validateLanguage(this.p_AD_Language, this.get_TrxName());
                if (msg.length() > 0) {
                    throw new AdempiereSystemError(msg);
                }
                StringBuilder whereClause = new StringBuilder("TableName LIKE '%_Trl' AND TableName<>'AD_Column_Trl'");
                if (this.p_AD_Table_ID > 0) {
                    whereClause.append(" AND AD_Table_ID=?");
                }
                Query query = new Query(this.getCtx(), "AD_Table", whereClause.toString(), this.get_TrxName()).setOnlyActiveRecords(true).setOrderBy("TableName");
                if (this.p_AD_Table_ID > 0) {
                    query.setParameters(this.p_AD_Table_ID);
                }
                List tables = query.list();
                for (MTable table2 : tables) {
                    String msgProc;
                    String tableName = table2.getTableName();
                    if ("import".equals(this.p_ImportOrExport)) {
                        this.statusUpdate(Msg.parseTranslation(this.getCtx(), "@Import@ " + tableName + " ..."));
                        msgProc = translation.importTrl(this.p_Folder, this.p_AD_Client_ID, this.p_AD_Language, tableName, this.get_TrxName());
                    } else {
                        this.statusUpdate(Msg.parseTranslation(this.getCtx(), "@Export@ " + tableName + " ..."));
                        msgProc = translation.exportTrl(this.p_Folder, this.p_AD_Client_ID, this.p_AD_Language, tableName, this.p_IsOnlyCentralizedData);
                    }
                    this.addLog(tableName + " " + msgProc);
                }
                if ("import".equals(this.p_ImportOrExport) || tempFolder == null) break block29;
                File destZipFile = null;
                try {
                    destZipFile = File.createTempFile(this.p_AD_Language + "_trlExport_", ".zip");
                }
                catch (Throwable e) {
                    throw new AdempiereException("Unable to create temp file", e);
                }
                destZipFile.delete();
                Zip zipper = new Zip();
                zipper.setDestFile(destZipFile);
                zipper.setBasedir(tempFolder);
                zipper.setUpdate(false);
                zipper.setCompress(true);
                zipper.setCaseSensitive(false);
                zipper.setFilesonly(true);
                zipper.setTaskName("zip");
                zipper.setTaskType("zip");
                zipper.setProject(new Project());
                zipper.setOwningTarget(new Target());
                zipper.execute();
                this.processUI.download(destZipFile);
            }
            catch (Throwable throwable) {
                if (tempFolder != null) {
                    try {
                        FileUtil.deleteFolderRecursive(tempFolder);
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
        }
        if (tempFolder != null) {
            try {
                FileUtil.deleteFolderRecursive(tempFolder);
            }
            catch (IOException iOException) {}
        }
        return "@OK@";
    }

    private File createTempFolder(String language) {
        File tmpFolder;
        try {
            tmpFolder = Files.createTempDirectory(language, new FileAttribute[0]).toFile();
        }
        catch (IOException e1) {
            throw new AdempiereException("Problem creating temp folder", e1);
        }
        return tmpFolder;
    }

    private void unZipLangFile(String fileName, String language, File folder) throws AdempiereException {
        String suffix = "_" + language + ".xml";
        ZipFile zipFile = null;
        boolean validfile = false;
        try {
            try {
                zipFile = new ZipFile(fileName);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    File outFile;
                    String prefixFolderLang;
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory()) {
                        this.addLog("Imported zip must not contain folders, ignored folder" + entry.getName());
                        continue;
                    }
                    if (!entry.getName().endsWith(suffix)) {
                        this.addLog("Ignored file " + entry.getName());
                        continue;
                    }
                    String outName = entry.getName();
                    if (outName.startsWith(prefixFolderLang = language + File.separator)) {
                        outName = outName.substring(prefixFolderLang.length());
                    }
                    if (!(outFile = new File(folder.getPath(), outName)).toPath().normalize().startsWith(folder.toPath())) {
                        this.log.severe("Bad zip entry: " + entry.getName());
                        this.addLog("Bad zip entry: " + entry.getName());
                        continue;
                    }
                    if (this.log.isLoggable(Level.INFO)) {
                        this.log.info("Extracting file: " + entry.getName());
                    }
                    TranslationImpExp.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(outFile)));
                    validfile = true;
                }
            }
            catch (Throwable e) {
                throw new AdempiereException("Uncompress zip failed", e);
            }
        }
        catch (Throwable throwable) {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
        if (!validfile) {
            throw new AdempiereException("ZIP file invalid, doesn't contain *" + suffix + " files");
        }
    }

    public static final void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }
}

