/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.report.jasper;

import java.io.File;
import java.util.ArrayList;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.model.MProcess;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.utils.DigestOfFile;

public class AttachmentResourceLoader {
    private static final CLogger log = CLogger.getCLogger(AttachmentResourceLoader.class);
    private String destinationFolder;
    private MAttachment attachment;
    private static final String ATTACHMENT_PATH_PREFIX = "attachment:";

    public AttachmentResourceLoader(String destinationFolder) {
        this.destinationFolder = destinationFolder;
    }

    public File getReportFile(ProcessInfo processInfo, String reportPath) {
        File reportFile = null;
        String name = reportPath.substring(ATTACHMENT_PATH_PREFIX.length()).trim();
        MProcess process = new MProcess(Env.getCtx(), processInfo.getAD_Process_ID(), processInfo.getTransactionName());
        this.attachment = process.getAttachment();
        if (this.attachment != null) {
            MAttachmentEntry[] entries = this.attachment.getEntries();
            MAttachmentEntry entry = null;
            int i = 0;
            while (i < entries.length) {
                if (entries[i].getName().equals(name)) {
                    entry = entries[i];
                    break;
                }
                ++i;
            }
            if (entry != null) {
                reportFile = this.getAttachmentEntryFile(entry);
            }
        }
        return reportFile;
    }

    private File getAttachmentEntryFile(MAttachmentEntry entry) {
        String localFile = this.destinationFolder + entry.getName();
        String downloadedLocalFile = this.destinationFolder + "TMP_" + entry.getName();
        File reportFile = new File(localFile);
        if (reportFile.exists()) {
            String entryMD5hash;
            String localMD5hash = DigestOfFile.getMD5Hash(reportFile);
            if (localMD5hash.equals(entryMD5hash = DigestOfFile.getMD5Hash(entry.getData()))) {
                log.info(" no need to download: local report is up-to-date");
            } else {
                log.info(" report on server is different from local copy, download and replace");
                File downloadedFile = new File(downloadedLocalFile);
                entry.getFile(downloadedFile);
                if (!reportFile.delete()) {
                    throw new AdempiereException("Cannot delete temporary file " + reportFile.toString());
                }
                if (!downloadedFile.renameTo(reportFile)) {
                    throw new AdempiereException("Cannot rename temporary file " + downloadedFile.toString() + " to " + reportFile.toString());
                }
            }
        } else {
            entry.getFile(reportFile);
        }
        return reportFile;
    }

    private File getAttachmentEntryFile(String resname) {
        File fileattach = null;
        MAttachmentEntry[] entries = this.attachment.getEntries();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getName().equals(resname)) {
                fileattach = this.getAttachmentEntryFile(entries[i]);
                break;
            }
            ++i;
        }
        return fileattach;
    }

    public File getResourceBundle(String bundleName, Language currLang) {
        String resname = bundleName + "_" + currLang.getLocale().getLanguage() + "_" + currLang.getLocale().getCountry() + ".properties";
        File resFile = this.getAttachmentEntryFile(resname);
        if (resFile == null && (resFile = this.getAttachmentEntryFile(resname = bundleName + "_" + currLang.getLocale().getLanguage() + ".properties")) == null) {
            resname = bundleName + ".properties";
            resFile = this.getAttachmentEntryFile(resname);
        }
        return resFile;
    }

    public File[] getSubreports(String reportPath) {
        String name = reportPath.substring(ATTACHMENT_PATH_PREFIX.length()).trim();
        ArrayList<File> subreports = new ArrayList<File>();
        MAttachmentEntry[] entries = this.attachment.getEntries();
        int i = 0;
        while (i < entries.length) {
            File reportFile;
            if (!entries[i].getName().equals(name) && (reportFile = this.getAttachmentEntryFile(entries[i])) != null && (entries[i].getName().toLowerCase().endsWith(".jrxml") || entries[i].getName().toLowerCase().endsWith(".jasper"))) {
                subreports.add(reportFile);
            }
            ++i;
        }
        return subreports.toArray(new File[0]);
    }

    public static boolean isAttachmentResourcePath(String path) {
        return path != null && path.startsWith(ATTACHMENT_PATH_PREFIX);
    }
}

