/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.form.WCreateFromWindow;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.grid.CreateFrom;
import org.compiere.grid.CreateFromRMA;
import org.compiere.model.GridTab;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;

public class WCreateFromRMAUI
extends CreateFromRMA
implements ValueChangeListener {
    private WCreateFromWindow window;
    private int p_WindowNo;
    protected Label bPartnerLabel = new Label();
    protected WEditor bPartnerField;

    public WCreateFromRMAUI(GridTab tab) {
        super(tab);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.getGridTab().toString());
        }
        this.window = new WCreateFromWindow((CreateFrom)this, this.getGridTab().getWindowNo());
        this.p_WindowNo = this.getGridTab().getWindowNo();
        try {
            if (!this.dynInit()) {
                return;
            }
            this.zkInit();
            this.setInitOK(true);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", (Throwable)e);
            this.setInitOK(false);
        }
        AEnv.showWindow(this.window);
    }

    protected boolean dynInit() throws Exception {
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("");
        }
        super.dynInit();
        this.window.setTitle(this.getTitle());
        this.initBPartner(true);
        this.bPartnerField.addValueChangeListener(this);
        this.loadRMA();
        return true;
    }

    protected void zkInit() throws Exception {
        this.bPartnerLabel.setText(Msg.getElement((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        Panel parameterPanel = this.window.getParameterPanel();
        Grid parameterStdLayout = GridFactory.newGridLayout();
        Panel parameterStdPanel = new Panel();
        parameterStdPanel.appendChild((Component)parameterStdLayout);
        parameterPanel.appendChild((Component)parameterStdPanel);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)parameterStdLayout, "min");
        Rows rows = parameterStdLayout.newRows();
        Row row = rows.newRow();
        row.appendChild(this.bPartnerLabel.rightAlign());
        if (this.bPartnerField != null) {
            row.appendChild(this.bPartnerField.getComponent());
        }
        if (ClientInfo.isMobile()) {
            ClientInfo.onClientInfo((Component)this.window, this::onClientInfo);
        }
    }

    @Override
    public void valueChange(ValueChangeEvent e) {
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config(e.getPropertyName() + "=" + String.valueOf(e.getNewValue()));
        }
        if (e.getPropertyName().equals("C_BPartner_ID")) {
            this.loadRMA();
        }
        this.window.tableChanged(null);
    }

    protected void initBPartner(boolean forInvoice) throws Exception {
        int AD_Column_ID = 3499;
        MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)AD_Column_ID, (int)30);
        this.bPartnerField = new WSearchEditor("C_BPartner_ID", true, false, true, (Lookup)lookup);
        int C_BPartner_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"C_BPartner_ID");
        this.bPartnerField.setValue(C_BPartner_ID);
    }

    protected void loadRMA() {
        this.loadTableOIS(this.getRMAData());
    }

    protected void loadTableOIS(Vector<?> data) {
        this.window.getWListbox().clear();
        this.window.getWListbox().getModel().removeTableModelListener(this.window);
        ListModelTable model = new ListModelTable(data);
        model.addTableModelListener(this.window);
        this.window.getWListbox().setData(model, this.getOISColumnNames());
        this.configureMiniTable(this.window.getWListbox());
    }

    public void showWindow() {
        this.window.setVisible(true);
    }

    public void closeWindow() {
        this.window.dispose();
    }

    public Object getWindow() {
        return this.window;
    }

    protected void onClientInfo() {
        ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this.window);
        ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this.window);
        this.window.invalidate();
    }
}

