/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.GenericPO;
import org.compiere.model.MAttachment;
import org.compiere.model.MTable;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class FileUtil {
    public static final String COPYRIGHT = "/******************************************************************************\n * Product: Adempiere ERP & CRM Smart Business Solution                       *\n * Copyright (C) 1999-2007 Adempiere, Inc. All Rights Reserved.               *\n * This program is free software; you can redistribute it and/or modify it    *\n * under the terms version 2 of the GNU General Public License as published   *\n * by the Free Software Foundation. This program is distributed in the hope   *\n * that it will be useful, but WITHOUT ANY WARRANTY; without even the implied *\n * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *\n * See the GNU General Public License for more details.                       *\n * You should have received a copy of the GNU General Public License along    *\n * with this program; if not, write to the Free Software Foundation, Inc.,    *\n * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *\n ******************************************************************************/\n";
    private String m_filterString = null;
    private FileUtilFilter m_filter = new FileUtilFilter();
    private int m_count = 0;
    private int m_actions = 0;
    private int m_actionIndex = -1;
    protected static final String[] ACTIONS = new String[]{"List", "Replace", "Latex", "License"};

    public FileUtil(String file, String filter, String action, String p1, String p2) {
        this(new File(file), filter, action, p1, p2);
    }

    public FileUtil(File file, String filter, String action, String p1, String p2) {
        if (action == null || action.length() == 0) {
            System.err.println("FileUtil: No Action");
        } else if (!this.validAction(action)) {
            System.err.println("FileUtil: Action not valid: " + action + String.valueOf(ACTIONS));
        } else if (file == null) {
            System.err.println("FileUtil: No Input file");
        } else if (!file.exists()) {
            System.err.println("FileUtil: Input file does not exist: " + String.valueOf(file));
        } else {
            System.out.println("FileUtil (" + String.valueOf(file) + ", Filter=" + filter + ", Action=" + action + ")");
            this.m_filterString = filter;
            this.processFile(file, p1, p2);
            System.out.println("FileUtil  Process count = " + this.m_count + "  actions=" + this.m_actions);
        }
    }

    private boolean validAction(String action) {
        int i2 = 0;
        while (i2 < ACTIONS.length) {
            if (ACTIONS[i2].equals(action)) {
                this.m_actionIndex = i2;
                return true;
            }
            ++i2;
        }
        return false;
    }

    private void processFile(File file, String p1, String p2) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] dirFiles = file.listFiles(this.m_filter);
            int i2 = 0;
            while (i2 < dirFiles.length) {
                this.processFile(dirFiles[i2], p1, p2);
                ++i2;
            }
        } else {
            System.out.println(" ProcessFile=" + file.getAbsolutePath());
            ++this.m_count;
            this.processFileAction(file, p1, p2);
        }
    }

    void processFileAction(File file, String p1, String p2) {
        try {
            if (this.m_actionIndex != 0) {
                if (this.m_actionIndex == 1) {
                    this.replaceString(file, p1, p2);
                } else if (this.m_actionIndex == 2) {
                    this.latex(file);
                } else if (this.m_actionIndex == 3) {
                    this.license(file);
                }
            }
        }
        catch (Exception exception) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void replaceString(File file, String from, String to) throws IOException {
        boolean found;
        File tmpFile;
        String fileName;
        block19: {
            fileName = file.getAbsolutePath();
            tmpFile = new File(fileName + ".tmp");
            found = false;
            Throwable throwable = null;
            Object var8_9 = null;
            try {
                BufferedReader in = new BufferedReader(new FileReader(file));
                try {
                    try (BufferedWriter out = new BufferedWriter(new FileWriter(tmpFile, false));){
                        String line = null;
                        int lineNo = 0;
                        while ((line = in.readLine()) != null) {
                            ++lineNo;
                            if (line.indexOf(from) != -1) {
                                found = true;
                                System.out.println("  " + lineNo + ": " + line);
                                line = Util.replace(line, from, to);
                                ++this.m_actions;
                            }
                            out.write(line);
                            out.newLine();
                        }
                    }
                    if (in == null) break block19;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                in.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        if (!found) {
            if (tmpFile.delete()) return;
            System.err.println(" - Temp file not deleted - " + tmpFile.getAbsolutePath());
            return;
        }
        File oldFile = new File(fileName + ".old");
        if (!file.renameTo(oldFile)) {
            System.err.println(" - Old File not renamed - " + fileName);
            return;
        }
        if (!tmpFile.renameTo(new File(fileName))) {
            System.err.println(" - New File not renamed - " + fileName);
            return;
        }
        if (oldFile.delete()) {
            System.out.println(" - File updated: " + fileName);
            return;
        }
        System.err.println(" - Old File not deleted - " + fileName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void latex(File file) throws IOException {
        int lineNo;
        String fileName;
        block21: {
            fileName = file.getAbsolutePath();
            File outFile = new File(fileName + ".txt");
            lineNo = 0;
            Throwable throwable = null;
            Object var6_7 = null;
            try {
                BufferedReader in = new BufferedReader(new FileReader(file));
                try {
                    try (BufferedWriter out = new BufferedWriter(new FileWriter(outFile, false));){
                        String line = null;
                        block7: while ((line = in.readLine()) != null) {
                            ++lineNo;
                            boolean ignore = false;
                            char[] inLine = line.toCharArray();
                            StringBuilder sb = new StringBuilder();
                            int i2 = 0;
                            while (true) {
                                if (i2 >= inLine.length) {
                                    out.write(sb.toString());
                                    out.newLine();
                                    continue block7;
                                }
                                char c = inLine[i2];
                                if (c == '\\') {
                                    ignore = true;
                                } else if (c == '{') {
                                    ignore = false;
                                } else if (c != '}' && !ignore) {
                                    sb.append(c);
                                }
                                ++i2;
                            }
                        }
                    }
                    if (in == null) break block21;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                in.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        System.out.println("File " + fileName + " - lines=" + lineNo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void license(File file) throws IOException {
        boolean found;
        File tmpFile;
        String fileName;
        block18: {
            fileName = file.getAbsolutePath();
            tmpFile = new File(fileName + ".tmp");
            boolean isJava = fileName.endsWith(".java");
            found = false;
            Throwable throwable = null;
            Object var7_8 = null;
            try {
                BufferedReader in = new BufferedReader(new FileReader(file));
                try {
                    try (BufferedWriter out = new BufferedWriter(new FileWriter(tmpFile, false));){
                        out.write(COPYRIGHT);
                        String line = null;
                        while ((line = in.readLine()) != null) {
                            if (!found && line.startsWith("package ") && isJava) {
                                found = true;
                            }
                            if (!found) continue;
                            out.write(line);
                            out.newLine();
                        }
                    }
                    if (in == null) break block18;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                in.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        if (!found) {
            System.err.println(" - No Copyright - " + fileName);
            if (tmpFile.delete()) return;
            System.err.println(" - Temp file not deleted - " + tmpFile.getAbsolutePath());
            return;
        }
        File oldFile = new File(fileName + ".old");
        if (!file.renameTo(oldFile)) {
            System.err.println(" - Old File not renamed - " + fileName);
            return;
        }
        if (tmpFile.renameTo(new File(fileName))) {
            if (oldFile.delete()) return;
            System.err.println(" - Old File not deleted - " + fileName);
            return;
        }
        System.err.println(" - New File not renamed - " + fileName);
    }

    String getFilterString() {
        return this.m_filterString;
    }

    public static void main(String[] args) {
        String directory = "C:\\Adempiere\\adempiere-all2";
        String filter = ".java";
        String action = "Replace";
        String from = "$Id: FileUtil.java,v 1.4 2006/08/03 04:03:22 jjanke Exp $";
        String to = "$Id: FileUtil.java,v 1.4 2006/08/03 04:03:22 jjanke Exp $";
        if (args.length == 1) {
            directory = args[0];
        }
        if (args.length == 2) {
            filter = args[1];
        }
        if (filter == null) {
            filter = "";
        }
        new FileUtil(directory, filter, action, from, to);
    }

    public static String getTempMailName(String subject, String extension) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String dt = sdf.format(cal.getTime());
        String cleanName = subject.replaceAll("[ &/]", "");
        String dir = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "rpttmp_" + dt + "_" + Env.getContext(Env.getCtx(), "#AD_Session_ID") + System.getProperty("file.separator");
        String localFile = dir + cleanName + extension;
        new File(dir).mkdirs();
        return localFile;
    }

    public static String parseTitle(Properties ctx, String title, int table_ID, int record_ID, int m_WindowNo, String trxName) {
        if (title.contains("@") && record_ID > 0 && table_ID > 0) {
            MTable table2 = new MTable(ctx, table_ID, trxName);
            GenericPO po = new GenericPO(table2.getTableName(), ctx, record_ID, trxName);
            title = Env.parseVariable(title, po, trxName, true);
        } else {
            title = Env.parseContext(ctx, m_WindowNo, title, true, true);
        }
        return title;
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        if (Util.isEmpty(prefix)) {
            throw new IllegalArgumentException("Prefix is required");
        }
        prefix = Util.setFilenameCorrect(prefix);
        if (suffix == null) {
            suffix = ".tmp";
        }
        String tmpdirname = FileUtil.getTempFolderName(directory);
        File tmpdir = new File(tmpdirname);
        tmpdir.mkdirs();
        String fileName = prefix + suffix;
        File f = new File(tmpdirname, fileName);
        return f;
    }

    public static String getTempFolderName(File directory) throws IOException {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String dt = sdf.format(cal.getTime());
        Object tmpdirname = directory != null ? directory.getCanonicalPath() : System.getProperty("java.io.tmpdir");
        tmpdirname = (String)tmpdirname + System.getProperty("file.separator") + "rpttmp_" + dt + "_" + Env.getContext(Env.getCtx(), "#AD_Session_ID") + System.getProperty("file.separator");
        return tmpdirname;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return FileUtil.createTempFile(prefix, suffix, null);
    }

    public static File createFile(String fileName) throws IOException {
        if (Util.isEmpty(fileName)) {
            throw new IllegalArgumentException("Name is required");
        }
        File file = null;
        if (fileName.contains(System.getProperty("file.separator"))) {
            file = new File(fileName);
        } else {
            String tmpdirname = FileUtil.getTempFolderName(null);
            File tmpdir = new File(tmpdirname);
            tmpdir.mkdirs();
            file = new File(tmpdirname, fileName);
        }
        return file;
    }

    public static String makePrefix(String name) {
        char[] nameArray;
        StringBuilder prefix = new StringBuilder();
        char[] cArray = nameArray = name.toCharArray();
        int n = nameArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (Character.isLetterOrDigit(ch)) {
                prefix.append(ch);
            } else {
                prefix.append("_");
            }
            ++n2;
        }
        return prefix.toString();
    }

    public static boolean deleteFolderRecursive(File path) throws FileNotFoundException {
        if (!path.exists()) {
            throw new FileNotFoundException(path.getAbsolutePath());
        }
        boolean ret = true;
        if (path.isDirectory()) {
            File[] fileArray = path.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                ret = ret && FileUtil.deleteFolderRecursive(f);
                ++n2;
            }
        }
        return ret && path.delete();
    }

    public static void copy(MAttachment attachment, File destinationFile, int index) {
        FileOutputStream destinationFileOutputStream = null;
        try {
            try {
                destinationFile.createNewFile();
                destinationFileOutputStream = new FileOutputStream(destinationFile);
                byte[] buffer = attachment.getEntryData(index);
                destinationFileOutputStream.write(buffer);
            }
            catch (FileNotFoundException f) {
                throw new AdempiereException("File not found exception : " + destinationFile.getName() + " : " + String.valueOf(f));
            }
            catch (IOException e) {
                throw new AdempiereException("IOException : " + String.valueOf(e));
            }
        }
        catch (Throwable throwable) {
            try {
                if (destinationFileOutputStream != null) {
                    destinationFileOutputStream.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (destinationFileOutputStream != null) {
                destinationFileOutputStream.close();
            }
        }
        catch (Exception exception) {}
    }

    public static void deleteDirectory(File folder) throws IOException {
        Path directory = folder.toPath();
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    class FileUtilFilter
    implements FilenameFilter {
        FileUtilFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            File file = new File(dir, name);
            if (file.isDirectory()) {
                return true;
            }
            String filterString = FileUtil.this.getFilterString();
            if (filterString == null || filterString.length() == 0) {
                return true;
            }
            if (name == null) {
                return false;
            }
            if (name.indexOf(126) != -1 || name.equals("FileUtil.java")) {
                return false;
            }
            return name.indexOf(filterString) != -1;
        }
    }
}

