/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ecs.filter;

import java.text.StringCharacterIterator;
import java.util.Hashtable;
import org.apache.ecs.Filter;

public class CharacterFilter
extends Hashtable<String, Object>
implements Filter {
    private static final long serialVersionUID = 1425231653286948494L;

    public CharacterFilter() {
        super(4);
        this.addAttribute("\"", "&#34;");
        this.addAttribute("'", "&#8217;");
        this.addAttribute("&", "&#38;");
        this.addAttribute("<", "&#60;");
        this.addAttribute(">", "&#62;");
    }

    @Override
    public String getInfo() {
        return "CharacterFilter";
    }

    @Override
    public Filter addAttribute(String name, Object attribute) {
        this.put(name, attribute);
        return this;
    }

    @Override
    public Filter removeAttribute(String name) {
        try {
            this.remove(name);
        }
        catch (Exception exception) {}
        return this;
    }

    @Override
    public boolean hasAttribute(String key) {
        return this.containsKey(key);
    }

    @Override
    public String process(String to_process) {
        if (to_process == null || to_process.length() == 0) {
            return "";
        }
        StringBuilder bs = new StringBuilder(to_process.length() + 50);
        StringCharacterIterator sci = new StringCharacterIterator(to_process);
        Object tmp = null;
        char c = sci.first();
        while (c != '\uffff') {
            char ii;
            tmp = String.valueOf(c);
            if (this.hasAttribute((String)tmp)) {
                tmp = (String)this.get(tmp);
            }
            if ((ii = c) > '\u00ff') {
                tmp = "&#" + ii + ";";
            }
            bs.append((String)tmp);
            c = sci.next();
        }
        return bs.toString();
    }
}

