/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.model.X_R_MailText;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MMailText
extends X_R_MailText {
    private static final long serialVersionUID = -6458808409321394821L;
    protected MUser m_user = null;
    protected MBPartner m_bpartner = null;
    protected PO m_po = null;
    protected String m_MailHeader = null;
    protected String m_MailText = null;
    protected String m_MailText2 = null;
    protected String m_MailText3 = null;
    protected static CCache<String, MMailTextTrl> s_cacheTrl = new CCache("R_MailText", 20);
    protected String m_language = null;

    public MMailText(Properties ctx, String R_MailText_UU, String trxName) {
        super(ctx, R_MailText_UU, trxName);
    }

    public MMailText(Properties ctx, int R_MailText_ID, String trxName) {
        super(ctx, R_MailText_ID, trxName);
    }

    public MMailText(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getMailText(boolean all) {
        return this.getMailText(all, true);
    }

    public String getMailText(boolean all, boolean parsed) {
        this.translate();
        if (!all) {
            return parsed ? this.parse(this.m_MailText) : this.m_MailText;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.m_MailText);
        String s = this.m_MailText2;
        if (s != null && s.length() > 0) {
            sb.append("\n").append(s);
        }
        if ((s = this.m_MailText3) != null && s.length() > 0) {
            sb.append("\n").append(s);
        }
        return parsed ? this.parse(sb.toString()) : sb.toString();
    }

    @Override
    public String getMailText() {
        this.translate();
        return this.parse(this.m_MailText);
    }

    @Override
    public String getMailText2() {
        this.translate();
        return this.parse(this.m_MailText2);
    }

    @Override
    public String getMailText3() {
        this.translate();
        return this.parse(this.m_MailText3);
    }

    @Override
    public String getMailHeader() {
        return this.getMailHeader(true);
    }

    public String getMailHeader(boolean parsed) {
        this.translate();
        return parsed ? this.parse(this.m_MailHeader) : this.m_MailHeader;
    }

    protected String parse(String text) {
        if (Util.isEmpty(text) || text.indexOf(64) == -1) {
            return text;
        }
        text = this.parse(text, this.m_user);
        text = this.parse(text, this.m_bpartner);
        text = this.parse(text, this.m_po);
        return text;
    }

    protected String parse(String text, PO po) {
        if (po == null || Util.isEmpty(text) || text.indexOf(64) == -1) {
            return text;
        }
        Object inStr = text;
        StringBuilder outStr = new StringBuilder();
        int i = ((String)inStr).indexOf(64);
        while (i != -1) {
            outStr.append(((String)inStr).substring(0, i));
            inStr = ((String)inStr).substring(i + 1, ((String)inStr).length());
            int j = ((String)inStr).indexOf(64);
            if (j < 0) {
                inStr = "@" + (String)inStr;
                break;
            }
            String token = ((String)inStr).substring(0, j);
            outStr.append(this.parseVariable(token, po));
            inStr = ((String)inStr).substring(j + 1, ((String)inStr).length());
            i = ((String)inStr).indexOf(64);
        }
        outStr.append((String)inStr);
        return outStr.toString();
    }

    protected String parseVariable(String variable, PO po) {
        return Env.parseVariable("@" + variable + "@", po, this.get_TrxName(), true, true, true);
    }

    public void setUser(int AD_User_ID) {
        this.m_user = MUser.get(this.getCtx(), AD_User_ID);
    }

    public void setUser(MUser user) {
        this.m_user = user;
    }

    public void setBPartner(int C_BPartner_ID) {
        this.m_bpartner = new MBPartner(this.getCtx(), C_BPartner_ID, this.get_TrxName());
    }

    public void setBPartner(MBPartner bpartner) {
        this.m_bpartner = bpartner;
    }

    public void setPO(PO po) {
        this.m_po = po;
    }

    public void setPO(PO po, boolean analyse) {
        this.m_po = po;
        if (analyse) {
            Object oo;
            int index = po.get_ColumnIndex("C_BPartner_ID");
            if (index > 0 && (oo = po.get_Value(index)) instanceof Integer) {
                int C_BPartner_ID = (Integer)oo;
                this.setBPartner(C_BPartner_ID);
            }
            if ((index = po.get_ColumnIndex("AD_User_ID")) > 0 && (oo = po.get_Value(index)) instanceof Integer) {
                int AD_User_ID = (Integer)oo;
                this.setUser(AD_User_ID);
            }
        }
    }

    protected void translate() {
        this.m_MailHeader = super.getMailHeader();
        this.m_MailText = super.getMailText();
        this.m_MailText2 = super.getMailText2();
        this.m_MailText3 = super.getMailText3();
        if (this.m_bpartner != null && this.m_bpartner.getAD_Language() != null || !Util.isEmpty(this.m_language)) {
            String adLanguage = this.m_bpartner != null && this.m_bpartner.getAD_Language() != null ? this.m_bpartner.getAD_Language() : this.m_language;
            StringBuilder key = new StringBuilder().append(adLanguage).append(this.get_ID());
            MMailTextTrl trl = s_cacheTrl.get(key.toString());
            if (trl == null && (trl = this.getTranslation(adLanguage)) != null) {
                s_cacheTrl.put(key.toString(), trl);
            }
            if (trl != null) {
                this.m_MailHeader = trl.MailHeader;
                this.m_MailText = trl.MailText;
                this.m_MailText2 = trl.MailText2;
                this.m_MailText3 = trl.MailText3;
            }
        }
    }

    protected MMailTextTrl getTranslation(String AD_Language) {
        MMailTextTrl trl;
        block6: {
            trl = null;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            String sql = "SELECT * FROM R_MailText_Trl WHERE R_MailText_ID=? AND AD_Language=?";
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, this.getR_MailText_ID());
                    pstmt.setString(2, AD_Language);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        trl = new MMailTextTrl();
                        trl.AD_Language = rs.getString("AD_Language");
                        trl.MailHeader = rs.getString("MailHeader");
                        trl.MailText = rs.getString("MailText");
                        trl.MailText2 = rs.getString("MailText2");
                        trl.MailText3 = rs.getString("MailText3");
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return trl;
    }

    public void setLanguage(String language) {
        this.m_language = language;
    }

    public PO getPO() {
        return this.m_po;
    }

    public MBPartner getBPartner() {
        return this.m_bpartner;
    }

    public String getLanguage() {
        return this.m_language;
    }

    public MUser getUser() {
        return this.m_user;
    }

    static class MMailTextTrl {
        String AD_Language = null;
        String MailHeader = null;
        String MailText = null;
        String MailText2 = null;
        String MailText3 = null;

        MMailTextTrl() {
        }
    }
}

