/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.i18n;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.felix.webconsole.internal.i18n.CombinedResourceBundle;
import org.apache.felix.webconsole.internal.i18n.ResourceBundleCache;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class ResourceBundleManager
implements BundleListener {
    private final BundleContext bundleContext;
    private final ResourceBundleCache consoleResourceBundleCache;
    private final Map resourceBundleCaches;

    public ResourceBundleManager(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.consoleResourceBundleCache = new ResourceBundleCache(bundleContext.getBundle());
        this.resourceBundleCaches = new HashMap();
        bundleContext.addBundleListener((BundleListener)this);
    }

    public void dispose() {
        this.bundleContext.removeBundleListener((BundleListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceBundle getResourceBundle(Bundle provider, Locale locale) {
        ResourceBundleCache cache;
        ResourceBundle defaultResourceBundle = this.consoleResourceBundleCache.getResourceBundle(locale);
        if (provider == null || provider.equals(this.bundleContext.getBundle())) {
            return defaultResourceBundle;
        }
        Map map = this.resourceBundleCaches;
        synchronized (map) {
            Long key = new Long(provider.getBundleId());
            cache = (ResourceBundleCache)this.resourceBundleCaches.get(key);
            if (cache == null) {
                cache = new ResourceBundleCache(provider);
                this.resourceBundleCaches.put(key, cache);
            }
        }
        ResourceBundle bundleResourceBundle = cache.getResourceBundle(locale);
        return new CombinedResourceBundle(bundleResourceBundle, defaultResourceBundle, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void bundleChanged(BundleEvent event) {
        if (event.getType() == 4) {
            Long key = new Long(event.getBundle().getBundleId());
            Map map = this.resourceBundleCaches;
            synchronized (map) {
                this.resourceBundleCaches.remove(key);
            }
        }
    }
}

