/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.event;

import java.util.List;
import org.zkoss.lang.Generics;
import org.zkoss.util.UploadUtils;
import org.zkoss.util.media.Media;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;

public class UploadEvent
extends Event {
    private final Media[] _meds;

    public UploadEvent(String name, Component target, Media[] meds) {
        super(name, target);
        this._meds = meds != null && meds.length > 0 ? meds : null;
    }

    public final Media getMedia() {
        return this._meds != null ? this._meds[0] : null;
    }

    public final Media[] getMedias() {
        return this._meds;
    }

    public static UploadEvent getLatestUploadEvent(String name, Component component, AuRequest request) {
        Desktop desktop = component.getDesktop();
        String uuid = component.getUuid();
        String sid = String.valueOf(request.getData().getOrDefault("sid", ""));
        String uploadInfoKey = uuid + "." + sid;
        List result = Generics.cast((List)((List)desktop.removeAttribute(uploadInfoKey)));
        if (result == null) {
            throw new UiException("Upload content not found: " + uploadInfoKey);
        }
        return new UploadEvent(name, desktop.getComponentByUuid(uuid), UploadUtils.parseResult((List)result));
    }
}

