/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.format;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import org.zkoss.poi.ss.format.CellFormatPart;
import org.zkoss.poi.ss.format.CellFormatResult;
import org.zkoss.poi.ss.format.CellFormatType;
import org.zkoss.poi.ss.format.CellFormatter;
import org.zkoss.poi.ss.format.CellNumberFormatter;
import org.zkoss.poi.ss.formula.eval.ErrorEval;
import org.zkoss.poi.ss.usermodel.Cell;
import org.zkoss.poi.ss.usermodel.DateUtil;
import org.zkoss.util.Pair;

public class CellFormat {
    private final String format;
    private final CellFormatPart posNumFmt;
    private final CellFormatPart zeroNumFmt;
    private final CellFormatPart negNumFmt;
    private final CellFormatPart textFmt;
    private final int formatPartCount;
    private static final Pattern ONE_PART = Pattern.compile(CellFormatPart.FORMAT_PAT.pattern() + "(;|$)", 6);
    private static final CellFormatPart DEFAULT_TEXT_FORMAT = new CellFormatPart("@");
    private static final String INVALID_VALUE_FOR_FORMAT = "###############################################################################################################################################################################################################################################################";
    private static String QUOTE = "\"";
    private static final Map<Object, CellFormat> formatCache = Collections.synchronizedMap(new WeakHashMap());
    private static final CellFormatResult EMPTY_CELL_FORMAT_RESULT = new CellFormatResult(false, "", null);
    private boolean _implicit;

    public static final CellFormat getGeneralFormat(final Locale locale) {
        return new CellFormat("General"){

            @Override
            public CellFormatResult apply(Object value, int cellWidth) {
                String text = value == null ? "" : (value instanceof Byte ? ErrorEval.getText(((Byte)value).intValue()) : (value instanceof Number ? CellNumberFormatter.getFormatter(CellNumberFormatter.FormatterType.SIMPLE_NUMBER, locale).format(value) : (value instanceof Boolean ? ((Boolean)value != false ? "TRUE" : "FALSE") : value.toString())));
                return new CellFormatResult(true, text, null);
            }
        };
    }

    public static CellFormat getInstance(String format, Locale locale) {
        Pair key = new Pair((Object)format, (Object)locale);
        CellFormat fmt = formatCache.get(key);
        if (fmt == null) {
            fmt = format.equals("General") || format.equals("@") ? CellFormat.getGeneralFormat(locale) : new CellFormat(format);
            formatCache.put(key, fmt);
        }
        return fmt;
    }

    public CellFormat(String format) {
        this.format = format;
        Matcher m = ONE_PART.matcher(format);
        ArrayList<CellFormatPart> parts = new ArrayList<CellFormatPart>();
        while (m.find()) {
            try {
                String valueDesc = m.group();
                if (valueDesc.endsWith(";")) {
                    valueDesc = valueDesc.substring(0, valueDesc.length() - 1);
                }
                parts.add(new CellFormatPart(valueDesc));
            }
            catch (RuntimeException e) {
                CellFormatter.logger.log(Level.WARNING, "Invalid format: " + CellFormatter.quote(m.group()), e);
                parts.add(null);
            }
        }
        this.formatPartCount = parts.size();
        switch (this.formatPartCount) {
            case 1: {
                this.posNumFmt = (CellFormatPart)parts.get(0);
                this.negNumFmt = null;
                this.zeroNumFmt = null;
                this.textFmt = this.posNumFmt != null ? (this.posNumFmt.getCellFormatType() == CellFormatType.TEXT ? this.posNumFmt : DEFAULT_TEXT_FORMAT) : DEFAULT_TEXT_FORMAT;
                this._implicit = true;
                break;
            }
            case 2: {
                this.posNumFmt = (CellFormatPart)parts.get(0);
                this.negNumFmt = (CellFormatPart)parts.get(1);
                this.zeroNumFmt = null;
                this.textFmt = DEFAULT_TEXT_FORMAT;
                break;
            }
            case 3: {
                this.posNumFmt = (CellFormatPart)parts.get(0);
                this.negNumFmt = (CellFormatPart)parts.get(1);
                this.zeroNumFmt = (CellFormatPart)parts.get(2);
                this.textFmt = DEFAULT_TEXT_FORMAT;
                break;
            }
            default: {
                this.posNumFmt = (CellFormatPart)parts.get(0);
                this.negNumFmt = (CellFormatPart)parts.get(1);
                this.zeroNumFmt = (CellFormatPart)parts.get(2);
                this.textFmt = (CellFormatPart)parts.get(3);
            }
        }
    }

    public CellFormatResult apply(Object value, int cellWidth) {
        if (value instanceof Byte) {
            return new CellFormatResult(false, ErrorEval.getText(((Byte)value).intValue()), null);
        }
        if (value instanceof Number) {
            Number num = (Number)value;
            double val = num.doubleValue();
            if (val < 0.0 && (this.formatPartCount == 2 && !this.posNumFmt.hasCondition() && !this.negNumFmt.hasCondition() || this.formatPartCount == 3 && !this.negNumFmt.hasCondition() || this.formatPartCount == 4 && !this.negNumFmt.hasCondition())) {
                return this._implicit ? this.negNumFmt.apply(value) : this.negNumFmt.apply(-val);
            }
            return this.getApplicableFormatPart(val).apply(val);
        }
        if (value instanceof Date) {
            Double numericValue = DateUtil.getExcelDate((Date)value);
            if (DateUtil.isValidExcelDate(numericValue)) {
                return this.getApplicableFormatPart(numericValue).apply(value);
            }
            throw new IllegalArgumentException("value not a valid Excel date");
        }
        return this.textFmt.apply(value);
    }

    private CellFormatResult apply(Date date, double numericValue, int cellWidth) {
        return this.getApplicableFormatPart(numericValue).apply(date);
    }

    public CellFormatResult apply(Cell c) {
        int cellWidth = c.getSheet().getColumnWidth(c.getColumnIndex()) >> 8;
        switch (CellFormat.ultimateType(c)) {
            case 3: {
                return EMPTY_CELL_FORMAT_RESULT;
            }
            case 4: {
                return this.apply(c.getBooleanCellValue(), cellWidth);
            }
            case 0: {
                Double value = c.getNumericCellValue();
                if (this.getApplicableFormatPart(value).getCellFormatType() == CellFormatType.DATE) {
                    if (DateUtil.isValidExcelDate(value)) {
                        return this.apply(c.getDateCellValue(), value, cellWidth);
                    }
                    return this.apply(INVALID_VALUE_FOR_FORMAT, cellWidth);
                }
                return this.apply(value, cellWidth);
            }
            case 1: {
                String str = c.getStringCellValue();
                return str == null ? EMPTY_CELL_FORMAT_RESULT : this.apply(str, cellWidth);
            }
            case 5: {
                return this.apply(c.getErrorCellValue(), cellWidth);
            }
        }
        return this.apply("?", cellWidth);
    }

    public boolean isApplicableDateFormat(Double value) {
        return this.getApplicableFormatPart(value).getCellFormatType() == CellFormatType.DATE && DateUtil.isValidExcelDate(value);
    }

    public CellFormatResult apply(JLabel label, Object value, int cellWidth) {
        CellFormatResult result = this.apply(value, cellWidth);
        label.setText(result.text);
        if (result.textColor != null) {
            label.setForeground(result.textColor);
        }
        return result;
    }

    private CellFormatResult apply(JLabel label, Date date, double numericValue, int cellWidth) {
        CellFormatResult result = this.apply(date, numericValue, cellWidth);
        label.setText(result.text);
        if (result.textColor != null) {
            label.setForeground(result.textColor);
        }
        return result;
    }

    public CellFormatResult apply(JLabel label, Cell c) {
        int cellWidth = c.getSheet().getColumnWidth(c.getColumnIndex()) >> 8;
        switch (CellFormat.ultimateType(c)) {
            case 3: {
                return this.apply(label, "", cellWidth);
            }
            case 4: {
                return this.apply(label, c.getBooleanCellValue(), cellWidth);
            }
            case 0: {
                Double value = c.getNumericCellValue();
                if (this.getApplicableFormatPart(value).getCellFormatType() == CellFormatType.DATE) {
                    if (DateUtil.isValidExcelDate(value)) {
                        return this.apply(label, c.getDateCellValue(), value, cellWidth);
                    }
                    return this.apply(label, INVALID_VALUE_FOR_FORMAT, cellWidth);
                }
                return this.apply(label, value, cellWidth);
            }
            case 1: {
                return this.apply(label, c.getStringCellValue(), cellWidth);
            }
        }
        return this.apply(label, "?", cellWidth);
    }

    private CellFormatPart getApplicableFormatPart(Object value) {
        if (value instanceof Number) {
            double val = ((Number)value).doubleValue();
            if (this.formatPartCount == 1) {
                if (this.posNumFmt != null && (!this.posNumFmt.hasCondition() || this.posNumFmt.hasCondition() && this.posNumFmt.applies(val))) {
                    return this.posNumFmt;
                }
                return new CellFormatPart("General");
            }
            if (this.formatPartCount == 2) {
                if (this.posNumFmt != null && (!this.posNumFmt.hasCondition() && val >= 0.0 || this.posNumFmt.hasCondition() && this.posNumFmt.applies(val))) {
                    return this.posNumFmt;
                }
                if (this.negNumFmt != null && (!this.negNumFmt.hasCondition() || this.negNumFmt.hasCondition() && this.negNumFmt.applies(val))) {
                    return this.negNumFmt;
                }
                return new CellFormatPart(QUOTE + INVALID_VALUE_FOR_FORMAT + QUOTE);
            }
            if (!this.posNumFmt.hasCondition() && val > 0.0 || this.posNumFmt.hasCondition() && this.posNumFmt.applies(val)) {
                return this.posNumFmt;
            }
            if (!this.negNumFmt.hasCondition() && val < 0.0 || this.negNumFmt.hasCondition() && this.negNumFmt.applies(val)) {
                return this.negNumFmt;
            }
            return this.zeroNumFmt;
        }
        throw new IllegalArgumentException("value must be a Number");
    }

    public static int ultimateType(Cell cell) {
        int type = cell.getCellType();
        if (type == 2) {
            return cell.getCachedFormulaResultType();
        }
        return type;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CellFormat) {
            CellFormat that = (CellFormat)obj;
            return this.format.equals(that.format);
        }
        return false;
    }

    public int hashCode() {
        return this.format.hashCode();
    }
}

