/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hslf.record;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import org.zkoss.poi.hslf.model.textproperties.AlignmentTextProp;
import org.zkoss.poi.hslf.model.textproperties.CharFlagsTextProp;
import org.zkoss.poi.hslf.model.textproperties.ParagraphFlagsTextProp;
import org.zkoss.poi.hslf.model.textproperties.TextProp;
import org.zkoss.poi.hslf.model.textproperties.TextPropCollection;
import org.zkoss.poi.hslf.record.RecordAtom;
import org.zkoss.poi.util.HexDump;
import org.zkoss.poi.util.LittleEndian;

public final class StyleTextPropAtom
extends RecordAtom {
    private byte[] _header;
    private static long _type = 4001L;
    private byte[] reserved;
    private byte[] rawContents;
    private boolean initialised = false;
    private LinkedList<TextPropCollection> paragraphStyles;
    private LinkedList<TextPropCollection> charStyles;
    public static TextProp[] paragraphTextPropTypes = new TextProp[]{new TextProp(0, 1, "hasBullet"), new TextProp(0, 2, "hasBulletFont"), new TextProp(0, 4, "hasBulletColor"), new TextProp(0, 8, "hasBulletSize"), new ParagraphFlagsTextProp(), new TextProp(2, 128, "bullet.char"), new TextProp(2, 16, "bullet.font"), new TextProp(2, 64, "bullet.size"), new TextProp(4, 32, "bullet.color"), new AlignmentTextProp(), new TextProp(2, 256, "text.offset"), new TextProp(2, 1024, "bullet.offset"), new TextProp(2, 4096, "linespacing"), new TextProp(2, 8192, "spacebefore"), new TextProp(2, 16384, "spaceafter"), new TextProp(2, 32768, "defaultTabSize"), new TextProp(2, 0x100000, "tabStops"), new TextProp(2, 65536, "fontAlign"), new TextProp(2, 655360, "wrapFlags"), new TextProp(2, 0x200000, "textDirection")};
    public static TextProp[] characterTextPropTypes = new TextProp[]{new TextProp(0, 1, "bold"), new TextProp(0, 2, "italic"), new TextProp(0, 4, "underline"), new TextProp(0, 8, "unused1"), new TextProp(0, 16, "shadow"), new TextProp(0, 32, "fehint"), new TextProp(0, 64, "unused2"), new TextProp(0, 128, "kumi"), new TextProp(0, 256, "unused3"), new TextProp(0, 512, "emboss"), new TextProp(0, 1024, "nibble1"), new TextProp(0, 2048, "nibble2"), new TextProp(0, 4096, "nibble3"), new TextProp(0, 8192, "nibble4"), new TextProp(0, 16384, "unused4"), new TextProp(0, 32768, "unused5"), new CharFlagsTextProp(), new TextProp(2, 65536, "font.index"), new TextProp(0, 0x100000, "pp10ext"), new TextProp(2, 0x200000, "asian.font.index"), new TextProp(2, 0x400000, "ansi.font.index"), new TextProp(2, 0x800000, "symbol.font.index"), new TextProp(2, 131072, "font.size"), new TextProp(4, 262144, "font.color"), new TextProp(2, 524288, "superscript")};

    public LinkedList<TextPropCollection> getParagraphStyles() {
        return this.paragraphStyles;
    }

    public void setParagraphStyles(LinkedList<TextPropCollection> ps) {
        this.paragraphStyles = ps;
    }

    public LinkedList<TextPropCollection> getCharacterStyles() {
        return this.charStyles;
    }

    public void setCharacterStyles(LinkedList<TextPropCollection> cs) {
        this.charStyles = cs;
    }

    public int getParagraphTextLengthCovered() {
        return this.getCharactersCovered(this.paragraphStyles);
    }

    public int getCharacterTextLengthCovered() {
        return this.getCharactersCovered(this.charStyles);
    }

    private int getCharactersCovered(LinkedList<TextPropCollection> styles) {
        int length = 0;
        for (TextPropCollection tpc : styles) {
            length += tpc.getCharactersCovered();
        }
        return length;
    }

    public StyleTextPropAtom(byte[] source, int start, int len) {
        if (len < 18) {
            len = 18;
            if (source.length - start < 18) {
                throw new RuntimeException("Not enough data to form a StyleTextPropAtom (min size 18 bytes long) - found " + (source.length - start));
            }
        }
        this._header = new byte[8];
        System.arraycopy(source, start, this._header, 0, 8);
        this.rawContents = new byte[len - 8];
        System.arraycopy(source, start + 8, this.rawContents, 0, this.rawContents.length);
        this.reserved = new byte[0];
        this.paragraphStyles = new LinkedList();
        this.charStyles = new LinkedList();
    }

    public StyleTextPropAtom(int parentTextSize) {
        this._header = new byte[8];
        this.rawContents = new byte[0];
        this.reserved = new byte[0];
        LittleEndian.putInt(this._header, 2, (short)_type);
        LittleEndian.putInt(this._header, 4, 10);
        this.paragraphStyles = new LinkedList();
        this.charStyles = new LinkedList();
        TextPropCollection defaultParagraphTextProps = new TextPropCollection(parentTextSize, 0);
        this.paragraphStyles.add(defaultParagraphTextProps);
        TextPropCollection defaultCharacterTextProps = new TextPropCollection(parentTextSize);
        this.charStyles.add(defaultCharacterTextProps);
        this.initialised = true;
    }

    @Override
    public long getRecordType() {
        return _type;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        this.updateRawContents();
        int newSize = this.rawContents.length + this.reserved.length;
        LittleEndian.putInt(this._header, 4, newSize);
        out.write(this._header);
        out.write(this.rawContents);
        out.write(this.reserved);
    }

    public void setParentTextSize(int size) {
        int pos = 0;
        int textHandled = 0;
        int prsize = size;
        while (pos < this.rawContents.length && textHandled < prsize) {
            int textLen = LittleEndian.getInt(this.rawContents, pos);
            textHandled += textLen;
            short indent = LittleEndian.getShort(this.rawContents, pos += 4);
            int paraFlags = LittleEndian.getInt(this.rawContents, pos += 2);
            TextPropCollection thisCollection = new TextPropCollection(textLen, indent);
            int plSize = thisCollection.buildTextPropList(paraFlags, paragraphTextPropTypes, this.rawContents, pos += 4);
            this.paragraphStyles.add(thisCollection);
            if ((pos += plSize) >= this.rawContents.length || textHandled != size) continue;
            ++prsize;
        }
        if (this.rawContents.length > 0 && textHandled != size + 1) {
            logger.log(5, "Problem reading paragraph style runs: textHandled = " + textHandled + ", text.size+1 = " + (size + 1));
        }
        textHandled = 0;
        int chsize = size;
        while (pos < this.rawContents.length && textHandled < chsize) {
            int textLen = LittleEndian.getInt(this.rawContents, pos);
            textHandled += textLen;
            short no_val = -1;
            int charFlags = LittleEndian.getInt(this.rawContents, pos += 4);
            TextPropCollection thisCollection = new TextPropCollection(textLen, no_val);
            int chSize = thisCollection.buildTextPropList(charFlags, characterTextPropTypes, this.rawContents, pos += 4);
            this.charStyles.add(thisCollection);
            if ((pos += chSize) >= this.rawContents.length || textHandled != size) continue;
            ++chsize;
        }
        if (this.rawContents.length > 0 && textHandled != size + 1) {
            logger.log(5, "Problem reading character style runs: textHandled = " + textHandled + ", text.size+1 = " + (size + 1));
        }
        if (pos < this.rawContents.length) {
            this.reserved = new byte[this.rawContents.length - pos];
            System.arraycopy(this.rawContents, pos, this.reserved, 0, this.reserved.length);
        }
        this.initialised = true;
    }

    private void updateRawContents() throws IOException {
        TextPropCollection tpc;
        int i;
        if (!this.initialised) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (i = 0; i < this.paragraphStyles.size(); ++i) {
            tpc = this.paragraphStyles.get(i);
            tpc.writeOut(baos);
        }
        for (i = 0; i < this.charStyles.size(); ++i) {
            tpc = this.charStyles.get(i);
            tpc.writeOut(baos);
        }
        this.rawContents = baos.toByteArray();
    }

    public void setRawContents(byte[] bytes) {
        this.rawContents = bytes;
        this.reserved = new byte[0];
        this.initialised = false;
    }

    public TextPropCollection addParagraphTextPropCollection(int charactersCovered) {
        TextPropCollection tpc = new TextPropCollection(charactersCovered, 0);
        this.paragraphStyles.add(tpc);
        return tpc;
    }

    public TextPropCollection addCharacterTextPropCollection(int charactersCovered) {
        TextPropCollection tpc = new TextPropCollection(charactersCovered);
        this.charStyles.add(tpc);
        return tpc;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("StyleTextPropAtom:\n");
        if (!this.initialised) {
            out.append("Uninitialised, dumping Raw Style Data\n");
        } else {
            byte[] b;
            ByteArrayOutputStream baos;
            out.append("Paragraph properties\n");
            for (TextPropCollection pr : this.getParagraphStyles()) {
                out.append("  chars covered: " + pr.getCharactersCovered());
                out.append("  special mask flags: 0x" + HexDump.toHex(pr.getSpecialMask()) + "\n");
                for (TextProp p : pr.getTextPropList()) {
                    out.append("    " + p.getName() + " = " + p.getValue());
                    out.append(" (0x" + HexDump.toHex(p.getValue()) + ")\n");
                }
                out.append("  para bytes that would be written: \n");
                try {
                    baos = new ByteArrayOutputStream();
                    pr.writeOut(baos);
                    b = baos.toByteArray();
                    out.append(HexDump.dump(b, 0L, 0));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            out.append("Character properties\n");
            for (TextPropCollection pr : this.getCharacterStyles()) {
                out.append("  chars covered: " + pr.getCharactersCovered());
                out.append("  special mask flags: 0x" + HexDump.toHex(pr.getSpecialMask()) + "\n");
                for (TextProp p : pr.getTextPropList()) {
                    out.append("    " + p.getName() + " = " + p.getValue());
                    out.append(" (0x" + HexDump.toHex(p.getValue()) + ")\n");
                }
                out.append("  char bytes that would be written: \n");
                try {
                    baos = new ByteArrayOutputStream();
                    pr.writeOut(baos);
                    b = baos.toByteArray();
                    out.append(HexDump.dump(b, 0L, 0));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        out.append("  original byte stream \n");
        out.append(HexDump.dump(this.rawContents, 0L, 0));
        return out.toString();
    }
}

