/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.au.in;

import io.keikai.ui.Spreadsheet;
import io.keikai.ui.au.in.AbstractCommand;
import io.keikai.ui.au.in.Command;
import io.keikai.ui.sys.SpreadsheetInCtrl;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;

public class BlockSyncCommand
extends AbstractCommand
implements Command {
    @Override
    public void process(AuRequest request) {
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, BlockSyncCommand.class);
        }
        Map data = request.getData();
        if (data == null || data.size() != 17) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), BlockSyncCommand.class});
        }
        Spreadsheet spreadsheet = (Spreadsheet)comp;
        SpreadsheetInCtrl ctrl = (SpreadsheetInCtrl)spreadsheet.getExtraCtrl();
        String sheetId = (String)data.get("sheetId");
        int blockLeft = (Integer)data.get("blockLeft");
        int blockTop = (Integer)data.get("blockTop");
        int blockRight = (Integer)data.get("blockRight");
        int blockBottom = (Integer)data.get("blockBottom");
        int rangeLeft = (Integer)data.get("rangeLeft");
        int rangeTop = (Integer)data.get("rangeTop");
        int rangeRight = (Integer)data.get("rangeRight");
        int rangeBottom = (Integer)data.get("rangeBottom");
        ctrl.setLoadedRect(rangeLeft, rangeTop, rangeRight, rangeBottom);
        ctrl.setVisibleRect(blockLeft, blockTop, blockRight, blockBottom);
    }
}

