/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel;

import java.io.Serializable;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCustomFilter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STFilterOperator;
import org.zkoss.poi.ss.usermodel.CustomFilter;

public class XSSFCustomFilter
implements CustomFilter,
Serializable {
    private CTCustomFilter _ctFilter;

    XSSFCustomFilter(CTCustomFilter ctFilter) {
        this._ctFilter = ctFilter;
    }

    @Override
    public void setProperties(CustomFilter.Operator operator, String value) {
        switch (operator) {
            case greaterThan: 
            case greaterThanOrEqual: 
            case lessThan: 
            case lessThanOrEqual: 
            case notEqual: {
                this._ctFilter.setVal(value);
                this._ctFilter.setOperator(STFilterOperator.Enum.forString((String)operator.name()));
                break;
            }
            case notBeginWith: {
                this._ctFilter.setVal(value + "*");
                this._ctFilter.setOperator(STFilterOperator.Enum.forString((String)CustomFilter.Operator.notEqual.name()));
                break;
            }
            case notEndWith: {
                this._ctFilter.setVal("*" + value);
                this._ctFilter.setOperator(STFilterOperator.Enum.forString((String)CustomFilter.Operator.notEqual.name()));
                break;
            }
            case notContains: {
                this._ctFilter.setVal("*" + value + "*");
                this._ctFilter.setOperator(STFilterOperator.Enum.forString((String)CustomFilter.Operator.notEqual.name()));
                break;
            }
            case beginWith: {
                this._ctFilter.setVal(value + "*");
                if (!this._ctFilter.isSetOperator()) break;
                this._ctFilter.unsetOperator();
                break;
            }
            case endWith: {
                this._ctFilter.setVal("*" + value);
                if (!this._ctFilter.isSetOperator()) break;
                this._ctFilter.unsetOperator();
                break;
            }
            case contains: {
                this._ctFilter.setVal("*" + value + "*");
                if (!this._ctFilter.isSetOperator()) break;
                this._ctFilter.unsetOperator();
                break;
            }
            default: {
                this._ctFilter.setVal(value);
                if (!this._ctFilter.isSetOperator()) break;
                this._ctFilter.unsetOperator();
            }
        }
    }

    @Override
    public String getValue() {
        boolean contains;
        String val = this._ctFilter.getVal();
        boolean endWith = false;
        boolean beginWith = false;
        if (val.startsWith("*")) {
            endWith = true;
        }
        if (val.endsWith("*")) {
            beginWith = true;
        }
        boolean bl = contains = beginWith && endWith;
        if (contains) {
            return val.substring(1, val.length() - 1);
        }
        if (beginWith) {
            return val.substring(0, val.length() - 1);
        }
        if (endWith) {
            return val.substring(1);
        }
        return val;
    }

    @Override
    public CustomFilter.Operator getOperator() {
        String val = this._ctFilter.getVal();
        boolean endWith = false;
        boolean beginWith = false;
        if (val.startsWith("*")) {
            endWith = true;
        }
        if (val.endsWith("*")) {
            beginWith = true;
        }
        boolean contains = beginWith && endWith;
        switch (this._ctFilter.getOperator().intValue()) {
            case 6: {
                return CustomFilter.Operator.greaterThan;
            }
            case 5: {
                return CustomFilter.Operator.greaterThanOrEqual;
            }
            case 2: {
                return CustomFilter.Operator.lessThan;
            }
            case 3: {
                return CustomFilter.Operator.lessThanOrEqual;
            }
            case 4: {
                if (contains) {
                    return CustomFilter.Operator.notContains;
                }
                if (beginWith) {
                    return CustomFilter.Operator.notBeginWith;
                }
                if (endWith) {
                    return CustomFilter.Operator.notEndWith;
                }
                return CustomFilter.Operator.notEqual;
            }
        }
        if (contains) {
            return CustomFilter.Operator.contains;
        }
        if (beginWith) {
            return CustomFilter.Operator.beginWith;
        }
        if (endWith) {
            return CustomFilter.Operator.endWith;
        }
        return CustomFilter.Operator.equal;
    }
}

