/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.usermodel;

import org.zkoss.poi.hssf.usermodel.HSSFClientAnchor;
import org.zkoss.poi.hssf.usermodel.HSSFDataFormat;
import org.zkoss.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.zkoss.poi.hssf.usermodel.HSSFHyperlink;
import org.zkoss.poi.hssf.usermodel.HSSFRichTextString;
import org.zkoss.poi.hssf.usermodel.HSSFWorkbook;
import org.zkoss.poi.ss.usermodel.CreationHelper;

public class HSSFCreationHelper
implements CreationHelper {
    private HSSFWorkbook workbook;
    private HSSFDataFormat dataFormat;

    HSSFCreationHelper(HSSFWorkbook wb) {
        this.workbook = wb;
        this.dataFormat = new HSSFDataFormat(this.workbook.getWorkbook());
    }

    @Override
    public HSSFRichTextString createRichTextString(String text) {
        return new HSSFRichTextString(text);
    }

    @Override
    public HSSFDataFormat createDataFormat() {
        return this.dataFormat;
    }

    @Override
    public HSSFHyperlink createHyperlink(int type) {
        return new HSSFHyperlink(type);
    }

    @Override
    public HSSFFormulaEvaluator createFormulaEvaluator() {
        return new HSSFFormulaEvaluator(this.workbook);
    }

    @Override
    public HSSFClientAnchor createClientAnchor() {
        return new HSSFClientAnchor();
    }
}

