/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.statistics;

import com.hazelcast.client.impl.connection.ClientConnectionManager;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.nio.Connection;

class ClusterConnectionMetricsProvider
implements DynamicMetricsProvider {
    private final ClientConnectionManager clientConnectionManager;

    ClusterConnectionMetricsProvider(ClientConnectionManager clientConnectionManager) {
        this.clientConnectionManager = clientConnectionManager;
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        for (Connection connection : this.clientConnectionManager.getActiveConnections()) {
            context.collect(descriptor.withPrefix("cluster.connection").withDiscriminator("endpoint", connection.getRemoteAddress().toString()), connection);
        }
    }
}

