/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.cache;

import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.PreJoinCacheConfig;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheCreateConfigCodec;
import com.hazelcast.client.impl.protocol.codec.holder.CacheConfigHolder;
import com.hazelcast.client.impl.protocol.task.AbstractMessageTask;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.config.ConfigValidator;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.merge.SplitBrainMergePolicyProvider;
import java.security.Permission;
import java.util.function.BiConsumer;

public class CacheCreateConfigMessageTask
extends AbstractMessageTask<CacheCreateConfigCodec.RequestParameters>
implements BiConsumer<Object, Throwable> {
    public CacheCreateConfigMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected void processMessage() {
        CacheConfig cacheConfig = ((CacheCreateConfigCodec.RequestParameters)this.parameters).cacheConfig.asCacheConfig(this.serializationService);
        CacheService cacheService = (CacheService)this.getService("hz:impl:cacheService");
        SplitBrainMergePolicyProvider mergePolicyProvider = this.nodeEngine.getSplitBrainMergePolicyProvider();
        ConfigValidator.checkCacheConfig(cacheConfig, mergePolicyProvider);
        InternalCompletableFuture<Object> future = cacheService.createCacheConfigOnAllMembersAsync(PreJoinCacheConfig.of(cacheConfig));
        future.whenCompleteAsync((BiConsumer)this, ConcurrencyUtil.CALLER_RUNS);
    }

    @Override
    protected CacheCreateConfigCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return CacheCreateConfigCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        CacheConfig cacheConfig = (CacheConfig)response;
        return CacheCreateConfigCodec.encodeResponse(CacheConfigHolder.of(cacheConfig, this.serializationService));
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return null;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public void accept(Object response, Throwable throwable) {
        if (throwable == null) {
            this.sendResponse(response);
        } else {
            this.handleProcessingFailure(throwable);
        }
    }
}

