/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.console;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.console.HazelcastCommandLine;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.management.MCClusterMetadata;
import com.hazelcast.client.impl.spi.ClientClusterService;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.cluster.Member;
import com.hazelcast.collection.IList;
import com.hazelcast.collection.IQueue;
import com.hazelcast.collection.ISet;
import com.hazelcast.collection.ItemEvent;
import com.hazelcast.collection.ItemListener;
import com.hazelcast.console.Echo;
import com.hazelcast.console.SimulateLoadTask;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.cp.IAtomicLong;
import com.hazelcast.cp.lock.FencedLock;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.FutureUtil;
import com.hazelcast.internal.util.RuntimeAvailableProcessors;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.map.IMap;
import com.hazelcast.map.MapEvent;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.multimap.MultiMap;
import com.hazelcast.partition.Partition;
import com.hazelcast.topic.ITopic;
import com.hazelcast.topic.Message;
import com.hazelcast.topic.MessageListener;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jline.reader.EndOfFileException;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.InfoCmp;

public class ClientConsoleApp
implements EntryListener,
ItemListener,
MessageListener {
    private static final int ONE_KB = 1024;
    private static final int ONE_THOUSAND = 1000;
    private static final int ONE_HUNDRED = 100;
    private static final int ONE_HOUR = 3600;
    private static final int MAX_THREAD_COUNT = 16;
    private static final int HUNDRED_CONSTANT = 100;
    private static final int BYTE_TO_BIT = 8;
    private static final int LENGTH_BORDER = 4;
    private static final int COLOR = 12;
    private String namespace = "default";
    private String executorNamespace = "Sample Executor";
    private boolean silent;
    private boolean echo;
    private final LineReader lineReader;
    private final PrintWriter writer;
    private final HazelcastInstance client;
    private volatile boolean running;

    public ClientConsoleApp(@Nonnull HazelcastInstance client) {
        this(client, null);
    }

    public ClientConsoleApp(@Nonnull HazelcastInstance client, @Nullable PrintWriter writer) {
        this.client = client;
        Terminal terminal = this.createTerminal();
        this.lineReader = LineReaderBuilder.builder().variable("secondary-prompt-pattern", (Object)(ClientConsoleApp.isRealTerminal(terminal) ? new AttributedStringBuilder().style(AttributedStyle.BOLD.foreground(12)).append((CharSequence)"%M%P > ").toAnsi() : "")).variable("indentation", (Object)2).option(LineReader.Option.DISABLE_EVENT_EXPANSION, true).appName("hazelcast-console-app").terminal(terminal).build();
        this.writer = writer == null ? this.lineReader.getTerminal().writer() : writer;
    }

    private Terminal createTerminal() {
        try {
            return TerminalBuilder.terminal();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private static boolean isRealTerminal(Terminal terminal) {
        return !"dumb".equals(terminal.getType()) && !"dumb-color".equals(terminal.getType());
    }

    public IQueue<Object> getQueue() {
        return this.client.getQueue(this.namespace);
    }

    public ITopic<Object> getTopic() {
        return this.client.getTopic(this.namespace);
    }

    public IMap<Object, Object> getMap() {
        return this.client.getMap(this.namespace);
    }

    public MultiMap<Object, Object> getMultiMap() {
        return this.client.getMultiMap(this.namespace);
    }

    public IAtomicLong getAtomicNumber() {
        return this.client.getCPSubsystem().getAtomicLong(this.namespace);
    }

    public ISet<Object> getSet() {
        return this.client.getSet(this.namespace);
    }

    public IList<Object> getList() {
        return this.client.getList(this.namespace);
    }

    public void stop() {
        this.running = false;
    }

    public void start() {
        try {
            this.println(ClientConsoleApp.startPrompt(this.client));
            this.writer.flush();
            this.running = true;
            while (this.running) {
                try {
                    String command = this.lineReader.readLine(new AttributedStringBuilder().style(AttributedStyle.DEFAULT.foreground(12)).append((CharSequence)"hazelcast[").append((CharSequence)this.namespace).append((CharSequence)"] > ").toAnsi());
                    this.handleCommand(command);
                }
                catch (IOError | EndOfFileException e) {
                    this.println("Exiting from the client console application.");
                    this.writer.flush();
                    break;
                }
                catch (UserInterruptException e) {
                    if (ClientConsoleApp.isRealTerminal(this.lineReader.getTerminal())) continue;
                    this.writer.flush();
                    break;
                }
                catch (Throwable e) {
                    e.printStackTrace(this.writer);
                    this.writer.flush();
                }
                this.running = this.running && this.client.getLifecycleService().isRunning();
            }
        }
        finally {
            IOUtil.closeResource((AutoCloseable)this.lineReader.getTerminal());
        }
    }

    @SuppressFBWarnings(value={"DM_EXIT"})
    protected void handleCommand(String commandInputted) {
        String command = commandInputted;
        if (command == null) {
            return;
        }
        if (command.contains("__")) {
            this.namespace = command.split("__")[0];
            command = command.substring(command.indexOf("__") + 2);
        }
        if (this.echo) {
            this.handleEcho(command);
        }
        if (command.startsWith("//")) {
            return;
        }
        if ((command = command.trim()).length() == 0) {
            return;
        }
        String first = command;
        int spaceIndex = command.indexOf(32);
        String[] argsSplit = command.split(" ");
        String[] args = new String[argsSplit.length];
        for (int i = 0; i < argsSplit.length; ++i) {
            args[i] = argsSplit[i].trim();
        }
        if (spaceIndex != -1) {
            first = args[0];
        }
        if (StringUtil.equalsIgnoreCase(first, "help")) {
            this.handleHelp();
        } else if (first.startsWith("#") && first.length() > 1) {
            int repeat = Integer.parseInt(first.substring(1));
            long t0 = Clock.currentTimeMillis();
            for (int i = 0; i < repeat; ++i) {
                this.handleCommand(command.substring(first.length()).replaceAll("\\$i", "" + i));
            }
            this.println("ops/s = " + (long)(repeat * 1000) / (Clock.currentTimeMillis() - t0));
        } else if (first.startsWith("&") && first.length() > 1) {
            int fork = Integer.parseInt(first.substring(1));
            ExecutorService pool = Executors.newFixedThreadPool(fork);
            final String threadCommand = command.substring(first.length());
            int i = 0;
            while (i < fork) {
                final int threadID = i++;
                pool.submit(new Runnable(){

                    @Override
                    public void run() {
                        String command = threadCommand;
                        String[] threadArgs = command.replaceAll("\\$t", "" + threadID).trim().split(" ");
                        if (("m.putmany".equals(threadArgs[0]) || "m.removemany".equals(threadArgs[0])) && threadArgs.length < 4) {
                            command = command + " " + Integer.parseInt(threadArgs[1]) * threadID;
                        }
                        ClientConsoleApp.this.handleCommand(command);
                    }
                });
            }
            pool.shutdown();
            try {
                pool.awaitTermination(3600L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (first.startsWith("@")) {
            this.handleAt(first);
        } else if (command.indexOf(59) != -1) {
            this.handleColon(command);
        } else if (StringUtil.equalsIgnoreCase(first, "silent")) {
            this.silent = Boolean.parseBoolean(args[1]);
        } else if (StringUtil.equalsIgnoreCase(first, "echo")) {
            this.echo = Boolean.parseBoolean(args[1]);
            this.println("echo: " + this.echo);
        } else if (StringUtil.equalsIgnoreCase(first, "clear")) {
            this.lineReader.getTerminal().puts(InfoCmp.Capability.clear_screen, new Object[0]);
        } else if (StringUtil.equalsIgnoreCase(first, "history")) {
            History hist = this.lineReader.getHistory();
            ListIterator iterator = hist.iterator();
            while (iterator.hasNext()) {
                History.Entry entry = (History.Entry)iterator.next();
                if (iterator.hasNext()) {
                    String entryLine = entry.index() + 1 + " - " + entry.line();
                    this.writer.println(entryLine);
                    this.writer.flush();
                    continue;
                }
                iterator.remove();
                hist.resetIndex();
            }
        } else if (StringUtil.equalsIgnoreCase(first, "ns")) {
            this.handleNamespace(args);
        } else if (StringUtil.equalsIgnoreCase(first, "who")) {
            this.handleWho();
        } else if (StringUtil.equalsIgnoreCase(first, "jvm")) {
            this.handleJvm();
        } else if (StringUtil.lowerCaseInternal(first).contains("lock") && !first.contains(".")) {
            this.handleLock(args);
        } else if (first.contains(".size")) {
            this.handleSize(args);
        } else if (first.contains(".clear")) {
            this.handleClear(args);
        } else if (first.contains(".destroy")) {
            this.handleDestroy(args);
        } else if (first.contains(".iterator")) {
            this.handleIterator(args);
        } else if (first.contains(".contains")) {
            this.handleContains(args);
        } else if (first.contains(".stats")) {
            this.handleStats(args);
        } else if ("t.publish".equals(first)) {
            this.handleTopicPublish(args);
        } else if ("q.offer".equals(first)) {
            this.handleQOffer(args);
        } else if ("q.take".equals(first)) {
            this.handleQTake(args);
        } else if ("q.poll".equals(first)) {
            this.handleQPoll(args);
        } else if ("q.peek".equals(first)) {
            this.handleQPeek(args);
        } else if ("q.capacity".equals(first)) {
            this.handleQCapacity(args);
        } else if ("q.offermany".equals(first)) {
            this.handleQOfferMany(args);
        } else if ("q.pollmany".equals(first)) {
            this.handleQPollMany(args);
        } else if ("s.add".equals(first)) {
            this.handleSetAdd(args);
        } else if ("s.remove".equals(first)) {
            this.handleSetRemove(args);
        } else if ("s.addmany".equals(first)) {
            this.handleSetAddMany(args);
        } else if ("s.removemany".equals(first)) {
            this.handleSetRemoveMany(args);
        } else if (first.equals("m.replace")) {
            this.handleMapReplace(args);
        } else if (StringUtil.equalsIgnoreCase(first, "m.putIfAbsent")) {
            this.handleMapPutIfAbsent(args);
        } else if (first.equals("m.putAsync")) {
            this.handleMapPutAsync(args);
        } else if (first.equals("m.getAsync")) {
            this.handleMapGetAsync(args);
        } else if (first.equals("m.put")) {
            this.handleMapPut(args);
        } else if (first.equals("m.get")) {
            this.handleMapGet(args);
        } else if (StringUtil.equalsIgnoreCase(first, "m.getMapEntry")) {
            this.handleMapGetMapEntry(args);
        } else if (first.equals("m.remove")) {
            this.handleMapRemove(args);
        } else if (first.equals("m.delete")) {
            this.handleMapDelete(args);
        } else if (first.equals("m.evict")) {
            this.handleMapEvict(args);
        } else if (first.equals("m.putmany") || StringUtil.equalsIgnoreCase(first, "m.putAll")) {
            this.handleMapPutMany(args);
        } else if (first.equals("m.getmany")) {
            this.handleMapGetMany(args);
        } else if (first.equals("m.removemany")) {
            this.handleMapRemoveMany(args);
        } else if (command.equals("m.keys")) {
            this.handleMapKeys();
        } else if (command.equals("m.values")) {
            this.handleMapValues();
        } else if (command.equals("m.entries")) {
            this.handleMapEntries();
        } else if (first.equals("m.lock")) {
            this.handleMapLock(args);
        } else if (StringUtil.equalsIgnoreCase(first, "m.tryLock")) {
            this.handleMapTryLock(args);
        } else if (first.equals("m.unlock")) {
            this.handleMapUnlock(args);
        } else if (first.contains(".addListener")) {
            this.handleAddListener(args);
        } else if (first.equals("m.removeMapListener")) {
            this.handleRemoveListener(args);
        } else if (first.equals("mm.put")) {
            this.handleMultiMapPut(args);
        } else if (first.equals("mm.get")) {
            this.handleMultiMapGet(args);
        } else if (first.equals("mm.remove")) {
            this.handleMultiMapRemove(args);
        } else if (command.equals("mm.keys")) {
            this.handleMultiMapKeys();
        } else if (command.equals("mm.values")) {
            this.handleMultiMapValues();
        } else if (command.equals("mm.entries")) {
            this.handleMultiMapEntries();
        } else if (first.equals("mm.lock")) {
            this.handleMultiMapLock(args);
        } else if (StringUtil.equalsIgnoreCase(first, "mm.tryLock")) {
            this.handleMultiMapTryLock(args);
        } else if (first.equals("mm.unlock")) {
            this.handleMultiMapUnlock(args);
        } else if (first.equals("l.add")) {
            this.handleListAdd(args);
        } else if (first.equals("l.set")) {
            this.handleListSet(args);
        } else if ("l.addmany".equals(first)) {
            this.handleListAddMany(args);
        } else if (first.equals("l.remove")) {
            this.handleListRemove(args);
        } else if (first.equals("l.contains")) {
            this.handleListContains(args);
        } else if ("a.get".equals(first)) {
            this.handleAtomicNumberGet(args);
        } else if ("a.set".equals(first)) {
            this.handleAtomicNumberSet(args);
        } else if ("a.incrementAndGet".equals(first)) {
            this.handleAtomicNumberInc(args);
        } else if ("a.decrementAndGet".equals(first)) {
            this.handleAtomicNumberDec(args);
        } else if (first.equals("execute")) {
            this.execute(args);
        } else if (first.equals("partitions")) {
            this.handlePartitions(args);
        } else if (StringUtil.equalsIgnoreCase(first, "executeOnKey")) {
            this.executeOnKey(args);
        } else if (StringUtil.equalsIgnoreCase(first, "executeOnMember")) {
            this.executeOnMember(args);
        } else if (StringUtil.equalsIgnoreCase(first, "executeOnMembers")) {
            this.executeOnMembers(args);
        } else if (StringUtil.equalsIgnoreCase(first, "instances")) {
            this.handleInstances(args);
        } else if (StringUtil.equalsIgnoreCase(first, "quit") || StringUtil.equalsIgnoreCase(first, "exit") || StringUtil.equalsIgnoreCase(first, "shutdown")) {
            this.println("Exiting from the client console application.");
            this.writer.flush();
            System.exit(0);
        } else if (first.startsWith("e") && first.endsWith(".simulateLoad")) {
            this.handleExecutorSimulate(args);
        } else {
            this.println("type 'help' for help");
        }
    }

    private void handleExecutorSimulate(String[] args) {
        String first = args[0];
        int threadCount = Integer.parseInt(first.substring(1, first.indexOf(".")));
        if (threadCount < 1 || threadCount > 16) {
            throw new RuntimeException("threadcount can't be smaller than 1 or larger than 16");
        }
        int taskCount = Integer.parseInt(args[1]);
        int durationSec = Integer.parseInt(args[2]);
        long startMs = System.currentTimeMillis();
        IExecutorService executor = this.client.getExecutorService(this.executorNamespace + ' ' + threadCount);
        LinkedList futures = new LinkedList();
        LinkedList<Member> members = new LinkedList<Member>(this.client.getCluster().getMembers());
        int totalThreadCount = this.client.getCluster().getMembers().size() * threadCount;
        int latchId = 0;
        for (int k = 0; k < taskCount; ++k) {
            Member member = (Member)members.get(k % members.size());
            if (taskCount % totalThreadCount == 0) {
                latchId = taskCount / totalThreadCount;
                this.client.getCPSubsystem().getCountDownLatch("latch" + latchId).trySetCount(totalThreadCount);
            }
            Future f = executor.submitToMember(new SimulateLoadTask(durationSec, k + 1, "latch" + latchId), member);
            futures.add(f);
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        long durationMs = System.currentTimeMillis() - startMs;
        this.println(String.format("Executed %s tasks in %s ms", taskCount, durationMs));
    }

    private void handleColon(String command) {
        StringTokenizer st = new StringTokenizer(command, ";");
        while (st.hasMoreTokens()) {
            this.handleCommand(st.nextToken());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    private void handleAt(String first) {
        if (first.length() == 1) {
            this.println("usage: @<file-name>");
            return;
        }
        File f = new File(first.substring(1));
        this.println("Executing script file " + f.getAbsolutePath());
        if (f.exists()) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(f));
                String l = br.readLine();
                while (l != null) {
                    this.handleCommand(l);
                    l = br.readLine();
                }
                IOUtil.closeResource(br);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                IOUtil.closeResource(br);
            }
        } else {
            this.println("File not found! " + f.getAbsolutePath());
        }
    }

    private void handleEcho(String command) {
        String threadName = StringUtil.lowerCaseInternal(Thread.currentThread().getName());
        if (!threadName.contains("main")) {
            this.println(" [" + Thread.currentThread().getName() + "] " + command);
        } else {
            this.println(command);
        }
    }

    private void handleNamespace(String[] args) {
        if (args.length > 1) {
            this.namespace = args[1];
            this.println("namespace: " + this.namespace);
        }
    }

    @SuppressFBWarnings(value={"DM_GC"})
    private void handleJvm() {
        System.gc();
        Runtime runtime = Runtime.getRuntime();
        this.println("Memory max: " + runtime.maxMemory() / 1024L / 1024L + 'M');
        long freeMemory = runtime.freeMemory() / 1024L / 1024L;
        int freeMemoryPercentage = (int)(runtime.freeMemory() * 100L / runtime.maxMemory());
        this.println("Memory free: " + freeMemory + "M " + freeMemoryPercentage + '%');
        long total = runtime.totalMemory();
        long free = runtime.freeMemory();
        this.println("Used Memory:" + (total - free) / 1024L / 1024L + "MB");
        this.println("# procs: " + RuntimeAvailableProcessors.get());
        this.println("OS info: " + ManagementFactory.getOperatingSystemMXBean().getArch() + ' ' + ManagementFactory.getOperatingSystemMXBean().getName() + ' ' + ManagementFactory.getOperatingSystemMXBean().getVersion());
        this.println("JVM: " + ManagementFactory.getRuntimeMXBean().getVmVendor() + " " + ManagementFactory.getRuntimeMXBean().getVmName() + " " + ManagementFactory.getRuntimeMXBean().getVmVersion());
    }

    private void handleWho() {
        StringBuilder sb = new StringBuilder("\n\nMembers [");
        Set<Member> members = this.client.getCluster().getMembers();
        sb.append(members != null ? members.size() : 0);
        sb.append("] {");
        if (members != null) {
            for (Member member : members) {
                sb.append("\n\t").append(member);
            }
        }
        sb.append("\n}\n");
        this.println(sb.toString());
    }

    private void handleAtomicNumberGet(String[] args) {
        this.println(this.getAtomicNumber().get());
    }

    private void handleAtomicNumberSet(String[] args) {
        long v = 0L;
        if (args.length > 1) {
            v = Long.parseLong(args[1]);
        }
        this.getAtomicNumber().set(v);
        this.println(this.getAtomicNumber().get());
    }

    private void handleAtomicNumberInc(String[] args) {
        this.println(this.getAtomicNumber().incrementAndGet());
    }

    private void handleAtomicNumberDec(String[] args) {
        this.println(this.getAtomicNumber().decrementAndGet());
    }

    protected void handlePartitions(String[] args) {
        Set<Partition> partitions = this.client.getPartitionService().getPartitions();
        HashMap<Member, Integer> partitionCounts = new HashMap<Member, Integer>();
        for (Partition partition : partitions) {
            Member owner = partition.getOwner();
            if (owner != null) {
                Integer count = (Integer)partitionCounts.get(owner);
                int newCount = 1;
                if (count != null) {
                    newCount = count + 1;
                }
                partitionCounts.put(owner, newCount);
            }
            this.println(partition);
        }
        Set entries = partitionCounts.entrySet();
        for (Map.Entry entry : entries) {
            this.println(entry.getKey() + ":" + entry.getValue());
        }
    }

    protected void handleInstances(String[] args) {
        Collection<DistributedObject> distributedObjects = this.client.getDistributedObjects();
        for (DistributedObject distributedObject : distributedObjects) {
            this.println(distributedObject);
        }
    }

    protected void handleListContains(String[] args) {
        this.println(this.getList().contains(args[1]));
    }

    protected void handleListRemove(String[] args) {
        try {
            int index = Integer.parseInt(args[1]);
            if (index >= 0) {
                this.println(this.getList().remove(index));
            } else {
                this.println(this.getList().remove(args[1]));
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
    }

    protected void handleListAdd(String[] args) {
        if (args.length == 3) {
            int index = Integer.parseInt(args[1]);
            this.getList().add(index, args[2]);
            this.println("true");
        } else {
            this.println(this.getList().add(args[1]));
        }
    }

    protected void handleListSet(String[] args) {
        int index = Integer.parseInt(args[1]);
        this.println(this.getList().set(index, args[2]));
    }

    protected void handleListAddMany(String[] args) {
        IList<Object> list = this.getList();
        int count = 1;
        if (args.length > 1) {
            count = Integer.parseInt(args[1]);
        }
        int successCount = 0;
        long t0 = Clock.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            boolean success = list.add("obj" + i);
            if (!success) continue;
            ++successCount;
        }
        long t1 = Clock.currentTimeMillis();
        this.println("Added " + successCount + " objects.");
        this.println("size = " + list.size() + ", " + (long)(successCount * 1000) / (t1 - t0) + " evt/s");
    }

    protected void handleMapPut(String[] args) {
        this.println(this.getMap().put(args[1], args[2]));
    }

    protected void handleMapPutAsync(String[] args) {
        try {
            this.println(this.getMap().putAsync(args[1], args[2]).toCompletableFuture().get());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    protected void handleMapPutIfAbsent(String[] args) {
        this.println(this.getMap().putIfAbsent(args[1], args[2]));
    }

    protected void handleMapReplace(String[] args) {
        this.println(this.getMap().replace(args[1], args[2]));
    }

    protected void handleMapGet(String[] args) {
        this.println(this.getMap().get(args[1]));
    }

    protected void handleMapGetAsync(String[] args) {
        try {
            this.println(this.getMap().getAsync(args[1]).toCompletableFuture().get());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    protected void handleMapGetMapEntry(String[] args) {
        this.println(this.getMap().getEntryView(args[1]));
    }

    protected void handleMapRemove(String[] args) {
        this.println(this.getMap().remove(args[1]));
    }

    protected void handleMapDelete(String[] args) {
        this.getMap().delete(args[1]);
        this.println("true");
    }

    protected void handleMapEvict(String[] args) {
        this.println(this.getMap().evict(args[1]));
    }

    protected void handleMapPutMany(String[] args) {
        int count = 1;
        if (args.length > 1) {
            count = Integer.parseInt(args[1]);
        }
        int b = 100;
        byte[] value = new byte[b];
        if (args.length > 2) {
            b = Integer.parseInt(args[2]);
            value = new byte[b];
        }
        int start = this.getMap().size();
        if (args.length > 3) {
            start = Integer.parseInt(args[3]);
        }
        HashMap<String, byte[]> theMap = new HashMap<String, byte[]>(count);
        for (int i = 0; i < count; ++i) {
            theMap.put("key" + (start + i), value);
        }
        long t0 = Clock.currentTimeMillis();
        this.getMap().putAll(theMap);
        long t1 = Clock.currentTimeMillis();
        if (t1 - t0 > 1L) {
            this.println("size = " + this.getMap().size() + ", " + (long)(count * 1000) / (t1 - t0) + " evt/s, " + (long)(count * 1000) / (t1 - t0) * (long)(b * 8) / 1024L + " Kbit/s, " + count * b / 1024 + " KB added");
        }
    }

    protected void handleMapGetMany(String[] args) {
        int count = 1;
        if (args.length > 1) {
            count = Integer.parseInt(args[1]);
        }
        for (int i = 0; i < count; ++i) {
            this.println(this.getMap().get("key" + i));
        }
    }

    protected void handleMapRemoveMany(String[] args) {
        int count = 1;
        if (args.length > 1) {
            count = Integer.parseInt(args[1]);
        }
        int start = 0;
        if (args.length > 2) {
            start = Integer.parseInt(args[2]);
        }
        long t0 = Clock.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            this.getMap().remove("key" + (start + i));
        }
        long t1 = Clock.currentTimeMillis();
        this.println("size = " + this.getMap().size() + ", " + (long)(count * 1000) / (t1 - t0) + " evt/s");
    }

    protected void handleMapLock(String[] args) {
        this.getMap().lock(args[1]);
        this.println("true");
    }

    protected void handleMapTryLock(String[] args) {
        boolean locked;
        long time;
        String key = args[1];
        long l = time = args.length > 2 ? Long.parseLong(args[2]) : 0L;
        if (time == 0L) {
            locked = this.getMap().tryLock(key);
        } else {
            try {
                locked = this.getMap().tryLock(key, time, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                locked = false;
            }
        }
        this.println(locked);
    }

    protected void handleMapUnlock(String[] args) {
        this.getMap().unlock(args[1]);
        this.println("true");
    }

    protected void handleMapKeys() {
        Set<Object> set = this.getMap().keySet();
        Iterator<Object> it = set.iterator();
        int count = 0;
        while (it.hasNext()) {
            ++count;
            this.println(it.next());
        }
        this.println("Total " + count);
    }

    protected void handleMapEntries() {
        Set<Map.Entry<Object, Object>> set = this.getMap().entrySet();
        Iterator<Map.Entry<Object, Object>> it = set.iterator();
        int count = 0;
        while (it.hasNext()) {
            ++count;
            Map.Entry<Object, Object> entry = it.next();
            this.println(entry.getKey() + ": " + entry.getValue());
        }
        this.println("Total " + count);
    }

    protected void handleMapValues() {
        Collection<Object> set = this.getMap().values();
        Iterator<Object> it = set.iterator();
        int count = 0;
        while (it.hasNext()) {
            ++count;
            this.println(it.next());
        }
        this.println("Total " + count);
    }

    protected void handleMultiMapPut(String[] args) {
        this.println(this.getMultiMap().put(args[1], args[2]));
    }

    protected void handleMultiMapGet(String[] args) {
        this.println(this.getMultiMap().get(args[1]));
    }

    protected void handleMultiMapRemove(String[] args) {
        this.println(this.getMultiMap().remove(args[1]));
    }

    protected void handleMultiMapKeys() {
        Set<Object> set = this.getMultiMap().keySet();
        Iterator<Object> it = set.iterator();
        int count = 0;
        while (it.hasNext()) {
            ++count;
            this.println(it.next());
        }
        this.println("Total " + count);
    }

    protected void handleMultiMapEntries() {
        Set<Map.Entry<Object, Object>> set = this.getMultiMap().entrySet();
        Iterator<Map.Entry<Object, Object>> it = set.iterator();
        int count = 0;
        while (it.hasNext()) {
            ++count;
            Map.Entry<Object, Object> entry = it.next();
            this.println(entry.getKey() + ": " + entry.getValue());
        }
        this.println("Total " + count);
    }

    protected void handleMultiMapValues() {
        Collection<Object> set = this.getMultiMap().values();
        Iterator<Object> it = set.iterator();
        int count = 0;
        while (it.hasNext()) {
            ++count;
            this.println(it.next());
        }
        this.println("Total " + count);
    }

    protected void handleMultiMapLock(String[] args) {
        this.getMultiMap().lock(args[1]);
        this.println("true");
    }

    protected void handleMultiMapTryLock(String[] args) {
        boolean locked;
        long time;
        String key = args[1];
        long l = time = args.length > 2 ? Long.parseLong(args[2]) : 0L;
        if (time == 0L) {
            locked = this.getMultiMap().tryLock(key);
        } else {
            try {
                locked = this.getMultiMap().tryLock(key, time, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                locked = false;
            }
        }
        this.println(locked);
    }

    protected void handleMultiMapUnlock(String[] args) {
        this.getMultiMap().unlock(args[1]);
        this.println("true");
    }

    private void handleStats(String[] args) {
        String iteratorStr = args[0];
        if (iteratorStr.startsWith("m.")) {
            this.println(this.getMap().getLocalMapStats());
        }
    }

    protected void handleLock(String[] args) {
        String lockStr = args[0];
        String name = args[1];
        FencedLock lock = this.client.getCPSubsystem().getLock(name);
        if (StringUtil.equalsIgnoreCase(lockStr, "lock")) {
            lock.lock();
            this.println("true");
        } else if (StringUtil.equalsIgnoreCase(lockStr, "unlock")) {
            lock.unlock();
            this.println("true");
        } else if (StringUtil.equalsIgnoreCase(lockStr, "trylock")) {
            String timeout;
            String string = timeout = args.length > 2 ? args[2] : null;
            if (timeout == null) {
                this.println(lock.tryLock());
            } else {
                long time = Long.parseLong(timeout);
                try {
                    this.println(lock.tryLock(time, TimeUnit.SECONDS));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    protected void handleAddListener(String[] args) {
        String first = args[0];
        if (first.startsWith("s.")) {
            this.getSet().addItemListener(this, true);
        } else if (first.startsWith("m.")) {
            if (args.length > 1) {
                this.getMap().addEntryListener((MapListener)this, args[1], true);
            } else {
                this.getMap().addEntryListener(this, true);
            }
        } else if (first.startsWith("mm.")) {
            if (args.length > 1) {
                this.getMultiMap().addEntryListener(this, args[1], true);
            } else {
                this.getMultiMap().addEntryListener(this, true);
            }
        } else if (first.startsWith("q.")) {
            this.getQueue().addItemListener(this, true);
        } else if (first.startsWith("t.")) {
            this.getTopic().addMessageListener(this);
        } else if (first.startsWith("l.")) {
            this.getList().addItemListener(this, true);
        }
    }

    protected void handleRemoveListener(String[] args) {
    }

    protected void handleSetAdd(String[] args) {
        this.println(this.getSet().add(args[1]));
    }

    protected void handleSetRemove(String[] args) {
        this.println(this.getSet().remove(args[1]));
    }

    protected void handleSetAddMany(String[] args) {
        int count = 1;
        if (args.length > 1) {
            count = Integer.parseInt(args[1]);
        }
        int successCount = 0;
        long t0 = Clock.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            boolean success = this.getSet().add("obj" + i);
            if (!success) continue;
            ++successCount;
        }
        long t1 = Clock.currentTimeMillis();
        this.println("Added " + successCount + " objects.");
        this.println("size = " + this.getSet().size() + ", " + (long)(successCount * 1000) / (t1 - t0) + " evt/s");
    }

    protected void handleSetRemoveMany(String[] args) {
        int count = 1;
        if (args.length > 1) {
            count = Integer.parseInt(args[1]);
        }
        int successCount = 0;
        long t0 = Clock.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            boolean success = this.getSet().remove("obj" + i);
            if (!success) continue;
            ++successCount;
        }
        long t1 = Clock.currentTimeMillis();
        this.println("Removed " + successCount + " objects.");
        this.println("size = " + this.getSet().size() + ", " + (long)(successCount * 1000) / (t1 - t0) + " evt/s");
    }

    protected void handleIterator(String[] args) {
        Iterator<Object> it = null;
        String iteratorStr = args[0];
        if (iteratorStr.startsWith("s.")) {
            it = this.getSet().iterator();
        } else if (iteratorStr.startsWith("m.")) {
            it = this.getMap().keySet().iterator();
        } else if (iteratorStr.startsWith("mm.")) {
            it = this.getMultiMap().keySet().iterator();
        } else if (iteratorStr.startsWith("q.")) {
            it = this.getQueue().iterator();
        } else if (iteratorStr.startsWith("l.")) {
            it = this.getList().iterator();
        }
        if (it != null) {
            boolean remove = false;
            if (args.length > 1) {
                String removeStr = args[1];
                remove = removeStr.equals("remove");
            }
            int count = 1;
            while (it.hasNext()) {
                this.print(count++ + " " + it.next());
                if (remove) {
                    it.remove();
                    this.print(" removed");
                }
                this.println("");
            }
        }
    }

    protected void handleContains(String[] args) {
        String iteratorStr = args[0];
        boolean key = StringUtil.lowerCaseInternal(iteratorStr).endsWith("key");
        String data = args[1];
        boolean result = false;
        if (iteratorStr.startsWith("s.")) {
            result = this.getSet().contains(data);
        } else if (iteratorStr.startsWith("m.")) {
            result = key ? this.getMap().containsKey(data) : this.getMap().containsValue(data);
        } else if (iteratorStr.startsWith("mmm.")) {
            result = key ? this.getMultiMap().containsKey(data) : this.getMultiMap().containsValue(data);
        } else if (iteratorStr.startsWith("q.")) {
            result = this.getQueue().contains(data);
        } else if (iteratorStr.startsWith("l.")) {
            result = this.getList().contains(data);
        }
        this.println("Contains: " + result);
    }

    protected void handleSize(String[] args) {
        int size = 0;
        String iteratorStr = args[0];
        if (iteratorStr.startsWith("s.")) {
            size = this.getSet().size();
        } else if (iteratorStr.startsWith("m.")) {
            size = this.getMap().size();
        } else if (iteratorStr.startsWith("mm.")) {
            size = this.getMultiMap().size();
        } else if (iteratorStr.startsWith("q.")) {
            size = this.getQueue().size();
        } else if (iteratorStr.startsWith("l.")) {
            size = this.getList().size();
        }
        this.println("Size = " + size);
    }

    protected void handleClear(String[] args) {
        String iteratorStr = args[0];
        if (iteratorStr.startsWith("s.")) {
            this.getSet().clear();
        } else if (iteratorStr.startsWith("m.")) {
            this.getMap().clear();
        } else if (iteratorStr.startsWith("mm.")) {
            this.getMultiMap().clear();
        } else if (iteratorStr.startsWith("q.")) {
            this.getQueue().clear();
        } else if (iteratorStr.startsWith("l.")) {
            this.getList().clear();
        }
        this.println("Cleared all.");
    }

    protected void handleDestroy(String[] args) {
        String iteratorStr = args[0];
        if (iteratorStr.startsWith("s.")) {
            this.getSet().destroy();
        } else if (iteratorStr.startsWith("m.")) {
            this.getMap().destroy();
        } else if (iteratorStr.startsWith("mm.")) {
            this.getMultiMap().destroy();
        } else if (iteratorStr.startsWith("q.")) {
            this.getQueue().destroy();
        } else if (iteratorStr.startsWith("l.")) {
            this.getList().destroy();
        } else if (iteratorStr.startsWith("t.")) {
            this.getTopic().destroy();
        }
        this.println("Destroyed!");
    }

    protected void handleQOffer(String[] args) {
        long timeout = 0L;
        if (args.length > 2) {
            timeout = Long.parseLong(args[2]);
        }
        try {
            boolean offered = this.getQueue().offer(args[1], timeout, TimeUnit.SECONDS);
            this.println(offered);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
    }

    protected void handleQTake(String[] args) {
        try {
            this.println(this.getQueue().take());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
    }

    protected void handleQPoll(String[] args) {
        long timeout = 0L;
        if (args.length > 1) {
            timeout = Long.parseLong(args[1]);
        }
        try {
            this.println(this.getQueue().poll(timeout, TimeUnit.SECONDS));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
    }

    protected void handleTopicPublish(String[] args) {
        this.getTopic().publish(args[1]);
    }

    protected void handleQOfferMany(String[] args) {
        int count = 1;
        if (args.length > 1) {
            count = Integer.parseInt(args[1]);
        }
        byte[] value = null;
        if (args.length > 2) {
            value = new byte[Integer.parseInt(args[2])];
        }
        long t0 = Clock.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            if (value == null) {
                this.getQueue().offer("obj");
                continue;
            }
            this.getQueue().offer(value);
        }
        long t1 = Clock.currentTimeMillis();
        this.print("size = " + this.getQueue().size() + ", " + (long)(count * 1000) / (t1 - t0) + " evt/s");
        if (value == null) {
            this.println("");
        } else {
            int b = Integer.parseInt(args[2]);
            this.println(", " + (long)(count * 1000) / (t1 - t0) * (long)(b * 8) / 1024L + " Kbit/s, " + count * b / 1024 + " KB added");
        }
    }

    protected void handleQPollMany(String[] args) {
        int count = 1;
        if (args.length > 1) {
            count = Integer.parseInt(args[1]);
        }
        int c = 1;
        for (int i = 0; i < count; ++i) {
            Object obj = this.getQueue().poll();
            if (obj instanceof byte[]) {
                this.println(c++ + " " + ((byte[])obj).length);
                continue;
            }
            this.println(c++ + " " + obj);
        }
    }

    protected void handleQPeek(String[] args) {
        this.println(this.getQueue().peek());
    }

    protected void handleQCapacity(String[] args) {
        this.println(this.getQueue().remainingCapacity());
    }

    private void execute(String[] args) {
        this.doExecute(false, false, args);
    }

    private void executeOnKey(String[] args) {
        this.doExecute(true, false, args);
    }

    private void executeOnMember(String[] args) {
        this.doExecute(false, true, args);
    }

    private void doExecute(boolean onKey, boolean onMember, String[] args) {
        try {
            Future<String> future;
            IExecutorService executorService = this.client.getExecutorService("default");
            Echo callable = new Echo(args[1]);
            if (onKey) {
                String key = args[2];
                future = executorService.submitToKeyOwner(callable, key);
            } else if (onMember) {
                LinkedList<Member> members;
                int memberIndex = Integer.parseInt(args[2]);
                if (memberIndex >= (members = new LinkedList<Member>(this.client.getCluster().getMembers())).size()) {
                    throw new IndexOutOfBoundsException("Member index: " + memberIndex + " must be smaller than " + members.size());
                }
                Member member = (Member)members.get(memberIndex);
                future = executorService.submitToMember(callable, member);
            } else {
                future = executorService.submit(callable);
            }
            this.println("Result: " + future.get());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private void executeOnMembers(String[] args) {
        try {
            IExecutorService executorService = this.client.getExecutorService("default");
            Echo task = new Echo(args[1]);
            Map<Member, Future<String>> results = executorService.submitToAllMembers(task);
            for (Future<String> f : results.values()) {
                this.println(f.get());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void entryAdded(EntryEvent event) {
        this.println(event);
    }

    @Override
    public void entryRemoved(EntryEvent event) {
        this.println(event);
    }

    @Override
    public void entryUpdated(EntryEvent event) {
        this.println(event);
    }

    @Override
    public void entryEvicted(EntryEvent event) {
        this.println(event);
    }

    @Override
    public void entryExpired(EntryEvent event) {
        this.println(event);
    }

    @Override
    public void mapEvicted(MapEvent event) {
        this.println(event);
    }

    @Override
    public void mapCleared(MapEvent event) {
        this.println(event);
    }

    public void itemAdded(ItemEvent itemEvent) {
        this.println("Item added = " + itemEvent.getItem());
    }

    public void itemRemoved(ItemEvent itemEvent) {
        this.println("Item removed = " + itemEvent.getItem());
    }

    public void onMessage(Message msg) {
        this.println("Topic received = " + msg.getMessageObject());
    }

    protected void handleHelp() {
        boolean silentBefore = this.silent;
        this.silent = false;
        this.printlnBold("Commands:");
        this.printGeneralCommands();
        this.printMapCommands();
        this.printQueueCommands();
        this.printSetCommands();
        this.printLockCommands();
        this.printMulitiMapCommands();
        this.printListCommands();
        this.printAtomicLongCommands();
        this.printExecutorServiceCommands();
        this.silent = silentBefore;
    }

    private void printGeneralCommands() {
        this.printlnBold("General commands:");
        this.println("  echo true|false                         turns on/off echo of commands (default false)");
        this.println("  clear                                   clears the terminal screen");
        this.println("  exit                                    exits from the client console app.");
        this.println("  silent true|false                       turns on/off silent of command output (default false)");
        this.println("  #<number> <command>                     repeats <number> time <command>, replace $i in");
        this.println("                                            <command> with current iteration (0..<number-1>)");
        this.println("  &<number> <command>                     forks <number> threads to execute <command>, replace");
        this.println("                                            $t in <command> with current thread number (0..<number-1>).");
        this.println("                                            When using #x or &x, it is advised to use silent true");
        this.println("                                            as well. When using &x with m.putmany and m.removemany,");
        this.println("                                            each thread will get a different share of keys unless");
        this.println("                                            a start key index is specified.");
        this.println("  history                                 shows the command history of the current session");
        this.println("  jvm                                     displays info about the runtime");
        this.println("  who                                     displays info about the cluster");
        this.println("  ns <string>                             switch the namespace for using the distributed");
        this.println("                                            queue/map/set/list <string> (defaults to \"default\")");
        this.println("  @<file>                                 executes the given <file> script. Use '//' for");
        this.println("                                            comments in the script");
        this.println("");
    }

    private void printQueueCommands() {
        this.printlnBold("Queue commands:");
        this.println("  q.offer <string>                        adds a string object to the queue");
        this.println("  q.poll                                  takes an object from the queue");
        this.println("  q.offermany <number> [<size>]           adds indicated number of string objects to the");
        this.println("                                            queue ('obj<i>' or  byte[<size>]) ");
        this.println("  q.pollmany <number>                     takes indicated number of objects from the queue");
        this.println("  q.iterator [remove]                     iterates the queue, remove if specified");
        this.println("  q.size                                  size of the queue");
        this.println("  q.clear                                 clears the queue");
        this.println("");
    }

    private void printSetCommands() {
        this.printlnBold("Set commands:");
        this.println("  s.add <string>                          adds a string object to the set");
        this.println("  s.remove <string>                       removes the string object from the set");
        this.println("  s.addmany <number>                      adds indicated number of string objects");
        this.println("                                            to the set ('obj<i>')");
        this.println("  s.removemany <number>                   takes indicated number of objects from the set");
        this.println("  s.iterator [remove]                     iterates the set, removes if specified");
        this.println("  s.size                                  size of the set");
        this.println("  s.clear                                 clears the set");
        this.println("");
    }

    private void printLockCommands() {
        this.printlnBold("Lock commands:");
        this.println("  These lock commands demonstrate the usage of Hazelcast's linearizable, distributed, and reentrant");
        this.println("  implementation of Lock. For more information, see `com.hazelcast.cp.lock.FencedLock`.");
        this.println("  lock <name>                             acquires the lock with the given name");
        this.println("  tryLock <name>                          acquires the lock only if it is free at the time");
        this.println("                                            of invocation");
        this.println("  tryLock <name> <time>                   acquires the lock if it is free within the given");
        this.println("                                            waiting time");
        this.println("  unlock <name>                           releases the lock if the lock is currently held");
        this.println("                                            by the current thread");
        this.println("");
    }

    private void printMapCommands() {
        this.printlnBold("Map commands:");
        this.println("  m.put <key> <value>                     puts an entry to the map");
        this.println("  m.remove <key>                          removes the entry of given key from the map");
        this.println("  m.get <key>                             returns the value of given key from the map");
        this.println("  m.putmany <number> [<size>] [<index>]   puts indicated number of entries to the map:");
        this.println("                                            ('key<i>':byte[<size>], <index>+(0..<number>)");
        this.println("  m.removemany <number> [<index>]         removes indicated number of entries from the map");
        this.println("                                            ('key<i>', <index>+(0..<number>)");
        this.println("                                            When using &x with m.putmany and m.removemany, each");
        this.println("                                            thread will get a different share of keys unless a");
        this.println("                                            start key <index> is specified");
        this.println("  m.keys                                  iterates the keys of the map");
        this.println("  m.values                                iterates the values of the map");
        this.println("  m.entries                               iterates the entries of the map");
        this.println("  m.iterator [remove]                     iterates the keys of the map, remove if specified");
        this.println("  m.size                                  size of the map");
        this.println("  m.clear                                 clears the map");
        this.println("  m.destroy                               destroys the map");
        this.println("  m.lock <key>                            locks the key");
        this.println("  m.tryLock <key>                         tries to lock the key and returns immediately");
        this.println("  m.tryLock <key> <time>                  tries to lock the key within given seconds");
        this.println("  m.unlock <key>                          unlocks the key");
        this.println("  m.stats                                 shows the local stats of the map");
        this.println("");
    }

    private void printMulitiMapCommands() {
        this.printlnBold("MultiMap commands:");
        this.println("  mm.put <key> <value>                    puts an entry to the multimap");
        this.println("  mm.get <key>                            returns the value of given key from the multimap");
        this.println("  mm.remove <key>                         removes the entry of given key from the multimap");
        this.println("  mm.size                                 size of the multimap");
        this.println("  mm.clear                                clears the multimap");
        this.println("  mm.destroy                              destroys the multimap");
        this.println("  mm.iterator [remove]                    iterates the keys of the multimap, remove if specified");
        this.println("  mm.keys                                 iterates the keys of the multimap");
        this.println("  mm.values                               iterates the values of the multimap");
        this.println("  mm.entries                              iterates the entries of the multimap");
        this.println("  mm.lock <key>                           locks the key");
        this.println("  mm.tryLock <key>                        tries to lock the key and returns immediately");
        this.println("  mm.tryLock <key> <time>                 tries to lock the key within given seconds");
        this.println("  mm.unlock <key>                         unlocks the key");
        this.println("");
    }

    private void printExecutorServiceCommands() {
        this.printlnBold("Executor Service commands:");
        this.println("  execute <echo-input>                    executes an echo task on random member");
        this.println("  executeOnKey <echo-input> <key>         executes an echo task on the member that");
        this.println("                                            owns the given key");
        this.println("  executeOnMembers <echo-input>           executes an echo task on all of the members");
        this.println("  executeOnMembers <echo-input>           executes an echo task on the member with");
        this.println("                     <memberIndex>          given index");
        this.println("  e<threadcount>.simulateLoad             simulates load on executor with given number");
        this.println("          <task-count> <delaySeconds>       of thread (e1..e16)");
        this.println("");
    }

    private void printAtomicLongCommands() {
        this.printlnBold("IAtomicLong commands:");
        this.println("  a.get                                   gets the current value of atomic long");
        this.println("  a.set <long>                            atomically sets the given value");
        this.println("  a.incrementAndGet                       atomically increment the current value by");
        this.println("                                            one and then gets the resulting value");
        this.println("  a.decrementAndGet                       atomically decrement the current value by");
        this.println("                                            one and then gets the resulting value");
        this.println("");
    }

    private void printListCommands() {
        this.printlnBold("List commands:");
        this.println("  l.add <string>                          adds the given string object to the end of the");
        this.println("                                            list");
        this.println("  l.add <index> <string>                  adds the given string object to the specified");
        this.println("                                             position in the list");
        this.println("  l.contains <string>                     checks whether if the given string presents");
        this.println("                                            in the list");
        this.println("  l.remove <string>                       removes the first occurrence of the given string");
        this.println("  l.remove <index>                        removes the string element from the specified");
        this.println("                                             position of the list");
        this.println("  l.set <index> <string>                  replaces the element at the specified position");
        this.println("                                            with given string");
        this.println("  l.iterator [remove]                     iterates over the items of the list, remove");
        this.println("                                            if specified");
        this.println("  l.size                                  returns the number of element in the list");
        this.println("  l.clear                                 removes all items from the list");
        this.println("");
    }

    public void println(Object obj) {
        if (!this.silent) {
            this.writer.println(obj);
        }
    }

    public void print(Object obj) {
        if (!this.silent) {
            this.writer.print(obj);
        }
    }

    public void printlnBold(Object obj) {
        if (!this.silent) {
            this.writer.println(new AttributedStringBuilder().style(AttributedStyle.BOLD).append((CharSequence)String.valueOf(obj)).toAnsi());
        }
    }

    private static String startPrompt(HazelcastInstance hz) {
        HazelcastClientInstanceImpl hazelcastClientImpl = HazelcastCommandLine.getHazelcastClientInstanceImpl(hz);
        ClientClusterService clientClusterService = hazelcastClientImpl.getClientClusterService();
        MCClusterMetadata clusterMetadata = FutureUtil.getValue(HazelcastCommandLine.getClusterMetadata(hazelcastClientImpl, clientClusterService.getMasterMember()));
        Cluster cluster = hazelcastClientImpl.getCluster();
        Set<Member> members = cluster.getMembers();
        String versionString = "Hazelcast " + clusterMetadata.getMemberVersion();
        return "Hazelcast Console Application has started.\n" + "Connected to " + versionString + " at " + members.iterator().next().getAddress().toString() + " (+" + (members.size() - 1) + " more)\n" + "Type 'help' for instructions";
    }

    public static void run(HazelcastInstance client) {
        ClientConsoleApp clientConsoleApp = new ClientConsoleApp(client);
        clientConsoleApp.start();
    }

    public static void main(String[] args) {
        ClientConsoleApp.run(HazelcastClient.newHazelcastClient());
    }
}

