/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MAccount;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MJournalLine;
import org.compiere.model.MProcessPara;
import org.compiere.model.X_I_GLJournal;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;

@Process
public class ImportGLJournal
extends SvrProcess {
    private int m_AD_Client_ID = 0;
    private int m_AD_Org_ID = 0;
    private int m_C_AcctSchema_ID = 0;
    private Timestamp m_DateAcct = null;
    private boolean m_DeleteOldImported = false;
    private boolean m_IsValidateOnly = false;
    private boolean m_IsImportOnlyNoErrors = true;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Client_ID")) {
                    this.m_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("AD_Org_ID")) {
                    this.m_AD_Org_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("C_AcctSchema_ID")) {
                    this.m_C_AcctSchema_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("DateAcct")) {
                    this.m_DateAcct = (Timestamp)para[i].getParameter();
                } else if (name.equals("IsValidateOnly")) {
                    this.m_IsValidateOnly = "Y".equals(para[i].getParameter());
                } else if (name.equals("IsImportOnlyNoErrors")) {
                    this.m_IsImportOnlyNoErrors = "Y".equals(para[i].getParameter());
                } else if (name.equals("DeleteOldImported")) {
                    this.m_DeleteOldImported = "Y".equals(para[i].getParameter());
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        int noInsertLine;
        int noInsertJournal;
        int noInsert;
        StringBuilder clientCheck;
        int no;
        StringBuilder sql;
        block100: {
            ResultSet rs;
            CPreparedStatement pstmt;
            StringBuilder msglog;
            block98: {
                msglog = new StringBuilder("IsValidateOnly=").append(this.m_IsValidateOnly).append(", IsImportOnlyNoErrors=").append(this.m_IsImportOnlyNoErrors);
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info(msglog.toString());
                }
                sql = null;
                no = 0;
                clientCheck = new StringBuilder(" AND AD_Client_ID=").append(this.m_AD_Client_ID);
                if (this.m_DeleteOldImported) {
                    sql = new StringBuilder("DELETE FROM I_GLJournal ").append("WHERE I_IsImported='Y'").append((CharSequence)clientCheck);
                    no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Delete Old Impored =" + no);
                    }
                }
                sql = new StringBuilder("UPDATE I_GLJournal ").append("SET IsActive = COALESCE (IsActive, 'Y'),").append(" Created = COALESCE (Created, getDate()),").append(" CreatedBy = COALESCE (CreatedBy, 0),").append(" Updated = COALESCE (Updated, getDate()),").append(" UpdatedBy = COALESCE (UpdatedBy, 0),").append(" I_ErrorMsg = ' ',").append(" I_IsImported = 'N' ").append("WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Reset=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET AD_Client_ID=(SELECT c.AD_Client_ID FROM AD_Client c WHERE c.Value=i.ClientValue) ").append("WHERE (AD_Client_ID IS NULL OR AD_Client_ID=0) AND ClientValue IS NOT NULL").append(" AND I_IsImported<>'Y'");
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Client from Value=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal ").append("SET AD_Client_ID = COALESCE (AD_Client_ID,").append(this.m_AD_Client_ID).append("),").append(" AD_OrgDoc_ID = COALESCE (AD_OrgDoc_ID,").append(this.m_AD_Org_ID).append("),");
                if (this.m_C_AcctSchema_ID != 0) {
                    sql.append(" C_AcctSchema_ID = COALESCE (C_AcctSchema_ID,").append(this.m_C_AcctSchema_ID).append("),");
                }
                if (this.m_DateAcct != null) {
                    sql.append(" DateAcct = COALESCE (DateAcct,").append(DB.TO_DATE((Timestamp)this.m_DateAcct)).append("),");
                }
                sql.append(" Updated = COALESCE (Updated, getDate()) ").append("WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Client/DocOrg/Default=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_GLJournal o ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Doc Org, '").append("WHERE (AD_OrgDoc_ID IS NULL OR AD_OrgDoc_ID=0").append(" OR EXISTS (SELECT * FROM AD_Org oo WHERE o.AD_OrgDoc_ID=oo.AD_Org_ID AND (oo.IsSummary='Y' OR oo.IsActive='N')))").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid Doc Org=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET C_AcctSchema_ID=(SELECT a.C_AcctSchema_ID FROM C_AcctSchema a").append(" WHERE i.AcctSchemaName=a.Name AND i.AD_Client_ID=a.AD_Client_ID) ").append("WHERE C_AcctSchema_ID IS NULL AND AcctSchemaName IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set AcctSchema from Name=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET C_AcctSchema_ID=(SELECT c.C_AcctSchema1_ID FROM AD_ClientInfo c WHERE c.AD_Client_ID=i.AD_Client_ID) ").append("WHERE C_AcctSchema_ID IS NULL AND AcctSchemaName IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set AcctSchema from Client=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid AcctSchema, '").append("WHERE (C_AcctSchema_ID IS NULL OR C_AcctSchema_ID=0").append(" OR NOT EXISTS (SELECT * FROM C_AcctSchema a WHERE i.AD_Client_ID=a.AD_Client_ID))").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid AcctSchema=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET DateAcct=getDate() ").append("WHERE DateAcct IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set DateAcct=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET C_DocType_ID=(SELECT d.C_DocType_ID FROM C_DocType d").append(" WHERE d.Name=i.DocTypeName AND d.DocBaseType='GLJ' AND i.AD_Client_ID=d.AD_Client_ID) ").append("WHERE C_DocType_ID IS NULL AND DocTypeName IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set DocType=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid DocType, '").append("WHERE (C_DocType_ID IS NULL OR C_DocType_ID=0").append(" OR NOT EXISTS (SELECT * FROM C_DocType d WHERE i.AD_Client_ID=d.AD_Client_ID AND d.DocBaseType='GLJ'))").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid DocType=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET GL_Category_ID=(SELECT c.GL_Category_ID FROM GL_Category c").append(" WHERE c.Name=i.CategoryName AND i.AD_Client_ID=c.AD_Client_ID) ").append("WHERE GL_Category_ID IS NULL AND CategoryName IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set DocType=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Category, '").append("WHERE (GL_Category_ID IS NULL OR GL_Category_ID=0)").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid GLCategory=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET C_Currency_ID=(SELECT c.C_Currency_ID FROM C_Currency c").append(" WHERE c.ISO_Code=i.ISO_Code AND c.AD_Client_ID IN (0,i.AD_Client_ID)) ").append("WHERE C_Currency_ID IS NULL AND ISO_Code IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Currency from ISO=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET C_Currency_ID=(SELECT a.C_Currency_ID FROM C_AcctSchema a").append(" WHERE a.C_AcctSchema_ID=i.C_AcctSchema_ID AND a.AD_Client_ID=i.AD_Client_ID)").append("WHERE C_Currency_ID IS NULL AND ISO_Code IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Default Currency=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Currency, '").append("WHERE (C_Currency_ID IS NULL OR C_Currency_ID=0)").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid Currency=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET ConversionTypeValue='S' ").append("WHERE C_ConversionType_ID IS NULL AND ConversionTypeValue IS NULL").append(" AND I_IsImported='N'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set CurrencyType Value to Spot =" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET C_ConversionType_ID=(SELECT c.C_ConversionType_ID FROM C_ConversionType c").append(" WHERE c.Value=i.ConversionTypeValue AND c.AD_Client_ID IN (0,i.AD_Client_ID)) ").append("WHERE C_ConversionType_ID IS NULL AND ConversionTypeValue IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set CurrencyType from Value=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid CurrencyType, '").append("WHERE (C_ConversionType_ID IS NULL OR C_ConversionType_ID=0) AND ConversionTypeValue IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid CurrencyTypeValue=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No ConversionType, '").append("WHERE (C_ConversionType_ID IS NULL OR C_ConversionType_ID=0)").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("No CourrencyType=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET CurrencyRate=1").append("WHERE EXISTS (SELECT * FROM C_AcctSchema a").append(" WHERE a.C_AcctSchema_ID=i.C_AcctSchema_ID AND a.C_Currency_ID=i.C_Currency_ID)").append(" AND C_Currency_ID IS NOT NULL AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Home CurrencyRate=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET CurrencyRate=(SELECT MAX(r.MultiplyRate) FROM C_Conversion_Rate r, C_AcctSchema s").append(" WHERE s.C_AcctSchema_ID=i.C_AcctSchema_ID AND s.AD_Client_ID=i.AD_Client_ID").append(" AND r.C_Currency_ID=i.C_Currency_ID AND r.C_Currency_ID_TO=s.C_Currency_ID").append(" AND r.AD_Client_ID=i.AD_Client_ID AND r.AD_Org_ID=i.AD_OrgDoc_ID").append(" AND r.C_ConversionType_ID=i.C_ConversionType_ID").append(" AND i.DateAcct BETWEEN r.ValidFrom AND r.ValidTo ").append(") WHERE CurrencyRate IS NULL OR CurrencyRate=0 AND C_Currency_ID>0").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Org Rate=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET CurrencyRate=(SELECT MAX(r.MultiplyRate) FROM C_Conversion_Rate r, C_AcctSchema s").append(" WHERE s.C_AcctSchema_ID=i.C_AcctSchema_ID AND s.AD_Client_ID=i.AD_Client_ID").append(" AND r.C_Currency_ID=i.C_Currency_ID AND r.C_Currency_ID_TO=s.C_Currency_ID").append(" AND r.AD_Client_ID=i.AD_Client_ID").append(" AND r.C_ConversionType_ID=i.C_ConversionType_ID").append(" AND i.DateAcct BETWEEN r.ValidFrom AND r.ValidTo ").append(") WHERE CurrencyRate IS NULL OR CurrencyRate=0 AND C_Currency_ID>0").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Client Rate=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No Rate, '").append("WHERE CurrencyRate IS NULL OR CurrencyRate=0").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("No Rate=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET C_Period_ID=(SELECT MAX(p.C_Period_ID) FROM C_Period p").append(" INNER JOIN C_Year y ON (y.C_Year_ID=p.C_Year_ID)").append(" INNER JOIN AD_ClientInfo c ON (c.C_Calendar_ID=y.C_Calendar_ID)").append(" WHERE c.AD_Client_ID=i.AD_Client_ID").append(" AND i.DateAcct BETWEEN p.StartDate AND p.EndDate AND p.IsActive='Y' AND p.PeriodType='S') ").append("WHERE C_Period_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Period=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Period, '").append("WHERE C_Period_ID IS NULL OR C_Period_ID NOT IN").append("(SELECT C_Period_ID FROM C_Period p").append(" INNER JOIN C_Year y ON (y.C_Year_ID=p.C_Year_ID)").append(" INNER JOIN AD_ClientInfo c ON (c.C_Calendar_ID=y.C_Calendar_ID) ").append(" WHERE c.AD_Client_ID=i.AD_Client_ID").append(" AND i.DateAcct BETWEEN p.StartDate AND p.EndDate AND p.IsActive='Y' AND p.PeriodType='S')").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid Period=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET I_ErrorMsg=I_ErrorMsg||'WARN=Period Closed, ' ").append("WHERE C_Period_ID IS NOT NULL AND NOT EXISTS").append(" (SELECT * FROM C_PeriodControl pc WHERE pc.C_Period_ID=i.C_Period_ID AND DocBaseType='GLJ' AND PeriodStatus='O') ").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Period Closed=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET PostingType='A' ").append("WHERE PostingType IS NULL AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Actual PostingType=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid PostingType, ' ").append("WHERE PostingType IS NULL OR NOT EXISTS").append(" (SELECT * FROM AD_Ref_List r WHERE r.AD_Reference_ID=125 AND i.PostingType=r.Value)").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid PostingTypee=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET AD_Org_ID=COALESCE((SELECT o.AD_Org_ID FROM AD_Org o").append(" WHERE o.Value=i.OrgValue AND o.IsSummary='N' AND i.AD_Client_ID=o.AD_Client_ID),AD_Org_ID) ").append("WHERE (AD_Org_ID IS NULL OR AD_Org_ID=0) AND OrgValue IS NOT NULL").append(" AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'");
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Org from Value=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET AD_Org_ID=AD_OrgDoc_ID ").append("WHERE (AD_Org_ID IS NULL OR AD_Org_ID=0) AND OrgValue IS NULL AND AD_OrgDoc_ID IS NOT NULL AND AD_OrgDoc_ID<>0").append(" AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Org from Doc Org=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_GLJournal o ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Org, '").append("WHERE (AD_Org_ID IS NULL OR AD_Org_ID=0").append(" OR EXISTS (SELECT * FROM AD_Org oo WHERE o.AD_Org_ID=oo.AD_Org_ID AND (oo.IsSummary='Y' OR oo.IsActive='N')))").append(" AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid Org=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET Account_ID=(SELECT MAX(ev.C_ElementValue_ID) FROM C_ElementValue ev").append(" INNER JOIN C_Element e ON (e.C_Element_ID=ev.C_Element_ID)").append(" INNER JOIN C_AcctSchema_Element ase ON (e.C_Element_ID=ase.C_Element_ID AND ase.ElementType='AC')").append(" WHERE ev.Value=i.AccountValue AND ev.IsSummary='N'").append(" AND i.C_AcctSchema_ID=ase.C_AcctSchema_ID AND i.AD_Client_ID=ev.AD_Client_ID) ").append("WHERE Account_ID IS NULL AND AccountValue IS NOT NULL").append(" AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Account from Value=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Account, '").append("WHERE (Account_ID IS NULL OR Account_ID=0)").append(" AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid Account=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET C_BPartner_ID=(SELECT bp.C_BPartner_ID FROM C_BPartner bp").append(" WHERE bp.Value=i.BPartnerValue AND bp.IsSummary='N' AND i.AD_Client_ID=bp.AD_Client_ID) ").append("WHERE C_BPartner_ID IS NULL AND BPartnerValue IS NOT NULL").append(" AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set BPartner from Value=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid BPartner, '").append("WHERE C_BPartner_ID IS NULL AND BPartnerValue IS NOT NULL").append(" AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid BPartner=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET M_Product_ID=(SELECT MAX(p.M_Product_ID) FROM M_Product p").append(" WHERE (p.Value=i.ProductValue OR p.UPC=i.UPC OR p.SKU=i.SKU)").append(" AND p.IsSummary='N' AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_Product_ID IS NULL AND (ProductValue IS NOT NULL OR UPC IS NOT NULL OR SKU IS NOT NULL)").append(" AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Product from Value=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Product, '").append("WHERE M_Product_ID IS NULL AND (ProductValue IS NOT NULL OR UPC IS NOT NULL OR SKU IS NOT NULL)").append(" AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid Product=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET C_Project_ID=(SELECT p.C_Project_ID FROM C_Project p").append(" WHERE p.Value=i.ProjectValue AND p.IsSummary='N' AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE C_Project_ID IS NULL AND ProjectValue IS NOT NULL").append(" AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Project from Value=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Project, '").append("WHERE C_Project_ID IS NULL AND ProjectValue IS NOT NULL").append(" AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid Project=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET C_Campaign_ID=(SELECT p.C_Campaign_ID FROM C_Campaign p").append(" WHERE p.Value=i.CampaignValue AND p.IsSummary='N' AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE C_Campaign_ID IS NULL AND CampaignValue IS NOT NULL").append(" AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Campaign from Value=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Campaign, '").append("WHERE C_Campaign_ID IS NULL AND CampaignValue IS NOT NULL").append(" AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid Campaign=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET C_Activity_ID=(SELECT p.C_Activity_ID FROM C_Activity p").append(" WHERE p.Value=i.ActivityValue AND p.IsSummary='N' AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE C_Activity_ID IS NULL AND ActivityValue IS NOT NULL").append(" AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Activity from Value=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Activity, '").append("WHERE C_Activity_ID IS NULL AND ActivityValue IS NOT NULL").append(" AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid Activity=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET C_SalesRegion_ID=(SELECT p.C_SalesRegion_ID FROM C_SalesRegion p").append(" WHERE p.Value=i.SalesRegionValue AND p.IsSummary='N' AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE C_SalesRegion_ID IS NULL AND SalesRegionValue IS NOT NULL").append(" AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set SalesRegion from Value=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid SalesRegion, '").append("WHERE C_SalesRegion_ID IS NULL AND SalesRegionValue IS NOT NULL").append(" AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid SalesRegion=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET AD_OrgTrx_ID=(SELECT o.AD_Org_ID FROM AD_Org o").append(" WHERE o.Value=i.OrgTrxValue AND o.IsSummary='N' AND i.AD_Client_ID=o.AD_Client_ID) ").append("WHERE AD_OrgTrx_ID IS NULL AND OrgTrxValue IS NOT NULL").append(" AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set OrgTrx from Value=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid OrgTrx, '").append("WHERE AD_OrgTrx_ID IS NULL AND OrgTrxValue IS NOT NULL").append(" AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid OrgTrx=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal ").append("SET AmtSourceDr = 0 ").append("WHERE AmtSourceDr IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set 0 Source Dr=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal ").append("SET AmtSourceCr = 0 ").append("WHERE AmtSourceCr IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set 0 Source Cr=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET I_ErrorMsg=I_ErrorMsg||'WARN=Zero Source Balance, ' ").append("WHERE (AmtSourceDr-AmtSourceCr)=0").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Zero Source Balance=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal ").append("SET AmtAcctDr = ROUND(AmtSourceDr * CurrencyRate, 2) ").append("WHERE AmtAcctDr IS NULL OR AmtAcctDr=0").append(" AND I_IsImported='N'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Calculate Acct Dr=" + no);
                }
                sql = new StringBuilder("UPDATE I_GLJournal ").append("SET AmtAcctCr = ROUND(AmtSourceCr * CurrencyRate, 2) ").append("WHERE AmtAcctCr IS NULL OR AmtAcctCr=0").append(" AND I_IsImported='N'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Calculate Acct Cr=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_GLJournal i ").append("SET I_ErrorMsg=I_ErrorMsg||'WARN=Zero Acct Balance, ' ").append("WHERE (AmtSourceDr-AmtSourceCr)<>0 AND (AmtAcctDr-AmtAcctCr)=0").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Zero Acct Balance=" + no);
                }
                sql = new StringBuilder("SELECT SUM(AmtSourceDr)-SUM(AmtSourceCr), SUM(AmtAcctDr)-SUM(AmtAcctCr) ").append("FROM I_GLJournal ").append("WHERE I_IsImported='N'").append((CharSequence)clientCheck);
                pstmt = null;
                rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            BigDecimal source = rs.getBigDecimal(1);
                            BigDecimal acct = rs.getBigDecimal(2);
                            if (source != null && source.signum() == 0 && acct != null && acct.signum() == 0) {
                                if (this.log.isLoggable(Level.INFO)) {
                                    this.log.info("Import Balance = 0");
                                }
                            } else {
                                msglog = new StringBuilder("Balance Source=").append(source).append(", Acct=").append(acct);
                                this.log.warning(msglog.toString());
                            }
                            if (source != null) {
                                this.addLog(0, null, source, "@AmtSourceDr@ - @AmtSourceCr@");
                            }
                            if (acct != null) {
                                this.addLog(0, null, acct, "@AmtAcctDr@ - @AmtAcctCr@");
                            }
                        }
                    }
                    catch (SQLException ex) {
                        this.log.log(Level.SEVERE, sql.toString(), (Throwable)ex);
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block98;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            this.commitEx();
            StringBuilder msgdb = new StringBuilder("SELECT COUNT(*) FROM I_GLJournal WHERE I_IsImported NOT IN ('Y','N')").append((CharSequence)clientCheck);
            int errors = DB.getSQLValue((String)this.get_TrxName(), (String)msgdb.toString());
            if (errors != 0) {
                if (this.m_IsValidateOnly || this.m_IsImportOnlyNoErrors) {
                    throw new Exception("@Errors@=" + errors);
                }
            } else if (this.m_IsValidateOnly) {
                StringBuilder msgreturn = new StringBuilder("@Errors@=").append(errors);
                return msgreturn.toString();
            }
            msglog = new StringBuilder("Validation Errors=").append(errors);
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info(msglog.toString());
            }
            noInsert = 0;
            noInsertJournal = 0;
            noInsertLine = 0;
            MJournalBatch batch = null;
            String BatchDocumentNo = "";
            MJournal journal = null;
            String JournalDocumentNo = "";
            Timestamp DateAcct = null;
            boolean wasCreateNewBatch = false;
            sql = new StringBuilder("SELECT * FROM I_GLJournal ").append("WHERE I_IsImported='N'").append((CharSequence)clientCheck).append(" ORDER BY NVL(BatchDocumentNo, I_GLJournal_ID||' '), NVL(JournalDocumentNo, ").append("I_GLJournal_ID||' '), C_AcctSchema_ID, PostingType, C_DocType_ID, GL_Category_ID, ").append("C_Currency_ID, TRUNC(DateAcct), Line, I_GLJournal_ID");
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        String impJournalDocumentNo;
                        X_I_GLJournal imp = new X_I_GLJournal(this.getCtx(), rs, this.get_TrxName());
                        String impBatchDocumentNo = imp.getBatchDocumentNo();
                        if (impBatchDocumentNo == null) {
                            impBatchDocumentNo = "";
                        }
                        if (imp.isCreateNewBatch() || journal != null && journal.getC_AcctSchema_ID() != imp.getC_AcctSchema_ID() || imp.getBatchDocumentNo() == null && !wasCreateNewBatch || !BatchDocumentNo.equals(impBatchDocumentNo)) {
                            batch = null;
                        }
                        if (imp.isCreateNewBatch()) {
                            wasCreateNewBatch = true;
                        }
                        if (imp.isCreateNewBatch() || batch == null && imp.getBatchDocumentNo() != null) {
                            BatchDocumentNo = impBatchDocumentNo;
                            batch = new MJournalBatch(this.getCtx(), 0, this.get_TrxName());
                            batch.setClientOrg(imp.getAD_Client_ID(), imp.getAD_OrgDoc_ID());
                            if (imp.getBatchDocumentNo() != null && imp.getBatchDocumentNo().length() > 0) {
                                batch.setDocumentNo(imp.getBatchDocumentNo());
                            }
                            batch.setC_DocType_ID(imp.getC_DocType_ID());
                            batch.setPostingType(imp.getPostingType());
                            StringBuilder description = imp.getBatchDescription() == null || imp.getBatchDescription().toString().length() == 0 ? new StringBuilder("*Import-") : new StringBuilder(imp.getBatchDescription()).append(" *Import-");
                            description.append(new Timestamp(System.currentTimeMillis()));
                            batch.setDescription(description.toString());
                            if (!batch.save()) {
                                this.log.log(Level.SEVERE, "Batch not saved");
                                Exception ex = CLogger.retrieveException();
                                if (ex != null) {
                                    this.addLog(0, null, null, ex.getLocalizedMessage());
                                    throw ex;
                                }
                                break;
                            }
                            ++noInsert;
                            journal = null;
                        }
                        if ((impJournalDocumentNo = imp.getJournalDocumentNo()) == null) {
                            impJournalDocumentNo = "";
                        }
                        Timestamp impDateAcct = TimeUtil.getDay((Timestamp)imp.getDateAcct());
                        if (journal == null || imp.isCreateNewJournal() || !JournalDocumentNo.equals(impJournalDocumentNo) || journal.getC_DocType_ID() != imp.getC_DocType_ID() || journal.getGL_Category_ID() != imp.getGL_Category_ID() || !journal.getPostingType().equals(imp.getPostingType()) || journal.getC_Currency_ID() != imp.getC_Currency_ID() || !impDateAcct.equals(DateAcct)) {
                            JournalDocumentNo = impJournalDocumentNo;
                            DateAcct = impDateAcct;
                            journal = new MJournal(this.getCtx(), 0, this.get_TrxName());
                            if (batch != null) {
                                journal.setGL_JournalBatch_ID(batch.getGL_JournalBatch_ID());
                            }
                            journal.setClientOrg(imp.getAD_Client_ID(), imp.getAD_OrgDoc_ID());
                            String description = imp.getBatchDescription();
                            if (description == null || description.length() == 0) {
                                description = "(Import)";
                            }
                            journal.setDescription(description);
                            if (imp.getJournalDocumentNo() != null && imp.getJournalDocumentNo().length() > 0) {
                                journal.setDocumentNo(imp.getJournalDocumentNo());
                            }
                            journal.setC_AcctSchema_ID(imp.getC_AcctSchema_ID());
                            journal.setC_DocType_ID(imp.getC_DocType_ID());
                            journal.setGL_Category_ID(imp.getGL_Category_ID());
                            journal.setPostingType(imp.getPostingType());
                            journal.setGL_Budget_ID(imp.getGL_Budget_ID());
                            journal.setCurrency(imp.getC_Currency_ID(), imp.getC_ConversionType_ID(), imp.getCurrencyRate());
                            journal.setC_Period_ID(imp.getC_Period_ID());
                            journal.setDateAcct(imp.getDateAcct());
                            journal.setDateDoc(imp.getDateAcct());
                            if (!journal.save()) {
                                this.log.log(Level.SEVERE, "Journal not saved");
                                Exception ex = CLogger.retrieveException();
                                if (ex != null) {
                                    this.addLog(0, null, null, ex.getLocalizedMessage());
                                    throw ex;
                                }
                                break;
                            }
                            ++noInsertJournal;
                        }
                        MJournalLine line = new MJournalLine(journal);
                        line.setDescription(imp.getDescription());
                        line.setCurrency(imp.getC_Currency_ID(), imp.getC_ConversionType_ID(), imp.getCurrencyRate());
                        if (imp.getC_ValidCombination_ID() == 0) {
                            MAccount acct = MAccount.get((Properties)this.getCtx(), (int)imp.getAD_Client_ID(), (int)imp.getAD_Org_ID(), (int)imp.getC_AcctSchema_ID(), (int)imp.getAccount_ID(), (int)0, (int)imp.getM_Product_ID(), (int)imp.getC_BPartner_ID(), (int)imp.getAD_OrgTrx_ID(), (int)imp.getC_LocFrom_ID(), (int)imp.getC_LocTo_ID(), (int)imp.getC_SalesRegion_ID(), (int)imp.getC_Project_ID(), (int)imp.getC_Campaign_ID(), (int)imp.getC_Activity_ID(), (int)imp.getUser1_ID(), (int)imp.getUser2_ID(), (int)0, (int)0, (String)this.get_TrxName());
                            if (acct != null && acct.get_ID() == 0) {
                                acct.saveEx();
                            }
                            if (acct == null || acct.get_ID() == 0) {
                                imp.setI_ErrorMsg("ERROR creating Account");
                                imp.setI_IsImported(false);
                                imp.saveEx();
                                continue;
                            }
                            line.setC_ValidCombination_ID(acct.get_ID());
                            imp.setC_ValidCombination_ID(acct.get_ID());
                        } else {
                            line.setC_ValidCombination_ID(imp.getC_ValidCombination_ID());
                        }
                        line.setLine(imp.getLine());
                        line.setAmtSourceCr(imp.getAmtSourceCr());
                        line.setAmtSourceDr(imp.getAmtSourceDr());
                        line.setAmtAcct(imp.getAmtAcctDr(), imp.getAmtAcctCr());
                        line.setDateAcct(imp.getDateAcct());
                        line.setC_UOM_ID(imp.getC_UOM_ID());
                        line.setQty(imp.getQty());
                        if (!line.save()) continue;
                        if (batch != null) {
                            imp.setGL_JournalBatch_ID(batch.getGL_JournalBatch_ID());
                        }
                        imp.setGL_Journal_ID(journal.getGL_Journal_ID());
                        imp.setGL_JournalLine_ID(line.getGL_JournalLine_ID());
                        imp.setI_IsImported(true);
                        imp.setProcessed(true);
                        if (!imp.save()) continue;
                        ++noInsertLine;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "", (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block100;
                }
            }
            catch (Throwable throwable) {
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        sql = new StringBuilder("UPDATE I_GLJournal ").append("SET I_IsImported='N', Updated=getDate() ").append("WHERE I_IsImported<>'Y'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsert), "@GL_JournalBatch_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noInsertJournal), "@GL_Journal_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noInsertLine), "@GL_JournalLine_ID@: @Inserted@");
        return "";
    }
}

