/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.Adempiere;
import org.compiere.model.MCity;
import org.compiere.model.MCurrency;
import org.compiere.model.MProcessPara;
import org.compiere.model.MSetup;
import org.compiere.model.MSysConfig;
import org.compiere.print.PrintUtil;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;

@Process
public class InitialClientSetup
extends SvrProcess {
    private String p_ClientName = null;
    private String p_OrgValue = null;
    private String p_OrgName = null;
    private String p_AdminUserName = null;
    private String p_NormalUserName = null;
    private boolean p_IsSetInitialPassword = true;
    private int p_C_Currency_ID = 0;
    private int p_C_Country_ID = 0;
    private int p_C_Region_ID = 0;
    private String p_CityName = null;
    private String p_Postal = null;
    private String p_Address1 = null;
    private String p_Phone = null;
    private String p_Phone2 = null;
    private String p_Fax = null;
    private String p_EMail = null;
    private String p_TaxID = null;
    private int p_C_City_ID = 0;
    private boolean p_IsUseBPDimension = true;
    private boolean p_IsUseProductDimension = true;
    private boolean p_IsUseProjectDimension = false;
    private boolean p_IsUseCampaignDimension = false;
    private boolean p_IsUseSalesRegionDimension = false;
    private boolean p_IsUseActivityDimension;
    private boolean p_UseDefaultCoA = false;
    private String p_CoAFile = null;
    private boolean p_InactivateDefaults = false;
    private String p_AdminUserEmail = null;
    private String p_NormalUserEmail = null;
    public static final int WINDOW_THIS_PROCESS = 9999;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("ClientName")) {
                    this.p_ClientName = (String)para[i].getParameter();
                } else if (name.equals("OrgValue")) {
                    this.p_OrgValue = (String)para[i].getParameter();
                } else if (name.equals("OrgName")) {
                    this.p_OrgName = (String)para[i].getParameter();
                } else if (name.equals("AdminUserName")) {
                    this.p_AdminUserName = (String)para[i].getParameter();
                } else if (name.equals("NormalUserName")) {
                    this.p_NormalUserName = (String)para[i].getParameter();
                } else if (name.equals("IsSetInitialPassword")) {
                    this.p_IsSetInitialPassword = para[i].getParameterAsBoolean();
                } else if (name.equals("C_Currency_ID")) {
                    this.p_C_Currency_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_Country_ID")) {
                    this.p_C_Country_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_Region_ID")) {
                    this.p_C_Region_ID = para[i].getParameterAsInt();
                } else if (name.equals("CityName")) {
                    this.p_CityName = (String)para[i].getParameter();
                } else if (name.equals("C_City_ID")) {
                    this.p_C_City_ID = para[i].getParameterAsInt();
                } else if (name.equals("Postal")) {
                    this.p_Postal = (String)para[i].getParameter();
                } else if (name.equals("Address1")) {
                    this.p_Address1 = (String)para[i].getParameter();
                } else if (name.equals("IsUseBPDimension")) {
                    this.p_IsUseBPDimension = para[i].getParameterAsBoolean();
                } else if (name.equals("IsUseProductDimension")) {
                    this.p_IsUseProductDimension = para[i].getParameterAsBoolean();
                } else if (name.equals("IsUseProjectDimension")) {
                    this.p_IsUseProjectDimension = para[i].getParameterAsBoolean();
                } else if (name.equals("IsUseCampaignDimension")) {
                    this.p_IsUseCampaignDimension = para[i].getParameterAsBoolean();
                } else if (name.equals("IsUseSalesRegionDimension")) {
                    this.p_IsUseSalesRegionDimension = para[i].getParameterAsBoolean();
                } else if (name.equals("IsUseActivityDimension")) {
                    this.p_IsUseActivityDimension = para[i].getParameterAsBoolean();
                } else if (name.equals("UseDefaultCoA")) {
                    this.p_UseDefaultCoA = para[i].getParameterAsBoolean();
                } else if (name.equals("CoAFile")) {
                    this.p_CoAFile = (String)para[i].getParameter();
                } else if (name.equals("InactivateDefaults")) {
                    this.p_InactivateDefaults = para[i].getParameterAsBoolean();
                } else if (name.equals("Phone")) {
                    this.p_Phone = (String)para[i].getParameter();
                } else if (name.equals("Phone2")) {
                    this.p_Phone2 = (String)para[i].getParameter();
                } else if (name.equals("Fax")) {
                    this.p_Fax = (String)para[i].getParameter();
                } else if (name.equals("EMail")) {
                    this.p_EMail = (String)para[i].getParameter();
                } else if (name.equals("TaxID")) {
                    this.p_TaxID = (String)para[i].getParameter();
                } else if (name.equals("AdminUserEmail")) {
                    this.p_AdminUserEmail = (String)para[i].getParameter();
                } else if (name.equals("NormalUserEmail")) {
                    this.p_NormalUserEmail = (String)para[i].getParameter();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        File coaFile;
        boolean email_login;
        MCity city;
        boolean isDryRun = "Y".equalsIgnoreCase(Env.getContext((Properties)Env.getCtx(), (String)"#RUNNING_UNIT_TESTING_TEST_CASE"));
        StringBuilder msglog = new StringBuilder("InitialClientSetup").append(": ClientName=").append(this.p_ClientName).append(", OrgValue=").append(this.p_OrgValue).append(", OrgName=").append(this.p_OrgName).append(", AdminUserName=").append(this.p_AdminUserName).append(", NormalUserName=").append(this.p_NormalUserName).append(", IsSetInitialPassword=").append(this.p_IsSetInitialPassword).append(", C_Currency_ID=").append(this.p_C_Currency_ID).append(", C_Country_ID=").append(this.p_C_Country_ID).append(", C_Region_ID=").append(this.p_C_Region_ID).append(", CityName=").append(this.p_CityName).append(", C_City_ID=").append(this.p_C_City_ID).append(", IsUseBPDimension=").append(this.p_IsUseBPDimension).append(", IsUseProductDimension=").append(this.p_IsUseProductDimension).append(", IsUseProjectDimension=").append(this.p_IsUseProjectDimension).append(", IsUseCampaignDimension=").append(this.p_IsUseCampaignDimension).append(", IsUseSalesRegionDimension=").append(this.p_IsUseSalesRegionDimension).append(", IsUseActivityDimension=").append(this.p_IsUseActivityDimension).append(", UseDefaultCoA=").append(this.p_UseDefaultCoA).append(", InactivateDefaults=").append(this.p_InactivateDefaults).append(", CoAFile=").append(this.p_CoAFile);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(msglog.toString());
        }
        if (this.p_UseDefaultCoA) {
            this.p_CoAFile = null;
        }
        if (this.p_ClientName == null || this.p_ClientName.length() == 0 || this.p_OrgName == null || this.p_OrgName.length() == 0 || this.p_AdminUserName == null || this.p_AdminUserName.length() == 0 || this.p_NormalUserName == null || this.p_NormalUserName.length() == 0 || this.p_C_Currency_ID <= 0 || this.p_C_Country_ID <= 0 || !this.p_UseDefaultCoA && (this.p_CoAFile == null || this.p_CoAFile.length() == 0)) {
            throw new IllegalArgumentException(Msg.getMsg((Properties)Env.getCtx(), (String)"Missing required parameters"));
        }
        if (DB.getSQLValueEx(null, (String)"SELECT COUNT(*) FROM AD_Client WHERE Name=?", (Object[])new Object[]{this.p_ClientName}) != 0) {
            throw new AdempiereException(Msg.parseTranslation((Properties)this.getCtx(), (String)("@NotUnique@ @ClientName@ = " + this.p_ClientName)));
        }
        if (DB.getSQLValueEx(null, (String)"SELECT COUNT(*) FROM AD_Client WHERE Value=?", (Object[])new Object[]{this.p_ClientName}) != 0) {
            throw new AdempiereException(Msg.parseTranslation((Properties)this.getCtx(), (String)("@NotUnique@ @ClientValue@ = " + this.p_ClientName)));
        }
        if (DB.getSQLValueEx(null, (String)"SELECT COUNT(*) FROM AD_Client WHERE LoginPrefix=?", (Object[])new Object[]{this.p_ClientName}) != 0) {
            throw new AdempiereException(Msg.parseTranslation((Properties)this.getCtx(), (String)("@NotUnique@ @LoginPrefix@ = " + this.p_ClientName)));
        }
        if (DB.getSQLValueEx(null, (String)"SELECT COUNT(*) FROM AD_User WHERE Name=?", (Object[])new Object[]{this.p_AdminUserName}) != 0) {
            throw new AdempiereException(Msg.parseTranslation((Properties)this.getCtx(), (String)("@NotUnique@ @AdminUserName@ = " + this.p_AdminUserName)));
        }
        if (DB.getSQLValueEx(null, (String)"SELECT COUNT(*) FROM AD_User WHERE Name=?", (Object[])new Object[]{this.p_NormalUserName}) != 0) {
            throw new AdempiereException(Msg.parseTranslation((Properties)this.getCtx(), (String)("@NotUnique@ @NormalUserName@ = " + this.p_NormalUserName)));
        }
        if (this.p_C_City_ID > 0 && !(city = MCity.get((Properties)this.getCtx(), (int)this.p_C_City_ID)).getName().equals(this.p_CityName)) {
            msglog = new StringBuilder("City name changed from ").append(this.p_CityName).append(" to ").append(city.getName());
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info(msglog.toString());
            }
            this.p_CityName = city.getName();
        }
        if (email_login = MSysConfig.getBooleanValue((String)"USE_EMAIL_FOR_LOGIN", (boolean)false)) {
            if (Util.isEmpty((String)this.p_AdminUserEmail)) {
                throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"AdminUserEmail is required"));
            }
            if (!EMail.validate((String)this.p_AdminUserEmail)) {
                throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"AdminUserEmail") + " " + this.p_AdminUserEmail + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"is incorrect"));
            }
            if (Util.isEmpty((String)this.p_NormalUserEmail)) {
                throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"NormalUserEmail is required"));
            }
            if (!EMail.validate((String)this.p_NormalUserEmail)) {
                throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"NormalUserEmail") + " " + this.p_NormalUserEmail + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"is incorrect"));
            }
        }
        if (Util.isEmpty((String)this.p_CoAFile, (boolean)true)) {
            this.p_CoAFile = MSysConfig.getValue((String)"DEFAULT_COA_PATH", (String)(Adempiere.getAdempiereHome() + File.separator + "data" + File.separator + "import" + File.separator + "AccountingDefaultsOnly.csv"));
        }
        if (!(coaFile = new File(this.p_CoAFile)).exists()) {
            throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"CoaFile") + " " + this.p_CoAFile + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"does not exist"));
        }
        if (!coaFile.canRead()) {
            throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"Cannot read CoaFile") + " " + this.p_CoAFile);
        }
        if (!coaFile.isFile()) {
            throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"CoaFile") + " " + this.p_CoAFile + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"is not a file"));
        }
        if (coaFile.length() <= 0L) {
            throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"CoaFile") + " " + this.p_CoAFile + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"is empty"));
        }
        MSetup ms = new MSetup(Env.getCtx(), 9999, isDryRun);
        try {
            if (!ms.createClient(this.p_ClientName, this.p_OrgValue, this.p_OrgName, this.p_AdminUserName, this.p_NormalUserName, this.p_Phone, this.p_Phone2, this.p_Fax, this.p_EMail, this.p_TaxID, this.p_AdminUserEmail, this.p_NormalUserEmail, this.p_IsSetInitialPassword)) {
                ms.rollback();
                throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"Create client failed"));
            }
            this.addLog(ms.getInfo());
            MCurrency currency = MCurrency.get((Properties)this.getCtx(), (int)this.p_C_Currency_ID);
            KeyNamePair currency_kp = new KeyNamePair(this.p_C_Currency_ID, currency.getDescription());
            if (!ms.createAccounting(currency_kp, this.p_IsUseProductDimension, this.p_IsUseBPDimension, this.p_IsUseProjectDimension, this.p_IsUseCampaignDimension, this.p_IsUseSalesRegionDimension, this.p_IsUseActivityDimension, coaFile, this.p_UseDefaultCoA, this.p_InactivateDefaults)) {
                ms.rollback();
                throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"AccountSetupError"));
            }
            if (!ms.createEntities(this.p_C_Country_ID, this.p_CityName, this.p_C_Region_ID, this.p_C_Currency_ID, this.p_Postal, this.p_Address1)) {
                ms.rollback();
                throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"AccountSetupError"));
            }
            this.addLog(ms.getInfo());
            PrintUtil.setupPrintForm((int)ms.getAD_Client_ID(), (String)(isDryRun ? ms.getTrxName() : null));
            if (isDryRun) {
                ms.rollback();
            }
        }
        catch (Exception e) {
            ms.rollback();
            throw e;
        }
        return "@OK@";
    }
}

