/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.calendar.event;

import java.util.Date;
import java.util.TimeZone;
import org.zkoss.calendar.Calendars;
import org.zkoss.calendar.api.CalendarEvent;
import org.zkoss.calendar.impl.Util;
import org.zkoss.json.JSONArray;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuSetAttribute;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.util.Clients;

public class CalendarsEvent
extends Event {
    private static final long serialVersionUID = 20090331171731L;
    public static final String ON_EVENT_CREATE = "onEventCreate";
    public static final String ON_EVENT_EDIT = "onEventEdit";
    public static final String ON_EVENT_UPDATE = "onEventUpdate";
    public static final String ON_DAY_CLICK = "onDayClick";
    public static final String ON_WEEK_CLICK = "onWeekClick";
    public static final String ON_EVENT_TOOLTIP = "onEventTooltip";
    private Date _beginDate;
    private Date _endDate;
    private CalendarEvent _ce;
    private final int _x;
    private final int _y;
    private final int _dtwd;
    private final int _dthgh;

    public CalendarsEvent(String name, Component target, CalendarEvent ce, Date beginDate, Date endDate, int x, int y, int dtwd, int dthgh) {
        super(name, target);
        this._ce = ce;
        this._beginDate = beginDate;
        this._endDate = endDate;
        this._x = x;
        this._y = y;
        this._dtwd = dtwd;
        this._dthgh = dthgh;
        this.clear(target, true);
    }

    public static CalendarsEvent getCreateEvent(AuRequest request) {
        JSONArray data = (JSONArray)request.getData().get("data");
        Calendars cmp = CalendarsEvent.verifyEvent(request, data, 6);
        TimeZone tz = cmp.getDefaultTimeZone();
        Date eventBegin = Util.fixDSTTime(tz, new Date(CalendarsEvent.getLong(data.get(0))));
        Date eventEnd = Util.fixDSTTime(tz, new Date(CalendarsEvent.getLong(data.get(1))));
        return new CalendarsEvent(ON_EVENT_CREATE, (Component)cmp, null, eventBegin, eventEnd, CalendarsEvent.getInt(data.get(2)), CalendarsEvent.getInt(data.get(3)), CalendarsEvent.getInt(data.get(4)), CalendarsEvent.getInt(data.get(5)));
    }

    public static CalendarsEvent getEditEvent(AuRequest request) {
        JSONArray data = (JSONArray)request.getData().get("data");
        Calendars cmp = CalendarsEvent.verifyEvent(request, data, 5);
        CalendarEvent ce = cmp.getCalendarEventById(String.valueOf(data.get(0)));
        if (ce == null) {
            return null;
        }
        return new CalendarsEvent(ON_EVENT_EDIT, (Component)cmp, ce, null, null, CalendarsEvent.getInt(data.get(1)), CalendarsEvent.getInt(data.get(2)), CalendarsEvent.getInt(data.get(3)), CalendarsEvent.getInt(data.get(4)));
    }

    public static CalendarsEvent getUpdateEvent(AuRequest request) {
        JSONArray data = (JSONArray)request.getData().get("data");
        Calendars cmp = CalendarsEvent.verifyEvent(request, data, 7);
        CalendarEvent ce = cmp.getCalendarEventById(String.valueOf(data.get(0)));
        if (ce == null) {
            return null;
        }
        TimeZone tz = cmp.getDefaultTimeZone();
        Date eventBegin = Util.fixDSTTime(tz, new Date(CalendarsEvent.getLong(data.get(1))));
        Date eventEnd = Util.fixDSTTime(tz, new Date(CalendarsEvent.getLong(data.get(2))));
        return new CalendarsEvent(ON_EVENT_UPDATE, (Component)cmp, ce, eventBegin, eventEnd, CalendarsEvent.getInt(data.get(3)), CalendarsEvent.getInt(data.get(4)), CalendarsEvent.getInt(data.get(5)), CalendarsEvent.getInt(data.get(6)));
    }

    public static Event getClickEvent(AuRequest request, String cmd) {
        JSONArray data = (JSONArray)request.getData().get("data");
        Calendars cmp = CalendarsEvent.verifyEvent(request, data, 1);
        return new Event(cmd, (Component)cmp, (Object)Util.fixDSTTime(cmp.getDefaultTimeZone(), new Date(CalendarsEvent.getLong(data.get(0)))));
    }

    public static Event getTooltipEvent(AuRequest request) {
        JSONArray data = (JSONArray)request.getData().get("data");
        Calendars cmp = CalendarsEvent.verifyEvent(request, data, 5);
        CalendarEvent ce = cmp.getCalendarEventById(String.valueOf(data.get(0)));
        if (ce == null) {
            return null;
        }
        return new CalendarsEvent(ON_EVENT_TOOLTIP, (Component)cmp, ce, null, null, CalendarsEvent.getInt(data.get(1)), CalendarsEvent.getInt(data.get(2)), CalendarsEvent.getInt(data.get(3)), CalendarsEvent.getInt(data.get(4)));
    }

    private static int getInt(Object obj) {
        return Integer.parseInt(String.valueOf(obj));
    }

    private static long getLong(Object obj) {
        return Long.parseLong(String.valueOf(obj));
    }

    private static Calendars verifyEvent(AuRequest request, JSONArray data, int size) {
        Calendars cmp = (Calendars)request.getComponent();
        if (cmp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, (Object)request);
        }
        if (data == null || data.size() != size) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{data, request});
        }
        return cmp;
    }

    public void stopClearGhost() {
        this.clear(this.getTarget(), false);
    }

    public void clearGhost() {
        this.clear(this.getTarget(), true);
    }

    public Date getBeginDate() {
        return this._beginDate;
    }

    public Date getEndDate() {
        return this._endDate;
    }

    public CalendarEvent getCalendarEvent() {
        return this._ce;
    }

    public final int getX() {
        return this._x;
    }

    public final int getY() {
        return this._y;
    }

    public int getDesktopWidth() {
        return this._dtwd;
    }

    public int getDesktopHeight() {
        return this._dthgh;
    }

    private void clear(Component target, boolean isClear) {
        Clients.response((String)("cleardd" + target.getUuid()), (AuResponse)new AuSetAttribute(target, "cleardd", (Object)isClear));
    }
}

