/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.calendar.event;

import java.util.Date;
import java.util.Map;
import org.zkoss.calendar.Calendars;
import org.zkoss.calendar.api.CalendarEvent;
import org.zkoss.calendar.impl.Util;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.DropEvent;

public class CalendarDropEvent
extends DropEvent {
    private static final long serialVersionUID = 20110830181507L;
    private Date _date;
    private CalendarEvent _ce;

    public static CalendarDropEvent getCalendarDropEvent(AuRequest request) {
        Calendars cmp = (Calendars)request.getComponent();
        Map data = request.getData();
        int keys = AuRequests.parseKeys((Map)data);
        Date date = null;
        Object t = data.get("time");
        if (t != null) {
            date = Util.fixDSTTime(cmp.getDefaultTimeZone(), new Date(Long.parseLong(t.toString())));
        }
        return new CalendarDropEvent(request.getCommand(), request.getComponent(), request.getDesktop().getComponentByUuid((String)data.get("dragged")), AuRequests.getInt((Map)data, (String)"x", (int)0), AuRequests.getInt((Map)data, (String)"y", (int)0), AuRequests.getInt((Map)data, (String)"pageX", (int)0), AuRequests.getInt((Map)data, (String)"pageY", (int)0), keys, date, cmp.getCalendarEventById(String.valueOf(data.get("ce"))));
    }

    public CalendarDropEvent(String name, Component target, Component dragged, int x, int y, int pageX, int pageY, int keys, Date date, CalendarEvent ce) {
        super(name, target, dragged, x, y, pageX, pageY, keys);
        this._date = date;
        this._ce = ce;
    }

    public Date getDate() {
        return this._date;
    }

    public CalendarEvent getCalendarEvent() {
        return this._ce;
    }
}

