/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.zk.datatable;

import com.google.common.net.MediaType;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.Element;
import org.apache.ecs.MultiPartElement;
import org.apache.ecs.XhtmlDocument;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.link;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.span;
import org.apache.ecs.xhtml.style;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.tbody;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.th;
import org.apache.ecs.xhtml.thead;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.MColumn;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MStyle;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.print.IHTMLExtension;
import org.compiere.print.MPrintFont;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.MPrintTableFormat;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataElement;
import org.compiere.print.ReportEngine;
import org.compiere.print.layout.InstanceAttributeColumn;
import org.compiere.print.layout.InstanceAttributeData;
import org.compiere.print.layout.LayoutEngine;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.print.renderer.HTMLReportRenderer;
import org.idempiere.print.renderer.IReportRenderer;
import org.idempiere.zk.datatable.DataTableOptions;
import org.idempiere.zk.datatable.DatatableReportRendererConfiguration;
import org.osgi.service.component.annotations.Component;
import org.zkoss.zk.ui.Executions;

@Component(service={IReportRenderer.class}, immediate=true)
public class DatatableReportRenderer
implements IReportRenderer<DatatableReportRendererConfiguration> {
    private static final CLogger log = CLogger.getCLogger(DatatableReportRenderer.class);
    private static final String JS_DATA_IDENTIFIER = "JS_DataTable";

    public String getId() {
        return "Datatables";
    }

    public String getName() {
        return this.getId();
    }

    public String getContentType() {
        return MediaType.HTML_UTF_8.toString();
    }

    public String getFileExtension() {
        return "datatables.html";
    }

    public void renderReport(ReportEngine reportEngine, DatatableReportRendererConfiguration configuration) {
        try {
            Language lang = configuration.getLanguage();
            if (lang == null) {
                lang = Language.getLoginLanguage();
            }
            Writer fw = null;
            fw = configuration.getOutputFile() != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(configuration.getOutputFile(), false), Ini.getCharset()) : configuration.getOutputWriter();
            this.createHTML(reportEngine, new BufferedWriter(fw), configuration.isOnlyTable(), lang, configuration.getExtension(), configuration.isExport());
        }
        catch (FileNotFoundException fnfe) {
            log.log(Level.SEVERE, "(f) - " + fnfe.toString());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(f)", (Throwable)e);
            throw new AdempiereException((Throwable)e);
        }
    }

    public boolean isBinary() {
        return false;
    }

    public Class<DatatableReportRendererConfiguration> getConfigurationType() {
        return DatatableReportRendererConfiguration.class;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createHTML(ReportEngine reportEngine, Writer writer, boolean onlyTable, Language language, IHTMLExtension extension, boolean isExport) {
        MPrintFormat printFormat = reportEngine.getPrintFormat();
        PrintData printData = reportEngine.getPrintData();
        MQuery reportEngineQuery = reportEngine.getQuery();
        LayoutEngine layout = reportEngine.getLayout();
        HashMap mapCssInfo = new HashMap();
        try {
            td td2;
            String cssPrefix;
            DataTableOptions dataTableOptions = new DataTableOptions(language.getLocale().toLanguageTag());
            ArrayList<Object> columns = new ArrayList<Object>();
            ArrayList<InstanceAttributeData> asiElements = new ArrayList<InstanceAttributeData>();
            int columnCount = 0;
            int col = 0;
            while (col < printFormat.getItemCount()) {
                MPrintFormatItem item = printFormat.getItem(col);
                if (item.isPrinted()) {
                    if (item.isTypeField() && item.isPrintInstanceAttributes()) {
                        InstanceAttributeData asiElement = new InstanceAttributeData(item, columnCount);
                        asiElement.readAttributesData(printData);
                        asiElements.add(asiElement);
                    } else {
                        columns.add(item);
                        ++columnCount;
                    }
                }
                ++col;
            }
            if (asiElements.size() > 0) {
                int columnCreated = 0;
                for (InstanceAttributeData data : asiElements) {
                    List instanceColumns = data.getColumns();
                    int index = data.getColumnIndex() + columnCreated;
                    for (InstanceAttributeColumn c : instanceColumns) {
                        columns.add(index, c);
                        ++index;
                        ++columnCreated;
                    }
                }
            }
            String string = cssPrefix = extension != null ? extension.getClassPrefix() : null;
            if (cssPrefix != null && cssPrefix.trim().length() == 0) {
                cssPrefix = null;
            }
            table parameterTable = null;
            if (!printFormat.isForm() && reportEngineQuery != null && reportEngineQuery.isActive()) {
                int rows;
                int n = rows = reportEngineQuery.getReportProcessQuery() != null ? reportEngineQuery.getReportProcessQuery().getRestrictionCount() : reportEngineQuery.getRestrictionCount();
                if (rows > 0) {
                    parameterTable = new table();
                    if (cssPrefix != null) {
                        parameterTable.setClass(cssPrefix + "-parameter-table");
                    } else {
                        parameterTable.setClass("parameter-table");
                    }
                    parameterTable.setNeedClosingTag(false);
                }
            }
            table table2 = new table();
            if (cssPrefix != null) {
                table2.setClass("cell-border compact hover " + cssPrefix + "-table");
            }
            table2.setID(JS_DATA_IDENTIFIER);
            table2.setNeedClosingTag(false);
            PrintWriter w = new PrintWriter(writer);
            XhtmlDocument doc = null;
            boolean minify = MSysConfig.getBooleanValue((String)"HTML_REPORT_MINIFY", (boolean)true, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            if (onlyTable) {
                w.print(HTMLReportRenderer.compress((String)table2.toString(), (boolean)minify));
            } else {
                doc = new XhtmlDocument();
                doc.getHtml().setNeedClosingTag(false);
                doc.getBody().setNeedClosingTag(false);
                doc.appendHead("<meta charset=\"UTF-8\" />");
                if (extension != null && !Util.isEmpty((String)extension.getWebFontLinks(), (boolean)true)) {
                    doc.appendHead(extension.getWebFontLinks());
                }
                if (extension != null && extension.getStyleURL() != null) {
                    String pathStyleFile = extension.getFullPathStyle();
                    Path path = Paths.get(pathStyleFile, new String[0]);
                    List<String> styleLines = Files.readAllLines(path, Ini.getCharset());
                    Files.delete(path);
                    StringBuilder styleBuild = new StringBuilder();
                    for (String styleLine : styleLines) {
                        styleBuild.append(styleLine);
                    }
                    HTMLReportRenderer.appendInlineCss((XhtmlDocument)doc, (StringBuilder)styleBuild);
                }
                if (extension != null && extension.getScriptURL() != null && !isExport) {
                    script jslink = new script();
                    jslink.setLanguage("javascript");
                    jslink.setSrc(extension.getScriptURL());
                    doc.appendHead((Element)jslink);
                }
                this.appendStyles(doc, isExport, dataTableOptions.geti18nURL());
                this.appendScripts(doc, isExport);
                if (extension != null && !isExport) {
                    extension.setWebAttribute(doc.getBody());
                }
            }
            if (doc != null) {
                MPrintFormatItem item = null;
                int printColIndex = -1;
                int col2 = 0;
                while (col2 < columns.size()) {
                    Object colobj = columns.get(col2);
                    if (colobj instanceof MPrintFormatItem) {
                        item = (MPrintFormatItem)colobj;
                    } else if (colobj instanceof InstanceAttributeColumn) {
                        item = ((InstanceAttributeColumn)colobj).getPrintFormatItem();
                    }
                    if (item != null) {
                        HTMLReportRenderer.addCssInfo((MPrintFormat)printFormat, (MPrintFormatItem)item, (int)(++printColIndex), mapCssInfo);
                    }
                    ++col2;
                }
                HTMLReportRenderer.appendInlineCss((XhtmlDocument)doc, mapCssInfo);
                StringBuilder styleBuild = new StringBuilder();
                MPrintTableFormat tf = printFormat.getTableFormat();
                HTMLReportRenderer.CSSInfo cssInfo = new HTMLReportRenderer.CSSInfo(tf.getPageHeader_Font(), tf.getPageHeaderFG_Color());
                if (cssPrefix != null) {
                    if (parameterTable != null) {
                        styleBuild.append("." + cssPrefix + "-parameter-table th").append(cssInfo.getCssRule());
                    }
                    styleBuild.append("." + cssPrefix + "-table th").append(cssInfo.getCssRule());
                } else {
                    if (parameterTable != null) {
                        styleBuild.append("parameter-table th").append(cssInfo.getCssRule());
                    }
                    styleBuild.append("table th").append(cssInfo.getCssRule());
                }
                cssInfo = new HTMLReportRenderer.CSSInfo(tf.getParameter_Font(), tf.getParameter_Color());
                styleBuild.append(".tr-parameter td").append(cssInfo.getCssRule());
                cssInfo = new HTMLReportRenderer.CSSInfo(tf.getFunct_Font(), tf.getFunctFG_Color());
                styleBuild.append(".tr-function td").append(cssInfo.getCssRule());
                MPrintFont printFont = MPrintFont.get((int)printFormat.getAD_PrintFont_ID());
                Font base = printFont.getFont();
                Font newFont = new Font(base.getName(), 0, base.getSize() - 1);
                cssInfo = new HTMLReportRenderer.CSSInfo(newFont, null);
                styleBuild.append(".tr-level-1 td").append(cssInfo.getCssRule());
                newFont = new Font(base.getName(), 0, base.getSize() - 2);
                cssInfo = new HTMLReportRenderer.CSSInfo(newFont, null);
                styleBuild.append(".tr-level-2 td").append(cssInfo.getCssRule());
                styleBuild = new StringBuilder(styleBuild.toString().replaceAll(";", "!important;"));
                HTMLReportRenderer.appendInlineCss((XhtmlDocument)doc, (StringBuilder)styleBuild);
                w.print(doc.toString());
                w.print("<div class='" + cssPrefix + "-flex-container'>");
                String paraWrapId = null;
                if (parameterTable != null) {
                    paraWrapId = cssPrefix + "-para-table-wrap";
                    w.print("<details id='" + paraWrapId + "' open=true style='cursor:pointer'>");
                    w.print("<summary style='cursor:pointer'>" + Msg.getMsg((Properties)Env.getCtx(), (String)"Parameter") + "</summary>");
                    w.print(HTMLReportRenderer.compress((String)parameterTable.toString(), (boolean)minify));
                    tr tr2 = new tr();
                    tr2.setClass("tr-parameter");
                    MQuery query = reportEngineQuery;
                    if (reportEngineQuery.getReportProcessQuery() != null) {
                        query = reportEngineQuery.getReportProcessQuery();
                    }
                    int r = 0;
                    while (r < query.getRestrictionCount()) {
                        if (r > 0) {
                            tr2 = new tr();
                            tr2.setClass("tr-parameter");
                        }
                        td2 = new td();
                        tr2.addElement((Element)td2);
                        td2.addElement(query.getInfoName(r));
                        td2 = new td();
                        tr2.addElement((Element)td2);
                        td2.addElement(query.getInfoOperator(r));
                        td2 = new td();
                        tr2.addElement((Element)td2);
                        td2.addElement(query.getInfoDisplayAll(r));
                        w.print(HTMLReportRenderer.compress((String)tr2.toString(), (boolean)minify));
                        ++r;
                    }
                    w.print("</table>");
                    w.print("</details>");
                }
                StringBuilder tableWrapDiv = new StringBuilder();
                tableWrapDiv.append("<div class='").append(cssPrefix).append("-table-wrap' ");
                if (paraWrapId != null) {
                    String paraWrapGet = "document.getElementById(\"" + paraWrapId + "\")";
                    tableWrapDiv.append("onscroll='setTimeout(() => {if (this.scrollTop > 0) ").append(" if(").append(paraWrapGet).append(".open) ").append(paraWrapGet).append(".open=false;}, 100)'");
                }
                tableWrapDiv.append(" >");
                w.print(HTMLReportRenderer.compress((String)tableWrapDiv.toString(), (boolean)minify));
                w.print(HTMLReportRenderer.compress((String)table2.toString(), (boolean)minify));
            }
            thead thead2 = new thead();
            thead2.setClass("sticky");
            tbody tbody2 = new tbody();
            tbody2.setNeedClosingTag(false);
            Boolean[] colSuppressRepeats = layout == null || layout.colSuppressRepeats == null ? LayoutEngine.getColSuppressRepeats((MPrintFormat)printFormat) : layout.colSuppressRepeats;
            Object[] preValues = null;
            if (colSuppressRepeats != null) {
                preValues = new Object[colSuppressRepeats.length];
            }
            int printColIndex = -1;
            HashMap<Integer, th> suppressMap = new HashMap<Integer, th>();
            tr tr3 = new tr();
            int col3 = 0;
            while (col3 < printFormat.getItemCount()) {
                MPrintFormatItem item = printFormat.getItem(col3);
                if (item.isPrinted()) {
                    String printName = item.getPrintName(language);
                    th th2 = new th();
                    th2.addAttribute("data-dt-order", "disable");
                    tr3.addElement((Element)th2);
                    input searchInput = new input();
                    if (!Util.isEmpty((String)printName)) {
                        searchInput.addAttribute("placeholder", "Search " + printName);
                    }
                    th2.addElement((Element)searchInput);
                }
                ++col3;
            }
            thead2.addElement((Element)tr3);
            int row = -1;
            while (row < printData.getRowCount()) {
                block100: {
                    tr tr4;
                    block101: {
                        block99: {
                            tr4 = new tr();
                            if (row == -1) break block99;
                            printData.setRowIndex(row);
                            if (printData.isFunctionRow()) break block100;
                            if (extension != null && !isExport) {
                                extension.extendRowElement((ConcreteElement)tr4, printData);
                            }
                            if (printData.isFunctionRow()) {
                                tr4.setClass(cssPrefix + "-functionrow");
                                break block101;
                            } else if (row < printData.getRowCount() && printData.isFunctionRow(row + 1)) {
                                tr4.setClass(cssPrefix + "-lastgrouprow");
                            }
                            break block101;
                        }
                        thead2.addElement((Element)tr4);
                    }
                    printColIndex = -1;
                    int col4 = 0;
                    while (col4 < columns.size()) {
                        block102: {
                            Object obj;
                            block105: {
                                Object pde;
                                MPrintFormatItem item;
                                block98: {
                                    String value;
                                    MStyle style2;
                                    block108: {
                                        boolean isZoom;
                                        block110: {
                                            block109: {
                                                block106: {
                                                    block107: {
                                                        block104: {
                                                            InstanceAttributeColumn instanceAttributeColumn;
                                                            block103: {
                                                                String description;
                                                                MColumn column;
                                                                Object colObj = columns.get(col4);
                                                                item = null;
                                                                instanceAttributeColumn = null;
                                                                if (colObj instanceof MPrintFormatItem) {
                                                                    item = (MPrintFormatItem)colObj;
                                                                } else if (colObj instanceof InstanceAttributeColumn) {
                                                                    instanceAttributeColumn = (InstanceAttributeColumn)colObj;
                                                                    item = instanceAttributeColumn.getPrintFormatItem();
                                                                }
                                                                if (item == null) break block102;
                                                                ++printColIndex;
                                                                if (row != -1) break block103;
                                                                th th3 = new th();
                                                                tr4.addElement((Element)th3);
                                                                String columnHeader = instanceAttributeColumn != null ? instanceAttributeColumn.getName() : item.getPrintName(language);
                                                                th3.addElement(Util.maskHTML((String)columnHeader));
                                                                if (cssPrefix != null && instanceAttributeColumn == null && (column = MColumn.get((Properties)Env.getCtx(), (int)item.getAD_Column_ID())) != null && column.getAD_Column_ID() > 0 && DisplayType.isNumeric((int)column.getAD_Reference_ID())) {
                                                                    th3.setClass(cssPrefix + "-number");
                                                                }
                                                                if (item.isSuppressNull()) {
                                                                    suppressMap.put(printColIndex, th3);
                                                                    th3.setID("report-th-" + printColIndex);
                                                                }
                                                                if (this.isDataTableFunctionColumn(item)) {
                                                                    if (item.isOrderBy()) {
                                                                        dataTableOptions.addPrintColumnIndex(FunctionTypes.ORDER_BY, item.isDesc() ? dataTableOptions.DESC_OFFSET + printColIndex : printColIndex);
                                                                    }
                                                                    if (item.isGroupBy()) {
                                                                        dataTableOptions.addPrintColumnIndex(FunctionTypes.GROUP_BY, printColIndex);
                                                                    }
                                                                    if (item.isSummarized()) {
                                                                        dataTableOptions.addPrintColumnIndex(FunctionTypes.SUM, printColIndex);
                                                                    }
                                                                    if (item.isCounted()) {
                                                                        dataTableOptions.addPrintColumnIndex(FunctionTypes.COUNT, printColIndex);
                                                                    }
                                                                    if (item.isMinCalc()) {
                                                                        dataTableOptions.addPrintColumnIndex(FunctionTypes.MIN, printColIndex);
                                                                    }
                                                                    if (item.isMaxCalc()) {
                                                                        dataTableOptions.addPrintColumnIndex(FunctionTypes.MAX, printColIndex);
                                                                    }
                                                                    if (item.isAveraged()) {
                                                                        dataTableOptions.addPrintColumnIndex(FunctionTypes.AVG, printColIndex);
                                                                    }
                                                                    if (item.isDeviationCalc()) {
                                                                        dataTableOptions.addPrintColumnIndex(FunctionTypes.DEVIATION, printColIndex);
                                                                    }
                                                                    if (item.isVarianceCalc()) {
                                                                        dataTableOptions.addPrintColumnIndex(FunctionTypes.VARIANCE, printColIndex);
                                                                    }
                                                                }
                                                                if (item.getAD_Column_ID() > 0 && !Util.isEmpty((String)(description = (column = MColumn.get((int)item.getAD_Column_ID())).get_Translation("Description", language.getAD_Language())))) {
                                                                    th3.addAttribute("title", description);
                                                                }
                                                                break block102;
                                                            }
                                                            td2 = new td();
                                                            tr4.addElement((Element)td2);
                                                            style2 = item.getAD_FieldStyle_ID() > 0 ? MStyle.get((Properties)Env.getCtx(), (int)item.getAD_FieldStyle_ID()) : null;
                                                            Object object = obj = instanceAttributeColumn != null ? instanceAttributeColumn.getPrintDataElement(row) : printData.getNodeByPrintFormatItemId(item.getAD_PrintFormatItem_ID());
                                                            if (obj != null && ReportEngine.isDisplayPFItem((PrintData)printData, (MPrintFormatItem)item)) break block104;
                                                            td2.addElement("&nbsp;");
                                                            if (colSuppressRepeats != null && colSuppressRepeats[printColIndex].booleanValue()) {
                                                                preValues[printColIndex] = null;
                                                            }
                                                            if (item.isSuppressNull() && obj != null && suppressMap.containsKey(printColIndex)) {
                                                                suppressMap.remove(printColIndex);
                                                            }
                                                            break block102;
                                                        }
                                                        if (!(obj instanceof PrintDataElement)) break block105;
                                                        pde = obj;
                                                        value = pde.getValueDisplay(language);
                                                        if (colSuppressRepeats == null || !colSuppressRepeats[printColIndex].booleanValue()) break block106;
                                                        if (!value.equals(preValues[printColIndex])) break block107;
                                                        td2.addElement("&nbsp;");
                                                        break block102;
                                                    }
                                                    preValues[printColIndex] = value;
                                                }
                                                if (item.isSuppressNull() && obj != null && suppressMap.containsKey(printColIndex)) {
                                                    suppressMap.remove(printColIndex);
                                                }
                                                if (!pde.getColumnName().endsWith("_ID") || extension == null || isExport) break block108;
                                                isZoom = false;
                                                if (!item.getColumnName().equals("Record_ID")) break block109;
                                                Object tablePDE = printData.getNode("AD_Table_ID");
                                                if (tablePDE != null && tablePDE instanceof PrintDataElement) {
                                                    int tableID = -1;
                                                    try {
                                                        tableID = Integer.parseInt(((PrintDataElement)tablePDE).getValueAsString());
                                                    }
                                                    catch (Exception exception) {
                                                        tableID = -1;
                                                    }
                                                    if (tableID > 0) {
                                                        MTable mTable = MTable.get((Properties)Env.getCtx(), (int)tableID);
                                                        String tableName = mTable.getTableName();
                                                        value = reportEngine.getIdentifier(mTable, tableName, Integer.parseInt(value));
                                                        String foreignColumnName = tableName + "_ID";
                                                        pde.setForeignColumnName(foreignColumnName);
                                                        isZoom = true;
                                                    }
                                                }
                                                break block110;
                                            }
                                            isZoom = true;
                                        }
                                        if (isZoom) {
                                            MTable mTable = MTable.get((Properties)Env.getCtx(), (String)pde.getForeignColumnName().substring(0, pde.getForeignColumnName().length() - 3));
                                            int Record_ID = -1;
                                            try {
                                                Record_ID = Integer.parseInt(pde.getValueAsString());
                                            }
                                            catch (Exception exception) {
                                                Record_ID = -1;
                                            }
                                            Boolean canAccess = null;
                                            if (Record_ID >= 0 && mTable != null) {
                                                int AD_Window_ID = Env.getZoomWindowID((int)mTable.get_ID(), (int)Record_ID);
                                                canAccess = MRole.getDefault().getWindowAccess(AD_Window_ID);
                                            }
                                            if (canAccess == null) {
                                                isZoom = false;
                                            }
                                        }
                                        if (isZoom) {
                                            a href = new a("javascript:void(0)");
                                            href.setID(pde.getColumnName() + "_" + row + "_a");
                                            td2.addElement((Element)href);
                                            href.addElement(Util.maskHTML((String)value));
                                            if (cssPrefix != null) {
                                                href.setClass(cssPrefix + "-href");
                                            }
                                            if (style2 != null && style2.isWrapWithSpan()) {
                                                HTMLReportRenderer.setStyle((PrintData)printData, (MultiPartElement)href, (MStyle)style2);
                                            } else {
                                                HTMLReportRenderer.setStyle((PrintData)printData, (MultiPartElement)td2, (MStyle)style2);
                                            }
                                            extension.extendIDColumn(row, (ConcreteElement)td2, href, (PrintDataElement)pde);
                                            break block98;
                                        } else if (style2 != null && style2.isWrapWithSpan()) {
                                            span span2 = new span();
                                            HTMLReportRenderer.setStyle((PrintData)printData, (MultiPartElement)span2, (MStyle)style2);
                                            span2.addElement(Util.maskHTML((String)value));
                                            td2.addElement((Element)span2);
                                            break block98;
                                        } else {
                                            HTMLReportRenderer.setStyle((PrintData)printData, (MultiPartElement)td2, (MStyle)style2);
                                            td2.addElement(Util.maskHTML((String)value));
                                        }
                                        break block98;
                                    }
                                    if (style2 != null && style2.isWrapWithSpan()) {
                                        span span3 = new span();
                                        HTMLReportRenderer.setStyle((PrintData)printData, (MultiPartElement)span3, (MStyle)style2);
                                        span3.addElement(Util.maskHTML((String)value));
                                        td2.addElement((Element)span3);
                                    } else {
                                        HTMLReportRenderer.setStyle((PrintData)printData, (MultiPartElement)td2, (MStyle)style2);
                                        td2.addElement(Util.maskHTML((String)value));
                                    }
                                }
                                if (cssPrefix != null) {
                                    if (DisplayType.isNumeric((int)pde.getDisplayType())) {
                                        td2.setClass(cssPrefix + "-number");
                                    } else if (DisplayType.isDate((int)pde.getDisplayType())) {
                                        td2.setClass(cssPrefix + "-date");
                                    } else {
                                        td2.setClass(cssPrefix + "-text");
                                    }
                                }
                                if (row == 0) {
                                    HTMLReportRenderer.addCssInfo((MPrintFormat)printFormat, (MPrintFormatItem)item, (int)printColIndex, mapCssInfo);
                                }
                                break block102;
                            }
                            if (!(obj instanceof PrintData)) {
                                log.log(Level.SEVERE, "Element not PrintData(Element) " + String.valueOf(obj.getClass()));
                            }
                        }
                        ++col4;
                    }
                    dataTableOptions.setPrintColLastIndex(printColIndex);
                    if (row == -1) {
                        w.print(HTMLReportRenderer.compress((String)thead2.toString(), (boolean)minify));
                        w.print(HTMLReportRenderer.compress((String)tbody2.toString(), (boolean)minify));
                    } else {
                        w.print(HTMLReportRenderer.compress((String)tr4.toString(), (boolean)minify));
                    }
                }
                ++row;
            }
            w.print("</tbody>");
            w.print("</table>");
            if (suppressMap.size() > 0) {
                StringBuilder st = new StringBuilder();
                for (th t : suppressMap.values()) {
                    if (st.length() > 0) {
                        st.append(",");
                    }
                    st.append("#").append(t.getAttribute("id"));
                }
                st.append(" {\n\t\tdisplay:none;\n\t}");
                style styleTag = new style();
                styleTag.addElement(st.toString());
                w.print(HTMLReportRenderer.compress((String)styleTag.toString(), (boolean)minify));
            }
            if (!onlyTable) {
                w.print("</div>");
                w.print("</div>");
                String dataTableOptionString = dataTableOptions.getDataTableOptions();
                if (dataTableOptionString != null) {
                    w.print("<script type=\"text/javascript\"> ");
                    w.print(HTMLReportRenderer.compress((String)"class NumberParser {  constructor(locale) {   const parts = new Intl.NumberFormat(locale).formatToParts(12345.6);    const numerals = [...new Intl.NumberFormat(locale, {useGrouping: false}).format(9876543210)].reverse();    const index = new Map(numerals.map((d, i) => [d, i]));    let groupValue = parts.find(d => d.type === \"group\").value;   this._group = new RegExp(`[${groupValue.charCodeAt(0)==160 ? '&nbsp;' : groupValue}]`, \"g\");    this._decimal = new RegExp(`[${parts.find(d => d.type === \"decimal\").value}]`);    this._numeral = new RegExp(`[${numerals.join(\"\")}]`, \"g\");    this._index = d => index.get(d); }  parse(string) {    let retValue = (string = string.trim()      .replace(this._group, \"\")      .replace(this._decimal, \".\") \t.replace(this._numeral, this._index)) ? +string : 0; \treturn Number.isNaN(retValue) ? 0 : retValue; } }\n", (boolean)true));
                    String jsDataTables = "$(document).ready(function() {   let t = $('#JS_DataTable').DataTable( " + dataTableOptionString + " );  });";
                    w.print(jsDataTables);
                    w.print("</script>");
                }
                w.print("</body>");
                w.print("</html>");
            }
            w.flush();
            w.close();
            return;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
            throw new AdempiereException((Throwable)e);
        }
    }

    private boolean isDataTableFunctionColumn(MPrintFormatItem item) {
        return item.isOrderBy() || item.isGroupBy() || item.isSummarized() || item.isCounted() || item.isMinCalc() || item.isAveraged() || item.isDeviationCalc() || item.isMaxCalc() || item.isVarianceCalc();
    }

    private void appendScripts(XhtmlDocument doc, boolean isExport) throws IOException, URISyntaxException {
        List<String> urls = Arrays.asList("~./js/datatables/datatables.min.js");
        if (isExport) {
            for (String extraScriptPath : urls) {
                URL url = this.getClass().getResource(extraScriptPath.replace("~./", "/web/"));
                this.appendInlineScriptContent(doc, this.readResource(url));
            }
        } else {
            for (String extraScriptUrl : urls) {
                this.embedScriptLink(doc, Executions.encodeURL((String)extraScriptUrl));
            }
        }
    }

    private void appendStyles(XhtmlDocument doc, boolean isExport, String i18nURL) throws IOException, URISyntaxException {
        List<String> urls = Arrays.asList("~./js/datatables/datatables.min.css", "~./js/datatables/customization.css");
        if (isExport) {
            for (String extraStylePath : urls) {
                URL url = this.getClass().getResource(extraStylePath.replace("~./", "/web/"));
                HTMLReportRenderer.appendInlineCss((XhtmlDocument)doc, (StringBuilder)this.readResource(url));
            }
        } else {
            for (String extraStyleUrl : urls) {
                this.embedStyleLink(doc, Executions.encodeURL((String)extraStyleUrl));
                if (i18nURL == null) continue;
                link link2 = new link();
                link2.setHref(i18nURL);
                link2.setRel("prefetch");
                link2.setType("application/json");
                doc.appendHead((Element)link2);
            }
        }
    }

    private StringBuilder readResource(URL url) throws IOException {
        String line;
        StringBuilder builder = new StringBuilder();
        InputStream is = url.openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((line = reader.readLine()) != null) {
            builder.append(line);
        }
        reader.close();
        return builder;
    }

    protected void embedScriptLink(XhtmlDocument doc, String scriptUrl) {
        script jslink = new script();
        jslink.setLanguage("javascript");
        jslink.setSrc(scriptUrl);
        doc.appendHead((Element)jslink);
    }

    protected void embedStyleLink(XhtmlDocument doc, String styleUrl) {
        link csslink = new link();
        csslink.setType("text/css");
        csslink.setRel("stylesheet");
        csslink.setHref(styleUrl);
        doc.appendHead((Element)csslink);
    }

    private void appendInlineScriptContent(XhtmlDocument doc, StringBuilder buildScriptContent) {
        if (buildScriptContent.length() > 0) {
            buildScriptContent.insert(0, "<script type=\"text/javascript\">\n");
            buildScriptContent.append("\n</script>");
            doc.appendHead(buildScriptContent.toString());
        }
    }

    protected static enum FunctionTypes {
        SUM,
        COUNT,
        MIN,
        MAX,
        AVG,
        DEVIATION,
        VARIANCE,
        GROUP_BY,
        ORDER_BY;

    }
}

