/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.apps.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.util.Callback;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.MRole;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;

public class BOMDrop {
    public int getMaxBOMDeep(MProduct product) {
        return this.getBOMDeep(product, 0);
    }

    private int getBOMDeep(MProduct product, int curentBomDeep) {
        MPPProductBOM bom;
        int bomDeep = curentBomDeep;
        if (product.isBOM() && (bom = MPPProductBOM.getDefault((MProduct)product, null)) != null) {
            MPPProductBOMLine[] mPPProductBOMLineArray = bom.getLines();
            int n = mPPProductBOMLineArray.length;
            int n2 = 0;
            while (n2 < n) {
                MPPProductBOMLine bomLine = mPPProductBOMLineArray[n2];
                int testBomDeep = this.getBOMDeep(bomLine.getProduct(), curentBomDeep + 1);
                if (testBomDeep > bomDeep) {
                    bomDeep = testBomDeep;
                }
                ++n2;
            }
        }
        return bomDeep;
    }

    public KeyNamePair[] getDraftOrders(String trxName) {
        String sql = "SELECT C_Order_ID, DocumentNo || '_' || GrandTotal FROM C_Order WHERE Processed='N' AND DocStatus='DR' ORDER BY DocumentNo";
        return DB.getKeyNamePairs((String)trxName, (String)MRole.getDefault().addAccessSQL(sql, "C_Order", false, false), (boolean)true, (Object[])new Object[0]);
    }

    public KeyNamePair[] getNonServiceProjects(String trxName) {
        String sql = "SELECT C_Project_ID, Name FROM C_Project WHERE Processed='N' AND IsSummary='N' AND IsActive='Y' AND ProjectCategory<>'S' ORDER BY Name";
        return DB.getKeyNamePairs((String)trxName, (String)MRole.getDefault().addAccessSQL(sql, "C_Project", false, false), (boolean)true, (Object[])new Object[0]);
    }

    public KeyNamePair[] getDraftInvoices(String trxName) {
        String sql = "SELECT C_Invoice_ID, DocumentNo || '_' || GrandTotal FROM C_Invoice WHERE Processed='N' AND DocStatus='DR' ORDER BY DocumentNo";
        return DB.getKeyNamePairs((String)trxName, (String)MRole.getDefault().addAccessSQL(sql, "C_Invoice", false, false), (boolean)true, (Object[])new Object[0]);
    }

    public MPPProductBOMLine[] getBOMLine(MProduct product) {
        MPPProductBOM bom = MPPProductBOM.getDefault((MProduct)product, null);
        MPPProductBOMLine[] bomLines = bom.getLines();
        Arrays.sort(bomLines, new Comparator<MPPProductBOMLine>(){

            @Override
            public int compare(MPPProductBOMLine arg0, MPPProductBOMLine arg1) {
                String feature1 = arg0.getFeature() != null ? arg0.getFeature() : "";
                String feature2 = arg1.getFeature() != null ? arg1.getFeature() : "";
                return feature1.compareTo(feature2);
            }
        });
        Arrays.sort(bomLines, new Comparator<MPPProductBOMLine>(){

            @Override
            public int compare(MPPProductBOMLine arg0, MPPProductBOMLine arg1) {
                return arg0.getComponentType().compareTo(arg1.getComponentType());
            }
        });
        Arrays.sort(bomLines, new Comparator<MPPProductBOMLine>(){

            @Override
            public int compare(MPPProductBOMLine arg0, MPPProductBOMLine arg1) {
                String t1 = String.valueOf(arg0.getLine() + 100000);
                String t2 = String.valueOf(arg1.getLine() + 100000);
                return t1.compareTo(t2);
            }
        });
        return bomLines;
    }

    public MOrder saveOrderLines(int C_Order_ID, List<SelectedItem> selectedItems, String trxName) {
        MOrder order = new MOrder(Env.getCtx(), C_Order_ID, trxName);
        if (order.get_ID() == 0) {
            throw new AdempiereException("Not found - C_Order_ID=" + C_Order_ID);
        }
        for (SelectedItem selectedItem : selectedItems) {
            this.addOrderLine(order, selectedItem.M_Product_ID, selectedItem.qty);
        }
        return order;
    }

    private MOrderLine addOrderLine(MOrder order, int M_Product_ID, BigDecimal qty) {
        MOrderLine ol = new MOrderLine(order);
        ol.setM_Product_ID(M_Product_ID, true);
        ol.setQty(qty);
        ol.setPrice();
        ol.setTax();
        ol.saveEx();
        return ol;
    }

    public MInvoice saveInvoiceLines(int C_Invoice_ID, List<SelectedItem> selectedItems, String trxName) {
        MInvoice invoice = new MInvoice(Env.getCtx(), C_Invoice_ID, trxName);
        if (invoice.get_ID() == 0) {
            throw new AdempiereException("Not found - C_Invoice_ID=" + C_Invoice_ID);
        }
        for (SelectedItem selectedItem : selectedItems) {
            this.addInvoiceLine(invoice, selectedItem.M_Product_ID, selectedItem.qty);
        }
        return invoice;
    }

    private MInvoiceLine addInvoiceLine(MInvoice invoice, int M_Product_ID, BigDecimal qty) {
        MInvoiceLine il = new MInvoiceLine(invoice);
        il.setM_Product_ID(M_Product_ID, true);
        il.setQty(qty);
        il.setPrice();
        il.setTax();
        il.saveEx();
        return il;
    }

    public MProject saveProjectLines(int C_Project_ID, List<SelectedItem> selectedItems, String trxName) {
        MProject project = new MProject(Env.getCtx(), C_Project_ID, trxName);
        if (project.get_ID() == 0) {
            throw new AdempiereException("Not found - C_Project_ID=" + C_Project_ID);
        }
        for (SelectedItem selectedItem : selectedItems) {
            this.addProjectLine(project, selectedItem.M_Product_ID, selectedItem.qty);
        }
        return project;
    }

    private MProjectLine addProjectLine(MProject project, int M_Product_ID, BigDecimal qty) {
        MProjectLine pl = new MProjectLine(project);
        pl.setM_Product_ID(M_Product_ID);
        pl.setPlannedQty(qty);
        pl.saveEx();
        return pl;
    }

    public void addBOMLines(MProduct product, BigDecimal qty, Callback<BOMLine> callback) {
        this.addBOMLines(product, qty, callback, 0);
    }

    private void addBOMLines(MProduct product, BigDecimal qty, Callback<BOMLine> callback, int bomLevel) {
        MPPProductBOMLine[] bomLines = this.getBOMLine(product);
        int i = 0;
        while (i < bomLines.length) {
            this.addBOMLines(bomLines[i], qty, callback, bomLevel);
            ++i;
        }
    }

    private void addBOMLines(MPPProductBOMLine productBOMLine, BigDecimal qty, Callback<BOMLine> callback, int bomLevel) {
        MProduct product = productBOMLine.getProduct();
        if (product == null) {
            return;
        }
        BOMLine bomLine = new BOMLine(productBOMLine, qty, bomLevel);
        callback.onCallback((Object)bomLine);
        if (product.isBOM() && product.isVerified()) {
            this.addBOMLines(product, bomLine.getLineQty(), callback, bomLevel + 1);
        }
    }

    public static class BOMLine {
        private MPPProductBOMLine bomLine;
        private BigDecimal lineQty;
        private String bomType;
        private int bomLevel;
        private String feature;

        public BOMLine(MPPProductBOMLine bomLine, BigDecimal qty, int level) {
            this.bomLine = bomLine;
            this.lineQty = bomLine.getQtyBOM().multiply(qty).setScale(MClient.get((Properties)Env.getCtx()).getAcctSchema().getStdPrecision(), RoundingMode.HALF_UP);
            this.bomType = bomLine.getComponentType();
            if (this.bomType == null) {
                this.bomType = "CO";
            }
            this.bomLevel = level;
            this.feature = bomLine.getFeature();
            if (this.feature == null) {
                this.feature = "";
            }
        }

        public MPPProductBOMLine getProductBOMLine() {
            return this.bomLine;
        }

        public BigDecimal getLineQty() {
            return this.lineQty;
        }

        public String getBOMType() {
            return this.bomType;
        }

        public int getBOMLevel() {
            return this.bomLevel;
        }

        public String getFeature() {
            return this.feature;
        }

        public MProduct getParentProduct() {
            MPPProductBOM parent = this.bomLine.getParent();
            return MProduct.get((int)parent.getM_Product_ID());
        }
    }

    public static class SelectedItem {
        private int M_Product_ID;
        private BigDecimal qty;

        public SelectedItem(int M_Product_ID, BigDecimal qty) {
            this.M_Product_ID = M_Product_ID;
            this.qty = qty;
        }

        public int getM_Product_ID() {
            return this.M_Product_ID;
        }

        public BigDecimal getQty() {
            return this.qty;
        }
    }
}

