/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import org.zkoss.lang.Library;
import org.zkoss.lang.Strings;
import org.zkoss.mesg.Messages;
import org.zkoss.xml.XMLs;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.WebApps;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.HtmlPageRenders;
import org.zkoss.zul.mesg.MZul;

public class Utils {
    public static final int[] stringToInts(String numbers, int defaultValue) throws WrongValueException {
        int[] ary;
        if (numbers == null) {
            return null;
        }
        LinkedList<Integer> list = new LinkedList<Integer>();
        int j = 0;
        while (true) {
            int k;
            String s;
            if ((s = ((k = numbers.indexOf(44, j)) >= 0 ? numbers.substring(j, k) : numbers.substring(j)).trim()).length() == 0) {
                if (k < 0) break;
                list.add(null);
            } else {
                try {
                    list.add(Integer.valueOf(s));
                }
                catch (Throwable ex) {
                    throw new WrongValueException("Not a valid number list: " + numbers);
                }
            }
            if (k < 0) break;
            j = k + 1;
        }
        int sz = list.size();
        if (sz > 0) {
            ary = new int[sz];
            int j2 = 0;
            for (Integer i : list) {
                ary[j2] = i != null ? i : defaultValue;
                ++j2;
            }
        } else {
            ary = null;
        }
        return ary;
    }

    public static final String intsToString(int[] ary) {
        if (ary == null || ary.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(50);
        for (int j = 0; j < ary.length; ++j) {
            if (j > 0) {
                sb.append(',');
            }
            sb.append(ary[j]);
        }
        return sb.toString();
    }

    public static final String[] stringToArray(String src, String defaultValue) {
        if (src == null) {
            return null;
        }
        LinkedList<String> list = new LinkedList<String>();
        int j = 0;
        while (true) {
            int k;
            String s;
            if ((s = ((k = src.indexOf(44, j)) >= 0 ? src.substring(j, k) : src.substring(j)).trim()).length() == 0) {
                if (k < 0) break;
                list.add(defaultValue);
            } else {
                list.add(s);
            }
            if (k < 0) break;
            j = k + 1;
        }
        return list.toArray(new String[list.size()]);
    }

    public static final String arrayToString(Object[] ary) {
        if (ary == null || ary.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(50);
        for (int j = 0; j < ary.length; ++j) {
            if (j > 0) {
                sb.append(',');
            }
            if (ary[j] == null) continue;
            sb.append(ary[j]);
        }
        return sb.toString();
    }

    public static String getDynamicMediaURI(AbstractComponent comp, int version, String name, String format) {
        Desktop desktop = comp.getDesktop();
        if (desktop == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(64).append('/');
        Strings.encode((StringBuffer)sb, (int)(version & 0xFFFF));
        if (name != null || format != null) {
            sb.append('/');
            boolean bExtRequired = true;
            if (name != null && name.length() != 0) {
                if ((name = name.replace('\\', '/')).charAt(0) == '/' && (name = name.substring(1)).length() == 0) {
                    name = "ua";
                }
                sb.append(name);
                bExtRequired = name.lastIndexOf(46) < 0;
            } else {
                sb.append(comp.getId());
            }
            if (bExtRequired && format != null) {
                sb.append('.').append(format);
            }
        }
        return desktop.getDynamicMediaURI((Component)comp, sb.toString());
    }

    public static final String outFeature() {
        StringBuffer sb = new StringBuffer(32);
        sb.append("if(!zk.feature)zk.feature = {standard:true");
        if (WebApps.getFeature((String)"ee")) {
            sb.append(",ee:true");
        } else if (WebApps.getFeature((String)"pe")) {
            sb.append(",pe:true");
        }
        sb.append("};");
        return sb.toString();
    }

    public static final String outLocaleJavaScript() {
        StringBuffer sb = new StringBuffer(1024).append("zk.$default(msgzul, {");
        Utils.addLocaleJS(sb, "VALUE_NOT_MATCHED", MZul.VALUE_NOT_MATCHED);
        Utils.addLocaleJS(sb, "EMPTY_NOT_ALLOWED", MZul.EMPTY_NOT_ALLOWED);
        Utils.addLocaleJS(sb, "INTEGER_REQUIRED", MZul.INTEGER_REQUIRED);
        Utils.addLocaleJS(sb, "NUMBER_REQUIRED", MZul.NUMBER_REQUIRED);
        Utils.addLocaleJS(sb, "DATE_REQUIRED", MZul.DATE_REQUIRED);
        Utils.addLocaleJS(sb, "NO_POSITIVE_NEGATIVE_ZERO", MZul.NO_POSITIVE_NEGATIVE_ZERO);
        Utils.addLocaleJS(sb, "NO_POSITIVE_NEGATIVE", MZul.NO_POSITIVE_NEGATIVE);
        Utils.addLocaleJS(sb, "NO_POSITIVE_ZERO", MZul.NO_POSITIVE_ZERO);
        Utils.addLocaleJS(sb, "NO_POSITIVE", MZul.NO_POSITIVE);
        Utils.addLocaleJS(sb, "NO_NEGATIVE_ZERO", MZul.NO_NEGATIVE_ZERO);
        Utils.addLocaleJS(sb, "NO_NEGATIVE", MZul.NO_NEGATIVE);
        Utils.addLocaleJS(sb, "NO_ZERO", MZul.NO_ZERO);
        Utils.addLocaleJS(sb, "NO_FUTURE_PAST_TODAY", MZul.NO_FUTURE_PAST_TODAY);
        Utils.addLocaleJS(sb, "NO_FUTURE_PAST", MZul.NO_FUTURE_PAST);
        Utils.addLocaleJS(sb, "NO_FUTURE_TODAY", MZul.NO_FUTURE_TODAY);
        Utils.addLocaleJS(sb, "NO_FUTURE", MZul.NO_FUTURE);
        Utils.addLocaleJS(sb, "NO_PAST_TODAY", MZul.NO_PAST_TODAY);
        Utils.addLocaleJS(sb, "NO_PAST", MZul.NO_PAST);
        Utils.addLocaleJS(sb, "NO_TODAY", MZul.NO_TODAY);
        Utils.addLocaleJS(sb, "FIRST", MZul.FIRST);
        Utils.addLocaleJS(sb, "LAST", MZul.LAST);
        Utils.addLocaleJS(sb, "PREV", MZul.PREV);
        Utils.addLocaleJS(sb, "NEXT", MZul.NEXT);
        Utils.addLocaleJS(sb, "CURRENT", MZul.CURRENT);
        Utils.addLocaleJS(sb, "CURRENT_DESCRIPTION", MZul.CURRENT_DESCRIPTION);
        Utils.addLocaleJS(sb, "DETAILED_DESCRIPTION", MZul.DETAILED_DESCRIPTION);
        Utils.addLocaleJS(sb, "GRID_GROUP", MZul.GRID_GROUP);
        Utils.addLocaleJS(sb, "GRID_OTHER", MZul.GRID_OTHER);
        Utils.addLocaleJS(sb, "GRID_ASC", MZul.GRID_ASC);
        Utils.addLocaleJS(sb, "GRID_DESC", MZul.GRID_DESC);
        Utils.addLocaleJS(sb, "GRID_COLUMNS", MZul.GRID_COLUMNS);
        Utils.addLocaleJS(sb, "GRID_UNGROUP", MZul.GRID_UNGROUP);
        Utils.addLocaleJS(sb, "WS_HOME", MZul.WS_HOME);
        Utils.addLocaleJS(sb, "WS_PREV", MZul.WS_PREV);
        Utils.addLocaleJS(sb, "WS_NEXT", MZul.WS_NEXT);
        Utils.addLocaleJS(sb, "WS_END", MZul.WS_END);
        Utils.addLocaleJS(sb, "OK", MZul.OK);
        Utils.addLocaleJS(sb, "CANCEL", MZul.CANCEL);
        Utils.addLocaleJS(sb, "YES", MZul.YES);
        Utils.addLocaleJS(sb, "NO", MZul.NO);
        Utils.addLocaleJS(sb, "RETRY", MZul.RETRY);
        Utils.addLocaleJS(sb, "ABORT", MZul.ABORT);
        Utils.addLocaleJS(sb, "IGNORE", MZul.IGNORE);
        Utils.addLocaleJS(sb, "RELOAD", MZul.RELOAD);
        Utils.addLocaleJS(sb, "UPLOAD_CANCEL", MZul.UPLOAD_CANCEL);
        Utils.addLocaleJS(sb, "ILLEGAL_VALUE", MZul.ILLEGAL_VALUE);
        Utils.addLocaleJS(sb, "PANEL_CLOSE", MZul.PANEL_CLOSE);
        Utils.addLocaleJS(sb, "PANEL_MAXIMIZE", MZul.PANEL_MAXIMIZE);
        Utils.addLocaleJS(sb, "PANEL_MINIMIZE", MZul.PANEL_MINIMIZE);
        Utils.addLocaleJS(sb, "PANEL_EXPAND", MZul.PANEL_EXPAND);
        Utils.addLocaleJS(sb, "PANEL_COLLAPSE", MZul.PANEL_COLLAPSE);
        Utils.addLocaleJS(sb, "PANEL_RESTORE", MZul.PANEL_RESTORE);
        Utils.addLocaleJS(sb, "PDFVIEWER_ROTATE_RIGHT", MZul.PDFVIEWER_ROTATE_RIGHT);
        Utils.addLocaleJS(sb, "PDFVIEWER_ROTATE_LEFT", MZul.PDFVIEWER_ROTATE_LEFT);
        Utils.addLocaleJS(sb, "PDFVIEWER_ZOOM_IN", MZul.PDFVIEWER_ZOOM_IN);
        Utils.addLocaleJS(sb, "PDFVIEWER_ZOOM_OUT", MZul.PDFVIEWER_ZOOM_OUT);
        Utils.addLocaleJS(sb, "PDFVIEWER_ZOOM_LEVEL", MZul.PDFVIEWER_ZOOM_LEVEL);
        Utils.addLocaleJS(sb, "PDFVIEWER_ZOOM_FIT_WIDTH", MZul.PDFVIEWER_ZOOM_FIT_WIDTH);
        Utils.addLocaleJS(sb, "PDFVIEWER_ZOOM_FIT_HEIGHT", MZul.PDFVIEWER_ZOOM_FIT_HEIGHT);
        Utils.addLocaleJS(sb, "PDFVIEWER_TOGGLE_FULLSCREEN", MZul.PDFVIEWER_TOGGLE_FULLSCREEN);
        Utils.addLocaleJS(sb, "UPLOAD_ERROR_EXCEED_MAXSIZE", MZul.UPLOAD_ERROR_EXCEED_MAXSIZE);
        Utils.addLocaleJS(sb, "COLORBOX_PALETTE_BUTTON_LABEL", MZul.COLORBOX_PALETTE_BUTTON_LABEL);
        Utils.addLocaleJS(sb, "COLORBOX_PICKER_BUTTON_LABEL", MZul.COLORBOX_PICKER_BUTTON_LABEL);
        Utils.addLocaleJS(sb, "COLORBOX_COLOR_PALETTE", MZul.COLORBOX_COLOR_PALETTE);
        Utils.addLocaleJS(sb, "COLORBOX_COLOR_PICKER", MZul.COLORBOX_COLOR_PICKER);
        Utils.addLocaleJS(sb, "COLORBOX_COLOR_R", MZul.COLORBOX_COLOR_R);
        Utils.addLocaleJS(sb, "COLORBOX_COLOR_G", MZul.COLORBOX_COLOR_G);
        Utils.addLocaleJS(sb, "COLORBOX_COLOR_B", MZul.COLORBOX_COLOR_B);
        Utils.addLocaleJS(sb, "COLORBOX_HUE", MZul.COLORBOX_HUE);
        Utils.addLocaleJS(sb, "COLORBOX_SATURATION", MZul.COLORBOX_SATURATION);
        Utils.addLocaleJS(sb, "COLORBOX_VALUE", MZul.COLORBOX_VALUE);
        Utils.addLocaleJS(sb, "COLORBOX_COLOR_HEX", MZul.COLORBOX_COLOR_HEX);
        Utils.addLocaleJS(sb, "COLORBOX_COLOR_FIELD", MZul.COLORBOX_COLOR_FIELD);
        Utils.addLocaleJS(sb, "COLORBOX_COLOR_SPECTRUM_BAR", MZul.COLORBOX_COLOR_SPECTRUM_BAR);
        Utils.addLocaleJS(sb, "COLORBOX_SELECT_COLOR_BUTTON", MZul.COLORBOX_SELECT_COLOR_BUTTON);
        Utils.addLocaleJS(sb, "COLORBOX_CURRENT_COLOR", MZul.COLORBOX_CURRENT_COLOR);
        Utils.addLocaleJS(sb, "LISTBOX_SELECT_ALL", MZul.LISTBOX_SELECT_ALL);
        Utils.addLocaleJS(sb, "NOTIFICATION_INFO", MZul.NOTIFICATION_INFO);
        Utils.addLocaleJS(sb, "NOTIFICATION_WARNING", MZul.NOTIFICATION_WARNING);
        Utils.addLocaleJS(sb, "NOTIFICATION_ERROR", MZul.NOTIFICATION_ERROR);
        Utils.addLocaleJS(sb, "CHOSENBOX_SELECTION", MZul.CHOSENBOX_SELECTION);
        Utils.addLocaleJS(sb, "CHOSENBOX_CREATE_MESSAGE", MZul.CHOSENBOX_CREATE_MESSAGE);
        Utils.addLocaleJS(sb, "ITEMWIDGET_SELECTED", MZul.ITEMWIDGET_SELECTED);
        int j = sb.length() - 1;
        if (sb.charAt(j) == ',') {
            sb.setLength(j);
        }
        return sb.append("});").toString();
    }

    private static void addLocaleJS(StringBuffer sb, String name, int mesgCode) {
        sb.append('\n').append(name).append(":'");
        Strings.escape((StringBuffer)sb, (CharSequence)Messages.get((int)mesgCode), (String)"'\n\r\t\f\\/!");
        sb.append("',");
    }

    public static void renderCrawlableA(String href, String label) throws IOException {
        HtmlPageRenders.RenderContext rc;
        if (href != null && href.length() > 0 && (rc = HtmlPageRenders.getRenderContext(null)) != null && rc.crawlable) {
            Writer cwout = rc.temp;
            cwout.write("<a href=\"");
            cwout.write(href);
            cwout.write("\">");
            cwout.write(label != null ? label : "");
            cwout.write("</a>\n");
        }
    }

    public static void renderCrawlableText(String text) throws IOException {
        HtmlPageRenders.RenderContext rc;
        if (text != null && text.length() > 0 && (rc = HtmlPageRenders.getRenderContext(null)) != null && rc.crawlable) {
            Writer cwout = rc.temp;
            cwout.write("<div>");
            cwout.write(XMLs.encodeText((String)text));
            cwout.write("</div>\n");
        }
    }

    public static Component getComponentById(Component comp, String id) {
        int len = id.length();
        if (id.startsWith("uuid(") && id.charAt(len - 1) == ')') {
            Desktop dt = comp.getDesktop();
            if (dt == null) {
                Execution exec = Executions.getCurrent();
                if (exec == null) {
                    return null;
                }
                dt = exec.getDesktop();
            }
            return dt != null ? dt.getComponentByUuidIfAny(id.substring(5, len - 1)) : null;
        }
        return comp.getFellowIfAny(id);
    }

    public static final boolean testAttribute(Component comp, String name, boolean defValue, boolean recurse) {
        return org.zkoss.zk.ui.impl.Utils.testAttribute((Component)comp, (String)name, (boolean)defValue, (boolean)recurse);
    }

    public static final int getIntAttribute(Component comp, String name, int defValue, boolean recurse) {
        Object val = comp.getAttribute(name, recurse);
        if (val == null) {
            val = Library.getProperty((String)name);
        }
        if (val instanceof Integer) {
            return (Integer)val;
        }
        try {
            return Integer.parseInt((String)val);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }
}

