/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.cdi;

import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.zkoss.lang.Objects;
import org.zkoss.xel.VariableResolverX;
import org.zkoss.xel.XelContext;
import org.zkoss.xel.XelException;
import org.zkoss.zkplus.cdi.CDIUtil;

public class DelegatingVariableResolver
implements VariableResolverX {
    private BeanManager _beanMgr = CDIUtil.getBeanManager();

    public Object resolveVariable(String name) throws XelException {
        return this.resolveVariable(null, null, name);
    }

    public Object resolveVariable(XelContext ctx, Object base, Object name) throws XelException {
        if (base != null || !(name instanceof String)) {
            return null;
        }
        Set beans = this._beanMgr.getBeans((String)name);
        if (beans == null || beans.size() == 0) {
            return null;
        }
        Bean bean = null;
        for (Bean b : beans) {
            if (b.isAlternative()) continue;
            if (bean != null) {
                throw new XelException("more than one non-alternative bean have same name " + bean + " and " + b + ", name " + name);
            }
            bean = b;
        }
        if (bean == null) {
            return null;
        }
        CreationalContext context = this._beanMgr.createCreationalContext(null);
        Object value = this._beanMgr.getReference(bean, (Type)bean.getBeanClass(), context);
        return value;
    }

    public int hashCode() {
        return Objects.hashCode((Object)this._beanMgr);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof DelegatingVariableResolver && Objects.equals((Object)this._beanMgr, (Object)((DelegatingVariableResolver)o)._beanMgr);
    }
}

