/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.tracker.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.AnnotateBinder;
import org.zkoss.bind.Binder;
import org.zkoss.bind.impl.AnnotateBinderHelper;
import org.zkoss.bind.impl.BinderImpl;
import org.zkoss.bind.impl.BinderUtil;
import org.zkoss.bind.sys.ReferenceBinding;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.ShadowElement;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.util.UiLifeCycle;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.event.ListDataListener;

public class BindUiLifeCycle
implements UiLifeCycle {
    static final Logger log = LoggerFactory.getLogger(BindUiLifeCycle.class);
    private static final String ON_ZKBIND_LATER = "onZKBindLater";
    private static final String REMOVE_MARK = "$$RemoveMark$$";
    private static final String SKIP_BIND_INIT = "$$SkipBindInitMark$$";
    private static Extension _ext;

    public void afterComponentAttached(Component comp, Page page) {
        this.handleComponentAttached(comp);
    }

    protected void handleComponentAttached(Component comp) {
        boolean removeMark = Boolean.TRUE.equals(comp.getAttribute(REMOVE_MARK));
        if (removeMark) {
            comp.addEventListener(10000, ON_ZKBIND_LATER, (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    Component comp = event.getTarget();
                    comp.removeAttribute(BindUiLifeCycle.REMOVE_MARK);
                    comp.removeEventListener(BindUiLifeCycle.ON_ZKBIND_LATER, (EventListener)this);
                    BindUiLifeCycle.this.handleComponentAttached(comp);
                }
            });
            Events.postEvent((Event)new Event(ON_ZKBIND_LATER, comp));
            return;
        }
        if (!Boolean.FALSE.equals(comp.removeAttribute(SKIP_BIND_INIT)) && comp instanceof ComponentCtrl && !((ComponentCtrl)comp).hasSubBindingAnnotation() && !(comp instanceof ShadowElement)) {
            return;
        }
        if (comp.getDesktop() != null || comp instanceof ShadowElement) {
            comp.addEventListener(10000, "onBindInit", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    Component comp = event.getTarget();
                    comp.removeEventListener("onBindInit", (EventListener)this);
                    BindUiLifeCycle.getExtension().removeLifeCycleHandling(comp);
                    BindUiLifeCycle.this.reInitBinder(comp);
                }
            });
            Events.postEvent((Event)new Event("onBindInit", comp));
        }
    }

    private void reInitBinder(Component comp) {
        boolean recursive = this.reInitBinder0(comp);
        if (recursive && !(comp instanceof ShadowElement)) {
            for (Component kid : comp.getChildren()) {
                if (kid == null) continue;
                this.reInitBinder(kid);
            }
        }
    }

    private boolean reInitBinder0(Component comp) {
        Binder innerBinder;
        String vmId;
        if (comp.getPage() == null && !(comp instanceof ShadowElement)) {
            return false;
        }
        Desktop desktop = comp.getDesktop();
        if (desktop != null && !Strings.isEmpty((String)(vmId = (String)comp.getAttribute("$VM_ID$")))) {
            HashMap<String, Binder> relationMap = (HashMap<String, Binder>)desktop.getAttribute("org.zkoss.bind.vmId_binder");
            if (relationMap == null) {
                relationMap = new HashMap<String, Binder>(4);
                desktop.setAttribute("org.zkoss.bind.vmId_binder", relationMap);
            }
            relationMap.put(vmId, (Binder)comp.getAttribute((String)comp.getAttribute("$BINDER_ID$")));
        }
        if ((innerBinder = BinderUtil.getBinder(comp)) != null) {
            return false;
        }
        Binder binder = null;
        String bid = (String)comp.getAttribute("$BINDER_ID$");
        binder = bid != null ? (Binder)comp.getAttribute(bid) : BinderUtil.getBinder(comp, true);
        if (binder == null) {
            Component shadowHost;
            if (comp instanceof ShadowElement && (shadowHost = ((ShadowElement)comp).getShadowHost()) != null) {
                binder = BinderUtil.getBinder(shadowHost, true);
            }
            if (binder == null) {
                return true;
            }
        }
        if (BindUiLifeCycle.getExtension().isLifeCycleHandling(comp)) {
            return false;
        }
        if (binder instanceof AnnotateBinder) {
            new AnnotateBinderHelper(binder).initComponentBindings(comp);
        }
        BindUiLifeCycle.getExtension().markLifeCycleHandling(comp);
        binder.loadComponent(comp, true);
        ((BinderImpl)binder).initQueue();
        ((BinderImpl)binder).initActivator();
        if (comp.hasAttribute("$VAR$") || bid != null) {
            BinderUtil.markHandling(comp, binder);
        }
        return false;
    }

    public void afterComponentDetached(Component comp, Page prevpage) {
        this.handleComponentDetached(comp);
    }

    protected void handleComponentDetached(Component comp) {
        comp.addEventListener(10000, "onBindClean", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                Object ref;
                Component comp = event.getTarget();
                comp.removeAttribute(BindUiLifeCycle.REMOVE_MARK);
                comp.removeEventListener("onBindClean", (EventListener)this);
                if (comp.hasAttribute("$VAR$") && (ref = comp.getAttribute((String)comp.getAttribute("$VAR$"))) instanceof ReferenceBinding) {
                    BinderUtil.markHandling(comp, ((ReferenceBinding)ref).getBinder());
                }
                BindUiLifeCycle.this.removeBindings(comp);
            }
        });
        comp.setAttribute(REMOVE_MARK, (Object)Boolean.TRUE);
        if (comp.removeAttribute("$CHILDREN_BINDING_RENDERED_COMPONENTS$") != null) {
            ListModel model = (ListModel)comp.getAttribute("$CHILDREN_BINDING_MODEL$");
            ListDataListener listener = (ListDataListener)comp.removeAttribute("$CHILDREN_BINDING_MODEL_LISTENER$");
            if (model != null && listener != null) {
                model.removeListDataListener(listener);
            }
        }
        comp.setAttribute(SKIP_BIND_INIT, (Object)false);
        Events.postEvent((Event)new Event("onBindClean", comp));
    }

    public void afterComponentMoved(Component parent, Component child, Component prevparent) {
    }

    public void afterPageAttached(Page page, Desktop desktop) {
    }

    public void afterPageDetached(Page page, Desktop prevdesktop) {
        Collection comps = page.getRoots();
        for (Component comp : comps) {
            this.removeBindings(comp);
        }
    }

    public void afterShadowAttached(ShadowElement shadow, Component host) {
        if (shadow instanceof Component) {
            this.handleComponentAttached((Component)shadow);
        }
    }

    public void afterShadowDetached(ShadowElement shadow, Component prevhost) {
        if (shadow instanceof Component) {
            this.handleComponentDetached((Component)shadow);
        }
    }

    private void removeBindings(Component comp) {
        LinkedHashMap<Binder, Set<Component>> batchRemove = new LinkedHashMap<Binder, Set<Component>>();
        this.removeBindingsRecursively(comp, batchRemove);
        for (Map.Entry entry : batchRemove.entrySet()) {
            ((Binder)entry.getKey()).removeBindings((Set)entry.getValue());
        }
    }

    private void removeBindingsRecursively(Component comp, Map<Binder, Set<Component>> batchRemove) {
        this.removeBindings0(comp, batchRemove);
        for (Component kid : comp.getChildren()) {
            if (kid == null) continue;
            this.removeBindingsRecursively(kid, batchRemove);
        }
        if (comp instanceof ComponentCtrl) {
            for (ShadowElement se : ((ComponentCtrl)comp).getShadowRoots()) {
                this.removeBindingsRecursively((Component)se, batchRemove);
            }
        }
    }

    private void removeBindings0(Component comp, Map<Binder, Set<Component>> batchRemove) {
        Binder binder;
        Object installed = comp.removeAttribute("$RENDERER_INSTALLED$");
        if (installed != null) {
            BindELContext.removeModel(comp);
        }
        if ((binder = BinderUtil.getBinder(comp, comp.hasAttribute("$isTemplateModelEnabled$"))) != null) {
            if (batchRemove != null) {
                Set<Component> components = batchRemove.get(binder);
                if (components == null) {
                    components = new LinkedHashSet<Component>();
                    batchRemove.put(binder, components);
                }
                components.add(comp);
            } else {
                binder.removeBindings(comp);
            }
        }
        BindUiLifeCycle.getExtension().removeLifeCycleHandling(comp);
        Object vmIdBinderMap = Executions.getCurrent().getDesktop().getAttribute("org.zkoss.bind.vmId_binder");
        if (vmIdBinderMap != null) {
            ((Map)vmIdBinderMap).remove(comp.getAttribute("$VM_ID$"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Extension getExtension() {
        if (_ext != null) return _ext;
        Class<BindUiLifeCycle> clazz = BindUiLifeCycle.class;
        synchronized (BindUiLifeCycle.class) {
            if (_ext != null) return _ext;
            String clsnm = Library.getProperty((String)"org.zkoss.bind.tracker.impl.extension");
            if (clsnm != null) {
                try {
                    _ext = (Extension)Classes.newInstanceByThread((String)clsnm);
                }
                catch (Throwable ex) {
                    log.error("Unable to instantiate " + clsnm, ex);
                }
            }
            if (_ext != null) return _ext;
            _ext = new DefaultExtension();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _ext;
        }
    }

    public static void markLifeCycleHandling(Component comp) {
        BindUiLifeCycle.getExtension().markLifeCycleHandling(comp);
    }

    private static class DefaultExtension
    implements Extension {
        private DefaultExtension() {
        }

        @Override
        public void markLifeCycleHandling(Component comp) {
        }

        @Override
        public boolean isLifeCycleHandling(Component comp) {
            return false;
        }

        @Override
        public void removeLifeCycleHandling(Component comp) {
        }
    }

    public static interface Extension {
        public void markLifeCycleHandling(Component var1);

        public boolean isLifeCycleHandling(Component var1);

        public void removeLifeCycleHandling(Component var1);
    }
}

