/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.base;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Properties;
import org.adempiere.exceptions.DBException;
import org.compiere.dbPort.Convert;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MMessage;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProductCategoryAcct;
import org.compiere.model.MTest;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class POTest
extends AbstractTestCase {
    @Test
    public void test_Changed() {
        String[] testStrings = new String[]{"a", "test"};
        MTest testPO = new MTest(Env.getCtx(), this.getClass().getName(), 1, this.getTrxName());
        String[] stringArray = testStrings;
        int n = testStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            testPO.setHelp(str);
            testPO.saveEx();
            String originalString = testPO.getHelp();
            String info = "testString=[" + str + "], originalString=[" + originalString + "]";
            Assertions.assertFalse((boolean)testPO.is_ValueChanged("Help"), (String)info);
            Assertions.assertFalse((boolean)testPO.is_Changed(), (String)info);
            testPO.setHelp(originalString);
            Assertions.assertFalse((boolean)testPO.is_ValueChanged("Help"), (String)info);
            Assertions.assertFalse((boolean)testPO.is_Changed(), (String)info);
            testPO.setHelp(originalString + "-changed");
            Assertions.assertTrue((boolean)testPO.is_ValueChanged("Help"), (String)info);
            Assertions.assertTrue((boolean)testPO.is_Changed(), (String)info);
            testPO.setHelp(originalString);
            Assertions.assertFalse((boolean)testPO.is_ValueChanged("Help"), (String)info);
            Assertions.assertFalse((boolean)testPO.is_Changed(), (String)info);
            ++n2;
        }
        testPO.delete(true, this.getTrxName());
    }

    @Test
    public void testTruncatedStrings() {
        StringBuilder sb = new StringBuilder();
        int i = 1;
        while (i <= 1000) {
            sb.append("0123456789");
            ++i;
        }
        String bigString = sb.toString();
        MTest testPO = new MTest(Env.getCtx(), this.getClass().getName(), 1, this.getTrxName());
        POInfo info = POInfo.getPOInfo((Properties)Env.getCtx(), (int)135);
        int maxLength = info.getFieldLength(info.getColumnIndex("Name"));
        testPO.set_ValueOfColumn("Name", (Object)bigString.substring(0, maxLength - 1));
        String resultString = (String)testPO.get_Value("Name");
        Assertions.assertEquals((int)(maxLength - 1), (int)resultString.length(), (String)"String was not truncated correctly (1)");
        testPO.setName(bigString.substring(0, maxLength - 1));
        Assertions.assertEquals((int)(maxLength - 1), (int)testPO.getName().length(), (String)"String was not truncated correctly (2)");
        testPO.set_ValueOfColumn("Name", (Object)bigString.substring(0, maxLength));
        resultString = (String)testPO.get_Value("Name");
        Assertions.assertEquals((int)maxLength, (int)resultString.length(), (String)"String was not truncated correctly (3)");
        testPO.setName(bigString.substring(0, maxLength));
        Assertions.assertEquals((int)maxLength, (int)testPO.getName().length(), (String)"String was not truncated correctly (4)");
        testPO.set_ValueOfColumn("Name", (Object)bigString);
        resultString = (String)testPO.get_Value("Name");
        Assertions.assertEquals((int)maxLength, (int)resultString.length(), (String)"String was not truncated correctly (5)");
        testPO.setName(bigString);
        Assertions.assertEquals((int)maxLength, (int)testPO.getName().length(), (String)"String was not truncated correctly (6)");
    }

    @Test
    public void testAfterSaveError() {
        MyTestPO test = new MyTestPO(Env.getCtx(), true, null);
        Assertions.assertFalse((boolean)test.save(), (String)("Object should not be saved -- " + String.valueOf((Object)test)));
        Assertions.assertFalse((test.get_ID() <= 0 ? 1 : 0) != 0, (String)("Object should not be saved -- " + String.valueOf((Object)test)));
        Assertions.assertFalse((boolean)MyTestPO.exists(test.get_ID(), null), (String)("Object should not be saved(2) -- " + String.valueOf((Object)test)));
        test = null;
        try {
            test = new MyTestPO(Env.getCtx(), false, null);
            Assertions.assertTrue((boolean)test.save(), (String)("Object *should* be saved -- " + String.valueOf((Object)test)));
            MyTestPO test2 = new MyTestPO(Env.getCtx(), test.get_ID(), null);
            Assertions.assertEquals((int)test2.get_ID(), (int)test.get_ID(), (String)"Object not found");
            test2.failOnSave = true;
            test2.setName(test2.getName() + "_2");
            Assertions.assertFalse((boolean)test2.save(), (String)("Object should not be saved -- " + String.valueOf((Object)test2)));
            String name = MyTestPO.getName(test2.get_ID(), null);
            Assertions.assertEquals((Object)test.getName(), (Object)name, (String)("Object should not be modified(2) -- id=" + String.valueOf((Object)test2)));
        }
        finally {
            if (test != null) {
                if (test.getDependent_ID() > 0) {
                    MyTestPO testDependent = new MyTestPO(Env.getCtx(), test.getDependent_ID(), null);
                    testDependent.deleteEx(true);
                }
                test.deleteEx(true);
            }
        }
    }

    @Test
    public void testAfterSaveError_BF2849122() {
        Assertions.assertNotNull((Object)this.getTrxName(), (String)"TrxName should not be null");
        MyTestPO t1 = new MyTestPO(Env.getCtx(), false, this.getTrxName());
        t1.saveEx();
        Assertions.assertTrue((boolean)MyTestPO.exists(t1.get_ID(), this.getTrxName()), (String)("Object not found(1) - t1=" + String.valueOf((Object)t1)));
        Assertions.assertTrue((boolean)MyTestPO.exists(t1.getDependent_ID(), this.getTrxName()), (String)("Object not found(1) - t1(dep)=" + String.valueOf((Object)t1)));
        MyTestPO t2 = new MyTestPO(Env.getCtx(), true, this.getTrxName());
        try {
            t2.saveEx();
        }
        catch (Exception exception) {}
        Assertions.assertTrue((boolean)MyTestPO.exists(t1.get_ID(), this.getTrxName()), (String)("Object not found(2) - t1=" + String.valueOf((Object)t1)));
        Assertions.assertTrue((boolean)MyTestPO.exists(t1.getDependent_ID(), this.getTrxName()), (String)("Object not found(2) - t1(dep)=" + String.valueOf((Object)t1)));
        Assertions.assertFalse((boolean)MyTestPO.exists(t2.get_ID(), this.getTrxName()), (String)("Object found(2) - t2=" + String.valueOf((Object)t2)));
        Assertions.assertFalse((boolean)MyTestPO.exists(t2.getDependent_ID(), this.getTrxName()), (String)("Object found(2) - t2(dep)=" + String.valueOf((Object)t2)));
        MyTestPO t3 = new MyTestPO(Env.getCtx(), false, this.getTrxName());
        t3.saveEx();
        Assertions.assertTrue((boolean)MyTestPO.exists(t1.get_ID(), this.getTrxName()), (String)("Object not found(3) - t1=" + String.valueOf((Object)t1)));
        Assertions.assertTrue((boolean)MyTestPO.exists(t1.getDependent_ID(), this.getTrxName()), (String)("Object not found(3) - t1(dep)=" + String.valueOf((Object)t1)));
        Assertions.assertFalse((boolean)MyTestPO.exists(t2.get_ID(), this.getTrxName()), (String)("Object found(3) - t2=" + String.valueOf((Object)t2)));
        Assertions.assertFalse((boolean)MyTestPO.exists(t2.getDependent_ID(), this.getTrxName()), (String)("Object found(3) - t2(dep)=" + String.valueOf((Object)t2)));
        Assertions.assertTrue((boolean)MyTestPO.exists(t3.get_ID(), this.getTrxName()), (String)("Object not found(3) - t3=" + String.valueOf((Object)t3)));
        Assertions.assertTrue((boolean)MyTestPO.exists(t3.getDependent_ID(), this.getTrxName()), (String)("Object not found(3) - t3(dep)=" + String.valueOf((Object)t3)));
    }

    @Test
    public void testForUpdate() {
        MClient client = new MClient(Env.getCtx(), Env.getAD_Client_ID((Properties)Env.getCtx()), this.getTrxName());
        Assertions.assertDoesNotThrow(() -> {
            boolean ok = DB.getDatabase().forUpdate((PO)client, 5);
            Assertions.assertTrue((boolean)ok);
        });
        try (Trx trx2 = Trx.get((String)Trx.createTrxName(), (boolean)true);){
            trx2.start();
            MClient client2 = new MClient(Env.getCtx(), Env.getAD_Client_ID((Properties)Env.getCtx()), trx2.getTrxName());
            Assertions.assertThrows(DBException.class, () -> DB.getDatabase().forUpdate((PO)client2, 5));
        }
        String description = client.getDescription();
        client.setDescription(client.getName() + ".Description");
        Assertions.assertDoesNotThrow(() -> client.saveEx());
        this.rollback();
        client.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)description, (Object)client.getDescription());
        try (Trx trx3 = Trx.get((String)Trx.createTrxName(), (boolean)true);){
            trx3.start();
            MClient client3 = new MClient(Env.getCtx(), Env.getAD_Client_ID((Properties)Env.getCtx()), trx3.getTrxName());
            Assertions.assertDoesNotThrow(() -> {
                boolean ok = DB.getDatabase().forUpdate((PO)client3, 5);
                Assertions.assertTrue((boolean)ok);
            });
        }
    }

    @Test
    public void testOptimisticLocking() {
        int joeBlock = 118;
        MBPartner bp1 = new MBPartner(Env.getCtx(), joeBlock, this.getTrxName());
        MBPartner bp2 = new MBPartner(Env.getCtx(), joeBlock, this.getTrxName());
        bp1.setDescription("bp1");
        boolean updated = bp1.save();
        Assertions.assertTrue((boolean)updated);
        bp2.setDescription("bp2");
        updated = bp2.save();
        Assertions.assertTrue((boolean)updated);
        bp1 = new MBPartner(Env.getCtx(), joeBlock, this.getTrxName());
        bp2 = new MBPartner(Env.getCtx(), joeBlock, this.getTrxName());
        Assertions.assertEquals((Object)"bp2", (Object)bp1.getDescription());
        Assertions.assertEquals((Object)"bp2", (Object)bp2.getDescription());
        bp1.set_UseOptimisticLocking(true);
        bp1.setDescription("bp1");
        if (DB.isOracle()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        updated = bp1.save();
        Assertions.assertTrue((boolean)updated);
        bp2.set_UseOptimisticLocking(true);
        bp2.setDescription("bp2.1");
        updated = bp2.save();
        Assertions.assertFalse((boolean)updated);
        bp1 = new MBPartner(Env.getCtx(), joeBlock, this.getTrxName());
        bp2 = new MBPartner(Env.getCtx(), joeBlock, this.getTrxName());
        Assertions.assertEquals((Object)"bp1", (Object)bp1.getDescription());
        Assertions.assertEquals((Object)"bp1", (Object)bp2.getDescription());
        bp1.set_UseOptimisticLocking(true);
        bp1.setDescription("bp1.1");
        updated = bp1.save();
        Assertions.assertTrue((boolean)updated);
        bp2.set_UseOptimisticLocking(true);
        bp2.set_OptimisticLockingColumns(new String[]{"Name"});
        bp2.setDescription("bp2");
        updated = bp2.save();
        Assertions.assertTrue((boolean)updated);
        bp1 = new MBPartner(Env.getCtx(), joeBlock, this.getTrxName());
        bp2 = new MBPartner(Env.getCtx(), joeBlock, this.getTrxName());
        Assertions.assertEquals((Object)"bp2", (Object)bp1.getDescription());
        Assertions.assertEquals((Object)"bp2", (Object)bp2.getDescription());
        bp1.set_UseOptimisticLocking(true);
        bp1.setDescription("bp1");
        updated = bp1.save();
        Assertions.assertTrue((boolean)updated);
        bp2.set_UseOptimisticLocking(true);
        bp2.set_OptimisticLockingColumns(new String[]{"Name", "Description"});
        bp2.setDescription("bp2.1");
        updated = bp2.save();
        Assertions.assertFalse((boolean)updated);
        bp1 = new MBPartner(Env.getCtx(), joeBlock, this.getTrxName());
        bp2 = new MBPartner(Env.getCtx(), joeBlock, this.getTrxName());
        Assertions.assertEquals((Object)"bp1", (Object)bp1.getDescription());
        Assertions.assertEquals((Object)"bp1", (Object)bp2.getDescription());
        MMessage msg1 = new MMessage(Env.getCtx(), 0, this.getTrxName());
        msg1.setValue("msg1 test");
        msg1.setMsgText("msg1 test");
        msg1.setMsgType("I");
        msg1.saveEx();
        updated = msg1.delete(true);
        Assertions.assertTrue((boolean)updated);
        msg1 = new MMessage(Env.getCtx(), 0, this.getTrxName());
        msg1.setValue("msg1 test");
        msg1.setMsgText("msg1 test");
        msg1.setMsgType("I");
        msg1.saveEx();
        MMessage msg2 = new MMessage(Env.getCtx(), msg1.getAD_Message_ID(), this.getTrxName());
        msg1.setMsgText("msg 1.1 test");
        if (DB.isOracle()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        msg1.saveEx();
        msg2.set_UseOptimisticLocking(true);
        updated = msg2.delete(true);
        Assertions.assertFalse((boolean)updated);
        msg2 = new MMessage(Env.getCtx(), msg1.getAD_Message_ID(), this.getTrxName());
        Assertions.assertEquals((Object)msg1.getMsgText(), (Object)msg2.getMsgText());
        msg1.setMsgText("msg1 test");
        msg1.saveEx();
        msg2.set_UseOptimisticLocking(true);
        msg2.set_OptimisticLockingColumns(new String[]{"Value"});
        updated = msg2.delete(true);
        Assertions.assertTrue((boolean)updated);
        msg1 = new MMessage(Env.getCtx(), 0, this.getTrxName());
        msg1.setValue("msg1 test");
        msg1.setMsgText("msg1 test");
        msg1.setMsgType("I");
        msg1.saveEx();
        msg2 = new MMessage(Env.getCtx(), msg1.getAD_Message_ID(), this.getTrxName());
        msg1.setMsgText("msg 1.1 test");
        msg1.saveEx();
        msg2.set_UseOptimisticLocking(true);
        msg2.set_OptimisticLockingColumns(new String[]{"Value", "MsgText"});
        updated = msg2.delete(true);
        Assertions.assertFalse((boolean)updated);
        msg2 = new MMessage(Env.getCtx(), msg1.getAD_Message_ID(), this.getTrxName());
        Assertions.assertEquals((Object)msg1.getMsgText(), (Object)msg2.getMsgText());
    }

    @Test
    public void testVirtualColumnLoad() {
        MTest testPo = new MTest(Env.getCtx(), this.getClass().getName(), 1, this.getTrxName());
        testPo.save();
        Assertions.assertTrue((testPo.get_ValueOld("TestVirtualQty") == null ? 1 : 0) != 0);
        BigDecimal expected = new BigDecimal("123.45");
        Assertions.assertEquals((Object)expected, (Object)testPo.getTestVirtualQty().setScale(2, RoundingMode.HALF_UP), (String)"Wrong value returned");
        testPo = new MTest(Env.getCtx(), testPo.get_ID(), this.getTrxName(), new String[]{"TestVirtualQty"});
        Assertions.assertTrue((testPo.get_ValueOld("TestVirtualQty") != null ? 1 : 0) != 0);
        Assertions.assertEquals((Object)expected, (Object)testPo.getTestVirtualQty().setScale(2, RoundingMode.HALF_UP), (String)"Wrong value returned");
    }

    @Test
    public void testLogMigrationScript() {
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        Assertions.assertFalse((boolean)Env.isLogMigrationScript((String)"M_Product"), (String)"Unexpected Log Migration Script default for MProduct");
        Env.getCtx().setProperty("LogMigrationScript", "Y");
        Env.setContext((Properties)Env.getCtx(), (String)"MigrationScriptComment", (String)"testLogMigrationScript");
        Assertions.assertTrue((boolean)Env.isLogMigrationScript((String)"M_Product"), (String)"Unexpected Log Migration Script Y/N value for MProduct");
        MProductCategory lotLevel = new MProductCategory(Env.getCtx(), 0, null);
        lotLevel.setName("testLogMigrationScript");
        lotLevel.saveEx();
        MProduct product = null;
        try {
            MProductCategoryAcct lotLevelAcct = MProductCategoryAcct.get((int)lotLevel.get_ID(), (int)as.get_ID());
            lotLevelAcct = new MProductCategoryAcct(Env.getCtx(), lotLevelAcct);
            lotLevelAcct.setCostingLevel("B");
            lotLevelAcct.saveEx();
            product = new MProduct(Env.getCtx(), 0, null);
            product.setM_Product_Category_ID(lotLevel.get_ID());
            product.setName("testLogMigrationScript");
            product.setProductType("I");
            product.setIsStocked(true);
            product.setIsSold(true);
            product.setIsPurchased(true);
            product.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            product.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            product.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
            product.saveEx();
        }
        finally {
            this.rollback();
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
            lotLevel.deleteEx(true);
        }
        String fileName = Convert.getGeneratedMigrationScriptFileName();
        String folderPg = Convert.getMigrationScriptFolder((String)"postgresql");
        String folderOr = Convert.getMigrationScriptFolder((String)"oracle");
        Convert.closeLogMigrationScript();
        File file = new File(folderPg + fileName);
        Assertions.assertTrue((boolean)file.exists(), (String)("Not found: " + folderPg + fileName));
        file.delete();
        file = new File(folderOr + fileName);
        Assertions.assertTrue((boolean)file.exists(), (String)("Not found: " + folderOr + fileName));
        file.delete();
    }

    @Test
    public void testIsVirtualColumnMethods() {
        MColumn column = MColumn.get((Properties)Env.getCtx(), (String)"Test", (String)"TestVirtualQty");
        Assertions.assertTrue((boolean)column.isVirtualColumn(), (String)("MColumn.isVirtualColumn() not working as expected for ColumnSQL=" + column.getColumnSQL()));
        Assertions.assertTrue((boolean)column.isVirtualDBColumn(), (String)("MColumn.isVirtualDBColumn() not working as expected for ColumnSQL=" + column.getColumnSQL()));
        Assertions.assertFalse((boolean)column.isVirtualUIColumn(), (String)("MColumn.isVirtualUIColumn() not working as expected for ColumnSQL=" + column.getColumnSQL()));
        Assertions.assertFalse((boolean)column.isVirtualSearchColumn(), (String)("MColumn.isVirtualSearchColumn() not working as expected for ColumnSQL=" + column.getColumnSQL()));
        column = MColumn.get((Properties)Env.getCtx(), (String)"M_ProductionLine", (String)"ProductType");
        Assertions.assertTrue((boolean)column.isVirtualColumn(), (String)("MColumn.isVirtualColumn() not working as expected for ColumnSQL=" + column.getColumnSQL()));
        Assertions.assertFalse((boolean)column.isVirtualDBColumn(), (String)("MColumn.isVirtualDBColumn() not working as expected for ColumnSQL=" + column.getColumnSQL()));
        Assertions.assertFalse((boolean)column.isVirtualUIColumn(), (String)("MColumn.isVirtualUIColumn() not working as expected for ColumnSQL=" + column.getColumnSQL()));
        Assertions.assertTrue((boolean)column.isVirtualSearchColumn(), (String)("MColumn.isVirtualSearchColumn() not working as expected for ColumnSQL=" + column.getColumnSQL()));
        column = MColumn.get((Properties)Env.getCtx(), (String)"Test", (String)"TestVirtualQty");
        column = new MColumn(column);
        column.setColumnSQL("@SQL=" + column.getColumnSQL());
        Assertions.assertTrue((boolean)column.isVirtualColumn(), (String)("MColumn.isVirtualColumn() not working as expected for ColumnSQL=" + column.getColumnSQL()));
        Assertions.assertFalse((boolean)column.isVirtualDBColumn(), (String)("MColumn.isVirtualDBColumn() not working as expected for ColumnSQL=" + column.getColumnSQL()));
        Assertions.assertTrue((boolean)column.isVirtualUIColumn(), (String)("MColumn.isVirtualUIColumn() not working as expected for ColumnSQL=" + column.getColumnSQL()));
        Assertions.assertFalse((boolean)column.isVirtualSearchColumn(), (String)("MColumn.isVirtualSearchColumn() not working as expected for ColumnSQL=" + column.getColumnSQL()));
    }

    public static class MyTestPO
    extends MTest {
        private static final long serialVersionUID = -6861171283806782985L;
        protected boolean failOnSave = false;
        private MyTestPO m_parent = null;
        private MyTestPO m_dependentRecord = null;

        public static String getName(int Test_ID, String trxName) {
            String sql = "SELECT Name FROM Test WHERE Test_ID=?";
            return DB.getSQLValueStringEx((String)trxName, (String)sql, (Object[])new Object[]{Test_ID});
        }

        public static boolean exists(int Test_ID, String trxName) {
            int id = DB.getSQLValueEx((String)trxName, (String)"SELECT Test_ID FROM Test WHERE Test_ID=?", (Object[])new Object[]{Test_ID});
            return id > 0 && id == Test_ID;
        }

        public MyTestPO(Properties ctx, boolean failOnSave, String trxName) {
            super(ctx, "Test_" + System.currentTimeMillis(), 10, trxName);
            this.setDescription(String.valueOf(((Object)((Object)this)).getClass()));
            this.failOnSave = failOnSave;
        }

        public MyTestPO(Properties ctx, int id, String trxName) {
            super(ctx, id, trxName);
        }

        protected boolean afterSave(boolean newRecord, boolean success) {
            if (this.m_parent == null) {
                this.m_dependentRecord = new MyTestPO(this.getCtx(), false, this.get_TrxName());
                this.m_dependentRecord.m_parent = this;
                this.m_dependentRecord.setName("D_" + this.getName());
                this.m_dependentRecord.saveEx();
            }
            if (this.failOnSave) {
                throw new RuntimeException("Never save this object [trxName=" + this.get_TrxName() + ", success=" + success + "]");
            }
            return true;
        }

        public int getDependent_ID() {
            return this.m_dependentRecord != null ? this.m_dependentRecord.get_ID() : -1;
        }
    }
}

