/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.printformat.editor.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.print.attribute.standard.MediaSize;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.adwindow.ADWindowContent;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.component.ZkCssHelper;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.print.MPrintColor;
import org.compiere.print.MPrintFont;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.MPrintPaper;
import org.compiere.print.layout.LocationElement;
import org.compiere.print.layout.StringElement;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Evaluator;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.printformat.editor.FieldPosition;
import org.idempiere.printformat.editor.PrintAreaBean;
import org.idempiere.printformat.editor.action.EditorAction;
import org.idempiere.printformat.editor.ui.PrintFormatEditorUtil;
import org.idempiere.printformat.editor.ui.WPrintFormatEditorForm;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.DropEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.KeyEvent;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Absolutechildren;
import org.zkoss.zul.Div;
import org.zkoss.zul.Window;

public class WPrintFormatEditor
implements ValueChangeListener {
    private static final String PRINTFORMAT_ITEM_ATTR = "printFormatItem";
    private static final String PT = "pt";
    private static final String selectedStyle = "curser:pointer; border:solid 1px #0000FF;";
    private static final String normalStyle = "curser:pointer; border:solid 1px #CCC;";
    private static final int AREA_HEADER = 0;
    private static final int AREA_CONTENT = 1;
    private static final int AREA_FOOTER = 2;
    protected float paperHeight = 11.5f;
    protected float paperWidth = 8.0f;
    private float leftRef = 0.0f;
    private float rightRef = 0.0f;
    private float topRef = 0.0f;
    private float bottomRef = 0.0f;
    private WPrintFormatEditorForm printFormatForm = null;
    private HashMap<MPrintFormatItem, Absolutechildren> printFormatItemMap = new HashMap();
    private LinkedHashMap<MPrintFormatItem, FieldPosition> fieldPosMap = new LinkedHashMap();
    private Map<MPrintFormatItem, String> testValueMap = new HashMap<MPrintFormatItem, String>();
    private Div prevSelectedItem = null;
    private String prevStyle = "";
    private ArrayList<MPrintFormatItem> formatItems;
    private HashMap<String, WEditor> editorMap = new HashMap();
    private ArrayList<String> currentEditors = new ArrayList();
    protected MPrintFormat m_printFormat = null;
    private float lineHeight;
    private int AD_PrintFormat_ID;
    private ADWindowContent adWindowContent;
    private static final CLogger log = CLogger.getCLogger(WPrintFormatEditor.class);
    private EventListener<Event> onSelectListner = e -> this.onSelect(e);

    public WPrintFormatEditor(int AD_PrintFormat_ID, ADWindowContent adWindowContent) {
        this.AD_PrintFormat_ID = AD_PrintFormat_ID;
        this.adWindowContent = adWindowContent;
        this.printFormatForm = new WPrintFormatEditorForm(this);
        LayoutUtils.addSclass((String)"report-editor-form", (HtmlBasedComponent)this.printFormatForm);
    }

    public void showEditorWindow() {
        try {
            this.m_printFormat = new MPrintFormat(Env.getCtx(), this.AD_PrintFormat_ID, null);
            this.loadPrintPaper();
            this.printFormatForm.init();
            String title = Msg.getMsg((Properties)Env.getCtx(), (String)(EditorAction.class.getName() + ".label"), (boolean)true);
            title = Util.cleanAmp((String)title);
            this.printFormatForm.setTitle(title + ": " + this.m_printFormat.getName());
            this.printFormatForm.setVisible(true);
            this.printFormatForm.setAttribute("mode", Window.Mode.HIGHLIGHTED);
            SessionManager.getAppDesktop().showWindow((Window)this.printFormatForm);
            this.initMap();
            this.initFormatItemListbox();
            this.updatePreview();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getLocalizedMessage(), (Throwable)ex);
        }
    }

    private void loadPrintPaper() {
        int paperID = this.m_printFormat.getAD_PrintPaper_ID();
        MPrintPaper printPaper = MPrintPaper.get((int)paperID);
        this.paperHeight = printPaper.getSizeY().floatValue();
        this.paperWidth = printPaper.getSizeX().floatValue();
        if (this.paperHeight > 0.0f & this.paperWidth > 0.0f) {
            if ("M".equals(printPaper.getDimensionUnits())) {
                this.paperHeight = PrintFormatEditorUtil.mmToPointValue(this.paperHeight);
                this.paperWidth = PrintFormatEditorUtil.mmToPointValue(this.paperWidth);
            } else {
                this.paperHeight = PrintFormatEditorUtil.inchToPointValue(this.paperHeight);
                this.paperWidth = PrintFormatEditorUtil.inchToPointValue(this.paperWidth);
            }
        } else {
            MediaSize mediaSize = printPaper.getMediaSize();
            float mediaHeight = 0.0f;
            float mediaWidth = 0.0f;
            if ("M".equals(printPaper.getDimensionUnits())) {
                mediaHeight = mediaSize.getY(1000);
                mediaWidth = mediaSize.getX(1000);
                this.paperHeight = PrintFormatEditorUtil.mmToPointValue(mediaHeight);
                this.paperWidth = PrintFormatEditorUtil.mmToPointValue(mediaWidth);
            } else {
                mediaHeight = mediaSize.getY(25400);
                mediaWidth = mediaSize.getX(25400);
                this.paperHeight = PrintFormatEditorUtil.inchToPointValue(mediaHeight);
                this.paperWidth = PrintFormatEditorUtil.inchToPointValue(mediaWidth);
            }
        }
        if (printPaper.isLandscape()) {
            float t = this.paperHeight;
            this.paperHeight = this.paperWidth;
            this.paperWidth = t;
        }
        this.leftRef = printPaper.getMarginLeft();
        this.rightRef = printPaper.getMarginRight();
        this.topRef = printPaper.getMarginTop();
        this.bottomRef = printPaper.getMarginBottom();
    }

    private float getActualPaperWidth() {
        return this.paperWidth - this.leftRef - this.rightRef;
    }

    private float getActualPaperHeight() {
        return this.paperHeight - this.topRef - this.bottomRef;
    }

    private void initPrintArea(PrintAreaBean[] pArea) {
        float x = 0.0f;
        float y = 0.0f;
        if (!this.m_printFormat.isForm() || this.m_printFormat.isStandardHeaderFooter() || this.m_printFormat.getAD_PrintHeaderFooter_ID() > 0) {
            pArea[1] = new PrintAreaBean(1, x, y);
        } else {
            float height = 0.0f;
            height = this.m_printFormat.getHeaderMargin();
            pArea[0] = new PrintAreaBean(0, x, y);
            y += height;
            height = this.getActualPaperHeight() - (float)this.m_printFormat.getHeaderMargin() - (float)this.m_printFormat.getFooterMargin();
            pArea[1] = new PrintAreaBean(1, x, y);
            pArea[2] = new PrintAreaBean(2, x, y += height);
        }
    }

    private void initMap() {
        this.editorMap.put("IsSuppressNull", this.printFormatForm.supressNull);
        this.editorMap.put("IsSetNLPosition", this.printFormatForm.setNLPosition);
        this.editorMap.put("IsRelativePosition", (WEditor)this.printFormatForm.relativePosition);
        this.editorMap.put("IsFilledRectangle", this.printFormatForm.fillShape);
        this.editorMap.put("IsNextPage", this.printFormatForm.nextPage);
        this.editorMap.put("IsNextLine", this.printFormatForm.nextLine);
        this.editorMap.put("IsHeightOneLine", this.printFormatForm.oneLineOnly);
        this.editorMap.put("ImageIsAttached", this.printFormatForm.imageAttached);
        this.editorMap.put("IsImageField", this.printFormatForm.imageField);
        this.editorMap.put("IsFixedWidth", this.printFormatForm.fixedWidth);
        this.editorMap.put("YPosition", this.printFormatForm.yPosition);
        this.editorMap.put("XPosition", this.printFormatForm.xPosition);
        this.editorMap.put("YSpace", this.printFormatForm.ySpace);
        this.editorMap.put("XSpace", this.printFormatForm.xSpace);
        this.editorMap.put("MaxHeight", this.printFormatForm.maxHeight);
        this.editorMap.put("MaxWidth", this.printFormatForm.maxWidth);
        this.editorMap.put("ArcDiameter", this.printFormatForm.arcDiameter);
        this.editorMap.put("ShapeType", this.printFormatForm.shapeType);
        this.editorMap.put("AD_PrintFormatChild_ID", this.printFormatForm.includedPrintFormat);
        this.editorMap.put("AD_PrintColor_ID", this.printFormatForm.printColor);
        this.editorMap.put("LineWidth", this.printFormatForm.lineWidth);
        this.editorMap.put("LineAlignmentType", this.printFormatForm.lineAlignment);
        this.editorMap.put("ImageURL", this.printFormatForm.imageUrl);
        this.editorMap.put("AD_PrintFont_ID", this.printFormatForm.printFont);
        this.editorMap.put("FieldAlignmentType", this.printFormatForm.fieldAlignment);
        this.editorMap.put("Name", this.printFormatForm.editorName);
        this.editorMap.put("SeqNo", this.printFormatForm.editorSeqNo);
        this.editorMap.put("PrintAreaType", this.printFormatForm.printAreaType);
        this.editorMap.put("PrintName", this.printFormatForm.editorPrintName);
        this.editorMap.put("BelowColumn", this.printFormatForm.editorBelowColumn);
        this.editorMap.put("FormatPattern", this.printFormatForm.editorFormatPattern);
        this.editorMap.put("Script", this.printFormatForm.editorScript);
        this.editorMap.put("IsOrderBy", this.printFormatForm.editorIsOrderBy);
        this.editorMap.put("SortNo", this.printFormatForm.editorSortNo);
        this.editorMap.put("IsGroupBy", this.printFormatForm.editorIsGroupBy);
        this.editorMap.put("IsAveraged", this.printFormatForm.editorIsAveraged);
        this.editorMap.put("IsCounted", this.printFormatForm.editorIsCounted);
        this.editorMap.put("IsDeviationCalc", this.printFormatForm.editorIsDeviationCalc);
        this.editorMap.put("IsMaxCalc", this.printFormatForm.editorIsMaxCalc);
        this.editorMap.put("IsMinCalc", this.printFormatForm.editorIsMinCalc);
        this.editorMap.put("IsSummarized", this.printFormatForm.editorIsSummarized);
        this.editorMap.put("IsVarianceCalc", this.printFormatForm.editorIsVarianceCalc);
        this.editorMap.put("IsRunningTotal", this.printFormatForm.editorIsRunningTotal);
        this.editorMap.put("RunningTotalLines", this.printFormatForm.editorRunningTotalLines);
        this.editorMap.put("IsPrintInstanceAttributes", this.printFormatForm.editorIsPrintInstanceAttributes);
    }

    private void validateProperties(final MPrintFormatItem pfItem) {
        Evaluatee evaluatee = new Evaluatee(){

            public String get_ValueAsString(String variableName) {
                MPrintFormat format;
                String retString = null;
                String foreignColumn = "";
                int f = variableName.indexOf(46);
                if (f > 0) {
                    foreignColumn = variableName.substring(f + 1, variableName.length());
                    variableName = variableName.substring(0, f);
                }
                if (pfItem.get_ColumnIndex(variableName) >= 0) {
                    retString = pfItem.get_Value(variableName) instanceof Boolean ? (pfItem.get_Value(variableName).equals(true) ? "Y" : "N") : pfItem.get_ValueAsString(variableName);
                }
                if (!Util.isEmpty(retString) && !Util.isEmpty((String)foreignColumn) && variableName.endsWith("_ID")) {
                    int id = 0;
                    try {
                        id = Integer.parseInt(retString);
                    }
                    catch (Exception exception) {}
                    if (id > 0) {
                        String foreignTable = variableName.substring(0, variableName.length() - 3);
                        MTable table = MTable.get((Properties)Env.getCtx(), (String)foreignTable);
                        if (table != null) {
                            retString = DB.getSQLValueString(null, (String)("SELECT " + foreignColumn + " FROM " + foreignTable + " WHERE " + foreignTable + "_ID = ?"), (int)id);
                        }
                    }
                }
                if (Util.isEmpty(retString) && (format = MPrintFormat.get((Properties)Env.getCtx(), (int)pfItem.getAD_PrintFormat_ID(), (boolean)false)).get_ColumnIndex(variableName) >= 0) {
                    retString = format.get_Value(variableName) instanceof Boolean ? (format.get_Value(variableName).equals(true) ? "Y" : "N") : format.get_ValueAsString(variableName);
                }
                return retString;
            }
        };
        for (Map.Entry<String, WEditor> entry : this.editorMap.entrySet()) {
            String sql = "Select displaylogic from AD_Field Where AD_Column_ID = ? ";
            String logic = DB.getSQLValueString(null, (String)sql, (int)MColumn.getColumn_ID((String)"AD_PrintFormatItem", (String)entry.getKey()));
            boolean retValue = true;
            if (logic != null && logic.trim().length() > 0) {
                retValue = Evaluator.evaluateLogic((Evaluatee)evaluatee, (String)logic);
            }
            if (retValue) {
                entry.getValue().getComponent().getParent().setVisible(true);
                if (this.currentEditors.contains(entry.getKey())) continue;
                this.currentEditors.add(entry.getKey());
                continue;
            }
            entry.getValue().getComponent().getParent().setVisible(false);
            if (!this.currentEditors.contains(entry.getKey())) continue;
            this.currentEditors.remove(entry.getKey());
        }
    }

    private void updatePreview() {
        if (this.m_printFormat.isForm()) {
            this.updateFormPreview();
        } else {
            this.updateTablePreview();
        }
    }

    private void updateFormPreview() {
        PrintAreaBean[] printArea = new PrintAreaBean[3];
        this.initPrintArea(printArea);
        float[] prevWidth = new float[]{0.0f, 0.0f, 0.0f};
        float[] prevHeight = new float[]{0.0f, 0.0f, 0.0f};
        float nlPosition = 0.0f;
        this.printFormatForm.printLayout.getChildren().clear();
        this.printFormatItemMap.clear();
        this.fieldPosMap.clear();
        Absolutechildren area = new Absolutechildren();
        area.setX(PrintFormatEditorUtil.pointToPixel(this.leftRef));
        area.setY(PrintFormatEditorUtil.pointToPixel(this.topRef));
        Div printableArea = new Div();
        PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)printableArea, "border: 1px black solid; background-color: white;", false);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)printableArea, (String)(this.getActualPaperWidth() + PT));
        ZKUpdateUtil.setHeight((HtmlBasedComponent)printableArea, (String)(this.getActualPaperHeight() + PT));
        printableArea.setTooltiptext(printableArea.getWidth() + " x " + printableArea.getHeight());
        area.appendChild((Component)printableArea);
        this.printFormatForm.printLayout.appendChild((Component)area);
        this.lineHeight = (float)new FontMetrics(MPrintFont.get((int)this.m_printFormat.getAD_PrintFont_ID()).getFont()){
            private static final long serialVersionUID = 7467192921216454967L;
        }.getHeight() * 1.25f;
        for (MPrintFormatItem pfItem : this.formatItems) {
            if (!pfItem.isActive() || pfItem.getSeqNo() <= 0 || !pfItem.isPrinted()) continue;
            int currentPrintArea = 1;
            float x = 0.0f;
            float y = 0.0f;
            float width = 0.0f;
            float height = 0.0f;
            if (pfItem.getPrintAreaType().equals("H")) {
                currentPrintArea = 0;
            } else if (pfItem.getPrintAreaType().equals("F")) {
                currentPrintArea = 2;
            }
            Absolutechildren child = new Absolutechildren();
            x = printArea[currentPrintArea].getCurrentX();
            y = printArea[currentPrintArea].getCurrentY();
            if (pfItem.isRelativePosition() && pfItem.isSetNLPosition()) {
                nlPosition = 0.0f;
            }
            if (pfItem.isNextLine()) {
                y = y + (prevHeight[currentPrintArea] > 0.0f ? prevHeight[currentPrintArea] : this.lineHeight) + 2.0f;
                x = nlPosition;
            } else {
                x = x + prevWidth[currentPrintArea] + 2.0f;
            }
            if (pfItem.isRelativePosition()) {
                x += (float)pfItem.getXSpace();
                y += (float)pfItem.getYSpace();
            } else {
                x = printArea[currentPrintArea].getPointX() + (float)pfItem.getXPosition();
                y = printArea[currentPrintArea].getPointY() + (float)pfItem.getYPosition();
                if (pfItem.isSetNLPosition()) {
                    nlPosition = x;
                }
            }
            Div fieldDiv = new Div();
            fieldDiv.setAttribute(PRINTFORMAT_ITEM_ATTR, (Object)pfItem);
            String printText = pfItem.getPrintName();
            if (pfItem.getPrintFormatType().equals("F") || pfItem.getPrintFormatType().equals("T") || pfItem.getPrintFormatType().equals("I")) {
                Object printString = printText != null ? printText : "";
                String displayData = this.testValueMap.get(pfItem);
                if (pfItem.isTypeText()) {
                    if (displayData != null && displayData.length() > 0) {
                        printString = displayData;
                    } else if (((String)printString).length() == 0) {
                        printString = "{" + pfItem.getName() + "}";
                    }
                } else {
                    printString = (String)printString + (String)(displayData != null ? displayData : "{" + pfItem.getName() + "}");
                }
                if (pfItem.getAD_Column().getAD_Reference_ID() == 21) {
                    element = new LocationElement(Env.getCtx(), 109, this.getFont(pfItem), (Paint)Color.black, pfItem.isHeightOneLine(), "", "", Env.getAD_Language((Properties)Env.getCtx()));
                    width = pfItem.getMaxWidth() > 0 ? (float)pfItem.getMaxWidth() : element.getWidth();
                    height = pfItem.getMaxHeight() > 0 ? (float)pfItem.getMaxHeight() : element.getHeight();
                } else if (pfItem.getPrintFormatType().equals("I")) {
                    width = pfItem.getMaxWidth();
                    height = pfItem.getMaxHeight();
                } else {
                    element = new StringElement((String)printString, this.getFont(pfItem), null, null, false);
                    width = pfItem.getMaxWidth() > 0 ? (float)pfItem.getMaxWidth() : element.getWidth();
                    height = pfItem.getMaxHeight() > 0 ? (float)pfItem.getMaxHeight() : element.getHeight();
                }
                Label text = new Label((String)printString);
                text.setTooltiptext((String)printString);
                PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)text, this.getCssColorStyle(pfItem), false);
                if (pfItem.isHeightOneLine()) {
                    PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)text, "white-space: nowrap;", true);
                }
                PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)fieldDiv, normalStyle, true);
                PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)fieldDiv, "overflow: hidden;", true);
                fieldDiv.appendChild((Component)text);
                if (pfItem.getMaxWidth() == 0 && pfItem.isFieldAlignBlock()) {
                    width = this.getActualPaperWidth();
                    x = 0.0f;
                    y = y + (prevHeight[currentPrintArea] > 0.0f ? prevHeight[currentPrintArea] : this.lineHeight) + 2.0f;
                }
            } else if (pfItem.getPrintFormatType().equals("R")) {
                if (pfItem.getShapeType().equals("N")) {
                    PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)fieldDiv, "border: 1pt solid black;", false);
                } else if (pfItem.getShapeType().equals("R")) {
                    PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)fieldDiv, "border-radius: " + pfItem.getArcDiameter() / 2 + "pt;border: 1pt solid black;", false);
                }
                width = pfItem.getMaxWidth();
                height = pfItem.getMaxHeight();
                if (pfItem.isFilledRectangle() && (itemColor = this.getPrintColor(pfItem)) != null && itemColor.getAD_PrintColor_ID() > 0) {
                    PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)fieldDiv, "background-color: #" + ZkCssHelper.createHexColorString((Color)itemColor.getColor()) + ";", true);
                }
            } else if (pfItem.getPrintFormatType().equals("P")) {
                Label text = new Label(pfItem.getName() + "(Included print format)");
                PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)text, this.getCssColorStyle(pfItem), false);
                fieldDiv.appendChild((Component)text);
                height = this.lineHeight;
                ZKUpdateUtil.setHeight((HtmlBasedComponent)fieldDiv, (String)(height + PT));
                fieldDiv.setStyle("border: 2px solid black;");
                width = this.getActualPaperWidth() - 4.0f;
                x += 2.0f;
            } else if (pfItem.getPrintFormatType().equals("L")) {
                width = pfItem.getMaxWidth();
                height = pfItem.getLineWidth();
                itemColor = this.getPrintColor(pfItem);
                PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)fieldDiv, "background-color: #" + ZkCssHelper.createHexColorString((Color)itemColor.getColor()) + ";", true);
            }
            ZKUpdateUtil.setHeight((HtmlBasedComponent)fieldDiv, (String)(height + PT));
            if (width > 0.0f) {
                ZKUpdateUtil.setWidth((HtmlBasedComponent)fieldDiv, (String)(width + PT));
            }
            if (pfItem.isTypePrintFormat()) {
                height += 2.0f;
            }
            if (x + width > this.getActualPaperWidth() && pfItem.getMaxWidth() == 0) {
                width = this.getActualPaperWidth() - x;
                ZKUpdateUtil.setWidth((HtmlBasedComponent)fieldDiv, (String)(width + PT));
                if (!pfItem.isHeightOneLine()) {
                    ZKUpdateUtil.setHeight((HtmlBasedComponent)fieldDiv, (String)((height *= 2.0f) + PT));
                }
                PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)fieldDiv, "overflow: hidden;", true);
            }
            prevHeight[currentPrintArea] = height != this.lineHeight && !pfItem.getPrintFormatType().equals("R") ? height : 0.0f;
            prevWidth[currentPrintArea] = !pfItem.getPrintFormatType().equals("R") ? width : 0.0f;
            printArea[currentPrintArea].setCurrentX(x);
            printArea[currentPrintArea].setCurrentY(y);
            child.setX(PrintFormatEditorUtil.pointToPixel(x + this.leftRef));
            child.setY(PrintFormatEditorUtil.pointToPixel(y + this.topRef));
            child.setDroppable("true");
            child.addEventListener("onDrop", e -> this.onDrop((DropEvent)e));
            child.appendChild((Component)fieldDiv);
            child.setDraggable("true");
            this.printFormatForm.printLayout.appendChild((Component)child);
            PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)fieldDiv, "text-align:" + PrintFormatEditorUtil.getAlignmentStyleCSS(pfItem) + ";", true);
            this.printFormatItemMap.put(pfItem, child);
            if (this.printFormatForm.printedItemListbox.getSelectedItem().getValue().equals(pfItem)) {
                this.prevStyle = fieldDiv.getStyle();
                this.prevSelectedItem = fieldDiv;
                PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)fieldDiv, selectedStyle, true);
            }
            fieldDiv.addEventListener("onClick", e -> this.onFieldDivClick(e));
            FieldPosition pos = new FieldPosition();
            pos.setX(x);
            pos.setY(y);
            pos.setPrintFormatItem(pfItem);
            this.fieldPosMap.put(pfItem, pos);
        }
        if (!this.m_printFormat.isStandardHeaderFooter() && this.m_printFormat.getAD_PrintHeaderFooter_ID() == 0) {
            Absolutechildren line = new Absolutechildren();
            ZKUpdateUtil.setHeight((HtmlBasedComponent)line, (String)"0px");
            line.setId("headerMargin");
            line.setStyle("border: 1px solid #666;cursor: move;");
            line.setY(PrintFormatEditorUtil.pointToPixel((float)this.m_printFormat.getHeaderMargin() + this.topRef));
            line.setX(PrintFormatEditorUtil.pointToPixel(this.leftRef) - 2);
            ZKUpdateUtil.setWidth((HtmlBasedComponent)line, (String)(this.getActualPaperWidth() + 4.0f + PT));
            line.setDraggable("true");
            this.printFormatForm.printLayout.appendChild((Component)line);
            line = new Absolutechildren();
            ZKUpdateUtil.setHeight((HtmlBasedComponent)line, (String)"0px");
            line.setStyle("border: 1px solid #666;cursor: move;");
            line.setY(PrintFormatEditorUtil.pointToPixel(this.paperHeight - this.bottomRef - (float)this.m_printFormat.getFooterMargin()));
            line.setX(PrintFormatEditorUtil.pointToPixel(this.leftRef) - 2);
            ZKUpdateUtil.setWidth((HtmlBasedComponent)line, (String)(this.getActualPaperWidth() + 4.0f + PT));
            line.setDraggable("true");
            line.setId("footerMargin");
            this.printFormatForm.printLayout.appendChild((Component)line);
        }
    }

    private void updateTablePreview() {
        PrintAreaBean[] printArea = new PrintAreaBean[3];
        this.initPrintArea(printArea);
        float[] prevWidth = new float[]{0.0f, 0.0f, 0.0f};
        float[] prevHeight = new float[]{0.0f, 0.0f, 0.0f};
        this.printFormatForm.printLayout.getChildren().clear();
        this.printFormatItemMap.clear();
        this.fieldPosMap.clear();
        Absolutechildren area = new Absolutechildren();
        area.setX(PrintFormatEditorUtil.pointToPixel(this.leftRef));
        area.setY(PrintFormatEditorUtil.pointToPixel(this.topRef));
        Div printableArea = new Div();
        PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)printableArea, "border: 1px black solid; background-color: white;", false);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)printableArea, (String)(this.getActualPaperWidth() + PT));
        ZKUpdateUtil.setHeight((HtmlBasedComponent)printableArea, (String)(this.getActualPaperHeight() + PT));
        printableArea.setTooltiptext(printableArea.getWidth() + " x " + printableArea.getHeight());
        area.appendChild((Component)printableArea);
        this.printFormatForm.printLayout.appendChild((Component)area);
        this.lineHeight = (float)new FontMetrics(MPrintFont.get((int)this.m_printFormat.getAD_PrintFont_ID()).getFont()){
            private static final long serialVersionUID = 7467192921216454967L;
        }.getHeight() * 1.25f;
        ArrayList<float[]> columns = new ArrayList<float[]>();
        for (MPrintFormatItem pfItem : this.formatItems) {
            if (!pfItem.isActive() || pfItem.getSeqNo() <= 0 || !pfItem.isPrinted()) continue;
            int currentPrintArea = 1;
            float x = 0.0f;
            float y = 0.0f;
            float width = 0.0f;
            float height = 0.0f;
            Absolutechildren child = new Absolutechildren();
            x = printArea[currentPrintArea].getCurrentX();
            y = printArea[currentPrintArea].getCurrentY();
            float[] belowColumn = null;
            if (pfItem.isNextLine() && pfItem.getBelowColumn() > 0 && pfItem.getBelowColumn() <= columns.size()) {
                belowColumn = (float[])columns.get(pfItem.getBelowColumn() - 1);
            } else {
                x = x + prevWidth[currentPrintArea] + 2.0f;
            }
            Div fieldDiv = new Div();
            fieldDiv.setAttribute(PRINTFORMAT_ITEM_ATTR, (Object)pfItem);
            String printText = pfItem.getPrintName();
            if (pfItem.getPrintFormatType().equals("F") || pfItem.getPrintFormatType().equals("T") || pfItem.getPrintFormatType().equals("I")) {
                Object printString = printText != null ? printText + "\n" : "";
                String displayData = this.testValueMap.get(pfItem);
                if (pfItem.isTypeText()) {
                    if (displayData != null && displayData.length() > 0) {
                        printString = displayData;
                    } else if (((String)printString).length() == 0) {
                        printString = "{" + pfItem.getName() + "}";
                    }
                } else if (belowColumn == null) {
                    printString = (String)printString + (String)(displayData != null ? displayData : "{" + pfItem.getName() + "}");
                } else {
                    Object object = printString = displayData != null ? displayData : "{" + pfItem.getName() + "}";
                }
                if (pfItem.getAD_Column().getAD_Reference_ID() == 21) {
                    element = new LocationElement(Env.getCtx(), 109, this.getFont(pfItem), (Paint)Color.black, pfItem.isHeightOneLine(), "", "", Env.getAD_Language((Properties)Env.getCtx()));
                    width = pfItem.getMaxWidth() > 0 ? (float)pfItem.getMaxWidth() : element.getWidth();
                    height = pfItem.getMaxHeight() > 0 ? (float)pfItem.getMaxHeight() : element.getHeight();
                } else if (pfItem.getPrintFormatType().equals("I")) {
                    width = pfItem.getMaxWidth();
                    height = pfItem.getMaxHeight();
                } else {
                    element = new StringElement((String)printString, this.getFont(pfItem), null, null, false);
                    width = pfItem.getMaxWidth() > 0 ? (float)pfItem.getMaxWidth() : element.getWidth();
                    height = element.getHeight() + 4.0f;
                }
                Label text = new Label((String)printString);
                text.setMultiline(true);
                text.setTooltiptext((String)printString);
                PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)text, this.getCssColorStyle(pfItem), false);
                if (pfItem.isHeightOneLine()) {
                    PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)text, "white-space: nowrap;", true);
                }
                PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)fieldDiv, normalStyle, true);
                PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)fieldDiv, "overflow: hidden;", true);
                fieldDiv.appendChild((Component)text);
            } else if (pfItem.getPrintFormatType().equals("R")) {
                if (pfItem.getShapeType().equals("N")) {
                    PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)fieldDiv, "border: 1pt solid black;", false);
                } else if (pfItem.getShapeType().equals("R")) {
                    PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)fieldDiv, "border-radius: " + pfItem.getArcDiameter() / 2 + "pt;border: 1pt solid black;", false);
                }
                width = pfItem.getMaxWidth();
                height = pfItem.getMaxHeight();
                if (pfItem.isFilledRectangle() && (itemColor = this.getPrintColor(pfItem)) != null && itemColor.getAD_PrintColor_ID() > 0) {
                    PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)fieldDiv, "background-color: #" + ZkCssHelper.createHexColorString((Color)itemColor.getColor()) + ";", true);
                }
            } else if (pfItem.getPrintFormatType().equals("P")) {
                Label text = new Label(pfItem.getName() + "(Included print format)");
                PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)text, this.getCssColorStyle(pfItem), false);
                fieldDiv.appendChild((Component)text);
                height = this.lineHeight;
                ZKUpdateUtil.setHeight((HtmlBasedComponent)fieldDiv, (String)(height + PT));
                fieldDiv.setStyle("border: 2px solid black;");
                width = this.getActualPaperWidth() - 4.0f;
                x += 2.0f;
            } else if (pfItem.getPrintFormatType().equals("L")) {
                width = pfItem.getMaxWidth();
                height = pfItem.getLineWidth();
                itemColor = this.getPrintColor(pfItem);
                PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)fieldDiv, "background-color: #" + ZkCssHelper.createHexColorString((Color)itemColor.getColor()) + ";", true);
            }
            if (belowColumn != null) {
                x = belowColumn[0];
                y = belowColumn[1] + belowColumn[3] + 2.0f;
                width = belowColumn[2];
                belowColumn[1] = y;
                belowColumn[3] = height;
            }
            ZKUpdateUtil.setHeight((HtmlBasedComponent)fieldDiv, (String)(height + PT));
            if (width > 0.0f) {
                ZKUpdateUtil.setWidth((HtmlBasedComponent)fieldDiv, (String)(width + PT));
            }
            if (pfItem.isTypePrintFormat()) {
                height += 2.0f;
            }
            if (belowColumn == null) {
                prevHeight[currentPrintArea] = height != this.lineHeight && !pfItem.getPrintFormatType().equals("R") ? height : 0.0f;
                prevWidth[currentPrintArea] = !pfItem.getPrintFormatType().equals("R") ? width : 0.0f;
                printArea[currentPrintArea].setCurrentX(x);
                printArea[currentPrintArea].setCurrentY(y);
            }
            child.setX(PrintFormatEditorUtil.pointToPixel(x + this.leftRef));
            child.setY(PrintFormatEditorUtil.pointToPixel(y + this.topRef));
            child.setDroppable("true");
            child.addEventListener("onDrop", e -> this.onDrop((DropEvent)e));
            child.appendChild((Component)fieldDiv);
            child.setDraggable("true");
            this.printFormatForm.printLayout.appendChild((Component)child);
            PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)fieldDiv, "text-align:" + PrintFormatEditorUtil.getAlignmentStyleCSS(pfItem) + ";", true);
            this.printFormatItemMap.put(pfItem, child);
            if (this.printFormatForm.printedItemListbox.getSelectedItem().getValue().equals(pfItem)) {
                this.prevStyle = fieldDiv.getStyle();
                this.prevSelectedItem = fieldDiv;
                PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)fieldDiv, selectedStyle, true);
            }
            fieldDiv.addEventListener("onClick", e -> this.onFieldDivClick(e));
            FieldPosition pos = new FieldPosition();
            pos.setX(x);
            pos.setY(y);
            pos.setPrintFormatItem(pfItem);
            this.fieldPosMap.put(pfItem, pos);
            if (belowColumn != null) continue;
            columns.add(new float[]{x, y, width, height});
        }
        if (this.m_printFormat.isStandardHeaderFooter()) {
            Absolutechildren line = new Absolutechildren();
            ZKUpdateUtil.setHeight((HtmlBasedComponent)line, (String)"0px");
            line.setId("headerMargin");
            line.setStyle("border: 1px solid #666;cursor: move;");
            line.setY(PrintFormatEditorUtil.pointToPixel((float)this.m_printFormat.getHeaderMargin() + this.topRef));
            line.setX(PrintFormatEditorUtil.pointToPixel(this.leftRef) - 2);
            ZKUpdateUtil.setWidth((HtmlBasedComponent)line, (String)(this.getActualPaperWidth() + 4.0f + PT));
            line.setDraggable("true");
            this.printFormatForm.printLayout.appendChild((Component)line);
            line = new Absolutechildren();
            ZKUpdateUtil.setHeight((HtmlBasedComponent)line, (String)"0px");
            line.setStyle("border: 1px solid #666;cursor: move;");
            line.setY(PrintFormatEditorUtil.pointToPixel(this.paperHeight - this.bottomRef - (float)this.m_printFormat.getFooterMargin()));
            line.setX(PrintFormatEditorUtil.pointToPixel(this.leftRef) - 2);
            ZKUpdateUtil.setWidth((HtmlBasedComponent)line, (String)(this.getActualPaperWidth() + 4.0f + PT));
            line.setDraggable("true");
            line.setId("footerMargin");
            this.printFormatForm.printLayout.appendChild((Component)line);
        }
    }

    private Font getFont(MPrintFormatItem pfItem) {
        Font font = null;
        if (pfItem.getAD_PrintFont_ID() > 0) {
            font = MPrintFont.get((int)pfItem.getAD_PrintFont_ID()).getFont();
        } else if (this.m_printFormat.getAD_PrintFont_ID() > 0) {
            font = MPrintFont.get((int)this.m_printFormat.getAD_PrintFont_ID()).getFont();
        }
        return font;
    }

    private void setItemSelected(MPrintFormatItem pfItem) {
        if (pfItem != null) {
            this.validateProperties(pfItem);
            this.setProperties(pfItem);
            Div fieldDiv = (Div)this.printFormatItemMap.get(pfItem).getFirstChild();
            this.printFormatForm.printedItemListbox.setSelectedIndex(this.formatItems.indexOf(pfItem));
            if (this.prevSelectedItem != null) {
                PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)this.prevSelectedItem, this.prevStyle, false);
                PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)fieldDiv, "text-align:" + PrintFormatEditorUtil.getAlignmentStyleCSS(pfItem) + ";", true);
            }
            this.prevStyle = fieldDiv.getStyle();
            this.prevSelectedItem = fieldDiv;
            PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)fieldDiv, selectedStyle, false);
            PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)fieldDiv, "text-align:" + PrintFormatEditorUtil.getAlignmentStyleCSS(pfItem) + ";", true);
            PrintFormatEditorUtil.addCSSStyle((HtmlBasedComponent)fieldDiv, "overflow: hidden;", true);
            StringBuilder script = new StringBuilder();
            script.append("var w = zk.Widget.$('#").append(fieldDiv.getUuid()).append("');");
            script.append("if (!(zk(w).isRealScrollIntoView())) w.$n().scrollIntoView();");
            Clients.evalJavaScript((String)script.toString());
        }
    }

    private String getCssColorStyle(MPrintFormatItem pfItem) {
        Color color;
        MPrintColor mPrintColor;
        Object style = "";
        Font font = this.getFont(pfItem);
        if (font != null) {
            String fontFamily = font.getFamily();
            if ((fontFamily = PrintFormatEditorUtil.getCSSFontFamily(fontFamily)).equalsIgnoreCase("dialog")) {
                fontFamily = "sans-serif";
            }
            Object object = style = fontFamily != null ? "font-family:" + fontFamily + ";" : "";
            if (font.isBold()) {
                style = (String)style + "font-weight:bold;";
            }
            if (font.isItalic()) {
                style = (String)style + "font-style:italic;";
            }
            int size = font.getSize();
            style = (String)style + "font-size:" + size + "pt;";
        }
        if ((mPrintColor = this.getPrintColor(pfItem)) != null && mPrintColor.getAD_PrintColor_ID() > 0 && (color = mPrintColor.getColor()) != null) {
            style = (String)style + "color: #" + ZkCssHelper.createHexColorString((Color)color) + ";";
        }
        return style;
    }

    private MPrintColor getPrintColor(MPrintFormatItem pfItem) {
        MPrintColor mPrintColor = null;
        if (pfItem.getAD_PrintColor_ID() > 0) {
            mPrintColor = MPrintColor.get((Properties)Env.getCtx(), (int)pfItem.getAD_PrintColor_ID());
        } else if (this.m_printFormat.getAD_PrintColor_ID() > 0) {
            mPrintColor = MPrintColor.get((Properties)Env.getCtx(), (int)this.m_printFormat.getAD_PrintColor_ID());
        }
        return mPrintColor;
    }

    private void initFormatItemListbox() {
        MPrintFormatItem[] formatItem;
        this.formatItems = new ArrayList();
        MPrintFormatItem[] mPrintFormatItemArray = formatItem = this.m_printFormat.getAllItems();
        int n = formatItem.length;
        int n2 = 0;
        while (n2 < n) {
            MPrintFormatItem pfItem = mPrintFormatItemArray[n2];
            this.formatItems.add(pfItem);
            ++n2;
        }
        this.updateLists(null);
        this.resortArrays();
    }

    private void setProperties(MPrintFormatItem pfItem) {
        for (String columnName : this.currentEditors) {
            WEditor editor = this.editorMap.get(columnName);
            editor.setValue(pfItem.get_Value(columnName));
        }
        this.printFormatForm.editorTestValue.setValue((Object)this.testValueMap.get(pfItem));
    }

    public void dispose() {
        SessionManager.getAppDesktop().closeActiveWindow();
    }

    public void valueChange(ValueChangeEvent e) {
        MPrintFormatItem pfItem = (MPrintFormatItem)this.printFormatForm.printedItemListbox.getSelectedItem().getValue();
        if (!"_TestValue_".equals(e.getPropertyName())) {
            pfItem.set_ValueOfColumn(e.getPropertyName(), e.getNewValue());
            this.validateProperties(pfItem);
        } else {
            this.testValueMap.put(pfItem, (String)e.getNewValue());
        }
        this.updatePreview();
    }

    private void onFieldDivClick(Event event) {
        if (event.getTarget() instanceof Div && event.getName().equals("onClick") && event.getTarget().hasAttribute(PRINTFORMAT_ITEM_ATTR)) {
            Div fieldDiv = (Div)event.getTarget();
            MPrintFormatItem pfItem = (MPrintFormatItem)fieldDiv.getAttribute(PRINTFORMAT_ITEM_ATTR);
            this.setItemSelected(pfItem);
        }
    }

    private void onSelect(Event event) {
        Listbox list = (Listbox)event.getTarget();
        if (list.getSelectedItem() != null) {
            MPrintFormatItem pfItem = (MPrintFormatItem)list.getSelectedItem().getValue();
            this.setItemSelected(pfItem);
        }
    }

    protected void onConfirmPanelClick(Event event) {
        if (event.getTarget().getId().equals("Ok")) {
            this.onOk();
        } else if (event.getTarget().getId().equals("Cancel")) {
            this.onCancel();
        } else if (event.getTarget().getId().equals("Reset")) {
            this.onReset();
        }
    }

    private void onReset() {
        this.m_printFormat.load(null, new String[0]);
        this.initFormatItemListbox();
        this.updatePreview();
    }

    protected void onCancel() {
        this.printFormatForm.detach();
    }

    protected void onOk() {
        this.m_printFormat.saveEx();
        for (MPrintFormatItem item : this.formatItems) {
            if (!item.isActive()) continue;
            item.saveEx();
        }
        this.onCancel();
        this.adWindowContent.onRefresh();
    }

    protected void onCtrlKey(KeyEvent keyEvent) {
        MPrintFormatItem pfItem = (MPrintFormatItem)this.prevSelectedItem.getAttribute(PRINTFORMAT_ITEM_ATTR);
        int currentX = PrintFormatEditorUtil.getX(pfItem);
        int currentY = PrintFormatEditorUtil.getY(pfItem);
        switch (keyEvent.getKeyCode()) {
            case 37: {
                PrintFormatEditorUtil.setX(pfItem, currentX - 1);
                this.setProperties(pfItem);
                break;
            }
            case 39: {
                PrintFormatEditorUtil.setX(pfItem, currentX + 1);
                this.setProperties(pfItem);
                break;
            }
            case 38: {
                PrintFormatEditorUtil.setY(pfItem, currentY - 1);
                this.setProperties(pfItem);
                break;
            }
            case 40: {
                PrintFormatEditorUtil.setY(pfItem, currentY + 1);
                this.setProperties(pfItem);
                break;
            }
            case 46: {
                this.hideItem(pfItem);
            }
        }
        this.updatePreview();
    }

    protected void onDrop(DropEvent de) {
        ListItem startItem = null;
        ListItem endItem = null;
        if (de.getDragged() instanceof ListItem) {
            startItem = (ListItem)de.getDragged();
        }
        if (de.getTarget() instanceof ListItem) {
            endItem = (ListItem)de.getTarget();
        }
        if (startItem != null && endItem != null) {
            if (startItem.getListbox() == this.printFormatForm.printedItemListbox && endItem.getListbox() == this.printFormatForm.nonPrintedItemListbox) {
                MPrintFormatItem pfItem = (MPrintFormatItem)startItem.getValue();
                this.hideItem(pfItem);
                this.updateLists(null);
                this.updatePreview();
                this.setProperties((MPrintFormatItem)this.prevSelectedItem.getAttribute(PRINTFORMAT_ITEM_ATTR));
            } else if (startItem.getListbox() == this.printFormatForm.nonPrintedItemListbox && endItem.getListbox() == this.printFormatForm.printedItemListbox && startItem.getValue() != null) {
                MPrintFormatItem pfItem = (MPrintFormatItem)startItem.getValue();
                MPrintFormatItem pfItemTo = (MPrintFormatItem)endItem.getValue();
                pfItem.setSeqNo(pfItemTo.getSeqNo() - 5);
                pfItem.setIsPrinted(true);
                this.resortArrays();
                this.setProperties(pfItem);
                this.updateLists(pfItem);
                this.updatePreview();
            } else if (startItem.getListbox() == this.printFormatForm.printedItemListbox && endItem.getListbox() == this.printFormatForm.printedItemListbox) {
                MPrintFormatItem pfItem = (MPrintFormatItem)startItem.getValue();
                MPrintFormatItem pfItem2 = (MPrintFormatItem)endItem.getValue();
                pfItem.setSeqNo(pfItem2.getSeqNo() - 1);
                this.resortArrays();
                this.setProperties(pfItem);
                this.updateLists(pfItem);
                this.updatePreview();
            }
        } else if (startItem == null && endItem == null) {
            Absolutechildren child = (Absolutechildren)de.getDragged();
            if ("headerMargin".equals(child.getId())) {
                float ptY = PrintFormatEditorUtil.pixelToPointValue(de.getY());
                this.m_printFormat.setHeaderMargin(Float.valueOf(ptY - this.topRef).intValue());
                this.updatePreview();
                return;
            }
            if ("footerMargin".equals(child.getId())) {
                float ptY = PrintFormatEditorUtil.pixelToPointValue(de.getY());
                this.m_printFormat.setFooterMargin(Float.valueOf(this.paperHeight - this.bottomRef - ptY).intValue());
                this.updatePreview();
                return;
            }
            MPrintFormatItem pfItem = (MPrintFormatItem)child.getFirstChild().getAttribute(PRINTFORMAT_ITEM_ATTR);
            Component target = de.getTarget();
            MPrintFormatItem targetItem = target.getFirstChild() != null ? (MPrintFormatItem)target.getFirstChild().getAttribute(PRINTFORMAT_ITEM_ATTR) : null;
            float ptY = PrintFormatEditorUtil.pixelToPointValue(de.getY());
            float ptX = PrintFormatEditorUtil.pixelToPointValue(de.getX());
            if (targetItem == null) {
                if (pfItem.isRelativePosition()) {
                    FieldPosition fieldpos = this.fieldPosMap.get(pfItem);
                    float diffX = ptX - fieldpos.getX() - this.leftRef;
                    float diffY = ptY - fieldpos.getY() - this.topRef;
                    PrintFormatEditorUtil.setX(pfItem, diffX);
                    PrintFormatEditorUtil.setY(pfItem, diffY);
                }
                if (this.m_printFormat.isStandardHeaderFooter() || this.m_printFormat.getAD_PrintHeaderFooter_ID() > 0) {
                    if (!pfItem.isRelativePosition()) {
                        PrintFormatEditorUtil.setY(pfItem, ptY - this.topRef);
                    }
                    pfItem.setPrintAreaType("C");
                } else if (ptY < this.topRef + (float)this.m_printFormat.getHeaderMargin()) {
                    if (!"H".equals(pfItem.getPrintAreaType())) {
                        pfItem.setPrintAreaType("H");
                        if (pfItem.isRelativePosition()) {
                            pfItem.setIsRelativePosition(false);
                        }
                    }
                    if (!pfItem.isRelativePosition()) {
                        PrintFormatEditorUtil.setY(pfItem, ptY - this.topRef);
                    }
                } else if (ptY > this.paperHeight - this.bottomRef - (float)this.m_printFormat.getFooterMargin()) {
                    if (!"F".equals(pfItem.getPrintAreaType())) {
                        pfItem.setPrintAreaType("F");
                        if (pfItem.isRelativePosition()) {
                            pfItem.setIsRelativePosition(false);
                        }
                    }
                    if (!pfItem.isRelativePosition()) {
                        PrintFormatEditorUtil.setY(pfItem, ptY - (this.paperHeight - this.bottomRef - (float)this.m_printFormat.getFooterMargin()));
                    }
                } else {
                    if (!"C".equals(pfItem.getPrintAreaType())) {
                        pfItem.setPrintAreaType("C");
                        if (pfItem.isRelativePosition()) {
                            pfItem.setIsRelativePosition(false);
                        }
                    }
                    if (!pfItem.isRelativePosition()) {
                        PrintFormatEditorUtil.setY(pfItem, ptY - this.topRef - (float)this.m_printFormat.getHeaderMargin());
                    }
                }
                if (!pfItem.isRelativePosition()) {
                    PrintFormatEditorUtil.setX(pfItem, ptX - this.leftRef);
                }
            } else {
                pfItem.setSeqNo(targetItem.getSeqNo() + 1);
                pfItem.setIsRelativePosition(true);
                pfItem.setXSpace(0);
                pfItem.setYSpace(0);
                pfItem.setIsPrinted(true);
                pfItem.setPrintAreaType(targetItem.getPrintAreaType());
                this.resortArrays();
            }
            this.setProperties(pfItem);
            this.updateLists(pfItem);
            this.updatePreview();
        } else if (startItem != null && endItem == null) {
            Component target = de.getTarget();
            MPrintFormatItem targetItem = target.getFirstChild() != null ? (MPrintFormatItem)target.getFirstChild().getAttribute(PRINTFORMAT_ITEM_ATTR) : null;
            MPrintFormatItem pfItem = (MPrintFormatItem)startItem.getValue();
            if (targetItem == null) {
                FieldPosition fieldPos = this.fieldPosMap.get(pfItem);
                if (fieldPos == null) {
                    pfItem.setIsRelativePosition(false);
                }
                float ptX = PrintFormatEditorUtil.pixelToPointValue(de.getX());
                float ptY = PrintFormatEditorUtil.pixelToPointValue(de.getY());
                if (fieldPos == null || !pfItem.isRelativePosition()) {
                    PrintFormatEditorUtil.setX(pfItem, ptX - this.leftRef);
                } else {
                    float diffX = ptX - fieldPos.getX();
                    float diffY = ptY - fieldPos.getY();
                    PrintFormatEditorUtil.setX(pfItem, diffX);
                    PrintFormatEditorUtil.setY(pfItem, diffY);
                }
                if (this.m_printFormat.isStandardHeaderFooter()) {
                    if (fieldPos == null || !pfItem.isRelativePosition()) {
                        PrintFormatEditorUtil.setY(pfItem, ptY - this.topRef);
                    }
                    pfItem.setPrintAreaType("C");
                } else if (ptY < this.topRef + (float)this.m_printFormat.getHeaderMargin()) {
                    if (!"H".equals(pfItem.getPrintAreaType())) {
                        pfItem.setPrintAreaType("H");
                        if (pfItem.isRelativePosition()) {
                            pfItem.setIsRelativePosition(false);
                            PrintFormatEditorUtil.setX(pfItem, ptX - this.leftRef);
                        }
                    }
                    if (!pfItem.isRelativePosition()) {
                        PrintFormatEditorUtil.setY(pfItem, ptY - this.topRef);
                    }
                } else if (ptY > this.paperHeight - this.bottomRef - (float)this.m_printFormat.getFooterMargin()) {
                    if (!"F".equals(pfItem.getPrintAreaType())) {
                        pfItem.setPrintAreaType("F");
                        if (pfItem.isRelativePosition()) {
                            pfItem.setIsRelativePosition(false);
                            PrintFormatEditorUtil.setX(pfItem, ptX - this.leftRef);
                        }
                    }
                    if (!pfItem.isRelativePosition()) {
                        PrintFormatEditorUtil.setY(pfItem, ptY - (this.paperHeight - this.bottomRef - (float)this.m_printFormat.getFooterMargin()));
                    }
                } else {
                    if (!"C".equals(pfItem.getPrintAreaType())) {
                        pfItem.setPrintAreaType("C");
                        if (pfItem.isRelativePosition()) {
                            pfItem.setIsRelativePosition(false);
                            PrintFormatEditorUtil.setX(pfItem, ptX - this.leftRef);
                        }
                    }
                    if (!pfItem.isRelativePosition()) {
                        PrintFormatEditorUtil.setY(pfItem, ptY - this.topRef - (float)this.m_printFormat.getHeaderMargin());
                    }
                }
                pfItem.setIsPrinted(true);
                if (startItem.getListbox() == this.printFormatForm.nonPrintedItemListbox) {
                    pfItem.setSeqNo((this.printFormatItemMap.size() + 1) * 10 + 5);
                }
                this.resortArrays();
            } else {
                pfItem.setSeqNo(targetItem.getSeqNo() + 1);
                pfItem.setIsRelativePosition(true);
                pfItem.setXSpace(0);
                pfItem.setYSpace(0);
                pfItem.setIsPrinted(true);
                pfItem.setPrintAreaType(targetItem.getPrintAreaType());
                this.resortArrays();
            }
            this.setProperties(pfItem);
            this.updateLists(pfItem);
            this.updatePreview();
        } else if (startItem == null && endItem != null) {
            Absolutechildren child = (Absolutechildren)de.getDragged();
            MPrintFormatItem pfItem = (MPrintFormatItem)child.getFirstChild().getAttribute(PRINTFORMAT_ITEM_ATTR);
            this.hideItem(pfItem);
            this.updatePreview();
            this.setProperties((MPrintFormatItem)this.prevSelectedItem.getAttribute(PRINTFORMAT_ITEM_ATTR));
        }
    }

    private void hideItem(MPrintFormatItem pfItem) {
        pfItem.setSeqNo(0);
        pfItem.setIsPrinted(false);
        this.resortArrays();
        this.updateLists(null);
    }

    private void updateLists(MPrintFormatItem selectedItem) {
        ListItem item;
        this.printFormatForm.printedItemListbox.removeAllItems();
        this.printFormatForm.nonPrintedItemListbox.removeAllItems();
        this.printFormatForm.printedItemListbox.removeEventListener("onSelect", this.onSelectListner);
        this.printFormatForm.printedItemListbox.addEventListener("onSelect", this.onSelectListner);
        for (MPrintFormatItem pfItem : this.formatItems) {
            if (!pfItem.isActive()) continue;
            ListItem item2 = new ListItem(pfItem.getName(), (Object)pfItem);
            item2.setDroppable("true");
            item2.setDraggable("true");
            item2.addEventListener("onDrop", e -> this.onDrop((DropEvent)e));
            if (pfItem.isPrinted()) {
                this.printFormatForm.printedItemListbox.appendChild((Component)item2);
                if (selectedItem == null || pfItem != selectedItem) continue;
                item2.setSelected(true);
                continue;
            }
            this.printFormatForm.nonPrintedItemListbox.appendChild((Component)item2);
            if (selectedItem == null || pfItem != selectedItem) continue;
            item2.setSelected(true);
        }
        if (this.printFormatForm.nonPrintedItemListbox.getItems().isEmpty()) {
            item = new ListItem("...", null);
            item.setDroppable("true");
            this.printFormatForm.nonPrintedItemListbox.appendChild((Component)item);
            item.addEventListener("onDrop", e -> this.onDrop((DropEvent)e));
        }
        if (this.printFormatForm.printedItemListbox.getItems().isEmpty()) {
            item = new ListItem("...", null);
            item.setDroppable("true");
            this.printFormatForm.printedItemListbox.appendChild((Component)item);
            item.addEventListener("onDrop", e -> this.onDrop((DropEvent)e));
        }
        if (selectedItem == null) {
            this.printFormatForm.printedItemListbox.setSelectedIndex(0);
        }
        if (this.printFormatForm.printedItemListbox.getSelectedItem().getValue() != null) {
            this.validateProperties((MPrintFormatItem)this.printFormatForm.printedItemListbox.getSelectedItem().getValue());
            this.setProperties((MPrintFormatItem)this.printFormatForm.printedItemListbox.getSelectedItem().getValue());
        }
    }

    private void resortArrays() {
        Collections.sort(this.formatItems, new Comparator<MPrintFormatItem>(){

            @Override
            public int compare(MPrintFormatItem pfItem1, MPrintFormatItem pfItem2) {
                String compare1 = String.format("%s%10d%s", !pfItem1.isPrinted() ? "1" : "0", pfItem1.isPrinted() ? pfItem1.getSeqNo() : 0, pfItem1.getName());
                String compare2 = String.format("%s%10d%s", !pfItem2.isPrinted() ? "1" : "0", pfItem2.isPrinted() ? pfItem2.getSeqNo() : 0, pfItem2.getName());
                return compare1.compareTo(compare2);
            }
        });
        int seq = 10;
        for (MPrintFormatItem pfItem : this.formatItems) {
            if (!pfItem.isActive()) continue;
            if (pfItem.isPrinted()) {
                pfItem.setSeqNo(seq);
                seq += 10;
                continue;
            }
            pfItem.setSeqNo(0);
        }
    }
}

