/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.adempiere.webui.adwindow.ADTabpanel;
import org.adempiere.webui.adwindow.GridView;
import org.adempiere.webui.adwindow.QuickGridView;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.panel.CustomizeGridViewPanel;
import org.adempiere.webui.panel.QuickCustomizeGridViewPanel;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.GridField;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zul.Column;
import org.zkoss.zul.Columns;

public class CustomizeGridViewDialog
extends Window {
    private static final long serialVersionUID = -138153049225192685L;
    private CustomizeGridViewPanel customizePanel;
    private QuickCustomizeGridViewPanel quickCustomizePanel;
    private boolean isQuickForm = false;

    public CustomizeGridViewDialog(int windowNo, int AD_Tab_ID, int AD_User_ID, Map<Integer, String> columnsWidth, ArrayList<Integer> gridFieldIds, boolean isQuickForm) {
        this.setClosable(true);
        this.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"Customize"));
        this.isQuickForm = isQuickForm;
        this.initComponent(windowNo, AD_Tab_ID, AD_User_ID, columnsWidth, gridFieldIds);
    }

    private void initComponent(int windowNo, int AD_Tab_ID, int AD_User_ID, Map<Integer, String> columnsWidth, ArrayList<Integer> gridFieldIds) {
        if (this.isQuickForm) {
            this.quickCustomizePanel = new QuickCustomizeGridViewPanel(windowNo, AD_Tab_ID, AD_User_ID, columnsWidth, gridFieldIds);
        } else {
            this.customizePanel = new CustomizeGridViewPanel(windowNo, AD_Tab_ID, AD_User_ID, columnsWidth, gridFieldIds);
        }
        this.setStyle("position : relative;");
        this.setBorder("normal");
        this.setSclass("popup-dialog customize-grid-view-dialog");
        if (this.isQuickForm) {
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 500);
            ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, 410);
            this.quickCustomizePanel.createUI();
            this.quickCustomizePanel.loadData();
            this.appendChild((Component)this.quickCustomizePanel);
        } else {
            if (!ThemeManager.isUseCSSForWindowSize()) {
                ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 600);
                ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, 500);
            } else {
                this.addCallback("afterPageAttached", (Callback & Serializable)t -> {
                    ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this);
                    ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this);
                });
            }
            this.appendChild((Component)this.customizePanel);
            this.customizePanel.createUI();
            this.customizePanel.query();
        }
        this.addEventListener("onCancel", e -> this.customizePanel.onCancel());
    }

    public boolean isSaved() {
        if (this.isQuickForm) {
            return this.quickCustomizePanel.isSaved();
        }
        return this.customizePanel.isSaved();
    }

    public void setGridPanel(GridView gridPanel) {
        this.customizePanel.setGridPanel(gridPanel);
    }

    @Deprecated(forRemoval=true, since="11")
    public static boolean onCustomize(ADTabpanel tabPanel) {
        CustomizeGridViewDialog.onCustomize(tabPanel, null);
        return true;
    }

    public static void onCustomize(ADTabpanel tabPanel, org.adempiere.util.Callback<Boolean> callback) {
        Columns columns = tabPanel.getGridView().getListbox().getColumns();
        List columnList = columns.getChildren();
        GridField[] fields = tabPanel.getGridView().getFields();
        HashMap<Integer, String> columnsWidth = new HashMap<Integer, String>();
        ArrayList<Integer> gridFieldIds = new ArrayList<Integer>();
        int i = 0;
        while (i < fields.length) {
            int offset = tabPanel.getGridView().isShowCurrentRowIndicatorColumn() ? 2 : 1;
            Column column = (Column)columnList.get(i + offset);
            String width = column.getWidth();
            if ("0px".equals(width) && column.getAttribute("column.width.original") != null) {
                width = (String)column.getAttribute("column.width.original");
            }
            columnsWidth.put(fields[i].getAD_Field_ID(), width);
            gridFieldIds.add(fields[i].getAD_Field_ID());
            ++i;
        }
        CustomizeGridViewDialog.showCustomize(0, tabPanel.getGridTab().getAD_Tab_ID(), columnsWidth, gridFieldIds, tabPanel.getGridView(), null, false, callback);
    }

    @Deprecated(forRemoval=true, since="11")
    public static boolean showCustomize(int WindowNo, int AD_Tab_ID, Map<Integer, String> columnsWidth, ArrayList<Integer> gridFieldIds, GridView gridPanel, QuickGridView quickGridView, boolean isQuickForm) {
        CustomizeGridViewDialog.showCustomize(WindowNo, AD_Tab_ID, columnsWidth, gridFieldIds, gridPanel, quickGridView, isQuickForm, null);
        return true;
    }

    public static void showCustomize(int WindowNo, int AD_Tab_ID, Map<Integer, String> columnsWidth, ArrayList<Integer> gridFieldIds, GridView gridPanel, QuickGridView quickGridView, boolean isQuickForm, org.adempiere.util.Callback<Boolean> callback) {
        CustomizeGridViewDialog customizeWindow = new CustomizeGridViewDialog(WindowNo, AD_Tab_ID, Env.getAD_User_ID((Properties)Env.getCtx()), columnsWidth, gridFieldIds, isQuickForm);
        if (isQuickForm) {
            customizeWindow.setquickGridView(quickGridView);
        } else {
            customizeWindow.setGridPanel(gridPanel);
        }
        customizeWindow.addCallback("afterPageDetached", (Callback & Serializable)t -> {
            if (callback != null) {
                callback.onCallback((Object)customizeWindow.isSaved());
            }
        });
        AEnv.showWindow(customizeWindow);
    }

    private void setquickGridView(QuickGridView quickGridView) {
        this.quickCustomizePanel.setGridPanel(quickGridView);
    }
}

