/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.factory;

import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.adempiere.base.MappedByNameFactory;
import org.adempiere.webui.factory.IFormFactory;
import org.adempiere.webui.factory.IMappedFormFactory;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.IFormController;
import org.compiere.util.CLogger;
import org.idempiere.ui.zk.annotation.Form;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Component;

@Component(name="org.adempiere.webui.factory.MappedFormFactory", immediate=true, service={IFormFactory.class, IMappedFormFactory.class}, property={"service.ranking:Integer=1"})
public class MappedFormFactory
extends MappedByNameFactory<ADForm>
implements IFormFactory,
IMappedFormFactory {
    private static final CLogger s_log = CLogger.getCLogger(MappedFormFactory.class);

    @Override
    public ADForm newFormInstance(String formName) {
        return (ADForm)this.newInstance(formName);
    }

    @Override
    public void scan(BundleContext context, String ... packages) {
        ClassLoader classLoader = ((BundleWiring)context.getBundle().adapt(BundleWiring.class)).getClassLoader();
        ClassGraph graph = new ClassGraph().enableAnnotationInfo().overrideClassLoaders(new ClassLoader[]{classLoader}).disableNestedJarScanning().disableModuleScanning().acceptPackagesNonRecursive(packages);
        Throwable throwable = null;
        Object var6_7 = null;
        try (ScanResult scanResult = graph.scan();){
            for (ClassInfo classInfo : scanResult.getClassesWithAnnotation(Form.class)) {
                if (classInfo.isAbstract()) continue;
                String className = classInfo.getName();
                try {
                    Class clazz = classInfo.loadClass();
                    Constructor constructor = clazz.getConstructor(new Class[0]);
                    FormSupplier supplier = new FormSupplier(constructor);
                    AnnotationInfo annotationInfo = classInfo.getAnnotationInfo(Form.class);
                    String alternateName = null;
                    if (annotationInfo != null) {
                        alternateName = (String)annotationInfo.getParameterValues().getValue("name");
                    }
                    this.addMapping(className, supplier);
                    if (alternateName == null) continue;
                    this.addMapping(alternateName, supplier);
                }
                catch (Exception e) {
                    if (!s_log.isLoggable(Level.INFO)) continue;
                    s_log.log(Level.INFO, e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static final class FormSupplier
    implements Supplier<ADForm> {
        private Constructor<?> constructor;

        private FormSupplier(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        @Override
        public ADForm get() {
            ADForm form = null;
            try {
                Object formObject = this.constructor.newInstance(new Object[0]);
                if (formObject != null) {
                    if (formObject instanceof ADForm) {
                        form = (ADForm)formObject;
                    } else if (formObject instanceof IFormController) {
                        IFormController controller = (IFormController)formObject;
                        form = controller.getForm();
                        form.setICustomForm(controller);
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                s_log.log(Level.WARNING, e.getMessage(), (Throwable)e);
            }
            return form;
        }
    }
}

