/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.util.ArrayList;
import java.util.List;
import org.adempiere.base.IServiceReferenceHolder;
import org.adempiere.base.Service;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.factory.IEditorFactory;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.util.CCache;

public class WebEditorFactory {
    private static final CCache<Long, IServiceReferenceHolder<IEditorFactory>> s_editorFactoryCache = new CCache(null, "IEditorFactory", 10, false);

    public static WEditor getEditor(GridField gridField, boolean tableEditor) {
        return WebEditorFactory.getEditor(gridField, tableEditor, null);
    }

    public static WEditor getEditor(GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        return WebEditorFactory.getEditor(gridField.getGridTab(), gridField, tableEditor, editorConfiguration);
    }

    public static WEditor getEditor(GridTab gridTab, GridField gridField, boolean tableEditor) {
        return WebEditorFactory.getEditor(gridTab, gridField, tableEditor, null);
    }

    public static WEditor getEditor(GridTab gridTab, GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        ArrayList<Long> visitedIds = new ArrayList<Long>();
        if (!s_editorFactoryCache.isEmpty()) {
            Long[] keys;
            Long[] longArray = keys = s_editorFactoryCache.keySet().toArray(new Long[0]);
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                Long key = longArray[n2];
                IServiceReferenceHolder serviceReference = (IServiceReferenceHolder)s_editorFactoryCache.get((Object)key);
                if (serviceReference != null) {
                    IEditorFactory service = (IEditorFactory)serviceReference.getService();
                    if (service != null) {
                        visitedIds.add(key);
                        WEditor editor = service.getEditor(gridTab, gridField, tableEditor, editorConfiguration);
                        if (editor != null) {
                            return editor;
                        }
                    } else {
                        s_editorFactoryCache.remove((Object)key);
                    }
                }
                ++n2;
            }
        }
        WEditor editor = null;
        List serviceReferences = Service.locator().list(IEditorFactory.class).getServiceReferences();
        for (IServiceReferenceHolder serviceReference : serviceReferences) {
            IEditorFactory service;
            Long serviceId = (Long)serviceReference.getServiceReference().getProperty("service.id");
            if (visitedIds.contains(serviceId) || (service = (IEditorFactory)serviceReference.getService()) == null) continue;
            s_editorFactoryCache.put((Object)serviceId, (Object)serviceReference);
            editor = service.getEditor(gridTab, gridField, tableEditor, editorConfiguration);
            if (editor != null) break;
        }
        return editor;
    }
}

