/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.adempiere.base.IServiceReferenceHolder;
import org.adempiere.base.Service;
import org.adempiere.base.ServiceQuery;
import org.adempiere.webui.adwindow.IADTabpanel;
import org.adempiere.webui.apps.IProcessParameterListener;
import org.adempiere.webui.apps.graph.IChartRendererService;
import org.adempiere.webui.factory.IADTabPanelFactory;
import org.adempiere.webui.factory.IDashboardGadgetFactory;
import org.adempiere.webui.factory.IFormFactory;
import org.adempiere.webui.factory.IMappedFormFactory;
import org.adempiere.webui.factory.IQuickEntryFactory;
import org.adempiere.webui.grid.AbstractWQuickEntry;
import org.adempiere.webui.panel.ADForm;
import org.compiere.grid.ICreateFrom;
import org.compiere.grid.ICreateFromFactory;
import org.compiere.grid.IPaymentForm;
import org.compiere.grid.IPaymentFormFactory;
import org.compiere.model.GridTab;
import org.compiere.model.MDashboardContent;
import org.compiere.util.CCache;
import org.idempiere.ui.zk.media.IMediaView;
import org.idempiere.ui.zk.media.IMediaViewProvider;
import org.idempiere.ui.zk.report.IReportViewerRenderer;
import org.zkoss.zk.ui.Component;

public class Extensions {
    private static final CCache<String, IServiceReferenceHolder<IFormFactory>> s_formFactoryCache = new CCache(null, "IFormFactory", 100, false);
    private static final CCache<String, List<IServiceReferenceHolder<IProcessParameterListener>>> s_processParameterListenerCache = new CCache(null, "List<IProcessParameterListener>", 100, false);
    private static final CCache<String, IServiceReferenceHolder<ICreateFromFactory>> s_createFromFactoryCache = new CCache(null, "ICreateFromFactory", 100, false);
    private static final CCache<String, IServiceReferenceHolder<IPaymentFormFactory>> s_paymentFormFactoryCache = new CCache(null, "IPaymentFormFactory", 100, false);
    private static final CCache<String, IServiceReferenceHolder<IDashboardGadgetFactory>> s_dashboardGadgetFactoryCache = new CCache(null, "IDashboardGadgetFactory", 100, false);
    private static IServiceReferenceHolder<IMappedFormFactory> s_mappedFormFactoryReference = null;
    private static final CCache<Integer, IServiceReferenceHolder<IQuickEntryFactory>> s_quickEntryFactoryCache = new CCache(null, "IQuickEntryFactory", 100, false);
    private static final CCache<String, IServiceReferenceHolder<IMediaViewProvider>> s_mediaViewProviderCache = new CCache("_IMediaViewProvider_Cache", "IMediaViewProvider", 100, false);

    public static ADForm getForm(String formId) {
        List factories;
        IServiceReferenceHolder cache = (IServiceReferenceHolder)s_formFactoryCache.get((Object)formId);
        if (cache != null) {
            ADForm form;
            IFormFactory service = (IFormFactory)cache.getService();
            if (service != null && (form = service.newFormInstance(formId)) != null) {
                return form;
            }
            s_formFactoryCache.remove((Object)formId);
        }
        if ((factories = Service.locator().list(IFormFactory.class).getServiceReferences()) != null) {
            for (IServiceReferenceHolder factory : factories) {
                ADForm form;
                IFormFactory service = (IFormFactory)factory.getService();
                if (service == null || (form = service.newFormInstance(formId)) == null) continue;
                s_formFactoryCache.put((Object)formId, (Object)factory);
                return form;
            }
        }
        return null;
    }

    public static List<IProcessParameterListener> getProcessParameterListeners(String processClass, String columnName) {
        String cacheKey = processClass + "|" + columnName;
        ArrayList listeners = (ArrayList)s_processParameterListenerCache.get((Object)cacheKey);
        if (listeners != null) {
            return listeners.stream().filter(e -> e.getService() != null).map(e -> (IProcessParameterListener)e.getService()).collect(Collectors.toCollection(ArrayList::new));
        }
        ServiceQuery query = new ServiceQuery();
        query.put((Object)"ProcessClass", (Object)processClass);
        if (columnName != null) {
            query.put((Object)"|(ColumnName", (Object)(columnName + ")(ColumnName=" + columnName + ",*)(ColumnName=*," + columnName + ",*)(ColumnName=*," + columnName + ")"));
        }
        if ((listeners = Service.locator().list(IProcessParameterListener.class, null, query).getServiceReferences()) == null) {
            listeners = new ArrayList();
        }
        s_processParameterListenerCache.put((Object)cacheKey, listeners);
        return listeners.stream().filter(e -> e.getService() != null).map(e -> (IProcessParameterListener)e.getService()).collect(Collectors.toCollection(ArrayList::new));
    }

    public static ICreateFrom getCreateFrom(GridTab mTab) {
        ICreateFrom createFrom = null;
        String cacheKey = Integer.toString(mTab.getAD_Tab_ID());
        IServiceReferenceHolder cache = (IServiceReferenceHolder)s_createFromFactoryCache.get((Object)cacheKey);
        if (cache != null) {
            ICreateFromFactory service = (ICreateFromFactory)cache.getService();
            if (service != null && (createFrom = service.create(mTab)) != null) {
                return createFrom;
            }
            s_createFromFactoryCache.remove((Object)cacheKey);
        }
        List factories = Service.locator().list(ICreateFromFactory.class).getServiceReferences();
        for (IServiceReferenceHolder factory : factories) {
            ICreateFromFactory service = (ICreateFromFactory)factory.getService();
            if (service == null || (createFrom = service.create(mTab)) == null) continue;
            s_createFromFactoryCache.put((Object)cacheKey, (Object)factory);
            return createFrom;
        }
        return null;
    }

    public static IPaymentForm getPaymentForm(int windowNo, GridTab mTab, String paymentRule) {
        String cacheKey = mTab.getAD_Tab_ID() + "|" + paymentRule;
        IServiceReferenceHolder cache = (IServiceReferenceHolder)s_paymentFormFactoryCache.get((Object)cacheKey);
        if (cache != null) {
            IPaymentForm paymentForm;
            IPaymentFormFactory service = (IPaymentFormFactory)cache.getService();
            if (service != null && (paymentForm = service.create(windowNo, mTab, paymentRule)) != null) {
                return paymentForm;
            }
            s_paymentFormFactoryCache.remove((Object)cacheKey);
        }
        IPaymentForm paymentForm = null;
        List factories = Service.locator().list(IPaymentFormFactory.class).getServiceReferences();
        for (IServiceReferenceHolder factory : factories) {
            IPaymentFormFactory service = (IPaymentFormFactory)factory.getService();
            if (service == null || (paymentForm = service.create(windowNo, mTab, paymentRule)) == null) continue;
            s_paymentFormFactoryCache.put((Object)cacheKey, (Object)factory);
            return paymentForm;
        }
        return null;
    }

    public static final Component getDashboardGadget(String url, Component parent) {
        return Extensions.getDashboardGadget(url, parent, null);
    }

    public static final Component getDashboardGadget(String url, Component parent, MDashboardContent dc) {
        IServiceReferenceHolder cache = (IServiceReferenceHolder)s_dashboardGadgetFactoryCache.get((Object)url);
        if (cache != null) {
            Component component;
            IDashboardGadgetFactory service = (IDashboardGadgetFactory)cache.getService();
            if (service != null && (component = service.getGadget(url, parent, dc)) != null) {
                return component;
            }
            s_dashboardGadgetFactoryCache.remove((Object)url);
        }
        List f = Service.locator().list(IDashboardGadgetFactory.class).getServiceReferences();
        for (IServiceReferenceHolder factory : f) {
            Component component;
            IDashboardGadgetFactory service = (IDashboardGadgetFactory)factory.getService();
            if (service == null || (component = service.getGadget(url, parent, dc)) == null) continue;
            s_dashboardGadgetFactoryCache.put((Object)url, (Object)factory);
            return component;
        }
        return null;
    }

    public static final List<IChartRendererService> getChartRendererServices() {
        return Service.locator().list(IChartRendererService.class).getServices();
    }

    public static IMappedFormFactory getMappedFormFactory() {
        IMappedFormFactory formFactoryService = null;
        if (s_mappedFormFactoryReference != null && (formFactoryService = (IMappedFormFactory)s_mappedFormFactoryReference.getService()) != null) {
            return formFactoryService;
        }
        IServiceReferenceHolder serviceReference = Service.locator().locate(IMappedFormFactory.class).getServiceReference();
        if (serviceReference != null) {
            formFactoryService = (IMappedFormFactory)serviceReference.getService();
            s_mappedFormFactoryReference = serviceReference;
        }
        return formFactoryService;
    }

    public static AbstractWQuickEntry getQuickEntry(Integer AdWindowID) {
        List factories;
        IServiceReferenceHolder cache = (IServiceReferenceHolder)s_quickEntryFactoryCache.get((Object)AdWindowID);
        if (cache != null) {
            AbstractWQuickEntry quickEntry;
            IQuickEntryFactory service = (IQuickEntryFactory)cache.getService();
            if (service != null && (quickEntry = service.newQuickEntryInstance(AdWindowID)) != null) {
                return quickEntry;
            }
            s_quickEntryFactoryCache.remove((Object)AdWindowID);
        }
        if ((factories = Service.locator().list(IQuickEntryFactory.class).getServiceReferences()) != null) {
            for (IServiceReferenceHolder factory : factories) {
                AbstractWQuickEntry quickEntry;
                IQuickEntryFactory service = (IQuickEntryFactory)factory.getService();
                if (service == null || (quickEntry = service.newQuickEntryInstance(AdWindowID)) == null) continue;
                s_quickEntryFactoryCache.put((Object)AdWindowID, (Object)factory);
                return quickEntry;
            }
        }
        return null;
    }

    public static AbstractWQuickEntry getQuickEntry(int WindowNo, int TabNo, int AdWindowID) {
        List factories;
        IServiceReferenceHolder cache = (IServiceReferenceHolder)s_quickEntryFactoryCache.get((Object)AdWindowID);
        if (cache != null) {
            AbstractWQuickEntry quickEntry;
            IQuickEntryFactory service = (IQuickEntryFactory)cache.getService();
            if (service != null && (quickEntry = service.newQuickEntryInstance(WindowNo, TabNo, AdWindowID)) != null) {
                return quickEntry;
            }
            s_quickEntryFactoryCache.remove((Object)AdWindowID);
        }
        if ((factories = Service.locator().list(IQuickEntryFactory.class).getServiceReferences()) != null) {
            for (IServiceReferenceHolder factory : factories) {
                AbstractWQuickEntry quickEntry;
                IQuickEntryFactory service = (IQuickEntryFactory)factory.getService();
                if (service == null || (quickEntry = service.newQuickEntryInstance(WindowNo, TabNo, AdWindowID)) == null) continue;
                s_quickEntryFactoryCache.put((Object)AdWindowID, (Object)factory);
                return quickEntry;
            }
        }
        return null;
    }

    public static IMediaView getMediaView(String contentType, String extension, boolean mobile) {
        List serviceReferences;
        String key = contentType + "|" + extension;
        IMediaView view = null;
        IServiceReferenceHolder cache = (IServiceReferenceHolder)s_mediaViewProviderCache.get((Object)key);
        if (cache != null) {
            IMediaViewProvider service = (IMediaViewProvider)cache.getService();
            if (service != null && (view = service.getMediaView(contentType, extension, mobile)) != null) {
                return view;
            }
            s_mediaViewProviderCache.remove((Object)key);
        }
        if ((serviceReferences = Service.locator().list(IMediaViewProvider.class).getServiceReferences()) == null) {
            return null;
        }
        for (IServiceReferenceHolder serviceReference : serviceReferences) {
            IMediaViewProvider service = (IMediaViewProvider)serviceReference.getService();
            if (service == null || (view = service.getMediaView(contentType, extension, mobile)) == null) continue;
            s_mediaViewProviderCache.put((Object)key, (Object)serviceReference);
            return view;
        }
        return null;
    }

    public static IADTabpanel getADTabPanel(String tabType) {
        IADTabpanel Object2 = null;
        List factoryList = Service.locator().list(IADTabPanelFactory.class).getServices();
        if (factoryList == null) {
            return null;
        }
        for (IADTabPanelFactory factory : factoryList) {
            Object2 = factory.getInstance(tabType);
            if (Object2 == null) continue;
            return Object2;
        }
        return null;
    }

    public static List<IReportViewerRenderer> getReportViewerRenderers() {
        List references = Service.locator().list(IReportViewerRenderer.class, null, null).getServiceReferences();
        return references.stream().filter(e -> e.getService() != null).map(e -> (IReportViewerRenderer)e.getService()).collect(Collectors.toCollection(ArrayList::new));
    }
}

