/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Expectable;
import org.zkoss.lang.Library;
import org.zkoss.util.resource.Loader;
import org.zkoss.util.resource.ResourceCache;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.web.util.resource.Extendlet;
import org.zkoss.web.util.resource.ExtendletConfig;
import org.zkoss.web.util.resource.ExtendletContext;
import org.zkoss.web.util.resource.ExtendletLoader;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.OperationException;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zk.ui.http.I18Ns;
import org.zkoss.zk.ui.http.Utils;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.impl.RequestInfoImpl;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.PageDefinitions;
import org.zkoss.zk.ui.sys.RequestInfo;
import org.zkoss.zk.ui.sys.WebAppCtrl;

public class ZumlExtendlet
implements Extendlet {
    private static final Logger log = LoggerFactory.getLogger(ZumlExtendlet.class);
    private ExtendletContext _webctx;
    private ResourceCache<String, PageDefinition> _cache;

    private ServletContext getServletContext() {
        return this._webctx.getServletContext();
    }

    private WebManager getWebManager() {
        return WebManager.getWebManager(this.getServletContext());
    }

    private WebApp getWebApp() {
        return this.getWebManager().getWebApp();
    }

    public void init(ExtendletConfig config) {
        this._webctx = config.getExtendletContext();
        ZumlLoader loader = new ZumlLoader();
        this._cache = new ResourceCache((Loader)loader, 17);
        this._cache.setMaxSize(512);
        this._cache.setLifetime(3600000);
        int checkPeriod = loader.getCheckPeriod();
        this._cache.setCheckPeriod(checkPeriod >= 0 ? checkPeriod : 3600000);
        config.addCompressExtension("zul");
    }

    public boolean getFeature(int feature) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        String resourceCache = Library.getProperty((String)"org.zkoss.zk.ZUML.cache", (String)"true");
        if (!Boolean.valueOf(resourceCache).booleanValue()) {
            this._cache.clear();
        }
        Session sess = WebManager.getSession(this.getServletContext(), request);
        PageDefinition pagedef = (PageDefinition)this._cache.get((Object)path);
        if (pagedef == null) {
            this.handleError(sess, request, response, path, null);
            return;
        }
        Object old = I18Ns.setup(sess, (ServletRequest)request, (ServletResponse)response, sess.getWebApp().getConfiguration().getResponseCharset());
        try {
            this.process(sess, request, response, pagedef, path);
        }
        catch (Throwable ex) {
            this.handleError(sess, request, response, path, ex);
        }
        finally {
            I18Ns.cleanup((ServletRequest)request, old);
        }
    }

    private void process(Session sess, HttpServletRequest request, HttpServletResponse response, PageDefinition pagedef, String path) throws ServletException, IOException {
        WebApp wapp = sess.getWebApp();
        WebAppCtrl wappc = (WebAppCtrl)((Object)wapp);
        Desktop desktop = this.getWebManager().getDesktop(sess, (ServletRequest)request, (ServletResponse)response, path, true);
        if (desktop == null) {
            return;
        }
        RequestInfoImpl ri = new RequestInfoImpl(wapp, sess, desktop, request, PageDefinitions.getLocator(wapp, path));
        boolean compress = this._webctx.shallCompress((ServletRequest)request, "zul");
        Page page = WebManager.newPage(wappc.getUiFactory(), (RequestInfo)ri, pagedef, (ServletResponse)response, path);
        ExecutionImpl exec = new ExecutionImpl(this.getServletContext(), request, response, desktop, page);
        Writer out = compress ? new StringWriter() : response.getWriter();
        wappc.getUiEngine().execNewPage((Execution)exec, pagedef, page, out);
        if (compress) {
            String result = ((StringWriter)out).toString();
            try {
                byte[] bs;
                ServletOutputStream os = response.getOutputStream();
                byte[] data = result.getBytes("UTF-8");
                if (data.length > 200 && (bs = Https.gzip((HttpServletRequest)request, (HttpServletResponse)response, null, (byte[])data)) != null) {
                    data = bs;
                }
                response.setContentLength(data.length);
                os.write(data);
                response.flushBuffer();
            }
            catch (IllegalStateException ex) {
                response.getWriter().write(result);
            }
        }
    }

    private void handleError(Session sess, HttpServletRequest request, HttpServletResponse response, String path, Throwable err) throws ServletException, IOException {
        String errpg;
        Throwable cause;
        Utils.resetOwner();
        if (err instanceof OperationException && (cause = err.getCause()) instanceof Expectable) {
            err = cause;
        }
        if (err != null && Servlets.isIncluded((ServletRequest)request) && (errpg = sess.getWebApp().getConfiguration().getErrorPage(sess.getDeviceType(), err)) != null) {
            try {
                request.setAttribute("javax.servlet.error.message", (Object)Exceptions.getMessage((Throwable)err));
                request.setAttribute("javax.servlet.error.exception", (Object)err);
                request.setAttribute("javax.servlet.error.exception_type", err.getClass());
                request.setAttribute("javax.servlet.error.status_code", (Object)new Integer(500));
                Servlets.forward((ServletContext)this.getServletContext(), (ServletRequest)request, (ServletResponse)response, (String)errpg, null, (int)0);
                return;
            }
            catch (IOException iOException) {
            }
            catch (Throwable ex) {
                log.warn("Failed to load the error page: " + errpg, ex);
            }
        }
        Utils.handleError(this.getServletContext(), request, response, path, err);
    }

    private class ZumlLoader
    extends ExtendletLoader<PageDefinition> {
        private ZumlLoader() {
        }

        protected PageDefinition parse(InputStream is, String path, String orgpath) throws Exception {
            return PageDefinitions.getPageDefinitionDirectly(ZumlExtendlet.this.getWebApp(), ZumlExtendlet.this._webctx.getLocator(), new InputStreamReader(is, "UTF-8"), Servlets.getExtension((String)path));
        }

        protected ExtendletContext getExtendletContext() {
            return ZumlExtendlet.this._webctx;
        }
    }
}

