/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.zkoss.idom.Element;
import org.zkoss.idom.input.SAXBuilder;
import org.zkoss.idom.util.IDOMs;
import org.zkoss.io.Files;
import org.zkoss.json.JSONArray;
import org.zkoss.json.JSONObject;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.http.Encodes;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.web.util.resource.ExtendletConfig;
import org.zkoss.web.util.resource.ExtendletContext;
import org.zkoss.web.util.resource.ExtendletLoader;
import org.zkoss.zk.device.Device;
import org.zkoss.zk.device.Devices;
import org.zkoss.zk.fn.JspFns;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.WebApps;
import org.zkoss.zk.ui.http.AbstractExtendlet;
import org.zkoss.zk.ui.http.ScriptManager;
import org.zkoss.zk.ui.http.ScriptManagerImpl;
import org.zkoss.zk.ui.http.SourceMapManager;
import org.zkoss.zk.ui.http.Utils;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.metainfo.WidgetDefinition;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.URIInfo;

public class WpdExtendlet
extends AbstractExtendlet<Object> {
    private Boolean _sourceMapEnabled;
    private static final String HANDLE_SOURCE_MAPPING_URL = "zk$handlesourcemappingurl";
    private static final String SOURCE_MAP_PREFIX = "zk$sourcemap$";
    private static final String SOURCE_MAP_SUPPORTED = "zk$sourcemapsupported";
    private Boolean CLOSURE_COMPILER_AVAILABLE;
    private static final int SOURCE_CACHE_SIZE = 100;
    private ConcurrentMap _sourceFromSourceMap;
    private ConcurrentMap<String, String> _sourceMapContentMap;
    private static volatile ScriptManager _smanager;

    public void init(ExtendletConfig config) {
        this.init(config, new WpdLoader());
        if (!this.isDebugJS()) {
            config.addCompressExtension("wpd");
        } else if (this.isSourceMapEnabled() && this.CLOSURE_COMPILER_AVAILABLE == null) {
            this.CLOSURE_COMPILER_AVAILABLE = Classes.existsByThread((String)"com.google.javascript.jscomp.Compiler");
            if (!this.CLOSURE_COMPILER_AVAILABLE.booleanValue()) {
                log.warn("Closure compiler is not available.");
            } else {
                ServletContext servletContext = config.getExtendletContext().getServletContext();
                this._sourceFromSourceMap = WebManager.getWebManager(servletContext).getClassWebResource().initSourceCache(100);
                this._sourceMapContentMap = new ConcurrentHashMap<String, String>();
            }
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        byte[] bs;
        byte[] data;
        if (this.isDebugJS() && path.endsWith("wpd")) {
            request.setAttribute(HANDLE_SOURCE_MAPPING_URL, (Object)true);
        }
        if ((data = this.retrieve(request, response, path)) == null) {
            return;
        }
        response.setContentType("text/javascript;charset=UTF-8");
        if (this._webctx.shallCompress((ServletRequest)request, "wpd") && data.length > 200 && (bs = Https.gzip((HttpServletRequest)request, (HttpServletResponse)response, null, (byte[])data)) != null) {
            data = bs;
        }
        response.setContentLength(data.length);
        response.getOutputStream().write(data);
        response.flushBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] retrieve(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        boolean isNotModified;
        boolean cacheable;
        byte[] data;
        Content content;
        String resourceCache;
        String pkg = null;
        boolean isSourceMapSupported = false;
        Boolean shouldHandleSourceMappingURL = null;
        String userAgent = null;
        if (this.isDebugJS()) {
            userAgent = request.getHeader("user-agent");
            boolean bl = isSourceMapSupported = Objects.equals((Object)this.CLOSURE_COMPILER_AVAILABLE, (Object)true) && (Servlets.isBrowser((String)userAgent, (String)"chrome") || Servlets.isBrowser((String)userAgent, (String)"ff") || Servlets.isBrowser((String)userAgent, (String)"ie11") || Servlets.isBrowser((String)userAgent, (String)"safari"));
            if (isSourceMapSupported) {
                HttpSession session = request.getSession();
                if (path.endsWith(".map")) {
                    String name = path.substring(path.lastIndexOf("/") + 1).replaceAll(".map", "");
                    String sourceMapContent = (String)this._sourceMapContentMap.get(Servlets.getBrowser((String)userAgent) + "$" + name);
                    if (sourceMapContent == null) {
                        log.warn("Failed to load the source map resource: " + path);
                        response.sendError(404, path);
                        return null;
                    }
                    session.setAttribute(SOURCE_MAP_SUPPORTED, (Object)true);
                    return sourceMapContent.getBytes();
                }
                shouldHandleSourceMappingURL = (Boolean)request.getAttribute(HANDLE_SOURCE_MAPPING_URL);
                if (shouldHandleSourceMappingURL != null) {
                    request.removeAttribute(HANDLE_SOURCE_MAPPING_URL);
                }
                request.setAttribute(SOURCE_MAP_SUPPORTED, (Object)true);
            }
        }
        if ((resourceCache = Library.getProperty((String)"org.zkoss.zk.WPD.cache")) != null && "false".equalsIgnoreCase(resourceCache)) {
            this._cache.clear();
        }
        if ((content = (Content)this._cache.get((Object)path)) == null) {
            if (Servlets.isIncluded((ServletRequest)request)) {
                log.error("Failed to load the resource: " + path);
                throw new FileNotFoundException("Failed to load the resource: " + path);
            }
            response.sendError(404, path);
            return null;
        }
        AbstractExtendlet.RequestContext reqctx = new AbstractExtendlet.RequestContext(this, request, response);
        Content content2 = content;
        synchronized (content2) {
            Object rawdata = content.parse(reqctx);
            if (rawdata instanceof ByteContent) {
                ByteContent bc = (ByteContent)rawdata;
                data = bc.content;
                cacheable = bc.cacheable;
            } else {
                WpdContent wc = (WpdContent)rawdata;
                data = wc.toByteArray(reqctx);
                pkg = wc.name;
                cacheable = wc.cacheable;
            }
        }
        if (cacheable && (isNotModified = JspFns.setCacheControl(this.getServletContext(), request, response, "org.zkoss.web.classWebResource.cache", 8760))) {
            return null;
        }
        if (pkg != null) {
            data = this.mergeJavaScript(request, response, pkg, data);
        }
        if (isSourceMapSupported && shouldHandleSourceMappingURL != null) {
            String sourceMapManagerKey;
            SourceMapManager sourceMapManager;
            if (pkg == null) {
                pkg = path.substring(path.lastIndexOf("/") + 1).replaceAll(".wpd", "");
            }
            if ((sourceMapManager = (SourceMapManager)request.getAttribute(sourceMapManagerKey = SOURCE_MAP_PREFIX + pkg)) != null) {
                request.removeAttribute(sourceMapManagerKey);
                data = sourceMapManager.generateFinalWpd(this._sourceMapContentMap, Servlets.getBrowser((String)userAgent) + "$" + pkg, this._sourceFromSourceMap, data).getBytes();
            }
        }
        return data;
    }

    protected String getDeviceType() {
        return "ajax";
    }

    protected byte[] mergeJavaScript(HttpServletRequest request, HttpServletResponse response, String pkgTo, byte[] data) throws ServletException, IOException {
        ByteArrayOutputStream out = null;
        Device device = null;
        String deviceType = this.getDeviceType();
        SourceMapManager sourceMapManagerPkgTo = (SourceMapManager)request.getAttribute(SOURCE_MAP_PREFIX + pkgTo);
        for (LanguageDefinition langdef : LanguageDefinition.getByDeviceType(deviceType)) {
            for (String pkg : langdef.getMergedJavaScriptPackages(pkgTo)) {
                String path;
                if (out == null) {
                    out = new ByteArrayOutputStream(102400);
                    out.write(data);
                    device = Devices.getDevice(deviceType);
                }
                if ((data = this.retrieve(request, response, path = device.packageToPath(pkg))) != null) {
                    if (request.getAttribute(SOURCE_MAP_SUPPORTED) != null) {
                        sourceMapManagerPkgTo.mergeWpd((SourceMapManager)request.getAttribute(SOURCE_MAP_PREFIX + pkg), data);
                        continue;
                    }
                    out.write(data);
                    continue;
                }
                log.error("Failed to load the resource: " + path);
            }
        }
        return out != null ? out.toByteArray() : data;
    }

    private Object parse(AbstractExtendlet.RequestContext reqctx, InputStream is, String path) throws Exception {
        Element root = new SAXBuilder(true, false, true).build(is).getRootElement();
        String name = IDOMs.getRequiredAttributeValue((Element)root, (String)"name");
        if (name.length() == 0) {
            throw new UiException("The name attribute must be specified, " + root.getLocator() + ", " + path);
        }
        boolean zk = "zk".equals(name);
        boolean aaas = "zk.aaas".equals(name);
        String lang = root.getAttributeValue("language");
        LanguageDefinition langdef = lang != null ? LanguageDefinition.lookup(lang) : null;
        String dir = path.substring(0, path.lastIndexOf(47) + 1);
        boolean cacheable = !"false".equals(root.getAttributeValue("cacheable"));
        WpdContent wc = zk || aaas || !cacheable || this.isWpdContentRequired(name, root) ? new WpdContent(name, dir, cacheable) : null;
        ByteArrayOutputStream out = new ByteArrayOutputStream(16384);
        String depends = null;
        SourceMapManager sourceMapManager = null;
        String requestURI = reqctx.request.getRequestURI();
        if (this.isDebugJS() && reqctx.request.getAttribute(SOURCE_MAP_SUPPORTED) != null) {
            String sourceRoot = requestURI.substring(0, requestURI.indexOf("js/"));
            sourceMapManager = new SourceMapManager(name, sourceRoot, reqctx.request.getSession().getId());
        }
        StringBuilder preScriptBuilder = new StringBuilder();
        if (zk) {
            preScriptBuilder.append("if(!window.zk){\n");
        } else if (!aaas) {
            depends = root.getAttributeValue("depends");
            if (depends != null && depends.length() == 0) {
                depends = null;
            }
            if (depends != null) {
                preScriptBuilder.append("zk.load('").append(depends).append("',");
            } else {
                preScriptBuilder.append("(");
            }
            preScriptBuilder.append("function(){if(zk._p=zkpi('").append(name).append('\'');
            if (reqctx.getResource(dir + "wv/zk.wpd") != null) {
                preScriptBuilder.append(",true");
            }
            preScriptBuilder.append("))try{\n");
        }
        String preStr = preScriptBuilder.toString();
        if (sourceMapManager == null) {
            this.write((OutputStream)out, preStr);
        } else {
            sourceMapManager.setPreScript(preStr);
        }
        HashMap<String, String[]> moldInfos = new HashMap<String, String[]>();
        for (Element el : root.getElements()) {
            String jspath;
            String elnm = el.getName();
            if ("widget".equals(elnm)) {
                WidgetDefinition wgtdef;
                String wgtnm = IDOMs.getRequiredAttributeValue((Element)el, (String)"name");
                jspath = wgtnm + ".js";
                if (sourceMapManager != null) {
                    sourceMapManager.startJsCursor(jspath);
                }
                if (!this.writeResource(reqctx, out, jspath, dir, false, sourceMapManager)) {
                    log.error("Widget " + wgtnm + ": " + jspath + " not found, " + el.getLocator() + ", " + path);
                    if (sourceMapManager == null) continue;
                    sourceMapManager.closeJsCursor(out);
                    continue;
                }
                String wgtflnm = name + "." + wgtnm;
                this.appendJsContent(out, sourceMapManager, "zkreg('", wgtflnm, "'");
                WidgetDefinition widgetDefinition = wgtdef = langdef != null ? langdef.getWidgetDefinitionIfAny(wgtflnm) : null;
                if (wgtdef != null && wgtdef.isBlankPreserved()) {
                    this.appendJsContent(out, sourceMapManager, ",true");
                }
                this.appendJsContent(out, sourceMapManager, ");\n");
                if (wgtdef == null) {
                    if (sourceMapManager == null) continue;
                    sourceMapManager.closeJsCursor(out);
                    continue;
                }
                try {
                    boolean first = true;
                    for (String mold : wgtdef.getMoldNames()) {
                        String uri = wgtdef.getMoldURI(mold);
                        if (uri == null) continue;
                        if (first) {
                            first = false;
                            this.appendJsContent(out, sourceMapManager, "zk._m={};\n");
                        }
                        this.appendJsContent(out, sourceMapManager, "zk._m['", mold, "']=");
                        String[] info = (String[])moldInfos.get(uri);
                        if (info != null) {
                            this.appendJsContent(out, sourceMapManager, "[zk._p.p.", info[0], ",'", info[1], "'];\n");
                            continue;
                        }
                        moldInfos.put(uri, new String[]{wgtnm, mold});
                        if (!this.writeResource(reqctx, out, uri, dir, true, sourceMapManager)) {
                            this.appendJsContent(out, sourceMapManager, "zk.$void;zk.error('", uri, " not found')");
                            if (sourceMapManager != null) {
                                sourceMapManager.closeJsCursor(out);
                            }
                            log.error("Failed to load mold " + mold + " for widget " + wgtflnm + ": " + uri + " not found");
                        }
                        this.appendJsContent(out, sourceMapManager, ";");
                    }
                    if (!first) {
                        this.appendJsContent(out, sourceMapManager, "zkmld(", zk ? "zk." : "zk._p.p.", wgtnm, ",zk._m);\n");
                    }
                }
                catch (Throwable ex) {
                    log.error("Failed to load molds for widget " + wgtflnm + ".\nCause: " + Exceptions.getMessage((Throwable)ex));
                }
                if (sourceMapManager == null) continue;
                sourceMapManager.closeJsCursor(out);
                continue;
            }
            if ("script".equals(elnm)) {
                String s;
                String browser = el.getAttributeValue("browser");
                jspath = el.getAttributeValue("src");
                if (jspath != null && jspath.length() > 0) {
                    if (sourceMapManager != null) {
                        sourceMapManager.startJsCursor(jspath);
                    }
                    if (wc != null && (browser != null || jspath.indexOf(42) >= 0)) {
                        this.move(wc, out);
                        wc.add(jspath, browser);
                    } else {
                        if (browser != null && (!Servlets.isBrowser((ServletRequest)reqctx.request, (String)browser) || this.getScriptManager().isScriptIgnored((ServletRequest)reqctx.request, jspath))) {
                            if (sourceMapManager == null) continue;
                            sourceMapManager.clearJsCursor();
                            continue;
                        }
                        if (!this.writeResource(reqctx, out, jspath, dir, true, sourceMapManager)) {
                            log.error(jspath + " not found, " + el.getLocator() + ", " + path);
                        }
                    }
                    if (sourceMapManager != null) {
                        sourceMapManager.closeJsCursor(out);
                    }
                }
                if ((s = el.getText(true)) == null || s.length() <= 0) continue;
                this.write((OutputStream)out, s);
                this.write((OutputStream)out, '\n');
                continue;
            }
            if ("function".equals(elnm)) {
                AbstractExtendlet.MethodInfo mtd = WpdExtendlet.getMethodInfo(el);
                if (mtd == null) continue;
                if (wc != null) {
                    this.move(wc, out);
                    wc.add(mtd);
                    continue;
                }
                String string = this.write(reqctx, out, mtd);
                continue;
            }
            log.warn("Unknown element " + elnm + ", " + el.getLocator() + ", " + path);
        }
        if (zk) {
            WebApp wapp = this.getWebApp();
            if (wapp != null) {
                this.writeAppInfo(reqctx, out, wapp, sourceMapManager);
            }
            this.appendPostJsScript(out, sourceMapManager, "}");
            this.writeHost(wc, out, wapp, reqctx, sourceMapManager);
        } else if (aaas) {
            this.writeHost(wc, out, this.getWebApp(), reqctx, sourceMapManager);
        } else {
            this.appendPostJsScript(out, sourceMapManager, "\n}catch(error){console.error(error);}finally{zk.setLoaded(zk._p.n);}");
            if (depends != null) {
                this.appendPostJsScript(out, sourceMapManager, "});zk.setLoaded('", name, "',1);");
            } else {
                this.appendPostJsScript(out, sourceMapManager, "})();");
            }
        }
        if (sourceMapManager != null) {
            reqctx.request.setAttribute(SOURCE_MAP_PREFIX + name, (Object)sourceMapManager);
        }
        if (wc != null) {
            this.move(wc, out);
            return wc;
        }
        return new ByteContent(out.toByteArray(), cacheable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScriptManager getScriptManager() {
        if (_smanager == null) {
            WpdExtendlet wpdExtendlet = this;
            synchronized (wpdExtendlet) {
                if (_smanager == null) {
                    String clsnm = Library.getProperty((String)"org.zkoss.zk.ui.http.ScriptManager.class");
                    if (clsnm != null) {
                        try {
                            _smanager = (ScriptManager)Classes.newInstanceByThread((String)clsnm);
                        }
                        catch (Throwable ex) {
                            log.error("Unable to instantiate " + clsnm, ex);
                        }
                    }
                    if (_smanager == null) {
                        _smanager = new ScriptManagerImpl();
                    }
                }
            }
        }
        return _smanager;
    }

    private boolean isWpdContentRequired(String pkg, Element root) {
        for (LanguageDefinition langdef : LanguageDefinition.getByDeviceType(this.getDeviceType())) {
            if (!langdef.getJavaScriptPackagesWithMerges().contains(pkg)) continue;
            return true;
        }
        for (Element el : root.getElements("script")) {
            if (el.getAttributeValue("browser") == null) continue;
            return true;
        }
        return false;
    }

    private void writeHost(WpdContent wc, ByteArrayOutputStream out, WebApp wapp, AbstractExtendlet.RequestContext reqctx, SourceMapManager sourceMapManager) throws ServletException, IOException {
        Object[] pkgs;
        if (wapp != null && (pkgs = wapp.getConfiguration().getClientPackages()).length > 0) {
            if (sourceMapManager == null) {
                this.move(wc, out);
            } else {
                sourceMapManager.appendPostScript(new String(wc.toByteArray(reqctx)));
            }
            wc.addHost(wapp, JSONArray.toJSONString((Object[])pkgs));
        }
    }

    private boolean writeResource(AbstractExtendlet.RequestContext reqctx, OutputStream out, String path, String dir, boolean locate, SourceMapManager sourceMapManager) throws IOException, ServletException {
        if (path.startsWith("~./")) {
            path = path.substring(2);
        } else if (path.charAt(0) != '/') {
            path = Files.normalize((String)dir, (String)path);
        }
        String originalPath = "";
        if (this.isDebugJS() && "js".equals(Servlets.getExtension((String)path)) && !path.endsWith(".src.js")) {
            originalPath = path;
            path = path.substring(0, path.length() - 3) + ".src.js";
        }
        InputStream is = reqctx.getResourceAsStream(path, locate);
        while (is == null) {
            if (Strings.isEmpty((String)originalPath)) {
                this.write(out, "zk.log('");
                this.write(out, path);
                this.write(out, " not found');");
                return false;
            }
            path = originalPath;
            is = reqctx.getResourceAsStream(path, locate);
            originalPath = null;
        }
        if (sourceMapManager != null) {
            String jsContent = new String(Files.readAll((InputStream)is));
            if (!path.endsWith(".src.js")) {
                path = path.substring(0, path.length() - 3) + ".src.js";
            }
            sourceMapManager.updateCursorRealPath(path);
            sourceMapManager.appendJsContent(jsContent);
        }
        if (sourceMapManager == null) {
            Files.copy((OutputStream)out, (InputStream)is);
        }
        Files.close((InputStream)is);
        this.write(out, '\n');
        return true;
    }

    private int countLines(String js) {
        int line = 0;
        for (int i = 0; i < js.length(); ++i) {
            if (js.charAt(i) != '\n') continue;
            ++line;
        }
        return line;
    }

    private void write(OutputStream out, String s) throws IOException {
        if (s != null) {
            byte[] bs = s.getBytes("UTF-8");
            out.write(bs, 0, bs.length);
        }
    }

    private void write(OutputStream out, char cc) throws IOException {
        assert (cc < '\u0080');
        byte[] bs = new byte[]{(byte)cc};
        out.write(bs, 0, 1);
    }

    private String write(AbstractExtendlet.RequestContext reqctx, OutputStream out, AbstractExtendlet.MethodInfo mtd) throws IOException {
        String result = this.invoke(reqctx, mtd);
        this.write(out, result);
        return result;
    }

    private void writeln(OutputStream out) throws IOException {
        this.write(out, '\n');
    }

    private void move(WpdContent wc, ByteArrayOutputStream out) {
        byte[] bs = out.toByteArray();
        if (bs.length > 0) {
            wc.add(bs);
            out.reset();
        }
    }

    private void writeAppInfo(AbstractExtendlet.RequestContext reqctx, OutputStream out, WebApp wapp, SourceMapManager sourceMapManager) throws IOException, ServletException {
        String deviceType;
        Object[][] infs;
        String verInfoEnabled = Library.getProperty((String)"org.zkoss.zk.ui.versionInfo.enabled", (String)"true");
        boolean exposeVer = "true".equals(verInfoEnabled);
        StringBuffer sb = new StringBuffer(256);
        if (exposeVer) {
            sb.append("\nzkver('").append(wapp.getVersion()).append("','");
        } else {
            sb.append("\nzkver('','");
        }
        String build = wapp.getBuild();
        sb.append(exposeVer ? build : Utils.obfuscateHashWithSalt(build, verInfoEnabled));
        ServletContext ctx = this.getServletContext();
        String s = Encodes.encodeURL((ServletContext)ctx, (ServletRequest)reqctx.request, (ServletResponse)reqctx.response, (String)"/");
        int j = s.lastIndexOf(47);
        if (j >= 0) {
            s = s.substring(0, j) + s.substring(j + 1);
        }
        sb.append("','").append(s).append("','").append(Encodes.encodeURL((ServletContext)ctx, (ServletRequest)reqctx.request, (ServletResponse)reqctx.response, (String)wapp.getUpdateURI(false)));
        sb.append("',{");
        for (LanguageDefinition langdef : LanguageDefinition.getByDeviceType(this.getDeviceType())) {
            for (Map.Entry<String, String> me : langdef.getJavaScriptModules().entrySet()) {
                String value = me.getValue();
                sb.append('\'').append((Object)me.getKey()).append("':'").append((Object)(exposeVer ? value : Utils.obfuscateHashWithSalt(value, verInfoEnabled))).append("',");
            }
            WpdExtendlet.removeLast(sb, ',');
        }
        sb.append("},{");
        if (WebApps.getFeature("ee")) {
            sb.append("ed:'e',");
        } else if (WebApps.getFeature("pe")) {
            sb.append("ed:'p',");
        }
        Configuration config = wapp.getConfiguration();
        int v = config.getProcessingPromptDelay();
        if (v != 900) {
            sb.append("pd:").append(v).append(',');
        }
        if ((v = config.getTooltipDelay()) != 800) {
            sb.append("td:").append(v).append(',');
        }
        if ((v = config.getAutoResendTimeout()) != 200) {
            sb.append("art:").append(v).append(',');
        }
        if (config.isTimerKeepAlive()) {
            sb.append("ta:1,");
        }
        if (config.isDebugJS()) {
            sb.append("dj:1,");
        }
        if (config.isKeepDesktopAcrossVisits()) {
            sb.append("kd:1,");
        }
        if (config.getPerformanceMeter() != null) {
            sb.append("pf:1,");
        }
        if (!config.isHistoryStateEnabled()) {
            sb.append("hs:0,");
        }
        if ((infs = config.getClientErrorReloads(deviceType = this.getDeviceType(), null)) != null) {
            sb.append("eu:{");
            this.outErrReloads(reqctx, config, sb, infs);
            sb.append("},");
        }
        if ((infs = config.getClientErrorReloads(deviceType, "server-push")) != null) {
            sb.append("eup:{");
            this.outErrReloads(reqctx, config, sb, infs);
            sb.append("},");
        }
        sb.append("resURI:'").append(Encodes.encodeURL((ServletContext)ctx, (ServletRequest)reqctx.request, (ServletResponse)reqctx.response, (String)wapp.getResourceURI(false))).append("'").append("});");
        this.appendPostJsScript((ByteArrayOutputStream)out, sourceMapManager, sb.toString());
    }

    private void outErrReloads(AbstractExtendlet.RequestContext reqctx, Configuration config, StringBuffer sb, Object[][] infs) {
        for (int j = 0; j < infs.length; ++j) {
            if (j > 0) {
                sb.append(',');
            }
            sb.append('\'').append(infs[j][0]).append("':'");
            String uri = ((URIInfo)infs[j][1]).uri;
            if (uri.length() > 0) {
                try {
                    uri = Encodes.encodeURL((ServletContext)this.getServletContext(), (ServletRequest)reqctx.request, (ServletResponse)reqctx.response, (String)uri);
                }
                catch (ServletException ex) {
                    throw new UiException("Unable to encode " + uri, (Throwable)ex);
                }
            }
            sb.append(Strings.escape((String)uri, (String)"'\\")).append('\'');
        }
    }

    private static void removeLast(StringBuffer sb, char cc) {
        if (sb.charAt(sb.length() - 1) == cc) {
            sb.setLength(sb.length() - 1);
        }
    }

    private static String outMain(String main, Map<String, String[]> params) {
        StringBuffer sb = new StringBuffer("\nzkamn('");
        int j = main.lastIndexOf(46);
        if (j >= 0) {
            sb.append(main.substring(0, j));
        }
        sb.append("',function(){\n").append(main).append(".main(");
        LinkedHashMap<String, String[]> ms = new LinkedHashMap<String, String[]>();
        for (Map.Entry<String, String[]> me : params.entrySet()) {
            String nm = me.getKey();
            if ("main".equals(nm)) continue;
            String[] vals = me.getValue();
            ms.put(nm, (String[])(vals.length == 0 ? null : (vals.length == 1 ? vals[0] : vals)));
        }
        sb.append(JSONObject.toJSONString(ms)).append(")\n})");
        return sb.toString();
    }

    private static String outHost(HttpServletRequest request, WebApp wapp, String clientPackages) {
        String uri;
        StringBuffer sb = new StringBuffer().append("zk.setHost('").append(request.getScheme()).append("://").append(request.getServerName());
        if (request.getServerPort() != 80) {
            sb.append(':').append(request.getServerPort());
        }
        if ((uri = request.getContextPath()) != null && uri.length() > 0) {
            if (uri.charAt(0) != '/') {
                sb.append('/');
            }
            sb.append(uri);
            WpdExtendlet.removeLast(sb, '/');
        }
        return sb.append("','").append(wapp.getResourceURI(false)).append("',").append(clientPackages).append(");").toString();
    }

    private boolean isSourceMapEnabled() {
        if (this._sourceMapEnabled == null) {
            WebApp wapp = this.getWebApp();
            if (wapp == null) {
                return false;
            }
            this._sourceMapEnabled = wapp.getConfiguration().isSourceMapEnabled();
        }
        return this._sourceMapEnabled;
    }

    private void appendJsContent(ByteArrayOutputStream out, SourceMapManager sourceMapManager, String ... scripts) throws IOException {
        if (sourceMapManager == null) {
            for (String script : scripts) {
                this.write((OutputStream)out, script);
            }
        } else {
            sourceMapManager.appendJsContent(scripts);
        }
    }

    private void appendPostJsScript(ByteArrayOutputStream out, SourceMapManager sourceMapManager, String ... scripts) throws IOException {
        if (sourceMapManager == null) {
            for (String script : scripts) {
                this.write((OutputStream)out, script);
            }
        } else {
            sourceMapManager.appendPostScript(scripts);
        }
    }

    private class WpdContent {
        private final String name;
        private final String _dir;
        private final List<Object> _cnt = new LinkedList<Object>();
        private final boolean cacheable;

        private WpdContent(String name, String dir, boolean cacheable) {
            this.name = name;
            this._dir = dir;
            this.cacheable = cacheable;
        }

        private void add(byte[] bs) {
            this._cnt.add(bs);
        }

        private void add(AbstractExtendlet.MethodInfo mtd) {
            this._cnt.add(mtd);
        }

        private void add(String jspath, String browser) {
            this._cnt.add(new String[]{jspath, browser});
        }

        private void addHost(WebApp wapp, String clientPackages) {
            this._cnt.add(new Object[]{wapp, clientPackages});
        }

        private byte[] toByteArray(AbstractExtendlet.RequestContext reqctx) throws ServletException, IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            HttpServletRequest request = reqctx.request;
            String main = request != null ? request.getParameter("main") : null;
            SourceMapManager sourceMapManager = null;
            if (WpdExtendlet.this.isDebugJS()) {
                sourceMapManager = (SourceMapManager)reqctx.request.getAttribute(WpdExtendlet.SOURCE_MAP_PREFIX + this.name);
            }
            for (Object o : this._cnt) {
                Object[] inf;
                String result = "";
                if (o instanceof byte[]) {
                    out.write((byte[])o);
                    continue;
                }
                if (o instanceof AbstractExtendlet.MethodInfo) {
                    result = WpdExtendlet.this.write(reqctx, out, (AbstractExtendlet.MethodInfo)o);
                    continue;
                }
                if (o instanceof String[]) {
                    inf = (String[])o;
                    if (inf[1] != null && request != null && (!Servlets.isBrowser((ServletRequest)request, (String)inf[1]) || WpdExtendlet.this.getScriptManager().isScriptIgnored((ServletRequest)reqctx.request, (String)inf[0]))) continue;
                    if (sourceMapManager != null) {
                        sourceMapManager.startJsCursor((String)inf[0]);
                    }
                    if (!WpdExtendlet.this.writeResource(reqctx, out, (String)inf[0], this._dir, true, sourceMapManager)) {
                        AbstractExtendlet.log.error((String)inf[0] + " not found");
                        if (sourceMapManager == null) continue;
                        sourceMapManager.clearJsCursor();
                        continue;
                    }
                    if (sourceMapManager == null) continue;
                    sourceMapManager.closeJsCursor(out);
                    continue;
                }
                if (!(o instanceof Object[]) || main == null) continue;
                inf = (Object[])o;
                result = WpdExtendlet.outHost(request, (WebApp)inf[0], (String)inf[1]);
                WpdExtendlet.this.write(out, result);
            }
            if (main != null && main.length() > 0) {
                WpdExtendlet.this.write(out, WpdExtendlet.outMain(main, request.getParameterMap()));
            }
            return out.toByteArray();
        }
    }

    private static class ByteContent {
        private final byte[] content;
        private final boolean cacheable;

        private ByteContent(byte[] cnt, boolean cacheable) {
            this.content = cnt;
            this.cacheable = cacheable;
        }
    }

    private class SourceInfo {
        private final byte[] _raw;
        private final String _path;

        private SourceInfo(InputStream input, String path) throws IOException {
            this._raw = Files.readAll((InputStream)input);
            this._path = path;
        }

        private Object parse(AbstractExtendlet.RequestContext reqctx) throws Exception {
            return WpdExtendlet.this.parse(reqctx, new ByteArrayInputStream(this._raw), this._path);
        }
    }

    private static class Content {
        private Object _cnt;

        private Content(SourceInfo si) {
            this._cnt = si;
        }

        private Object parse(AbstractExtendlet.RequestContext reqctx) throws ServletException, IOException {
            if (this._cnt instanceof SourceInfo) {
                try {
                    this._cnt = ((SourceInfo)this._cnt).parse(reqctx);
                }
                catch (IOException ex) {
                    throw ex;
                }
                catch (ServletException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw UiException.Aide.wrap(ex);
                }
            }
            return this._cnt;
        }
    }

    private class WpdLoader
    extends ExtendletLoader<Object> {
        private WpdLoader() {
        }

        protected Object parse(InputStream is, String path, String orgpath) throws Exception {
            return new Content(new SourceInfo(is, path));
        }

        protected ExtendletContext getExtendletContext() {
            return WpdExtendlet.this._webctx;
        }

        protected String getRealPath(String path) {
            int j = path.lastIndexOf(".wpd");
            return path.substring(0, j).replace('.', '/') + "/zk" + path.substring(j);
        }
    }
}

