/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.sql.RowSet;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.adempiere.util.ProcessUtil;
import org.compiere.Adempiere;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.CConnection;
import org.compiere.db.Database;
import org.compiere.db.ProxyFactory;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MLanguage;
import org.compiere.model.MRole;
import org.compiere.model.MSequence;
import org.compiere.model.MSysConfig;
import org.compiere.model.MSystem;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.POResultSet;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CStatementVO;
import org.compiere.util.DBReadReplica;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.Trx;
import org.compiere.util.ValueNamePair;

public final class DB {
    private static CConnection s_cc = null;
    private static CLogger log = CLogger.getCLogger(DB.class);
    private static Object s_ccLock = new Object();
    public static final String SQLSTATEMENT_SEPARATOR = "; ";
    private static final char QUOTE = '\'';
    private static boolean m_isUUIDVerified = false;
    private static boolean m_isUUIDSupported = false;

    @Deprecated(forRemoval=true, since="11")
    public static boolean afterMigration(Properties ctx) {
        MSystem system;
        block10: {
            system = MSystem.get(ctx);
            if (!system.isJustMigrated()) {
                return false;
            }
            log.info("Role");
            String sql = "SELECT * FROM AD_Role";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MRole role = new MRole(ctx, rs, null);
                        role.updateAccessRecords();
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "(1)", e);
                    DB.close(rs);
                    DB.close(pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs);
                DB.close(pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs);
            DB.close(pstmt);
            rs = null;
            pstmt = null;
        }
        try {
            Class<?> clazz = Class.forName("org.compiere.MigrateData");
            clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Data", e);
        }
        log.info("Language");
        MLanguage.maintain(ctx);
        log.info("Sequence");
        ProcessInfo processInfo = new ProcessInfo("Sequence Check", 0);
        processInfo.setClassName("org.compiere.process.SequenceCheck");
        processInfo.setParameter(new ProcessInfoParameter[0]);
        ProcessUtil.startJavaProcess(ctx, processInfo, null);
        log.info("Costing");
        MAcctSchema[] ass = MAcctSchema.getClientAcctSchema(ctx, 0);
        int i2 = 0;
        while (i2 < ass.length) {
            ass[i2].checkCosting();
            ass[i2].saveEx();
            ++i2;
        }
        system.setIsJustMigrated(false);
        return system.save();
    }

    public static void updateMail() {
        Object envName = Ini.getAdempiereHome();
        if (envName == null) {
            return;
        }
        File envFile = new File((String)(envName = (String)envName + File.separator + "idempiereEnv.properties"));
        if (!envFile.exists()) {
            return;
        }
        Properties env = new Properties();
        try {
            FileInputStream in = new FileInputStream(envFile);
            env.load(in);
            in.close();
        }
        catch (Exception exception) {
            return;
        }
        String updated = env.getProperty("ADEMPIERE_MAIL_UPDATED");
        if (updated != null && updated.equals("Y")) {
            return;
        }
        String server = env.getProperty("ADEMPIERE_MAIL_SERVER");
        if (server == null || server.length() == 0) {
            return;
        }
        String adminEMail = env.getProperty("ADEMPIERE_ADMIN_EMAIL");
        if (adminEMail == null || adminEMail.length() == 0) {
            return;
        }
        String mailUser = env.getProperty("ADEMPIERE_MAIL_USER");
        if (mailUser == null || mailUser.length() == 0) {
            return;
        }
        String mailPassword = !env.containsKey("ADEMPIERE_MAIL_PASSWORD") && MSystem.isSecureProps() ? Ini.getVar("ADEMPIERE_MAIL_PASSWORD") : env.getProperty("ADEMPIERE_MAIL_PASSWORD");
        StringBuilder sql = new StringBuilder("UPDATE AD_Client SET").append(" SMTPHost=").append(DB.TO_STRING(server)).append(", RequestEMail=").append(DB.TO_STRING(adminEMail)).append(", RequestUser=").append(DB.TO_STRING(mailUser)).append(", RequestUserPW=").append(DB.TO_STRING(mailPassword)).append(", IsSMTPAuthorization='Y' WHERE AD_Client_ID=0");
        int no = DB.executeUpdate(sql.toString(), null);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Client #" + no);
        }
        sql = new StringBuilder("UPDATE AD_User SET ").append(" EMail=").append(DB.TO_STRING(adminEMail)).append(", EMailUser=").append(DB.TO_STRING(mailUser)).append(", EMailUserPW=").append(DB.TO_STRING(mailPassword)).append(" WHERE AD_User_ID IN (?,?,?)");
        no = DB.executeUpdate(sql.toString(), new Object[]{0, 10, 100}, false, null);
        if (log.isLoggable(Level.FINE)) {
            log.fine("User #" + no);
        }
        try {
            Throwable throwable = null;
            Object var11_12 = null;
            try (FileOutputStream out = new FileOutputStream(envFile);){
                env.setProperty("ADEMPIERE_MAIL_UPDATED", "Y");
                env.store(out, "");
                out.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void setDBTarget(CConnection cc) {
        if (cc == null) {
            throw new IllegalArgumentException("Connection is NULL");
        }
        if (s_cc != null && s_cc.equals(cc)) {
            return;
        }
        DB.closeTarget();
        Object object = s_ccLock;
        synchronized (object) {
            s_cc = cc;
        }
        s_cc.setDataSource();
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.valueOf(s_cc) + " - DS=" + s_cc.isDataSource());
        }
    }

    @Deprecated
    public static boolean connect() {
        boolean success = false;
        try {
            Connection conn = DB.getConnection();
            if (conn != null) {
                s_cc.readInfo(conn);
                conn.close();
            }
            success = conn != null;
        }
        catch (Exception e) {
            System.err.println("Could not connect to DB - " + e.getLocalizedMessage());
            e.printStackTrace();
            success = false;
        }
        return success;
    }

    public static boolean isConnected() {
        if (s_cc == null) {
            return false;
        }
        boolean success = false;
        try {
            Connection conn = DB.getConnection();
            if (conn != null) {
                conn.close();
                success = true;
            } else {
                success = false;
            }
        }
        catch (Exception exception) {
            success = false;
        }
        return success;
    }

    @Deprecated(since="10", forRemoval=true)
    public static boolean isConnected(boolean createNew) {
        return DB.isConnected();
    }

    public static Connection getConnection() {
        return DB.getConnection(true);
    }

    public static Connection getConnection(boolean autoCommit) {
        return DB.createConnection(autoCommit, 2);
    }

    @Deprecated(since="10", forRemoval=true)
    public static Connection getConnectionRW() {
        return DB.getConnection();
    }

    @Deprecated(since="10", forRemoval=true)
    public static Connection getConnectionRW(boolean createNew) {
        return DB.getConnection();
    }

    @Deprecated(since="10", forRemoval=true)
    public static Connection getConnectionID() {
        return DB.getConnection(false);
    }

    @Deprecated(since="10", forRemoval=true)
    public static Connection getConnectionRO() {
        return DB.getConnection();
    }

    public static Connection getReportingConnectionRO() {
        Connection conn = DBReadReplica.getConnectionRO();
        if (conn == null) {
            conn = DB.getConnection();
        }
        return conn;
    }

    public static Connection createConnection(boolean autoCommit, int trxLevel) {
        Connection conn = s_cc.getConnection(autoCommit, trxLevel);
        if (conn == null) {
            throw new IllegalStateException("DB.createConnection - @NoDBConnection@");
        }
        try {
            if (conn != null && conn.getAutoCommit() != autoCommit) {
                throw new IllegalStateException("Failed to set the requested auto commit mode on connection. [autoCommit=" + autoCommit + "]");
            }
        }
        catch (SQLException sQLException) {}
        return conn;
    }

    @Deprecated(since="10", forRemoval=true)
    public static Connection createConnection(boolean autoCommit, boolean readOnly, int trxLevel) {
        return DB.createConnection(autoCommit, trxLevel);
    }

    public static AdempiereDatabase getDatabase() {
        if (s_cc != null) {
            return s_cc.getDatabase();
        }
        log.severe("No Database Connection");
        return null;
    }

    public static AdempiereDatabase getDatabase(String URL2) {
        return Database.getDatabaseFromURL(URL2);
    }

    public static boolean isOracle() {
        if (s_cc != null) {
            return s_cc.isOracle();
        }
        log.severe("No Database Connection");
        return false;
    }

    public static boolean isPostgreSQL() {
        if (s_cc != null) {
            return s_cc.isPostgreSQL();
        }
        log.severe("No Database");
        return false;
    }

    public static String getDatabaseInfo() {
        if (s_cc != null) {
            return s_cc.getDBInfo();
        }
        return "No Database";
    }

    @Deprecated(since="10", forRemoval=true)
    public static boolean isDatabaseOK(Properties ctx) {
        String version = "?";
        String sql = "SELECT Version FROM AD_System";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    version = rs.getString(1);
                }
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, "Problem with AD_System Table - Run system.sql script - " + e.toString());
                DB.close(rs);
                DB.close(pstmt);
                rs = null;
                pstmt = null;
                return false;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs);
            DB.close(pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs);
        DB.close(pstmt);
        rs = null;
        pstmt = null;
        if (log.isLoggable(Level.INFO)) {
            log.info("DB_Version=" + version);
        }
        if (Adempiere.DB_VERSION.equals(version)) {
            return true;
        }
        String AD_Message = "DatabaseVersionError";
        String msg = Msg.getMsg(ctx, AD_Message, new Object[]{Adempiere.DB_VERSION, version});
        System.err.println(msg);
        return false;
    }

    public static boolean isBuildOK(Properties ctx) {
        String buildClient = Adempiere.getVersion();
        String buildDatabase = "";
        boolean failOnBuild = false;
        String sql = "SELECT LastBuildInfo, IsFailOnBuildDiffer FROM AD_System";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    buildDatabase = rs.getString(1);
                    failOnBuild = rs.getString(2).equals("Y");
                }
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, "Problem with AD_System Table - Run system.sql script - " + e.toString());
                DB.close(rs);
                DB.close(pstmt);
                rs = null;
                pstmt = null;
                return false;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs);
            DB.close(pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs);
        DB.close(pstmt);
        rs = null;
        pstmt = null;
        if (log.isLoggable(Level.INFO)) {
            log.info("Build DB=" + buildDatabase);
            log.info("Build Cl=" + buildClient);
        }
        if (buildClient.equals(buildDatabase)) {
            return true;
        }
        String AD_Message = "BuildVersionError";
        String msg = Msg.getMsg(ctx, AD_Message, new Object[]{buildClient, buildDatabase});
        if (!failOnBuild) {
            log.warning(msg);
            return true;
        }
        log.log(Level.SEVERE, msg);
        return false;
    }

    public static void closeTarget() {
        boolean closed = false;
        if (s_cc != null) {
            closed = true;
            s_cc.setDataSource(null);
        }
        s_cc = null;
        if (closed) {
            log.fine("closed");
        }
    }

    public static CallableStatement prepareCall(String sql) {
        return DB.prepareCall(sql, 1008, null);
    }

    public static CallableStatement prepareCall(String SQL, int resultSetConcurrency, String trxName) {
        if (SQL == null || SQL.length() == 0) {
            throw new IllegalArgumentException("Required parameter missing - " + SQL);
        }
        return ProxyFactory.newCCallableStatement(1003, resultSetConcurrency, SQL, trxName);
    }

    public static CPreparedStatement prepareStatement(String sql) {
        return DB.prepareStatement(sql, 1003, 1007, null);
    }

    public static CPreparedStatement prepareStatement(String sql, String trxName) {
        return DB.prepareStatement(sql, 1003, 1007, trxName);
    }

    public static CPreparedStatement prepareStatement(Connection connection, String sql) {
        return DB.prepareStatement(connection, sql, 1003, 1007);
    }

    public static CPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) {
        return DB.prepareStatement(sql, resultSetType, resultSetConcurrency, null);
    }

    public static CPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, String trxName) {
        if (sql == null || sql.length() == 0) {
            throw new IllegalArgumentException("No SQL");
        }
        return ProxyFactory.newCPreparedStatement(resultSetType, resultSetConcurrency, sql, trxName);
    }

    public static CPreparedStatement prepareStatement(Connection connection, String sql, int resultSetType, int resultSetConcurrency) {
        if (sql == null || sql.length() == 0) {
            throw new IllegalArgumentException("No SQL");
        }
        return ProxyFactory.newCPreparedStatement(resultSetType, resultSetConcurrency, sql, connection);
    }

    public static Statement createStatement() {
        return DB.createStatement(1003, 1007, null);
    }

    public static Statement createStatement(int resultSetType, int resultSetConcurrency, String trxName) {
        return ProxyFactory.newCStatement(resultSetType, resultSetConcurrency, trxName);
    }

    public static void setParameters(PreparedStatement stmt, Object[] params) throws SQLException {
        if (params == null || params.length == 0) {
            return;
        }
        int i2 = 0;
        while (i2 < params.length) {
            DB.setParameter(stmt, i2 + 1, params[i2]);
            ++i2;
        }
    }

    public static void setParameters(PreparedStatement stmt, List<?> params) throws SQLException {
        if (params == null || params.size() == 0) {
            return;
        }
        int i2 = 0;
        while (i2 < params.size()) {
            DB.setParameter(stmt, i2 + 1, params.get(i2));
            ++i2;
        }
    }

    public static void setParameter(PreparedStatement pstmt, int index, Object param) throws SQLException {
        if (param == null) {
            pstmt.setObject(index, null);
        } else if (param instanceof String) {
            pstmt.setString(index, (String)param);
        } else if (param instanceof Integer) {
            pstmt.setInt(index, (Integer)param);
        } else if (param instanceof BigDecimal) {
            pstmt.setBigDecimal(index, (BigDecimal)param);
        } else if (param instanceof Timestamp) {
            pstmt.setTimestamp(index, (Timestamp)param);
        } else if (param instanceof Boolean) {
            pstmt.setString(index, (Boolean)param != false ? "Y" : "N");
        } else if (param instanceof byte[]) {
            pstmt.setBytes(index, (byte[])param);
        } else if (param instanceof Clob) {
            pstmt.setClob(index, (Clob)param);
        } else if (param.getClass().getName().equals("oracle.sql.BLOB")) {
            pstmt.setObject(index, param);
        } else {
            throw new DBException("Unknown parameter type " + index + " - " + String.valueOf(param));
        }
    }

    public static int executeUpdate(String sql) {
        return DB.executeUpdate(sql, null, false, null);
    }

    public static int executeUpdate(String sql, String trxName) {
        return DB.executeUpdate(sql, trxName, 0);
    }

    public static int executeUpdate(String sql, String trxName, int timeOut) {
        return DB.executeUpdate(sql, null, false, trxName, timeOut);
    }

    public static int executeUpdate(String sql, boolean ignoreError) {
        return DB.executeUpdate(sql, null, ignoreError, null);
    }

    public static int executeUpdate(String sql, boolean ignoreError, String trxName) {
        return DB.executeUpdate(sql, ignoreError, trxName, 0);
    }

    public static int executeUpdate(String sql, boolean ignoreError, String trxName, int timeOut) {
        return DB.executeUpdate(sql, null, ignoreError, trxName, timeOut);
    }

    public static int executeUpdate(String sql, int param, String trxName) {
        return DB.executeUpdate(sql, param, trxName, 0);
    }

    public static int executeUpdate(String sql, int param, String trxName, int timeOut) {
        return DB.executeUpdate(sql, new Object[]{param}, false, trxName, timeOut);
    }

    public static int executeUpdate(String sql, int param, boolean ignoreError, String trxName) {
        return DB.executeUpdate(sql, param, ignoreError, trxName, 0);
    }

    public static int executeUpdate(String sql, int param, boolean ignoreError, String trxName, int timeOut) {
        return DB.executeUpdate(sql, new Object[]{param}, ignoreError, trxName, timeOut);
    }

    public static int executeUpdate(String sql, Object[] params, boolean ignoreError, String trxName) {
        return DB.executeUpdate(sql, params, ignoreError, trxName, 0);
    }

    public static int executeUpdate(String sql, Object[] params, boolean ignoreError, String trxName, int timeOut) {
        if (sql == null || sql.length() == 0) {
            throw new IllegalArgumentException("Required parameter missing - " + sql);
        }
        DB.verifyTrx(trxName);
        int no = -1;
        CPreparedStatement cs = ProxyFactory.newCPreparedStatement(1003, 1008, sql, trxName);
        try {
            try {
                DB.setParameters((PreparedStatement)cs, params);
                if (timeOut > 0) {
                    cs.setQueryTimeout(timeOut);
                }
                no = cs.executeUpdate();
            }
            catch (Exception e) {
                e = DB.getSQLException(e);
                if (ignoreError) {
                    log.log(Level.SEVERE, cs.getSql() + " [" + trxName + "] - " + e.getMessage());
                } else {
                    log.log(Level.SEVERE, cs.getSql() + " [" + trxName + "]", e);
                    String msg = DBException.getDefaultDBExceptionMessage(e);
                    log.saveError(msg != null ? msg : "DBExecuteError", e);
                }
                DB.close(cs);
                cs = null;
            }
        }
        finally {
            DB.close(cs);
            cs = null;
        }
        return no;
    }

    public static int executeUpdateEx(String sql, Object[] params, String trxName) throws DBException {
        return DB.executeUpdateEx(sql, params, trxName, 0);
    }

    public static int executeUpdateEx(String sql, Object[] params, String trxName, int timeOut) throws DBException {
        if (sql == null || sql.length() == 0) {
            throw new IllegalArgumentException("Required parameter missing - " + sql);
        }
        DB.verifyTrx(trxName);
        int no = -1;
        CPreparedStatement cs = ProxyFactory.newCPreparedStatement(1003, 1008, sql, trxName);
        try {
            try {
                DB.setParameters((PreparedStatement)cs, params);
                if (timeOut > 0) {
                    cs.setQueryTimeout(timeOut);
                }
                no = cs.executeUpdate();
            }
            catch (Exception e) {
                throw new DBException(e);
            }
        }
        finally {
            DB.close(cs);
            cs = null;
        }
        return no;
    }

    public static int executeUpdateMultiple(String sql, boolean ignoreError, String trxName) {
        if (sql == null || sql.length() == 0) {
            throw new IllegalArgumentException("Required parameter missing - " + sql);
        }
        int index = sql.indexOf(SQLSTATEMENT_SEPARATOR);
        if (index == -1) {
            return DB.executeUpdate(sql, null, ignoreError, trxName);
        }
        int no = 0;
        String[] statements = sql.split(SQLSTATEMENT_SEPARATOR);
        int i2 = 0;
        while (i2 < statements.length) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(statements[i2]);
            }
            no += DB.executeUpdate(statements[i2], null, ignoreError, trxName);
            ++i2;
        }
        return no;
    }

    public static int executeUpdateEx(String sql, String trxName) throws DBException {
        return DB.executeUpdateEx(sql, trxName, 0);
    }

    public static int executeUpdateEx(String sql, String trxName, int timeOut) throws DBException {
        return DB.executeUpdateEx(sql, null, trxName, timeOut);
    }

    public static boolean commit(boolean throwException, String trxName) throws SQLException, IllegalStateException {
        if (trxName == null) {
            return true;
        }
        try {
            Trx trx = Trx.get(trxName, false);
            if (trx != null) {
                return trx.commit(true);
            }
            if (throwException) {
                throw new IllegalStateException("Could not load transation with identifier: " + trxName);
            }
            return false;
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "[" + trxName + "]", e);
            if (throwException) {
                throw e;
            }
            return false;
        }
    }

    public static boolean rollback(boolean throwException, String trxName) throws SQLException {
        if (trxName == null) {
            return true;
        }
        try {
            Trx trx = Trx.get(trxName, false);
            if (trx != null) {
                return trx.rollback(true);
            }
            if (throwException) {
                throw new IllegalStateException("Could not load transation with identifier: " + trxName);
            }
            return false;
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "[" + trxName + "]", e);
            if (throwException) {
                throw e;
            }
            return false;
        }
    }

    public static RowSet getRowSet(String sql) {
        CStatementVO info = new CStatementVO(1004, 1007, DB.getDatabase().convertStatement(sql));
        CPreparedStatement stmt = null;
        RowSet retValue = null;
        try {
            stmt = ProxyFactory.newCPreparedStatement(info);
            retValue = stmt.getRowSet();
        }
        finally {
            DB.close(stmt);
        }
        return retValue;
    }

    public static int getSQLValueEx(String trxName, String sql, Object ... params) throws DBException {
        int retValue = -1;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        if (trxName == null) {
            conn = DB.createConnection(true, 2);
        }
        try {
            try {
                if (conn != null) {
                    conn.setAutoCommit(false);
                    conn.setReadOnly(true);
                }
                pstmt = conn != null ? DB.prepareStatement(conn, sql) : DB.prepareStatement(sql, trxName);
                DB.setParameters((PreparedStatement)pstmt, params);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    retValue = rs.getInt(1);
                } else if (log.isLoggable(Level.FINE)) {
                    log.fine("No Value " + sql);
                }
            }
            catch (SQLException e) {
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                }
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            if (conn != null) {
                DB.closeAndResetReadonlyConnection(conn);
            }
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (conn != null) {
            DB.closeAndResetReadonlyConnection(conn);
        }
        return retValue;
    }

    private static void closeAndResetReadonlyConnection(Connection conn) {
        try {
            conn.setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            conn.setReadOnly(false);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static int getSQLValueEx(String trxName, String sql, List<Object> params) {
        return DB.getSQLValueEx(trxName, sql, params.toArray(new Object[params.size()]));
    }

    public static int getSQLValue(String trxName, String sql, Object ... params) {
        int retValue = -1;
        try {
            retValue = DB.getSQLValueEx(trxName, sql, params);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, DB.getSQLException(e));
        }
        return retValue;
    }

    public static int getSQLValue(String trxName, String sql, List<Object> params) {
        return DB.getSQLValue(trxName, sql, params.toArray(new Object[params.size()]));
    }

    public static String getSQLValueStringEx(String trxName, String sql, Object ... params) {
        String retValue = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        if (trxName == null) {
            conn = DB.createConnection(true, 2);
        }
        try {
            try {
                if (conn != null) {
                    conn.setAutoCommit(false);
                    conn.setReadOnly(true);
                }
                pstmt = conn != null ? DB.prepareStatement(conn, sql) : DB.prepareStatement(sql, trxName);
                DB.setParameters((PreparedStatement)pstmt, params);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    retValue = rs.getString(1);
                } else if (log.isLoggable(Level.FINE)) {
                    log.fine("No Value " + sql);
                }
            }
            catch (SQLException e) {
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                }
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            if (conn != null) {
                DB.closeAndResetReadonlyConnection(conn);
            }
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (conn != null) {
            DB.closeAndResetReadonlyConnection(conn);
        }
        return retValue;
    }

    public static String getSQLValueStringEx(String trxName, String sql, List<Object> params) {
        return DB.getSQLValueStringEx(trxName, sql, params.toArray(new Object[params.size()]));
    }

    public static String getSQLValueString(String trxName, String sql, Object ... params) {
        String retValue = null;
        try {
            retValue = DB.getSQLValueStringEx(trxName, sql, params);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, DB.getSQLException(e));
        }
        return retValue;
    }

    public static String getSQLValueString(String trxName, String sql, List<Object> params) {
        return DB.getSQLValueString(trxName, sql, params.toArray(new Object[params.size()]));
    }

    public static BigDecimal getSQLValueBDEx(String trxName, String sql, Object ... params) throws DBException {
        BigDecimal retValue = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        if (trxName == null) {
            conn = DB.createConnection(true, 2);
        }
        try {
            try {
                if (conn != null) {
                    conn.setAutoCommit(false);
                    conn.setReadOnly(true);
                }
                pstmt = conn != null ? DB.prepareStatement(conn, sql) : DB.prepareStatement(sql, trxName);
                DB.setParameters((PreparedStatement)pstmt, params);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    retValue = rs.getBigDecimal(1);
                } else if (log.isLoggable(Level.FINE)) {
                    log.fine("No Value " + sql);
                }
            }
            catch (SQLException e) {
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                }
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            if (conn != null) {
                DB.closeAndResetReadonlyConnection(conn);
            }
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (conn != null) {
            DB.closeAndResetReadonlyConnection(conn);
        }
        return retValue;
    }

    public static BigDecimal getSQLValueBDEx(String trxName, String sql, List<Object> params) throws DBException {
        return DB.getSQLValueBDEx(trxName, sql, params.toArray(new Object[params.size()]));
    }

    public static BigDecimal getSQLValueBD(String trxName, String sql, Object ... params) {
        try {
            return DB.getSQLValueBDEx(trxName, sql, params);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, DB.getSQLException(e));
            return null;
        }
    }

    public static BigDecimal getSQLValueBD(String trxName, String sql, List<Object> params) {
        return DB.getSQLValueBD(trxName, sql, params.toArray(new Object[params.size()]));
    }

    public static Timestamp getSQLValueTSEx(String trxName, String sql, Object ... params) {
        Timestamp retValue = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        if (trxName == null) {
            conn = DB.createConnection(true, 2);
        }
        try {
            try {
                if (conn != null) {
                    conn.setAutoCommit(false);
                    conn.setReadOnly(true);
                }
                pstmt = conn != null ? DB.prepareStatement(conn, sql) : DB.prepareStatement(sql, trxName);
                DB.setParameters((PreparedStatement)pstmt, params);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    retValue = rs.getTimestamp(1);
                } else if (log.isLoggable(Level.FINE)) {
                    log.fine("No Value " + sql);
                }
            }
            catch (SQLException e) {
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                }
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            if (conn != null) {
                DB.closeAndResetReadonlyConnection(conn);
            }
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (conn != null) {
            DB.closeAndResetReadonlyConnection(conn);
        }
        return retValue;
    }

    public static Timestamp getSQLValueTSEx(String trxName, String sql, List<Object> params) throws DBException {
        return DB.getSQLValueTSEx(trxName, sql, params.toArray(new Object[params.size()]));
    }

    public static Timestamp getSQLValueTS(String trxName, String sql, Object ... params) {
        try {
            return DB.getSQLValueTSEx(trxName, sql, params);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, DB.getSQLException(e));
            return null;
        }
    }

    public static Timestamp getSQLValueTS(String trxName, String sql, List<Object> params) {
        Object[] arr = new Object[params.size()];
        params.toArray(arr);
        return DB.getSQLValueTS(trxName, sql, arr);
    }

    public static KeyNamePair[] getKeyNamePairs(String sql, boolean optional) {
        return DB.getKeyNamePairs(sql, optional, null);
    }

    public static KeyNamePair[] getKeyNamePairs(String sql, boolean optional, Object ... params) {
        return DB.getKeyNamePairs(null, sql, optional, params);
    }

    public static KeyNamePair[] getKeyNamePairs(String trxName, String sql, boolean optional, Object ... params) {
        ArrayList<KeyNamePair> list;
        block7: {
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            list = new ArrayList<KeyNamePair>();
            if (optional) {
                list.add(new KeyNamePair(-1, ""));
            }
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    DB.setParameters((PreparedStatement)pstmt, params);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, DB.getSQLException(e));
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        KeyNamePair[] retValue = new KeyNamePair[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static int[] getIDsEx(String trxName, String sql, Object ... params) throws DBException {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<Integer> list = new ArrayList<Integer>();
        try {
            try {
                pstmt = DB.prepareStatement(sql, trxName);
                DB.setParameters((PreparedStatement)pstmt, params);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.add(rs.getInt(1));
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        int[] retValue = new int[list.size()];
        int i2 = 0;
        while (i2 < retValue.length) {
            retValue[i2] = (Integer)list.get(i2);
            ++i2;
        }
        return retValue;
    }

    public static boolean isSOTrx(String TableName, String whereClause, int windowNo) {
        boolean noIsSOTrxColumn;
        Boolean isSOTrx;
        block22: {
            block20: {
                if (TableName == null || TableName.length() == 0) {
                    log.severe("No TableName");
                    return true;
                }
                if (whereClause == null || whereClause.length() == 0) {
                    log.severe("No Where Clause");
                    return true;
                }
                isSOTrx = null;
                noIsSOTrxColumn = false;
                if (MTable.get(Env.getCtx(), TableName).getColumn("IsSOTrx") == null) {
                    noIsSOTrxColumn = true;
                } else {
                    String sql = "SELECT IsSOTrx FROM " + TableName + " WHERE " + whereClause;
                    CPreparedStatement pstmt = null;
                    ResultSet rs = null;
                    try {
                        try {
                            pstmt = DB.prepareStatement(sql, null);
                            rs = pstmt.executeQuery();
                            if (rs.next()) {
                                isSOTrx = "Y".equals(rs.getString(1));
                            }
                        }
                        catch (Exception exception) {
                            noIsSOTrxColumn = true;
                            DB.close(rs, pstmt);
                            rs = null;
                            pstmt = null;
                            break block20;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                }
            }
            if (noIsSOTrxColumn && TableName.endsWith("Line")) {
                noIsSOTrxColumn = false;
                String hdr = TableName.substring(0, TableName.indexOf("Line"));
                if (MTable.get(Env.getCtx(), hdr) == null || MTable.get(Env.getCtx(), hdr).getColumn("IsSOTrx") == null) {
                    noIsSOTrxColumn = true;
                } else {
                    String sql = "SELECT IsSOTrx FROM " + hdr + " h WHERE h." + hdr + "_ID IN (SELECT l." + hdr + "_ID FROM " + TableName + " l WHERE " + whereClause + ")";
                    CPreparedStatement pstmt2 = null;
                    ResultSet rs2 = null;
                    try {
                        try {
                            pstmt2 = DB.prepareStatement(sql, null);
                            rs2 = pstmt2.executeQuery();
                            if (rs2.next()) {
                                isSOTrx = "Y".equals(rs2.getString(1));
                            }
                        }
                        catch (Exception exception) {
                            noIsSOTrxColumn = true;
                            DB.close(rs2, pstmt2);
                            rs2 = null;
                            pstmt2 = null;
                            break block22;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs2, pstmt2);
                        rs2 = null;
                        pstmt2 = null;
                        throw throwable;
                    }
                    DB.close(rs2, pstmt2);
                    rs2 = null;
                    pstmt2 = null;
                }
            }
        }
        if (noIsSOTrxColumn && log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, TableName + " - No SOTrx");
        }
        if (isSOTrx == null) {
            isSOTrx = windowNo >= 0 ? Boolean.valueOf("Y".equals(Env.getContext(Env.getCtx(), windowNo, "IsSOTrx"))) : Boolean.TRUE;
        }
        return isSOTrx;
    }

    public static boolean isSOTrx(String TableName, String whereClause) {
        return DB.isSOTrx(TableName, whereClause, -1);
    }

    public static int getNextID(Properties ctx, String TableName, String trxName) {
        if (ctx == null) {
            throw new IllegalArgumentException("Context missing");
        }
        if (TableName == null || TableName.length() == 0) {
            throw new IllegalArgumentException("TableName missing");
        }
        return DB.getNextID(Env.getAD_Client_ID(ctx), TableName, trxName);
    }

    public static int getNextID(int AD_Client_ID, String TableName, String trxName) {
        return MSequence.getNextID(AD_Client_ID, TableName, trxName);
    }

    public static String getDocumentNo(int C_DocType_ID, String trxName) {
        return MSequence.getDocumentNo(C_DocType_ID, trxName, false);
    }

    public static String getDocumentNo(int C_DocType_ID, String trxName, boolean definite) {
        return DB.getDocumentNo(C_DocType_ID, trxName, definite, null);
    }

    public static String getDocumentNo(int C_DocType_ID, String trxName, boolean definite, PO po) {
        return MSequence.getDocumentNo(C_DocType_ID, trxName, definite, po);
    }

    public static String getDocumentNo(int AD_Client_ID, String TableName, String trxName) {
        return DB.getDocumentNo(AD_Client_ID, TableName, trxName, null);
    }

    public static String getDocumentNo(int AD_Client_ID, String TableName, String trxName, PO po) {
        String dn = MSequence.getDocumentNo(AD_Client_ID, TableName, trxName, po);
        if (dn == null) {
            throw new DBException("No DocumentNo");
        }
        return dn;
    }

    public static String getDocumentNo(Properties ctx, int WindowNo, String TableName, boolean onlyDocType, String trxName) {
        if (ctx == null || TableName == null || TableName.length() == 0) {
            throw new IllegalArgumentException("Required parameter missing");
        }
        int AD_Client_ID = Env.getContextAsInt(ctx, WindowNo, "AD_Client_ID");
        int C_DocType_ID = Env.getContextAsInt(ctx, WindowNo + "|C_DocTypeTarget_ID");
        if (C_DocType_ID == 0) {
            C_DocType_ID = Env.getContextAsInt(ctx, WindowNo + "|C_DocType_ID");
        }
        if (C_DocType_ID == 0) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Window=" + WindowNo + " - Target=" + Env.getContextAsInt(ctx, WindowNo + "|C_DocTypeTarget_ID") + "/" + Env.getContextAsInt(ctx, WindowNo, "C_DocTypeTarget_ID") + " - Actual=" + Env.getContextAsInt(ctx, WindowNo + "|C_DocType_ID") + "/" + Env.getContextAsInt(ctx, WindowNo, "C_DocType_ID"));
            }
            return DB.getDocumentNo(AD_Client_ID, TableName, trxName);
        }
        String retValue = DB.getDocumentNo(C_DocType_ID, trxName, false);
        if (!onlyDocType && retValue == null) {
            return DB.getDocumentNo(AD_Client_ID, TableName, trxName);
        }
        return retValue;
    }

    @Deprecated(forRemoval=true)
    public static boolean isRemoteObjects() {
        return false;
    }

    @Deprecated(forRemoval=true)
    public static boolean isRemoteProcess() {
        return false;
    }

    public static void printWarning(String comment, SQLWarning warning) {
        if (comment == null || warning == null || comment.length() == 0) {
            return;
        }
        log.warning(comment);
        SQLWarning warn = warning;
        while (warn != null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(warn.getMessage()).append("; State=").append(warn.getSQLState()).append("; ErrorCode=").append(warn.getErrorCode());
            log.warning(buffer.toString());
            warn = warn.getNextWarning();
        }
    }

    public static String TO_DATE(Timestamp time, boolean dayOnly) {
        return s_cc.getDatabase().TO_DATE(time, dayOnly);
    }

    public static String TO_DATE(Timestamp day) {
        return DB.TO_DATE(day, true);
    }

    public static String TO_CHAR(String columnName, int displayType, String AD_Language) {
        if (columnName == null || AD_Language == null || columnName.length() == 0) {
            throw new IllegalArgumentException("Required parameter missing");
        }
        return s_cc.getDatabase().TO_CHAR(columnName, displayType, AD_Language);
    }

    public static String TO_NUMBER(BigDecimal number, int displayType) {
        return s_cc.getDatabase().TO_NUMBER(number, displayType);
    }

    public static String TO_STRING(String txt) {
        return DB.TO_STRING(txt, 0);
    }

    public static String TO_STRING(String txt, int maxLength) {
        if (txt == null || txt.length() == 0) {
            return "NULL";
        }
        String text = txt;
        if (maxLength != 0 && text.length() > maxLength) {
            text = txt.substring(0, maxLength);
        }
        StringBuilder out = new StringBuilder();
        out.append('\'');
        int i2 = 0;
        while (i2 < text.length()) {
            char c = text.charAt(i2);
            if (c == '\'') {
                out.append("''");
            } else {
                out.append(c);
            }
            ++i2;
        }
        out.append('\'');
        return out.toString();
    }

    public static String TO_JSON(String value) {
        return s_cc.getDatabase().TO_JSON(value);
    }

    public static String getJSONCast() {
        return s_cc.getDatabase().getJSONCast();
    }

    public static void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {}
    }

    public static void close(Statement st) {
        try {
            if (st != null) {
                st.close();
            }
        }
        catch (SQLException sQLException) {}
    }

    public static void close(ResultSet rs, Statement st) {
        DB.close(rs);
        DB.close(st);
    }

    public static void close(POResultSet<?> rs) {
        if (rs != null) {
            rs.close();
        }
    }

    public static Exception getSQLException(Exception e) {
        Throwable e1 = e;
        while (e1 != null) {
            if (e1 instanceof SQLException) {
                return (SQLException)e1;
            }
            e1 = e1.getCause();
        }
        return e;
    }

    public static int getSQLValue(String trxName, String sql) {
        return DB.getSQLValue(trxName, sql, new Object[0]);
    }

    public static int getSQLValue(String trxName, String sql, int int_param1) {
        return DB.getSQLValue(trxName, sql, new Object[]{int_param1});
    }

    public static int getSQLValue(String trxName, String sql, int int_param1, int int_param2) {
        return DB.getSQLValue(trxName, sql, new Object[]{int_param1, int_param2});
    }

    public static int getSQLValue(String trxName, String sql, String str_param1) {
        return DB.getSQLValue(trxName, sql, new Object[]{str_param1});
    }

    public static int getSQLValue(String trxName, String sql, int int_param1, String str_param2) {
        return DB.getSQLValue(trxName, sql, new Object[]{int_param1, str_param2});
    }

    public static String getSQLValueString(String trxName, String sql, int int_param1) {
        return DB.getSQLValueString(trxName, sql, new Object[]{int_param1});
    }

    public static BigDecimal getSQLValueBD(String trxName, String sql, int int_param1) {
        return DB.getSQLValueBD(trxName, sql, new Object[]{int_param1});
    }

    public static ValueNamePair[] getValueNamePairs(String sql, boolean optional, List<Object> params) {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<ValueNamePair> list = new ArrayList<ValueNamePair>();
        if (optional) {
            list.add(ValueNamePair.EMPTY);
        }
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                DB.setParameters((PreparedStatement)pstmt, params);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.add(new ValueNamePair(rs.getString(1), rs.getString(2)));
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return list.toArray(new ValueNamePair[list.size()]);
    }

    public static KeyNamePair[] getKeyNamePairs(String sql, boolean optional, List<Object> params) {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<KeyNamePair> list = new ArrayList<KeyNamePair>();
        if (optional) {
            list.add(KeyNamePair.EMPTY);
        }
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                DB.setParameters((PreparedStatement)pstmt, params);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return list.toArray(new KeyNamePair[list.size()]);
    }

    public static void createT_Selection(int AD_PInstance_ID, Collection<Integer> selection, String trxName) {
        StringBuilder insert = new StringBuilder();
        insert.append("INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) ");
        int counter = 0;
        for (Integer selectedId : selection) {
            if (++counter > 1) {
                insert.append(" UNION ");
            }
            insert.append("SELECT ");
            insert.append(AD_PInstance_ID);
            insert.append(", ");
            insert.append(selectedId);
            insert.append(" FROM DUAL ");
            if (counter < 1000) continue;
            DB.executeUpdateEx(insert.toString(), trxName);
            insert = new StringBuilder();
            insert.append("INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) ");
            counter = 0;
        }
        if (counter > 0) {
            DB.executeUpdateEx(insert.toString(), trxName);
        }
    }

    public static void createT_SelectionNew(int AD_PInstance_ID, Collection<KeyNamePair> saveKeys, String trxName) {
        ArrayList<NamePair> saveKeysNP = new ArrayList<NamePair>();
        for (NamePair namePair : saveKeys) {
            saveKeysNP.add(namePair);
        }
        DB.createT_SelectionNewNP(AD_PInstance_ID, saveKeysNP, trxName);
    }

    public static void createT_SelectionNewNP(int AD_PInstance_ID, Collection<NamePair> saveKeys, String trxName) {
        String initialInsert = "INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID, T_SELECTION_UU, ViewID) ";
        StringBuilder insert = new StringBuilder(initialInsert);
        int counter = 0;
        for (NamePair saveKey : saveKeys) {
            Object selectedId;
            if (saveKey instanceof KeyNamePair) {
                selectedId = ((KeyNamePair)saveKey).getKey();
            } else if (saveKey instanceof ValueNamePair) {
                selectedId = ((ValueNamePair)saveKey).getValue();
            } else {
                throw new AdempiereException("NamePair type not allowed in DB.createT_SelectionNewNP, just KeyNamePair or ValueNamePair are allowed");
            }
            if (++counter > 1) {
                insert.append(" UNION ");
            }
            insert.append("SELECT ");
            insert.append(AD_PInstance_ID);
            insert.append(", ");
            if (selectedId instanceof Integer) {
                insert.append((Integer)selectedId);
                insert.append(", ' '");
            } else {
                insert.append("0, ");
                insert.append(DB.TO_STRING(selectedId.toString()));
            }
            insert.append(", ");
            String viewIDValue = saveKey.getName();
            if (viewIDValue == null) {
                insert.append("NULL");
            } else {
                insert.append(DB.TO_STRING(viewIDValue));
            }
            insert.append(" FROM DUAL ");
            if (counter < 1000) continue;
            DB.executeUpdateEx(insert.toString(), trxName);
            insert.delete(0, insert.length());
            insert.append(initialInsert);
            counter = 0;
        }
        if (counter > 0) {
            DB.executeUpdateEx(insert.toString(), trxName);
        }
    }

    public static boolean isGenerateUUIDSupported() {
        if (!m_isUUIDVerified) {
            String uuidTest = null;
            try {
                uuidTest = DB.getSQLValueStringEx(null, "SELECT Generate_UUID() FROM Dual", new Object[0]);
            }
            catch (Exception exception) {}
            m_isUUIDSupported = uuidTest != null && uuidTest.trim().length() == 36;
            m_isUUIDVerified = true;
        }
        return m_isUUIDSupported;
    }

    private static void verifyTrx(String trxName) {
        if (trxName != null && Trx.get(trxName, false) == null) {
            String msg = "Transaction closed or never opened (" + trxName + ") => (maybe timed out)";
            log.severe(msg);
            throw new DBException(msg);
        }
    }

    /*
     * Loose catch block
     */
    public static boolean isTableOrViewExists(String tableName) {
        block13: {
            ResultSet rs;
            Connection conn;
            block12: {
                conn = DB.getConnection();
                rs = null;
                DatabaseMetaData metadata = conn.getMetaData();
                String tblName = metadata.storesUpperCaseIdentifiers() ? tableName.toUpperCase() : (metadata.storesLowerCaseIdentifiers() ? tableName.toLowerCase() : tableName);
                rs = metadata.getTables(null, null, tblName, null);
                if (!rs.next()) break block12;
                DB.close(rs);
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
                return true;
                catch (SQLException e) {
                    try {
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        DB.close(rs);
                        try {
                            conn.close();
                        }
                        catch (SQLException sQLException) {}
                        throw throwable;
                    }
                    DB.close(rs);
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {}
                    break block13;
                }
            }
            DB.close(rs);
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
        return false;
    }

    public static List<Object> getSQLValueObjectsEx(String trxName, String sql, Object ... params) {
        ArrayList<Object> retValue = new ArrayList<Object>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        if (trxName == null) {
            conn = DB.createConnection(true, 2);
        }
        try {
            try {
                if (conn != null) {
                    conn.setAutoCommit(false);
                    conn.setReadOnly(true);
                }
                pstmt = conn != null ? DB.prepareStatement(conn, sql) : DB.prepareStatement(sql, trxName);
                DB.setParameters((PreparedStatement)pstmt, params);
                rs = pstmt.executeQuery();
                ResultSetMetaData rsmd = rs.getMetaData();
                if (rs.next()) {
                    int i2 = 1;
                    while (i2 <= rsmd.getColumnCount()) {
                        Object obj = rs.getObject(i2);
                        if (rs.wasNull()) {
                            retValue.add(null);
                        } else {
                            retValue.add(obj);
                        }
                        ++i2;
                    }
                } else {
                    retValue = null;
                }
            }
            catch (SQLException e) {
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                }
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            if (conn != null) {
                DB.closeAndResetReadonlyConnection(conn);
            }
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (conn != null) {
            DB.closeAndResetReadonlyConnection(conn);
        }
        return retValue;
    }

    public static List<List<Object>> getSQLArrayObjectsEx(String trxName, String sql, Object ... params) {
        ArrayList<List<Object>> rowsArray = new ArrayList<List<Object>>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        if (trxName == null) {
            conn = DB.createConnection(true, 2);
        }
        try {
            try {
                if (conn != null) {
                    conn.setAutoCommit(false);
                    conn.setReadOnly(true);
                }
                pstmt = conn != null ? DB.prepareStatement(conn, sql) : DB.prepareStatement(sql, trxName);
                DB.setParameters((PreparedStatement)pstmt, params);
                rs = pstmt.executeQuery();
                ResultSetMetaData rsmd = rs.getMetaData();
                while (rs.next()) {
                    ArrayList<Object> retValue = new ArrayList<Object>();
                    int i2 = 1;
                    while (i2 <= rsmd.getColumnCount()) {
                        Object obj = rs.getObject(i2);
                        if (rs.wasNull()) {
                            retValue.add(null);
                        } else {
                            retValue.add(obj);
                        }
                        ++i2;
                    }
                    rowsArray.add(retValue);
                }
            }
            catch (SQLException e) {
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                }
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            if (conn != null) {
                DB.closeAndResetReadonlyConnection(conn);
            }
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (conn != null) {
            DB.closeAndResetReadonlyConnection(conn);
        }
        if (rowsArray.size() == 0) {
            return null;
        }
        return rowsArray;
    }

    public static PreparedStatement prepareNormalReadReplicaStatement(String sql, String trxName) {
        return DB.prepareNormalReadReplicaStatement(sql, 1003, 1007, trxName);
    }

    private static PreparedStatement prepareNormalReadReplicaStatement(String sql, int resultSetType, int resultSetConcurrency, String trxName) {
        CPreparedStatement stmt;
        boolean useReadReplica;
        if (sql == null || sql.length() == 0) {
            throw new IllegalArgumentException("No SQL");
        }
        boolean bl = useReadReplica = MSysConfig.getValue("DB_READ_REPLICA_URLS") != null;
        if (trxName == null && useReadReplica && resultSetType == 1003 && resultSetConcurrency == 1007 && (stmt = ProxyFactory.newReadReplicaPreparedStatement(resultSetType, resultSetConcurrency, sql)) != null) {
            return stmt;
        }
        return ProxyFactory.newCPreparedStatement(resultSetType, resultSetConcurrency, sql, trxName);
    }

    public static String inClauseForCSV(String columnName, String csv) {
        return DB.inClauseForCSV(columnName, csv, false);
    }

    public static String inClauseForCSV(String columnName, String csv, boolean isNotClause) {
        StringBuilder builder = new StringBuilder();
        builder.append(columnName);
        if (isNotClause) {
            builder.append(" NOT ");
        }
        builder.append(" IN (");
        String[] values = csv.split("[,]");
        int i2 = 0;
        while (i2 < values.length) {
            if (i2 > 0) {
                builder.append(",");
            }
            String key = values[i2];
            if (columnName.endsWith("_ID")) {
                builder.append(key);
            } else {
                if (key.startsWith("\"") && key.endsWith("\"")) {
                    key = key.substring(1, key.length() - 1);
                }
                builder.append(DB.TO_STRING(key));
            }
            ++i2;
        }
        builder.append(")");
        return builder.toString();
    }

    public static String subsetClauseForCSV(String columnName, String csv) {
        return DB.getDatabase().subsetClauseForCSV(columnName, csv);
    }

    public static String intersectClauseForCSV(String columnName, String csv) {
        return DB.intersectClauseForCSV(columnName, csv, false);
    }

    public static String intersectClauseForCSV(String columnName, String csv, boolean isNotClause) {
        return DB.getDatabase().intersectClauseForCSV(columnName, csv, isNotClause);
    }

    public static boolean isSelectStatement(String sql) {
        String removeComments = "/\\*(?:.|[\\n\\r])*?\\*/";
        String removeQuotedStrings = "'(?:.|[\\n\\r])*?'";
        String removeLeadingSpaces = "^\\s+";
        String cleanSql = sql.toLowerCase().replaceAll(removeComments, "").replaceAll(removeQuotedStrings, "").replaceFirst(removeLeadingSpaces, "");
        return cleanSql.matches("^select\\s.*$") && !cleanSql.contains(";");
    }
}

