/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.PeriodClosedException;
import org.compiere.model.MDocType;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;

public class DocActionDelegate<T extends PO>
implements DocAction {
    private T po;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private Map<String, Callable<String>> actionCallables = new HashMap<String, Callable<String>>();
    protected transient CLogger log = CLogger.getCLogger(this.getClass());

    public DocActionDelegate(T po) {
        this.po = po;
    }

    public void setActionCallable(String docAction, Callable<String> callable) {
        this.actionCallables.put(docAction, callable);
    }

    @Override
    public void setDocStatus(String DocStatus) {
        ((PO)this.po).columnExists("DocStatus", true);
        ((PO)this.po).set_ValueOfColumn("DocStatus", (Object)DocStatus);
    }

    @Override
    public String getDocStatus() {
        ((PO)this.po).columnExists("DocStatus", true);
        return (String)((PO)this.po).get_Value("DocStatus");
    }

    @Override
    public boolean processIt(String action) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this.po, this.getDocStatus());
        return engine.processIt(action, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("unlockIt - " + ((PO)this.po).toString());
        }
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("invalidateIt - " + ((PO)this.po).toString());
        }
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        Callable<String> callable;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(((PO)this.po).toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this.po, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        int doctype = -1;
        if (((PO)this.po).columnExists("C_DocTypeTarget_ID")) {
            doctype = ((PO)this.po).get_ValueAsInt("C_DocTypeTarget_ID");
        } else if (((PO)this.po).columnExists("C_DocType_ID")) {
            doctype = ((PO)this.po).get_ValueAsInt("C_DocType_ID");
        }
        Timestamp date = null;
        date = ((PO)this.po).columnExists("DateAcct") ? (Timestamp)((PO)this.po).get_Value("DateAcct") : (((PO)this.po).columnExists("DateTrx") ? (Timestamp)((PO)this.po).get_Value("DateTrx") : TimeUtil.getDay(0L));
        if (doctype >= 0) {
            MPeriod.testPeriodOpen(this.getCtx(), date, doctype, this.getAD_Org_ID());
        }
        if ((callable = this.actionCallables.get("PR")) != null) {
            try {
                this.m_processMsg = callable.call();
                if (this.m_processMsg != null) {
                    return "IN";
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this.po, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(((PO)this.po).toString());
        }
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(((PO)this.po).toString());
        }
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String valid;
        Callable<String> callable;
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        if (((PO)this.po).columnExists("C_DocTypeTarget_ID") && ((PO)this.po).columnExists("C_DocType_ID")) {
            ((PO)this.po).set_ValueOfColumn("C_DocType_ID", (Object)((PO)this.po).get_ValueAsInt("C_DocTypeTarget_ID"));
        }
        this.setDefiniteDocumentNo();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this.po, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(((PO)this.po).toString());
        }
        if ((callable = this.actionCallables.get("CO")) != null) {
            try {
                this.m_processMsg = callable.call();
                if (this.m_processMsg != null) {
                    return "IN";
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if ((valid = ModelValidationEngine.get().fireDocValidate((PO)this.po, 9)) != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    @Override
    public boolean voidIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(((PO)this.po).toString());
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            this.setDocAction("--");
            return false;
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this.po, 2);
            if (this.m_processMsg != null) {
                return false;
            }
            Callable<String> callable = this.actionCallables.get("VO");
            if (callable != null) {
                try {
                    this.m_processMsg = callable.call();
                    if (this.m_processMsg != null) {
                        return false;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            boolean accrual = false;
            int doctype = -1;
            if (((PO)this.po).columnExists("C_DocTypeTarget_ID")) {
                doctype = ((PO)this.po).get_ValueAsInt("C_DocTypeTarget_ID");
            } else if (((PO)this.po).columnExists("C_DocType_ID")) {
                doctype = ((PO)this.po).get_ValueAsInt("C_DocType_ID");
            }
            Timestamp date = null;
            date = ((PO)this.po).columnExists("DateAcct") ? (Timestamp)((PO)this.po).get_Value("DateAcct") : (((PO)this.po).columnExists("DateTrx") ? (Timestamp)((PO)this.po).get_Value("DateTrx") : TimeUtil.getDay(0L));
            if (doctype >= 0) {
                try {
                    MPeriod.testPeriodOpen(this.getCtx(), date, doctype, this.getAD_Org_ID());
                }
                catch (PeriodClosedException periodClosedException) {
                    accrual = true;
                }
            }
            if (accrual) {
                return this.reverseAccrualIt();
            }
            return this.reverseCorrectIt();
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this.po, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(((PO)this.po).toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this.po, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        Callable<String> callable = this.actionCallables.get("CL");
        if (callable != null) {
            try {
                this.m_processMsg = callable.call();
                if (this.m_processMsg != null) {
                    return false;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this.po, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(((PO)this.po).toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this.po, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        Callable<String> callable = this.actionCallables.get("RC");
        if (callable != null) {
            try {
                this.m_processMsg = callable.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this.po, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        if (callable != null) {
            return this.m_processMsg == null;
        }
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(((PO)this.po).toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this.po, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        Callable<String> callable = this.actionCallables.get("RA");
        if (callable != null) {
            try {
                this.m_processMsg = callable.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this.po, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        if (callable != null) {
            return this.m_processMsg == null;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(((PO)this.po).toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this.po, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        Callable<String> callable = this.actionCallables.get("RE");
        if (callable != null) {
            try {
                this.m_processMsg = callable.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this.po, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        if (callable != null) {
            return this.m_processMsg == null;
        }
        return false;
    }

    @Override
    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDocumentNo());
        String description = null;
        if (((PO)this.po).columnExists("Description")) {
            description = ((PO)this.po).get_ValueAsString("Description");
        }
        if (!Util.isEmpty(description)) {
            sb.append(" - ").append(description);
        }
        return sb.toString();
    }

    @Override
    public String getDocumentNo() {
        if (((PO)this.po).columnExists("DocumentNo")) {
            return ((PO)this.po).get_ValueAsString("DocumentNo");
        }
        return null;
    }

    @Override
    public String getDocumentInfo() {
        int doctype = -1;
        if (((PO)this.po).columnExists("C_DocTypeTarget_ID")) {
            doctype = ((PO)this.po).get_ValueAsInt("C_DocTypeTarget_ID");
        } else if (((PO)this.po).columnExists("C_DocType_ID")) {
            doctype = ((PO)this.po).get_ValueAsInt("C_DocType_ID");
        }
        MDocType dt = null;
        if (doctype > 0) {
            dt = MDocType.get(this.getCtx(), doctype);
        }
        StringBuilder msgreturn = new StringBuilder().append(dt != null ? dt.getNameTrl() : "").append(" ").append(this.getDocumentNo());
        return msgreturn.toString();
    }

    @Override
    public File createPDF() {
        return null;
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        int userid = 0;
        userid = ((PO)this.po).columnExists("SalesRep_ID") ? ((PO)this.po).get_ValueAsInt("SalesRep_ID") : (((PO)this.po).columnExists("AD_User_ID") ? ((PO)this.po).get_ValueAsInt("AD_User_ID") : ((PO)this.po).getCreatedBy());
        return userid;
    }

    @Override
    public int getC_Currency_ID() {
        int currency = 0;
        if (((PO)this.po).columnExists("C_Currency_ID")) {
            currency = ((PO)this.po).get_ValueAsInt("C_Currency_ID");
        }
        return currency;
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return ((PO)this.po).getAD_Client_ID();
    }

    @Override
    public int getAD_Org_ID() {
        return ((PO)this.po).getAD_Org_ID();
    }

    @Override
    public String getDocAction() {
        ((PO)this.po).columnExists("DocAction", true);
        return (String)((PO)this.po).get_Value("DocAction");
    }

    @Override
    public boolean save() {
        return ((PO)this.po).save();
    }

    @Override
    public void saveEx() throws AdempiereException {
        ((PO)this.po).saveEx();
    }

    @Override
    public Properties getCtx() {
        return ((PO)this.po).getCtx();
    }

    @Override
    public int get_ID() {
        return ((PO)this.po).get_ID();
    }

    @Override
    public int get_Table_ID() {
        return ((PO)this.po).get_Table_ID();
    }

    @Override
    public CLogger get_Logger() {
        return ((PO)this.po).get_Logger();
    }

    @Override
    public String get_TrxName() {
        return ((PO)this.po).get_TrxName();
    }

    public void setDocAction(String DocAction2) {
        ((PO)this.po).columnExists("DocAction", true);
        ((PO)this.po).set_ValueOfColumn("DocAction", (Object)DocAction2);
    }

    public void setProcessing(boolean Processing) {
        ((PO)this.po).columnExists("Processing", true);
        ((PO)this.po).set_ValueOfColumn("Processing", (Object)Processing);
    }

    public void setProcessed(boolean Processed) {
        ((PO)this.po).columnExists("Processed", true);
        ((PO)this.po).set_ValueNoCheck("Processed", Processed);
    }

    public boolean isApproved() {
        Object oo;
        if (((PO)this.po).columnExists("IsApproved") && (oo = ((PO)this.po).get_Value("IsApproved")) != null) {
            if (oo instanceof Boolean) {
                return (Boolean)oo;
            }
            return "Y".equals(oo);
        }
        return true;
    }

    public void setIsApproved(boolean IsApproved) {
        ((PO)this.po).columnExists("IsApproved", true);
        ((PO)this.po).set_ValueNoCheck("IsApproved", IsApproved);
    }

    private void setDefiniteDocumentNo() {
        int doctype = -1;
        if (((PO)this.po).columnExists("C_DocType_ID")) {
            doctype = ((PO)this.po).get_ValueAsInt("C_DocType_ID");
        }
        Timestamp dateacct = null;
        if (((PO)this.po).columnExists("DateAcct")) {
            dateacct = (Timestamp)((PO)this.po).get_Value("DateAcct");
        }
        Timestamp datetrx = null;
        if (((PO)this.po).columnExists("DateTrx")) {
            datetrx = (Timestamp)((PO)this.po).get_Value("DateTrx");
        }
        if (datetrx == null) {
            datetrx = TimeUtil.getDay(0L);
        }
        if (doctype >= 0) {
            String value;
            MPeriod.testPeriodOpen(this.getCtx(), dateacct != null ? dateacct : datetrx, doctype, this.getAD_Org_ID());
            MDocType dt = MDocType.get(doctype);
            if (dt.isOverwriteDateOnComplete()) {
                if (((PO)this.po).columnExists("DateTrx")) {
                    ((PO)this.po).set_ValueOfColumn("DateTrx", (Object)TimeUtil.getDay(0L));
                }
                if (dateacct != null && dateacct.before(datetrx)) {
                    ((PO)this.po).set_ValueOfColumn("DateAcct", (Object)datetrx);
                    MPeriod.testPeriodOpen(this.getCtx(), datetrx, doctype, this.getAD_Org_ID());
                }
            }
            if (dt.isOverwriteSeqOnComplete() && ((PO)this.po).columnExists("DocumentNo") && (value = DB.getDocumentNo(doctype, this.get_TrxName(), true, this.po)) != null) {
                ((PO)this.po).set_ValueOfColumn("DocumentNo", (Object)value);
            }
        }
    }
}

